/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.storage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class StorageUtil {
    public static final String DEFAULT_URLENCODE = "UTF-8";
    private static Logger logger = Logger.getLogger((String)StorageUtil.class.getName());

    private StorageUtil() {
    }

    public static String formatFileName(String fileName) {
        try {
            String name = fileName.trim();
            String encodeName = new String(name.getBytes(), DEFAULT_URLENCODE);
            encodeName = encodeName.replaceAll("/+", "/");
            if (encodeName.indexOf("/") == 0) {
                encodeName = encodeName.substring(1, encodeName.length());
            }
            return encodeName;
        }
        catch (Exception e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
            return "";
        }
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, DEFAULT_URLENCODE);
        }
        catch (UnsupportedEncodingException e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
            return "";
        }
    }

    public static String jsonEncode(Map<String, String> map) {
        JSONObject json = JSONObject.fromObject(map);
        return json.toString();
    }

    public static String jsonEncode(List<String> list) {
        JSONObject json = JSONObject.fromObject(list);
        return json.toString();
    }

    public static Map<String, String> parseFileAttr(Map<String, String> map) {
        Set<Map.Entry<String, String>> entry = map.entrySet();
        Iterator<Map.Entry<String, String>> iter = entry.iterator();
        HashMap<String, String> newMap = new HashMap<String, String>(4);
        while (iter.hasNext()) {
            Map.Entry<String, String> entryValue = iter.next();
            String key = entryValue.getKey().toLowerCase();
            if ("expires".equals(key)) {
                newMap.put("expires", entryValue.getValue());
                continue;
            }
            if ("encoding".equals(key)) {
                newMap.put("encoding", entryValue.getValue());
                continue;
            }
            if (!"type".equals(key)) continue;
            newMap.put("type", entryValue.getValue());
        }
        return newMap;
    }

    public static void createDirIfNotExist(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static String uploadFile(String srcFileName, String destFileName, boolean compress) {
        File f = new File(destFileName);
        if (f.getParent() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            byte[] buf;
            File src = new File(srcFileName);
            FileInputStream fis = new FileInputStream(src);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            if (compress) {
                buf = new byte[1024];
                int len = -1;
                while ((len = fis.read(buf)) != -1) {
                    gos.write(buf, 0, len);
                }
                gos.finish();
            } else {
                buf = new byte[1024];
                int len = -1;
                while ((len = fis.read(buf)) != -1) {
                    baos.write(buf, 0, len);
                }
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            fos.close();
            baos.close();
            gos.close();
            fis.close();
        }
        catch (Exception e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
        }
        return f.getAbsolutePath();
    }

    public static String uploadFileWithCompress(String parentFile, String srcFile) {
        File file = new File(parentFile);
        String childFile = Integer.toString(new Random().nextInt());
        File f = new File(file, childFile);
        try {
            File src = new File(srcFile);
            FileInputStream fis = new FileInputStream(src);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = fis.read(buf)) != -1) {
                gos.write(buf, 0, len);
            }
            gos.finish();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            fos.close();
            baos.close();
            gos.close();
            fis.close();
        }
        catch (Exception e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
        }
        return f.getAbsolutePath();
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    public static String writeFile(String filename, byte[] content, int size) {
        File f = new File(filename);
        if (f.getParent() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (size > -1) {
                byte[] newBuf = new byte[size];
                System.arraycopy(content, 0, newBuf, 0, size);
                content = newBuf;
            }
            baos.write(content);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            baos.close();
            fos.close();
        }
        catch (Exception e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
        }
        System.out.println("wrote " + f.getAbsolutePath() + "\n");
        return f.getAbsolutePath();
    }

    public static String writeFileWithCompress(String filename, byte[] content, int size) {
        File f = new File(filename);
        if (f.getParent() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            if (size > -1) {
                byte[] newBuf = new byte[size];
                System.arraycopy(content, 0, newBuf, 0, size);
                content = newBuf;
            }
            gos.write(content);
            gos.finish();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            baos.close();
            gos.close();
            fos.close();
        }
        catch (Exception e) {
            StackTraceElement[] st;
            for (StackTraceElement s : st = e.getStackTrace()) {
                logger.fatal((Object)s.toString());
            }
        }
        return f.getAbsolutePath();
    }
}

