/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.taskqueue;

import com.sina.sae.taskqueue.SaeScheduled;
import com.sina.sae.taskqueue.TaskInfo;
import com.sina.sae.taskqueue.TaskQueueItem;
import com.sina.sae.taskqueue.TaskQueueUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SaeTaskQueue {
    private static final int MAX_TASK_NUM = 256;
    private String accessKey;
    private String secretKey;
    private String queueName;
    private int errno;
    private String errmsg;
    private List<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
    private SaeScheduled schedulePool = new SaeScheduled(256);
    private boolean isDebug = false;
    private static Logger logger = Logger.getLogger((String)SaeTaskQueue.class.getName());

    public SaeTaskQueue(String queueName) {
        this.queueName = queueName;
        this.accessKey = UUID.randomUUID().toString();
        this.secretKey = UUID.randomUUID().toString();
    }

    public SaeTaskQueue(String accessKey, String secretKey, String queueName) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.queueName = queueName;
    }

    public void addTask(String url) {
        TaskInfo info = new TaskInfo();
        info.setExecuteUrl(url);
        info.setQueueName(this.queueName);
        this.taskInfos.add(info);
    }

    public void addTask(List<TaskQueueItem> list) {
        for (TaskQueueItem item : list) {
            TaskInfo info = new TaskInfo();
            info.setExecuteUrl(item.getUrl());
            info.setQueueName(this.queueName);
            info.setPostData(item.getPostStr());
            info.setPrior(item.isPrior());
            info.setDelay(item.getDelay());
            this.taskInfos.add(info);
        }
    }

    public void addTask(String url, Map<String, String> postData, boolean prior, int delay) {
        TaskInfo info = new TaskInfo();
        info.setExecuteUrl(url);
        info.setQueueName(this.queueName);
        info.setPostData(postData);
        info.setPrior(prior);
        info.setDelay(delay);
        this.taskInfos.add(info);
    }

    public boolean push() {
        if (this.schedulePool.getScheduleCount() < 256) {
            boolean result = true;
            for (TaskInfo info : this.taskInfos) {
                String url = info.getExecuteUrl();
                String queueName = info.getQueueName();
                Map<String, String> postData = info.getPostData();
                boolean prior = info.isPrior();
                int delay = info.getDelay();
                String postEncode = null;
                delay = TaskQueueUtil.fixMaxDelay(delay);
                ScheduleThread st = new ScheduleThread();
                st.url = url;
                st.queueName = queueName;
                st.postData = postData;
                st.prior = prior;
                st.delay = delay;
                ScheduledFuture<Boolean> feture = null;
                postEncode = TaskQueueUtil.changeStringToJsonArray(queueName, url, postData, prior, delay);
                st.postEncode = postEncode;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("urlencode+json : " + postEncode));
                }
                feture = this.schedulePool.schedule(st, (long)delay, TimeUnit.SECONDS);
                boolean isOk = false;
                try {
                    isOk = (Boolean)feture.get();
                }
                catch (Exception e) {
                    logger.error((Object)("execute failure " + info), (Throwable)e);
                }
                if (!result) continue;
                result = isOk;
            }
            this.schedulePool.shutdown();
            return result;
        }
        logger.warn((Object)"task queue is full.");
        this.schedulePool.shutdown();
        return false;
    }

    public int getErrno() {
        return this.errno;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setAuth(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    private boolean postData(Map<String, String> postEncode, String url) {
        try {
            int statusCode;
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost post = new HttpPost(url);
            this.genRequestHeader((HttpRequestBase)post);
            Set<Map.Entry<String, String>> entry = postEncode.entrySet();
            Iterator<Map.Entry<String, String>> iter = entry.iterator();
            StringBuilder postStr = new StringBuilder();
            while (iter.hasNext()) {
                Map.Entry<String, String> entryValue = iter.next();
                String name = entryValue.getKey();
                String value = entryValue.getValue();
                postStr.append(name).append("=").append(value).append("&");
            }
            if (postStr.length() > 0) {
                postStr.deleteCharAt(postStr.length() - 1);
            }
            post.setEntity((HttpEntity)new StringEntity(postStr.toString()));
            HttpResponse response = httpclient.execute((HttpUriRequest)post);
            if (this.isDebug && logger.isDebugEnabled()) {
                logger.debug((Object)("request url = " + post.getRequestLine().getUri()));
                logger.debug((Object)("request method = " + post.getRequestLine().getMethod()));
                logger.debug((Object)("request http version = " + post.getRequestLine().getProtocolVersion()));
                Header[] headers = post.getAllHeaders();
                logger.debug((Object)"request headers:");
                for (Header h : headers) {
                    logger.debug((Object)(h.getName() + " : " + h.getValue()));
                }
                logger.debug((Object)"body:");
                logger.debug((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            if (200 == (statusCode = response.getStatusLine().getStatusCode())) {
                this.errmsg = "success!";
                this.errno = 0;
                return true;
            }
            this.errmsg = response.getStatusLine().getReasonPhrase();
            this.errno = statusCode;
            if (this.isDebug && logger.isDebugEnabled()) {
                StatusLine sline = response.getStatusLine();
                logger.debug((Object)("status line =" + sline.getProtocolVersion() + " " + sline.getStatusCode() + " " + sline.getReasonPhrase()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"execute failure.", (Throwable)e);
        }
        return false;
    }

    public int getLeftLength() {
        return 256 - this.schedulePool.getScheduleCount();
    }

    public int getCurLength() {
        return this.schedulePool.getScheduleCount();
    }

    private void genRequestHeader(HttpRequestBase requestBase) {
        String timeStamp = TaskQueueUtil.getTimeStamp();
        requestBase.setHeader("TimeStamp", timeStamp);
        requestBase.setHeader("ACCESSKEY", this.accessKey);
        String content = "ACCESSKEY" + this.accessKey + "TIMESTAMP" + timeStamp;
        String signature = TaskQueueUtil.calcSignature(content, this.secretKey);
        requestBase.setHeader("Signature", signature);
        requestBase.setHeader("User-Agent", "SAE Online Platform");
        requestBase.setHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    private class ScheduleThread
    implements Callable<Boolean> {
        private String url;
        private String queueName;
        private Map<String, String> postData;
        private byte[] postBinary;
        private boolean prior;
        private int delay;
        private String postEncode = null;
        private boolean useStrPost = true;

        ScheduleThread() {
        }

        @Override
        public Boolean call() throws Exception {
            return SaeTaskQueue.this.postData(this.postData, this.url);
        }
    }
}

