<?php

/* ========================================================================
 * $Id: game.goods.php 14757 2017-07-29 23:51:40Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
#名称：游戏物品
#标识：game.goods

class onezphp_game_goods extends onezphp{
  /**
  * 添加物品到地图上
  * 
  * @return
  */
  function add($sceneid,$resid,$pos){
    global $G,$A;
    if($resid){
      $T=$G['this']->data()->open('res')->one("id='$resid'");
      $thumb=$T['thumb'];
      list($x,$y)=explode(',',$pos);
      $arr=array(
        'userid'=>$G['userid'],
        'name'=>$T['name'],
        'summary'=>$T['summary'],
        'thumb'=>$thumb,
        'resid'=>$resid,
        'restype'=>$T['token'],
        'sceneid'=>$G['player']['sceneid'],
        'upid'=>$G['appid'],
        'pos'=>$pos,
        'level'=>'front',
        'x'=>(int)$x,
        'y'=>(int)$y,
      );
      
      if($T['token']=='npc' || $T['token']=='monster' || $T['token']=='role'){
        $statusList=$G['this']->data()->open($T['token'].'_status')->one("upid='$resid' and token='stand'");
        $dirs=explode(',',$statusList['dir']);
        if(in_array('b',$dirs)){
          $dir='b';
        }else{
          list($dir)=$dirs;
        }
        $arr['dir']=$dir;
      }
      $goodsid=$G['this']->data()->open('mapgoods')->insert($arr);
      $A['call']=onez('game')->event(array(
        'token'=>'clearpage',
      ),array(
      /*
        'token'=>'event',
        'eventname'=>'addgoods',
        'action'=>'addgoods',
        'goodsid'=>$goodsid,
        */
        
        'token'=>'event',
        'eventname'=>'sendmsg',
        'action'=>'toscene',
        'to_sceneid'=>$G['player']['sceneid'],
        'msg'=>array(
          'action'=>'addgoods',
          'goodsid'=>$goodsid,
        ),
      ));
      $A['tip']='添加“'.$T['name'].'”成功';
      onez()->output($A);
      return $A;
    }
    
  }
  function event($goodsid,$resid,$action){
    return 'res&type=goodsevent&goodsid='.$goodsid.'&resid='.$resid.'&mod='.$action;
  }
  function findgoods($sceneid,$blocks){
    global $G,$A;
    !$sceneid && $sceneid=$G['player']['sceneid'];
    $arr=array();
    foreach(explode('|',$blocks) as $block){
      list($c,$r)=explode(',',$block);
      #*320/32=10;每个纹理上有10个块
      $left=$c*10;
      $right=$left+10;
      $top=$r*10;
      $bottom=$top+10;
      $arr[]="(index1>=$left and index1<$right and index2>=$top and index2<$bottom)";
    }
    if(!$arr){
      return;
    }
    $xxx=" and (".implode(' or ',$arr).")";
    $mapgoods=array();
    $T=$G['this']->data()->open('mapgoods')->record("upid='$sceneid'$xxx");
    foreach($T as $rs){
      $A['res']=array();
      $one=onez('game')->goods()->getRes($rs,'mapgoods');
      if($A['res']){
        $one['res']=$A['res'];
      }
      $mapgoods[]=$one;
    }
    $A['goods']=$mapgoods;
    $A['res']=array();
    onez()->output($A);
  }
  function click($goodsid,$resid=0){
    global $G,$A;
    $mapgoods=$G['this']->data()->open('mapgoods')->one("id='$goodsid'");
    !$resid && $resid=(int)$mapgoods['resid'];
    #$res=$G['this']->data()->open('res')->one("id='$mapgoods[resid]'");
    
    $A['pagetoken']='page';
    $A['title']=$mapgoods['name'];
    
    if($mapgoods['summary']){
      onez('game')->add('text',array(
        'text'=>$mapgoods['summary'],
        'width'=>'480',
        'x'=>'100',
      ));
    }
    
    $btns=array();
    if($G['player']['mode']=='editor'){
      $btns[]=array(
        'name'=>'我到那里去',
        'token'=>'page',
        'action'=>$this->event($goodsid,$resid,'mod_goto'),
      );
      $btns[]=array(
        'name'=>'到我这里来',
        'token'=>'page',
        'action'=>$this->event($goodsid,$resid,'mod_come'),
      );
      $btns[]=array(
        'name'=>'修改信息',
        'token'=>'page',
        'action'=>$this->event($goodsid,$resid,'mod_modify'),
      );
      
      $dir='';
      if($mapgoods['restype']=='monster' || $mapgoods['restype']=='npc' || $mapgoods['restype']=='role'){
        //$dir=onez('game')->rnddir($mapgoods['dir']);
        $btns[]=array(
          'name'=>'更改面对方向',
          'token'=>'page',
          'action'=>$this->event($goodsid,$resid,'mod_dir'),
        );
      }
      $btns[]=array(
        'name'=>'功能事件管理',
        'styleid'=>'yellow',
        'token'=>'page',
        'action'=>onez('x005001.2374')->action('events&goodsid='.$goodsid),
      );
      
      $btns[]=array(
        'name'=>'删除物件',
        'styleid'=>'red',
        'token'=>'confirm',
        'message'=>'您确定要删除此物件吗？',
        'action'=>$this->event($goodsid,$resid,'mod_delete'),
      );
    }
    $items=array();
    foreach($btns as $k=>$v){
      $v['exit']='1';
      $v['x']='80';
      $v['y']='30';
      $items[]=onez('game')->add('text',array(
        'text'=>'',
        'children'=>array(
          onez('game')->add('button',$v,0),
        ),
      ),0);
    }
    $col=3;
    $num=count($btns);
    if($num%$col==0){
      $row=$num/$col;
    }else{
      $row=intval($num/$col)+1;
    }
    $row=min($row,$col);
    $row>0 && onez('game')->add('list',array(
      'itemWidth'=>160,
      'itemHeight'=>80,
      'col'=>$col,
      'row'=>$row,
      'items'=>$items,
    ));
  }
  function mod_info($goodsid=0){
    global $G;
    !$goodsid && $goodsid=(int)onez()->gp('goodsid');
    $mapgoods=$G['this']->data()->open('mapgoods')->one("id='$goodsid'");
    $res=$G['this']->data()->open('res')->one("id='$mapgoods[resid]'");
    
    return array($goodsid,$mapgoods,$res);
  }
  function mod_goto(){//我到那里去
    global $G,$A,$record;
    list($goodsid,$mapgoods,$res)=$this->mod_info();
    
    $G['this']->data()->open('player')->update(array(
      'pos'=>$mapgoods['pos'],
    ),"userid='$G[userid]'");
    $A['exit']=1;
    $A['call']=onez('game')->event(array(
      'token'=>'clearpage',
    ),array(
      'token'=>'event',
      'eventname'=>'sendmsg',
      'action'=>'toscene',
      'to_sceneid'=>$G['player']['sceneid'],
      'msg'=>array(
        'action'=>'goto',
        'userid'=>$G['userid'],
        'to'=>$mapgoods['pos'],
      ),
    ));
  }
  function mod_come(){//Ta到我这里来
    global $G,$A,$record;
    list($goodsid,$mapgoods,$res)=$this->mod_info();
    
    $G['this']->data()->open('mapgoods')->update(array(
      'pos'=>$G['player']['pos'],
    ),"id='$goodsid'");
    $A['exit']=1;
    $A['call']=onez('game')->event(array(
      'token'=>'clearpage',
    ),array(
      'token'=>'event',
      'eventname'=>'sendmsg',
      'action'=>'toscene',
      'to_sceneid'=>$G['player']['sceneid'],
      'msg'=>array(
        'action'=>'goodsmove',
        'goodsid'=>$goodsid,
        'resid'=>$res['id'],
        'pos'=>$G['player']['pos'],
      ),
    ));
  }
  function mod_modify(){//修改资料
    global $G,$A,$record;
    list($goodsid,$mapgoods,$res)=$this->mod_info();
    
    if(defined('IS_POST')){
      $name=onez()->gp('name');
      if(!$name){
        $A['tip']='名称不能为空';
        return $A;
      }
      $onez=array();
      $onez['name']=$name;
      $onez['summary']=onez()->gp('summary');
      $onez['level']=onez()->gp('level');
      $onez['scale']=(int)onez()->gp('scale');
      $onez['hidename']=(int)onez()->gp('hidename')?0:1;
      $G['this']->data()->open('mapgoods')->update($onez,"id='$goodsid'");
      $A['tip']='保存成功';
      $A['exit']=1;
      $A['call']=onez('game')->event(array(
        'token'=>'clearpage',
      ),array(
        'token'=>'event',
        'eventname'=>'sendmsg',
        'action'=>'toscene',
        'to_sceneid'=>$G['player']['sceneid'],
        'msg'=>array(
          'action'=>'goodsupdate',
          'goodsid'=>$goodsid,
          'resid'=>$res['id'],
          'type'=>'reload',
        ),
      ));
      return $A;
    }
    onez('game')->set('labelWidth',80);
    onez('game')->set('valueWidth',330);
    $page=onez('game')->page();
    
    $mapgoods['hidename']=$mapgoods['hidename']?0:1;
    $page->data=$mapgoods;
    $page->set('action','setting');
    $page->set('title','修改名称');
    $page->set('dialog',array('popup'=>true,'close'=>true));
    
    $options=array();
    $options['back']='在人物后面';
    $options['front']='在人物前面';
    $page->add(array('label'=>'','type'=>'radios','key'=>'level','options'=>$options));
    
    $page->add(array('label'=>'显示名字','type'=>'checkbox','key'=>'hidename'));
    
    $page->addspace(10);
    
    $page->add(array('label'=>'名称','type'=>'text','key'=>'name','hint'=>'请正确填写名称','notempty'=>'名称不能为空'));
    $page->add(array('label'=>'介绍','type'=>'textarea','key'=>'summary','hint'=>'','notempty'=>''));
    $page->add(array('label'=>'缩放','type'=>'text','key'=>'scale','hint'=>'默认为100，不缩放','notempty'=>''));
    
    $page->addbutton(array(
      'name'=>'保存修改',
      'token'=>'submit',
    ));
    $page->addbutton(array(
      'name'=>'取消',
      'token'=>'close',
    ));
    $page->output();
  }
  function mod_delete(){//删除物件
    global $G,$A,$record;
    list($goodsid,$mapgoods,$res)=$this->mod_info();
    
    $G['this']->data()->open('mapgoods')->delete("id='$goodsid'");
    
    $A['call']=onez('game')->event(array(
      'token'=>'clearpage',
    ),array(
      'eventname'=>'goodsremove',
      'action'=>'goodsremove',
      'goodsid'=>$goodsid,
      'resid'=>$res['id'],
    ));
  }
  function mod_dir(){//更改朝向
    global $G,$A,$record;
    list($goodsid,$mapgoods,$res)=$this->mod_info();
    
    $dir=onez()->gp('dir');
    if($dir){
      $mapgoods=$G['this']->data()->open('mapgoods')->one("id='$goodsid'");
      $G['this']->data()->open('mapgoods')->update(array(
        'dir'=>$dir,
      ),"id='$goodsid'");
      $A['exit']=1;
      $A['call']=onez('game')->event(array(
        'token'=>'clearpage',
      ),array(
        'token'=>'event',
        'eventname'=>'sendmsg',
        'action'=>'toscene',
        'to_sceneid'=>$G['player']['sceneid'],
        'msg'=>array(
          'action'=>'goodsupdate',
          'goodsid'=>$goodsid,
          'resid'=>$res['id'],
          'type'=>'dir',
          'dir'=>$dir,
        ),
      ));
      
      return $A;
    }
    $A['pagetoken']='page';
    $A['title']='请选择面对方向';
    $btns=array();
    $dirs=array(
      'b'=>'正前 ↓',
      't'=>'正后 ↑',
      'l'=>'正左 ←',
      'r'=>'正右 →',
      'bl'=>'前左 ↙',
      'br'=>'前右 ↘',
      'tl'=>'后左 ↖',
      'tr'=>'后右↗ ',
    );
    $statusList=$G['this']->data()->open($res['token'].'_status')->one("upid='$res[id]' and token='stand'");
    if(count(explode(',',$statusList['dir']))==4){
      $dirs=array(
        'bl'=>'前左 ↙',
        'br'=>'前右 ↘',
        'tl'=>'后左 ↖',
        'tr'=>'后右↗ ',
      );
    }
    foreach($dirs as $dir=>$v){
      $btns[]=array(
        'name'=>$v,
        'token'=>'page',
        'action'=>$this->event($goodsid,$resid,'mod_dir&dir='.$dir),
      );
    }
    $items=array();
    foreach($btns as $k=>$v){
      $v['exit']='1';
      $v['x']='80';
      $v['y']='30';
      $items[]=onez('game')->add('text',array(
        'text'=>'',
        'children'=>array(
          onez('game')->add('button',$v,0),
        ),
      ),0);
    }
    $num=count($btns);
    if($num%4==0){
      $row=$num/4;
    }else{
      $row=intval($num/4)+1;
    }
    $row=min($row,4);
    $row>0 && onez('game')->add('list',array(
      'itemWidth'=>160,
      'itemHeight'=>80,
      'col'=>4,
      'row'=>$row,
      'items'=>$items,
    ));
  }
  /**
  * 显示添加到地图上的物品
  * @param undefined $resid
  * 
  * @return
  */
  function mapgoods($goodsid){
    global $G,$A;
    $infoA=array();
    $mapgoods=$G['this']->data()->open('mapgoods')->one("id='$goodsid'");
    if(!$mapgoods){
      $infoA['error']='物品不存在';
      return $infoA;
    }
    return $this->getRes($mapgoods,'mapgoods');
  }
  function getByResId($resid,$restype){
    global $G,$A;
    $res=$G['this']->data()->open('res')->one("id='$resid'");
    return $this->getRes($res);
  }
  //获取物品属性
  function getRes($T,$Ttype='mapgoods'){
    global $G,$A;
    $infoA=array();
    
    $infoA['status']='error';
    if($Ttype=='mapgoods'){
      $mapgoods=$T;
      $resid=$T['resid'];
      $res=$G['this']->data()->open('res')->one("id='$resid'");
      $infoA['goodsid']=(int)$T['id'];
      $infoA['resid']=(int)$resid;
    }elseif($Ttype=='res'){
      $resid=$T['id'];
      $res=$T;
      $infoA['resid']=(int)$resid;
    }else{
      return;
    }
    $infoA['status']='ok';
    $restype=$res['token'];
    
    $mapgoods['scale'] && $infoA['scale']=floatval($mapgoods['scale']/100);
    $infoA['restype']=$restype;
    $res['rect'] && $infoA['rect']=$res['rect'];
    $res['center'] && $infoA['center']=$res['center'];
    $infoA['nickname']=array(
      'type'=>'label',
      'offset'=>'0,10',
      'text'=>$res['name'],
      'color'=>'#ffff00',
      //'size'=>16,
      'attr'=>array(
        'stroke'=>5,
        'strokeColor'=>'#000000',
      ),
    );
    #NPC
    if($restype=='monster' || $restype=='npc' || $restype=='role'){
      $infoA['restype']='npc';
      $role=onez('game')->role();
      
      $T=$G['this']->data()->open($restype.'_status')->record("1 and upid='$res[id]' order by step,id");
      foreach($T as $rs){
        $item=array(
          'pic'=>onez('game')->resurl($rs['pic']),
          'col'=>$rs['col'],
          'dir'=>$rs['dir'],
          'center'=>$rs['center'],
          'speed'=>(int)$rs['speed'],
        );
        if($item['speed']<1){
          unset($item['speed']);
        }
        $role->add($rs['token'],$item);
      }
      $infoA['status']=$role->ui();
      
    }elseif($restype=='ani'){
      $infoA['restype']='ani';
      $infoA['pic']=onez('game')->resurl($res['pic']);
      $infoA['col']=$res['col'];
      $infoA['row']=$res['row'];
      $infoA['speed']=$res['speed'];
    }elseif($restype=='image'){
      $infoA['type']='image';
      $infoA['pic']=onez('game')->resurl($res['pic']);
    }
    if($mapgoods){
      $infoA['pos']=$mapgoods['pos'];
      $mapgoods['dir'] && $infoA['dir']=$mapgoods['dir'];
      $restype=$mapgoods['restype'];
      $resid=$mapgoods['resid'];
      if($mapgoods['level']=='front'){
        $infoA['is_top']=true;
      }
      if($mapgoods['name']){
        $infoA['nickname']['text']=$mapgoods['name'];
      }
      if($mapgoods['nickname']){
        $infoA['nickname']['text']=$mapgoods['nickname'];
      }
    }
    
    if($mapgoods['hidename']){
      unset($infoA['nickname']);
    }
    //$infoA['scale']=10;
    list($x,$y)=explode(',',$infoA['pos']);
    return $infoA;
  }
}