<?php

/* ========================================================================
 * $Id: image.php 4069 2017-07-11 10:12:31Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */

!defined('IN_ONEZ') && exit('Access Denied');
class onezphp_image extends onezphp{
  var $tmpfile='';
  var $outfile='';
  function __construct($file){
    
  }
  function seturl($pic){
    $this->pic=$pic;
    return $this;
  }
  function load($token, $id = 0){//避免与主类冲突
    $pic=$token;
    $this->close();
    if(strpos($pic,'http')===0){
      $data=onez()->post($pic);
    }elseif(is_file($pic) && file_exists($pic)){
      $data=onez()->read($pic);
    }else{
      $data=$pic;
    }
    $this->tmpfile=ONEZ_CACHE_PATH.'/image/'.uniqid().'.tmp';
    $this->outfile=ONEZ_CACHE_PATH.'/image/'.uniqid().'.png';
    onez()->mkdirs(dirname($this->outfile));
    onez()->write($this->tmpfile,$data);
    register_shutdown_function(array(&$this, 'close'));
    
    
    $this->type_in=$this->pictype($this->tmpfile);
    $this->type_out='png';
    $this->src=ImageCreateFromString($data);
    $this->src_w = imagesx($this->src);
    $this->src_h = imagesy($this->src);
    
    return $this;
  }
  function close(){
    if($this->src){
      imagedestroy($this->src);
      $this->src=null;
    }
    if(file_exists($this->tmpfile)){
      @unlink($this->tmpfile);
    }
    if(file_exists($this->outfile)){
      @unlink($this->outfile);
    }
  }
  /**   
   * 取得图片类型   
   *   
   * @param    string     $file_path    文件路径   
   */    
  function pictype($file_path){
    $type_list = array("1"=>"gif","2"=>"jpg","3"=>"png","4"=>"swf","5" => "psd","6"=>"bmp","15"=>"wbmp");
    if(file_exists($file_path)){
      $img_info = @getimagesize($file_path);
      if(isset($type_list[$img_info[2]])){
        Return $type_list[$img_info[2]];
      }
    }else{
      die("文件不存在,不能取得文件类型!");
    } 
  } 
  /**
  * 旋转
  * @param undefined $r
  * 
  * @return
  */
  function rotate($r){
    $this->src = imagerotate($this->src, $r, 0);
    $this->src_w=imagesx($this->src);
    $this->src_h=imagesy($this->src);
    return $this;
  }
  function resize($width,$height){
    $image = imagecreatetruecolor($width, $height);
    $alpha = imagecolorallocatealpha($image, 0, 0, 0, 127);  
    imagefill($image, 0, 0, $alpha);  
    imagecopyresampled($image, $this->src, 0, 0, 0, 0,$width,$height,$this->src_w, $this->src_h);
    imagesavealpha($image, true);
    imagepng($image,$this->outfile); 
    imagedestroy($this->src);
    
    $this->src=$image;
    $this->src_w=$width;
    $this->src_h=$height;
    return $this;
  }
  function data(){
    if(!file_exists($this->outfile)){
      imagepng($this->src,$this->outfile); 
    }
    return onez()->read($this->outfile);
  }
  function icon($size=32){
    if(!$this->pic){
      return'';
    }
    return '<img src="'.$this->pic.'" width="'.$size.'" height="'.$size.'" class="viewpic" onclick="'.onez('event')->load('viewpic')->args().'" /> ';
  }
  function seticon(){
    global $G;
    $html='';
    if($this->times(1)){
      $html.= onez('ui')->css($this->url.'/css/style.css');
      $G['footer'].= onez('ui')->js($this->url.'/js/main.js');
    }
    $html.='<div class="image-seticon" data-size="'.$this->get('size').'" data-value="'.$this->get('value').'" data-name="'.$this->get('name').'" data-server="'.$this->view('upload').'"></div>';
    echo $html;
  }
  function upload(){
    $A=array();
    $tmpfile=$_FILES['Filedata']['tmp_name'];
    if($_FILES['Filedata']['error']){
      onez()->error('上传失败['.$_FILES['Filedata']['error'].']');
    }
    if(!$tmpfile || !file_exists($tmpfile)){
      onez()->error('文件无效');
    }
    
    $data=onez()->read($tmpfile);
    $file='/cache/plugins/image/'.date('Y/m/d').'/'.uniqid().'.png';
    
    onez()->mkdirs(dirname(ONEZ_ROOT.$file));
    
    $im=imagecreatefromstring($data);
    imagepng($im,ONEZ_ROOT.$file);
    imagedestroy($im);
    @unlink($temp_file);
    
    $result=array();
    if(file_exists(ONEZ_ROOT.$file)){
      $A['status']='ok';
      $A['url']=onez()->homepage().$file;
    }else{
      onez()->error('文件无效');
    }
    onez()->output($A);
  }
}