﻿/* ********
*     Megami System Kernel{K1}
*     ~~ Gather Everything. ~~
*     By Infinte
*
*     Designed for web applications
*     No rights reserved.
*
*/

//命名空间类
var host = window,NameSpace,namespace,using,world;
void function() {
	NameSpace = function() {
		this.space = this;
	};

	var _NS = function(name, domain) {
		var _A = name.split('.');
		var _DOM = domain;
		for (i = 0; i < _A.length; i++) {
			if (!_DOM[_A[i]]) { _DOM[_A[i]] = new NameSpace() }
			_DOM = _DOM[_A[i]]
		};
		return _DOM;
	};

	NameSpace.prototype.namespace = function(path) {
		//子命名空间构造器，注意语法：namespace('.sub.sub.sub') 子空间； namespace(ns.sub.sbb)和window下面的一样。
		if (!path.match(/^\./)) return _NS(path, host);
		else return _NS(path.replace(/^\./, ''), this);
	};
	NameSpace.prototype.toString = NameSpace.prototype.valueOf = function() {
		return '[object Megamijs Namespace]';
	};

	//全局namespace注册器
	namespace = function() {
		var _DOM;
		for (h = 0; h < arguments.length; h++) {
			_DOM = _NS(arguments[h], host);
		}
		return _DOM;
	};

	// using功能
	using = function(nses) {
		var ref = {};
		for (var i = 0; i < arguments.length; i++) {
			if (arguments[i].space === arguments[i])
				for (var each in arguments[i])
				if (arguments[i].hasOwnProperty(each))
				ref[each] = arguments[i][each];
		};
		return ref;
	};
} ();
// 注册全局命名空间
namespace(
	'world' ,
	'world.util' ,
	'world.modules' ,
	'world.application' ,
	'world.environment' ,
	'world.assembly'
);
var application = world.application;
world.host = host;
with (namespace('world.util.originalTypes')) {
	space.Number = Number;
	space.String = String;
	space.Boolean = Boolean;
	space.Function = Function;
	space.Array = Array;
	space.Object = Object;
	space.Error = Error;
	space.RegExp = RegExp;
};
world.util.NameSpace = NameSpace;



//异常
// Adapted from Qomo
// 重写Error实现高级错误反馈

void function() {
	var _RTLERROR = new Error(8000, 'Megami核心瘫痪');
	var _Error = Error;
	;
	Error = function(v1, v2, v3) {
		var e, argn = arguments.length;

		if (v1 && v1 instanceof Array) {
			if (argn > 1) v3 = v2;
			v2 = '' + v1[1];
			v1 = v1[0];
		};
		if ((typeof v3 == 'string') || (v3 instanceof String)) { v3 = ({ reason: v3 }) };
		if (v2) v2 = v2.replace(/#\[([^\]:]+?)(?:\:([^\]]+?))?\]/g, function(s, $1, $2, pos, orig) {
			return (v3[$1] || $2 || '');
		});

		e = (v2 ? new _Error(v1, v2) : new _Error(v1));
		return e;
	}
	Error.constructor = _RTLERROR.constructor;
} ();

var Ragnarok; //核心崩溃(KP……)
var kernelPanic = Ragnarok = [8000, 'Megami核心瘫痪:#[reason:未指明的原因]'];
var notImplemented = [8001, '#[content:功能]未实现'];
var lowVersion = [8002, '#[content:功能]版本过低(期待#[expected],得到#[got:较低版本])'];
//var typeMismatch = [8003, '类型不匹配'];
var accessDenied = [8004, '#[access:访问]被拒绝'];
var deriveAvoid = [8005, '派生被拒绝:#[reason:基类不能派生]'];
var typeMismatch = [8006, '#[effect:类型不一致]:#[wanted]期待为#[expected],却得到#[got]'];

// empty function
var $void = function() { /* do nothing */ }
// list fast constructor
var $list = function() {
	if (arguments.length == 1)
		return [arguments[0]]
	else
		return Array.apply(null, arguments)
}
// unimplementament
var $abstract = function() { throw new Error(notImplemented) };
var $class = function() { throw new Error(notImplemented, { content: '此类' }) };
var $interface = function() { throw new Error(notImplemented, { content: '此接口' }) };
var $inheritedEx = function() { throw new Error(deriveAvoid, { reason: '不能进行多派生' }) };
//unaccessment
var unReadable = function() { throw new Error(accessDenied, { access: '属性读取' }) };
var unWriteable = function() { throw new Error(accessDenied, { access: '属性写入' }) };

//类型检测用
function isString(e) {
	return (typeof e == 'string') || (e instanceof String)
};
function isNumber(e) {
	return (typeof e == 'number') || (e instanceof Number)
};
function isBoolean(e) {
	return (typeof e == 'boolean') || (e instanceof Boolean)
};
function isUndefined(e) {
	return typeof e == 'undefined'
};
function isArray(e) {
	return (e && e instanceof Array)
}
function isFunction(e) {
	return (e && e instanceof Function)
};
function isObject(e) {
	return (typeof (e)) == 'object';
};
function exists(e) {
	return !((typeof (e)) == 'undefined');
};
function box(e) { //装箱 简单类型-->Object
	return Object(e);
};
with (namespace('world.util')) {
	space.isString = isString;
	space.isNumber = isNumber;
	space.isBoolean = isBoolean;
	space.isUndefined = isUndefined;
	space.isArray = isArray;
	space.isFunction = isFunction;
	space.isObject = isObject;
	space.exists = exists;
	space.box = box;
};


var Class;
var Interface;
void function() {
	// 下面是OOP用的方法
	// 或许是……
	// 天神赠与的礼物。
	// Bell会保佑用这些方法来OOP的人的，
	// 不过真的不想用的话也不会遭天谴。

	// 令牌
	var _mCHK = { };
	var _mSEALED = { };

	Function.prototype.inherits = function(base) {
		//派生关系，保留了prototype
		//只支持单派生
		//调用父类方法用CLASS.base('METHOD',this,ARGUMENTS)
		//访问父类成员用CLASS.inherited('member')

		if (base.sealed === _mSEALED) { // 不能派生密封类
			throw new Error(deriveAvoid, { reason: '不能派生密封类' })
		};


		var oproto = this.prototype; // 旧原型
		var _base = new base();   // 调用父类方法用
		var mid = function() { }; // 中间体
		mid.prototype = _base;
		this.prototype = new mid();
		for (var each in oproto) // 反射旧原型方法到新原型
			if (oproto.hasOwnProperty(each))
			this.prototype[each] = oproto[each];
		oproto = null;

		this.base = function(varName, subject, _ARGUMENTS_) { // 调用父类方法
			if (varName in _base) {
				if (_base[varName] instanceof Function) {
					return _base[varName].apply(subject, Array.prototype.slice.call(arguments, 2));
				}
				else
					return _base[varName];
			}
		};
		this.inherited = function(varName) { // 访问父类成员（调用时使用call）
			if (varName in _base) {
				return _base[varName];
			}
		};
		this.overrided = function(name) {
			return name in _base && this.prototype[name] !== _base[name]
		};
		this.added = function(name) {
			return name in this.prototype && !(name in _base);
		};
		this.baseConstructor = base; // 基类构造器
		this.inherits = this.derived = $inheritedEx; // 防止再次调用inherits
		return this;
	};
	Function.prototype.derived = Function.prototype.inherits;
	// 密封该类
	Function.prototype.seal = function() {
		this.sealed = _mSEALED;
	};
	Function.prototype.create = function() {
		//类的创建器，和用new等价
		//JS不支持在构造器用call和apply，所以……
		//Belldandy啊，感谢你告诉我怎么解决这个问题啊……
		var _args = [];
		for (i = 0; i < arguments.length; i++) _args.push('arguments[' + i + ']');

		return eval('new this(' + _args.join(',') + ')'); //eval都用上了……Bell啊，下次给个好点的主意吧……
	};
	Function.prototype.attach = function(interface, args) {
		//将接口附着在函数上
		var args = args || [];
		if (isFunction(interface))
			interface.apply(this.prototype, args);
		else if (isObject(interface)) {
			for (var each in interface) {
				this.prototype[each] = interface[each];
			}
		} else throw new Error(typeMismatch, { effect: '无法附加接口', wanted: '接口', expected: '函数或对象', got: (typeof interface) });
		return this;
	};
	Function.prototype.method = function(name, f) { //添加方法，高效
		if (!name || !isString(name)) throw new Error(typeMismatch, { effect: '方法定义失败', wanted: '方法名', expected: '字符串', got: (typeof name) });
		if (!isFunction(f)) throw new Error(typeMismatch, { wanted: '方法', got: (typeof f), expected: 'function' });
		this.prototype[name] = f;
		return this;
	};
	Function.prototype.field = function(name, f) { //添加原型成员，和method很相似
		if (!name || !isString(name)) throw new Error(typeMismatch, { effect: '方法定义失败', wanted: '成员名', expected: '字符串', got: (typeof name) });
		this.prototype[name] = f;
		return this;
	};
	Function.prototype.init = function(f) {
		this.method('init', f);
		return this;
	};
	Function.prototype.property = function(name, type, getter, setter) { //添加属性，可自定getter、setter
		if (!name || !isString(name)) throw new Error(typeMismatch, { effect: '方法定义失败', wanted: '属性名', expected: '字符串', got: (typeof name) });
		var localName = '__@[megami local]' + name;
		var TIF = isFunction(type);

		if (getter !== unReadable) {
			this.prototype['_get_' + name] = function() {
				if (this.hasOwnProperty('_getProp') && isFunction(this._getProp))
					return this._getProp.call(this, name, _mCHK);
				else
					return this[localName];
			};
			if (isFunction(getter)) {

			} else {
				this.prototype['get_' + name] = this.prototype['_get_' + name];
			};
		} else {
			this.prototype['_get_' + name] = this.prototype['get_' + name] = getter;
		};

		if (setter !== unWriteable) {
			this.prototype['_set_' + name] = function(value) {
				if (TIF && !(box(value) instanceof type)) {
					throw new Error(8006, '类型不一致');
				};
				if (this.hasOwnProperty('_setProp') && isFunction(this._setProp))
					this._setProp.call(this, name, value, _mCHK);
				else
					this[localName] = value;
				return this;
			};
			if (isFunction(setter)) {
				this.prototype['set_' + name] = setter;
			} else {
				this.prototype['set_' + name] = this.prototype['_set_' + name];
			}
		} else {
			this.prototype['_get_' + name] = this.prototype['set_' + name] = setter;
		};

		this.prototype[name] = new Function("value", " \
		if (arguments.length <= 0) { \
				return this['get_" + name + "'].call(this); \
		} else { \
				this['set_" + name + "'].call(this, value); \
				return this\
		}") //Belldandy啊，饶恕我吧，虽然这样不产生闭包
		return this;
	};
	Function.prototype.static = function(name, value) { //静态特征，包括属性和方法
		this[name] = value;
		return this;
	};
	Function.prototype.classOf = function(ob){
		return (ob instanceof this);
	};
	Function.prototype.convertFrom = function(ob){
		if(ob instanceof this) return ob;
	};

	// Class类模板
	var _initProps = function() {
		var __props = {};
		this._getProp = function(_n_, check) {
			if (check !== _mCHK) throw new Error(8004, '违例_getProp调用');
			if (__props.hasOwnProperty(_n_)) return __props[_n_];
		};
		this._setProp = function(_n_, _v_, check) {
			if (check !== _mCHK) throw new Error(8004, '违例_setProp调用');
			__props[_n_] = _v_;
			return _v_;
		};
		this._initProps = $void;
	};
	Class = function(derived, initer, _ints_) {
		if (isFunction(initer)) {
			var _cls = function(_ARGS_) {
				_initProps.call(this);
				initer.apply(this, arguments);
			};
		} else {
			var _cls = function(_ARGS_) {
				_initProps.call(this);
				if (isFunction(this.init))
					this.init.apply(this, arguments);
			};
		};
		if (isFunction(derived)) {
			_cls.inherits(derived);
			delete _cls.prototype._getProp;
			delete _cls.prototype._setProp;
		};
		_cls.method('init', $void);

		return _cls;
	};
	// Interface模板
	Interface = function() {
		var _attrs = {};
		var _int = function() {
			for (var each in _attrs) {
				this[each] = _attrs[each];
			};
		};
		_int.method = function(n, f) {
			_attrs[n] = f;
		};
		return _int;
	};

} ();

Number.classOf = function(e){
	return (typeof e === 'number') || (e instanceof Number);
};
String.classOf = function(e){
	return (typeof e === 'string') || (e instanceof String);
};
Boolean.classOf = function(e){
	return (typeof e === 'boolean') || (e instanceof Boolean);
};
Function.classOf = function(e){
	return (typeof e === 'function') && (e instanceof Function);
};

var GroupTemplate;
void function() {
	var GP_COVER = 1;
	var GP_STRUCTURE = 2;
	var filt = function() { this.structureFilter() };
	GroupTemplate = function(T, atts, prox) {
		var pt = T.prototype;
		var atts = atts || [];
		var prox = prox || {};
		var G = function(_arguments_) {
			var args;
			if (arguments.length === 1 && arguments[0] instanceof Array) args = arguments[0]
			else args = arguments;

			this.item = [];
			var m;
			for (var i = 0; i < args.length; i++) {
				if (args[i] instanceof T) this.item.push(args[i]);
				else if ((m = T.convertFrom(args[i])) instanceof T) this.item.push(m);
			};
			m = null;
		};
		for (var each in pt) {
			G.prototype[each] = T.prototype[each].multize('item', prox[each] & GP_COVER);
			if (prox[each] & GP_STRUCTURE) G.prototype[each] = G.prototype[each].before(filt);
		};
		G.prototype.include = function(item) {
			var m;
			if (item instanceof T) this.item.push(item);
			else if ((m = T.convertFrom(item)) instanceof T) this.item.push(m);
			return this;
		};
		G.prototype.exclude = function(no) {
			var m = this.item[no];
			this.item.splice(no, 1);
			return m;
		};
		G.prototype.clear = function() {
			this.item = [];
		};
		return G;
	};
}();
// 以下是原型扩展
// 除去左边空白
String.prototype.leftTrim = function() {
	return this.replace(/^\s+/g, "");
};
// 除去右边空白
String.prototype.rightTrim = function() {
	return this.replace(/\s+$/g, "");
};
// 除去两边空白
String.prototype.trim = function() {
	return this.replace(/(^\s+)|(\s+$)/g, "");
};
// 得到字节长度
String.prototype.bytes = function() {
	return this.replace(/[^\x00-\xff]/g, "--").length;
};
// Camel格
void function() {
	var _CAM1 = function(m, l) {
		return l.substr(0, 1).toUpperCase() + l.toLowerCase().substr(1, l.length);
	};
	var _CAM2 = function(m, l) {
		return l.toUpperCase();
	};
	String.prototype.toCamelCase = function() {
		return this.replace(/([A-Z]+)/g, _CAM1).replace(/[\-_\s](.)/g, _CAM2);
	};
} ();
// Pascal格
String.prototype.toPascalCase = function() {
	return ('-' + this).toCamelCase();
};

// HTML编码
String.prototype.encodeHTML = function() {
	return this.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;')
};
// js字符串编码
String.prototype.encodeJSString = function() {
	return '"' + this.replace(/\\/g, '\\\\').replace(/\r?\n/g, '\\n').replace(/\t/g, '\\t').replace(/"/g, "\\\"") + '"';
};
// MD5
void function() {
	var hexcase = 0;  /* hex output format. 0 - lowercase; 1 - uppercase        */
	var b64pad = ""; /* base-64 pad character. "=" for strict RFC compliance   */
	var chrsz = 16;  /* bits per input character. 8 - ASCII; 16 - Unicode      */

	/*
	* Calculate the MD5 of an array of little-endian words, and a bit length
	*/
	function core_md5(x, len) {
		len = len || x.length * chrsz;
		/* append padding */
		x[len >> 5] |= 0x80 << ((len) % 32);
		x[(((len + 64) >>> 9) << 4) + 14] = len;

		var a = 1732584193;
		var b = -271733879;
		var c = -1732584194;
		var d = 271733878;

		for (var i = 0; i < x.length; i += 16) {
			var olda = a;
			var oldb = b;
			var oldc = c;
			var oldd = d;

			a = md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
			d = md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
			c = md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
			b = md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
			a = md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
			d = md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
			c = md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
			b = md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
			a = md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
			d = md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
			c = md5_ff(c, d, a, b, x[i + 10], 17, -42063);
			b = md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
			a = md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
			d = md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
			c = md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
			b = md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);

			a = md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
			d = md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
			c = md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
			b = md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
			a = md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
			d = md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
			c = md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
			b = md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
			a = md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
			d = md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
			c = md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
			b = md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
			a = md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
			d = md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
			c = md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
			b = md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);

			a = md5_hh(a, b, c, d, x[i + 5], 4, -378558);
			d = md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
			c = md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
			b = md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
			a = md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
			d = md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
			c = md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
			b = md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
			a = md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
			d = md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
			c = md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
			b = md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
			a = md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
			d = md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
			c = md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
			b = md5_hh(b, c, d, a, x[i + 2], 23, -995338651);

			a = md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
			d = md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
			c = md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
			b = md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
			a = md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
			d = md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
			c = md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
			b = md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
			a = md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
			d = md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
			c = md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
			b = md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
			a = md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
			d = md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
			c = md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
			b = md5_ii(b, c, d, a, x[i + 9], 21, -343485551);

			a = safe_add(a, olda);
			b = safe_add(b, oldb);
			c = safe_add(c, oldc);
			d = safe_add(d, oldd);
		}
		return Array(a, b, c, d);

	}

	/*
	* These functions implement the four basic operations the algorithm uses.
	*/
	function md5_cmn(q, a, b, x, s, t) {
		return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b);
	}
	function md5_ff(a, b, c, d, x, s, t) {
		return md5_cmn((b & c) | ((~b) & d), a, b, x, s, t);
	}
	function md5_gg(a, b, c, d, x, s, t) {
		return md5_cmn((b & d) | (c & (~d)), a, b, x, s, t);
	}
	function md5_hh(a, b, c, d, x, s, t) {
		return md5_cmn(b ^ c ^ d, a, b, x, s, t);
	}
	function md5_ii(a, b, c, d, x, s, t) {
		return md5_cmn(c ^ (b | (~d)), a, b, x, s, t);
	}

	/*
	* Add integers, wrapping at 2^32. This uses 16-bit operations internally
	* to work around bugs in some JS interpreters.
	*/
	function safe_add(x, y) {
		var lsw = (x & 0xFFFF) + (y & 0xFFFF);
		var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
		return (msw << 16) | (lsw & 0xFFFF);
	}

	/*
	* Bitwise rotate a 32-bit number to the left.
	*/
	function bit_rol(num, cnt) {
		return (num << cnt) | (num >>> (32 - cnt));
	}

	/*
	* Convert a string to an array of little-endian words
	* If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
	*/
	function str2binl(str) {
		var bin = Array();
		var mask = (1 << chrsz) - 1;
		for (var i = 0; i < str.length * chrsz; i += chrsz)
			bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (i % 32);
		return bin;
	}
	/*
	* Convert an array of little-endian words to a hex string.
	*/
	function binl2hex(binarray) {
		var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
		var str = "";
		for (var i = 0; i < binarray.length * 4; i++) {
			str += hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8 + 4)) & 0xF) +
           hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8)) & 0xF);
		}
		return str;
	}
	/*
	* Convert an array of little-endian words to a base-64 string
	*/
	function binl2b64(binarray) {
		var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
		var str = "";
		for (var i = 0; i < binarray.length * 4; i += 3) {
			var triplet = (((binarray[i >> 2] >> 8 * (i % 4)) & 0xFF) << 16)
                | (((binarray[i + 1 >> 2] >> 8 * ((i + 1) % 4)) & 0xFF) << 8)
                | ((binarray[i + 2 >> 2] >> 8 * ((i + 2) % 4)) & 0xFF);
			for (var j = 0; j < 4; j++) {
				if (i * 8 + j * 6 > binarray.length * 32) str += b64pad;
				else str += tab.charAt((triplet >> 6 * (3 - j)) & 0x3F);
			}
		}
		return str;
	};


	// Megamijs interface
	String.prototype.md5bin = function() {
		return core_md5(str2binl(this));
	};
	String.prototype.md5 = function() {
		return binl2hex(this.MD5bin());
	};
	String.prototype.md5_base64 = function() {
		return binl2b64(this.MD5bin());
	};
} ();
// SHA2
void function() {
	var chrsz = 16;  /* bits per input character. 8 - ASCII; 16 - Unicode      */
	var hexcase = 0; /* hex output format. 0 - lowercase; 1 - uppercase        */
	function safe_add(x, y) {
		var lsw = (x & 0xFFFF) + (y & 0xFFFF);
		var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
		return (msw << 16) | (lsw & 0xFFFF);
	}
	function S(X, n) { return (X >>> n) | (X << (32 - n)); }
	function R(X, n) { return (X >>> n); }
	function Ch(x, y, z) { return ((x & y) ^ ((~x) & z)); }
	function Maj(x, y, z) { return ((x & y) ^ (x & z) ^ (y & z)); }
	function Sigma0256(x) { return (S(x, 2) ^ S(x, 13) ^ S(x, 22)); }
	function Sigma1256(x) { return (S(x, 6) ^ S(x, 11) ^ S(x, 25)); }
	function Gamma0256(x) { return (S(x, 7) ^ S(x, 18) ^ R(x, 3)); }
	function Gamma1256(x) { return (S(x, 17) ^ S(x, 19) ^ R(x, 10)); }

	function core_sha256(m, l) {
		var K = [
			0x428A2F98, 0x71374491, 0xB5C0FBCF, 0xE9B5DBA5, 0x3956C25B, 0x59F111F1, 0x923F82A4, 0xAB1C5ED5,
			0xD807AA98, 0x12835B01, 0x243185BE, 0x550C7DC3, 0x72BE5D74, 0x80DEB1FE, 0x9BDC06A7, 0xC19BF174, 
			0xE49B69C1, 0xEFBE4786,  0xFC19DC6, 0x240CA1CC, 0x2DE92C6F, 0x4A7484AA, 0x5CB0A9DC, 0x76F988DA, 
			0x983E5152, 0xA831C66D, 0xB00327C8, 0xBF597FC7, 0xC6E00BF3, 0xD5A79147, 0x6CA6351, 0x14292967, 
			0x27B70A85, 0x2E1B2138, 0x4D2C6DFC, 0x53380D13, 0x650A7354, 0x766A0ABB, 0x81C2C92E, 0x92722C85, 
			0xA2BFE8A1, 0xA81A664B, 0xC24B8B70, 0xC76C51A3, 0xD192E819, 0xD6990624, 0xF40E3585, 0x106AA070, 
			0x19A4C116, 0x1E376C08, 0x2748774C, 0x34B0BCB5, 0x391C0CB3, 0x4ED8AA4A, 0x5B9CCA4F, 0x682E6FF3, 
			0x748F82EE, 0x78A5636F, 0x84C87814, 0x8CC70208, 0x90BEFFFA, 0xA4506CEB, 0xBEF9A3F7, 0xC67178F2];
		var HASH = [0x6A09E667, 0xBB67AE85, 0x3C6EF372, 0xA54FF53A, 0x510E527F, 0x9B05688C, 0x1F83D9AB, 0x5BE0CD19];
		var W = new Array(64);
		var a, b, c, d, e, f, g, h, i, j;
		var T1, T2;

		/* append padding */
		m[l >> 5] |= 0x80 << (24 - l % 32);
		m[((l + 64 >> 9) << 4) + 15] = l;

		for (var i = 0; i < m.length; i += 16) {
			a = HASH[0];
			b = HASH[1];
			c = HASH[2];
			d = HASH[3];
			e = HASH[4];
			f = HASH[5];
			g = HASH[6];
			h = HASH[7];

			for (var j = 0; j < 64; j++) {
				if (j < 16) W[j] = m[j + i];
				else W[j] = safe_add(safe_add(safe_add(Gamma1256(W[j - 2]), W[j - 7]), Gamma0256(W[j - 15])), W[j - 16]);

				T1 = safe_add(safe_add(safe_add(safe_add(h, Sigma1256(e)), Ch(e, f, g)), K[j]), W[j]);
				T2 = safe_add(Sigma0256(a), Maj(a, b, c));

				h = g;
				g = f;
				f = e;
				e = safe_add(d, T1);
				d = c;
				c = b;
				b = a;
				a = safe_add(T1, T2);
			}

			HASH[0] = safe_add(a, HASH[0]);
			HASH[1] = safe_add(b, HASH[1]);
			HASH[2] = safe_add(c, HASH[2]);
			HASH[3] = safe_add(d, HASH[3]);
			HASH[4] = safe_add(e, HASH[4]);
			HASH[5] = safe_add(f, HASH[5]);
			HASH[6] = safe_add(g, HASH[6]);
			HASH[7] = safe_add(h, HASH[7]);
		}
		return HASH;
	}

	function str2binb(str) {
		var bin = Array();
		var mask = (1 << chrsz) - 1;
		for (var i = 0; i < str.length * chrsz; i += chrsz)
			bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << (24 - i % 32);
		return bin;
	}

	function binb2hex(binarray) {
		var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
		var str = "";
		for (var i = 0; i < binarray.length * 4; i++) {
			str += hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8 + 4)) & 0xF) +
           hex_tab.charAt((binarray[i >> 2] >> ((3 - i % 4) * 8)) & 0xF);
		}
		return str;
	}

	String.prototype.sha2bin = function() {
		return core_sha256(str2binb(this), this.length * chrsz);
	};
	String.prototype.sha2 = function() {
		return binb2hex(core_sha256(str2binb(this), this.length * chrsz));
	}
} ();
// 格式化
String.prototype.Format = function() {
	var tt = this;
	for (var n = 0; n < arguments.length; n++) {
		var reg;
		reg = new RegExp('\\{' + n + '\\}', 'g');
		tt = tt.replace(reg, arguments[n]);
	};
	return tt;
};

//合成正则
RegExp.prototype.compose = function(arg) {
	var src = this.source;
	var g = this.global;
	var i = this.ignoreCase;
	var m = this.multiLine;

	for (var each in arg) {
		src = src.replace(/`(.*?)`/, function(s, $1) { if (arg.hasOwnProperty($1)) return arg[$1].source; else return s });
	};
	return new RegExp(src, (g ? 'g' : '') + (i ? 'i' : '') + (m ? 'm' : ''));
}

//根据字符串返回javascript日期类型对象,如果不是合法的日期字符串返回null
Date.parseDate = function(date) {
	if (date == null) {
		return new Date();
	}
	if (date instanceof Date) {
		return date;
	}
	else {
		date = new Date(date.replace(/-/g, "/"));
	}
	if (isNaN(date.getTime())) {
		return null;
	}
	else
		return date;
};
//返回距离当前日期若干天之前/之后的日期
Date.prototype.getDateFrom = function(days) {
	if (isNaN(this.getTime()))
		return new Date();
	else
		return new Date(this.getTime() + 3600 * 24 * 1000 * days);
};
//格式化日期： var date = new Date(); var dateStr = date.toFormattedDateString("YYYY-MM-DD");
Date.prototype.toFormattedDateString = function(patternString) {
	if (patternString == null)
		return this.toLocaleString();

	var ret = patternString;
	var year = this.getFullYear();
	var month = this.getMonth() + 1;
	var date = this.getDate();
	var hour = this.getHours();
	var minute = this.getMinutes();
	var second = this.getSeconds();

	month = month > 9 ? "" + month : "0" + month;
	date = date > 9 ? "" + date : "0" + date;

	ret = ret.replace(/YYYY/gi, year);
	ret = ret.replace(/MM/g, month);
	ret = ret.replace(/DD/gi, date);

	ret = ret.replace(/HH/gi, hour);
	ret = ret.replace(/mm/g, minute);
	ret = ret.replace(/ss/gi, second);

	return ret;
};
Date.prototype.datePart = function() {
	return new Date(this.getFullYear(), this.getMonth(), this.getDate());
};
Date.now = function() {
	return new Date();
};

// 下面这些函数变换高手请无视
// 将函数绑定到具体对象（XE物慎用）
Function.prototype.bind = function(owner) {
	var $pointer = this;
	return function() {
		return $pointer.apply(owner, arguments);
	}
};
// 让函数只执行一次
Function.prototype.once = function() {
	var _exed = false;
	var $pointer = this;
	return function() {
		if (_exed) return;
		else {
			_exed = true;
			return $pointer.apply(this, arguments);
		};
	};
};
// 用于组模板的方法，将函数变成“多重的”，即invoke到一个array上，返回由返回值组成的array。
Function.prototype.multize = function(pn, over) {
	var F = this;
	return function(__ARGS__) {
		var domain = pn ? this[pn] : this;
		if (domain instanceof Array) {
			var r;
			if (!over) {
				r = [];
				for (var i = 0; i < domain.length; ++i) {
					r[i] = F.apply(domain[i], arguments);
				}
			} else {
				var m;
				for (var i = 0; i < domain.length; ++i) {
					m = F.apply(domain[i], arguments);
					if (m !== undefined) r = m;
				}
			};
			return r;
		}
		else return F.apply(this, arguments);
	};
};
// Curry化，期待更多参数的函数
Function.prototype.currize = function() {
	with ({ that: this }) {
		return function() {
			var args = Array.prototype.slice.call(arguments);
			if (args.length < that.length) {
				return function() {
					var _args = args.concat(Array.prototype.slice.call(arguments));
					return that.currize().apply(this, _args);
				}
			}
			else return that.apply(this, args);
		}
	};
};
// 连续化，将“片段”函数合称为连续的
// eg f.continus(0)(1,2,3,4,5) == f(f(f(f(1,2),3),4),5)
Function.prototype.continuous = function(direction) {
	var f = this;
	return function() {
		var rv, args = arguments;
		if (direction) { // 右向结合
			rv = f.call(this, args[args.length - 2], args[args.length - 1]);
			for (var i = args.length - 3; i >= 0; --i) rv = f.call(this, args[i], rv);
		} else { // 左向结合
			rv = f.call(this, args[0], args[1]);
			for (var i = 2; i < args.length; ++i) rv = f.call(this, rv, args[i]);
		};
		return rv;
	}
};
Function.prototype.before = function(adder) {
	var f = this;
	return function() {
		adder.apply(this, arguments);
		return f.apply(this, arguments);
	};
};
Function.prototype.after = function(adder) {
	var f = this;
	return function() {
		var rv = f.apply(this, arguments);
		adder.apply(this, arguments);
		return rv;
	};
};
world.Copyable = new Interface();
world.Copyable.method('copy', $abstract);
// disposable接口
world.Disposable = new Interface();
world.Disposable.method('dispose', $abstract);
world.TaskMachine = new Interface();
world.TaskMachine.method('accept',$abstract);
// 集合
var Collection = function() {
	var _member = {};
	var Col = function(name, value) { return _item.call(arguments.callee, name, value, arguments.length) };
	var _item = function(name, value, L) {
		if (L == 2) {
			_member[name] = value;
			return value
		} else {
			if (_member.hasOwnProperty(name))
				return _member[name]
			else
				return;
		}
	};
	return Col;
};

// Megami系统 依赖检测
function able(module, ability, version) {
	//检测能力是否被加入，非断言
	//eg able('belldandy','communicate','1.0.0')
	if (!world.modules[module] || (ability != '*' && !world.modules[module].abilities[ability]))
		return { check: false, version: '-0.0.0' }
	var version = version.split('.');
	var existsVersion = (ability == '*' ?
		world.modules[module].version :
		world.modules[module].abilities[ability].version).split('.');
	for (i = 0; i < version.length; i++) {
		if (!existsVersion[i]) existsVersion[i] = 0;
		if (parseInt(version[i], 10) > parseInt(existsVersion[i], 10))
			return { check: false, version: existsVersion.join('.') };
	}
	return { check: true };
};
function supports(module, ability, version) {
	//检测能力是否被加入，比requires更精细，是断言
	var _chk = able(module, ability, version);
	if (!_chk.check)
		throw new Error(lowVersion, { content: module + '.' + ability, expected: version, got: _chk.version });
};
var needs = supports;

// 选项与支持集合
var option = new Collection();
world.environment.supports = new Collection();


// 客户端探测
// op?
var isOpera = /opera/i.test(navigator.userAgent);
// ie?
var isIE = !isOpera && /msie/i.test(navigator.userAgent)
// ff?
var isFF = !isOpera && /firefox/i.test(navigator.userAgent);
// ie7?
var isIE7 = /msie 7/i.test(navigator.userAgent);
// webkit?
var isWebKit = /webkit/i.test(navigator.userAgent);

with (world.environment) {
	supports('DOMEvent', !!(document.documentElement.addEventListener));
	supports('IEEvent', !!(document.documentElement.attachEvent));
	supports('CSSOpacity', !isIE);
	supports('CSSXForm', !isIE && !isOpera);
	supports('Filter', isIE);
	supports('currentStyle', !!(document.documentElement.currentStyle));
	supports('BoundingRect', !!(document.documentElement.getBoundingClientRect));
	supports('compareDocumentPosition', !!(document.documentElement.compareDocumentPosition));
	supports('contains', !!(document.documentElement.contains));
	supports('createEvent',!!(document.createEvent));
};

// 基本DOM
// 获得文档的head，如果有的话
var $_head = function() {
	var heads = document.getElementsByTagName("head");
	return heads ? heads[0] : null;
};
// 获得文档的body，如果有的话 （$.body在applicaiton.init创建）
function $_body() {
	var bodys = document.getElementsByTagName("body");
	return bodys ? bodys[0] : null;
};
// 获得megami核心脚本所在的script DOM对象
var $_script = (function() {
	var scripts = document.getElementsByTagName("script");
	return scripts.length ? scripts[scripts.length - 1] : null;
})();
// 获得megami核心脚本的运行路径
var $_root = function() {
	return $_script.getAttribute("src").replace(/[^\/]+$/g, '');
} ();
var pageRect = function() {
	var w = (window.innerWidth) ? window.innerWidth : document.body.offsetWidth;
	var h = (window.innerHeight) ? window.innerHeight : document.body.offsetHeight;
	return { width: w, height: h };
};


// Megami 模块tag系统
// 格式eg：{module('ssss')};
var module, ability, version, endmodule, attribute, license;
void function() {
// Megami系统 支持机制
	var Module = function(appname, settings) {
		this.appName = appname;
		for (each in settings) this[each] = settings[each];
		this.abilities = {};
		this.constructor = arguments.callee;
	}
	Module.method('addAbility', function(name, version) {
		if (this.abilities[name]) throw new Error('Megami能力不能重复添加');
		this.abilities[name] = {
			abilityName: name,
			version: version
		};
	});
	var add = function(meg) {
		if (!meg instanceof Module) throw new Error('添加失败:传入值不是Megami模组');
		if (world.modules[meg.appName]) throw new Error('模组不能重复添加');
		world.modules[meg.appName] = meg;
	}

	world.modules.kernel = {         //核心描述，版本永远是K1.*.*.*
		appName: 'kernel',           // appn
		version: 'K1.0.6.20090726',  //注意K的含义……
		license: {                   //其实给kernel大谈执照没意义，因为kernel不是模组……不过还是写一下吧。
			level: 0,                //零级……（比一级还NB……）。另外注一下：原人设是class，这里和JS关键字冲突，改用level
			category: 0,             //未分类
			limited: true            //限制（给Kernel当然不能写附加……）
		}
	};

	var current;
	var defing = false;
	module = function(appname) {
		if (defing) {
			add(current);
			current = null;
		};
		current = new Module(appname, {});
		defing = true;
	};
	ability = function(abiname, vers) {
		if (!defing) return;
		current.addAbility(abiname, vers);
	};
	version = function(vers) {
		if (!defing) return;
		current.version = vers;
	};
	endmodule = function() {
		if (!defing) return;
		add(current);
		current = null;
		defing = false;
	};
	attribute = function(name, value) {
		if (!defing) return;
		current[name] = value;
	};
	license = function(level, category, limit) {
		attribute('license',
			{ level: level, category: category, limited: limit }
		);
	};
} ();

// Megami集会
// (这里都没有用with，以提高效率)
world.assembly.getXHR = function() {
	if ((!window.XMLHttpRequest) || (isIE7)) { //其实这里可以更简单一点的……
		for (var i = 0; i < 2; i++) {
			try {
				var xo = new ActiveXObject(["MSXml2.XMLHTTP", "Microsoft.XMLHTTP"][i]);
				return xo;
			} catch (e) {
				throw new Error(kernelPanic, 'XHR请求无法创建');
			}
		};
	} else {
		try {
			var xo = new XMLHttpRequest();
			return xo;
		} catch (e) {
			throw new Error(KernelPanic, 'XHR请求无法创建');
		}
	}
};
if (window.execScript == null) {
	window.execScript = function(script, type) {
		window.eval(script, type);
	}
};
world.assembly.execute = function(s) {
	try {
		window.execScript(s)
	} catch (ex) {
		throw new Error(ex.number, ex.message);
	};
};
// Megami反射
world.assembly.reflect = function(path, root) {
	root = root || world;
	var paths = path.split('.');
	var dom = root;
	for (i = 0; i < paths.length; i++) {
		if (!dom.hasOwnProperty(paths[i])) return null;
		dom = dom[paths[i]]
	}
	return dom;
};
var reflect = world.assembly.reflect;

//#wishbegin

// 上面的注释指导corodea在拼合Javascript时移除wish系统。请不要移除这个注释。（当然，和corodidea一块移除也可以）
// Megami 愿望系统
// 实际上就是导入啦！
void function() {

	// 映射和依赖
	var _maps = {};
	world.assembly.map = function(name, path) {
		_maps[name] = path;
	};
	var _depends = {};
	world.assembly.depend = function(m1, m2) {
		if (isString(_maps[m1])) m1 = _maps[m1];
		if (isString(_maps[m2])) m2 = _maps[m2];
		if (!_depends[m2]) _depends[m2] = {};
		_depends[m2][m1] = true;
	};
	var request = world.assembly.getXHR(); //主请求对象

	// Load And Exec
	var include = function(name) {
		if (!(typeof name == 'string') || !name) return;
		if (isString(_maps[name])) name = _maps[name];
		name = name.replace(/^~\//, $_root);
		if (request.overrideMimeType) request.overrideMimeType('text/javascript');
		try {
			request.open('GET', name, false);
			request.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
			request.send(null);
		} catch (e) { throw new Error(kernelPanic, e.message + '[' + name + ']') }
		if (request.status == 200 || request.status == 204 || request.status == 0) {
			world.assembly.execute(request.responseText);
		}
	};

	// DFS用'颜色'
	var COLOR = {
		WHITE: { CL: 0 },
		GRAY: { CL: 1 },
		BLACK: { CL: -1 }
	};

	// wish
	var _wishes = {};
	world.assembly.wish = function(name) {
		if (!(typeof name == 'string') || !name) return;
		if (isString(_maps[name])) name = _maps[name];
		_wishes[name] = { color: COLOR.WHITE };
	};

	// 配置文件
	include('~/modules.conf.js');

	// 页面wish
	var wishes = []
	.concat(($_script.getAttribute('wishes') || '').split(';'))
	.concat(($_script.getAttribute('modules') || '').split(';'));
	for (i = 0; i < wishes.length; i++)
		world.assembly.wish(wishes[i]);

	// 卸载WISH系统
	delete world.assembly.wish;
	delete world.assembly.map;
	delete world.assembly.depend;

	// 站点和页面配置文件
	include('siteconfig');
	include($_script.getAttribute('config'));

	// 拓扑排序 & Make_it_true
	var _TSQ = [];
	var _dfsvisit = function(name) {
		if (_wishes[name].color !== COLOR.WHITE) return;
		_wishes[name].color = COLOR.GRAY;
		if (!_depends[name]) _depends[name] = {};
		for (var each in _depends[name]) {
			_dfsvisit(each);
		};
		_wishes[name].color = COLOR.BLACK;
		_TSQ.unshift(name);
	};
	for (var each in _wishes) {
		if (_wishes[each].color === COLOR.WHITE) _dfsvisit(each);
	};
	for (var i = 0; i < _TSQ.length; i++) {
		include(_TSQ[i]);
		endmodule();
	};
	
	request = _TSQ = _wishes =  _maps = _depends = include = null; // 卸载
} ();

//#wishend