﻿/***
*   Megamijs
*   Dandy, v1(LVAID # 30478122)
*   ~~ Create wonder,For you. ~~
*   Infinte+{F}+{N}
*   NO RIGHTS RESERVED
*/

// 我希望……你这个……模组（汗~ by 某N）……能够……永远……留在我的身边……

{ module('dandy') }
{ version('1.0.12.20090923') }
{ license(1, 2, false) }

{ ability('eventable', '1.0.6') }
with (world) {

	//委托类
	//Delegate和C#的Delegate相似（吗？）
	space.Delegate = function(f, sender) {
		var _f;
		if (f instanceof Function)
			_f = f;
		else if (typeof (f) == 'string')
			_f = new Function(f);
		else throw new Error(typeMismatch, { effect: '委托创建失败', wanted: '响应者', expected: '函数或字符串', got: typeof f });
		this.handler = _f;
		this.sender = sender || null;
	};
	Delegate.convertFrom = function(m){
		if(isFunction(m))
			return new Delegate(m,null);
		else if(isString(m))
			return new Delegate(new Function(m),null);
		else return null;
	};
	Delegate.prototype.run = function(args) {
		if (this.sender)
			this.handler.apply(this.sender, arguments);
		else
			this.handler.apply(window, arguments);
	};
	Delegate.prototype.toString = Delegate.prototype.valueOf = function() {
		return '[Megami Delegate]'
	};
	Delegate.prototype.toFunction = function() {
		with ({ handler: this.handler, sender: this.sender }) {
			return function() {
				return handler.apply(sender, arguments);
			};
		};
	};

	// 事件类（=委托族）
	space.Event = new GroupTemplate(Delegate);
	Event.prototype.exclude = function(del) { //压出事件
		if (isNumber(del))
			this.item.splice(del, 1)
		else {
			for (i = 0; i < this.item.length; i++) {
				if (this.item[i] == del || this.item[i].handler == del) {
					this.item.splice(i, 1);
				}
			}
		};
		return this;
	};
	Event.prototype.toString = Event.prototype.valueOf = function() {
		return '[Megami Event]'
	};


	//接口：Eventable是一个重要的接口，它用来赋予对象自定义事件的能力
	//当对象类型的原型继承Eventable时，对象具有定义、分派和捕捉事件的能力
	//Eventable有3个重要的方法raiseEvent、addEventListener和removeEventListener
	space.Eventable = function() {
		this.raiseEvent = function(eventType, eventArgs, syn)
		//月版原来用dispatch的，这里照顾……呃……我的习惯，使用raise；syn是给一些要效率的过程用的。
		//当启用syn时，默认动作和捕捉不可用。
		//syn专为高效事件系统（如拖动时的实时动作）设计
		{
			var self = this;
			if (this.eventDisabled) return;
			eventArgs = eventArgs || {};
			eventArgs.target = eventArgs.target || this;
			var called = 0;
			var events = this["on" + eventType];
			if (!events) {
				this["on" + eventType] = new Event();
				events = this["on" + eventType]
			} else if (events && !(events instanceof Event)) {
				this["on" + eventType] = new Event(events);
				events = this["on" + eventType];
			};
			if (!eventArgs.type) eventArgs.type = eventType;
			
			//阻止默认动作的执行
			eventArgs.preventDefault = function() {
				this.defaultOp = null;
			};
			//阻止事件起泡
			eventArgs.stopPropagation = function() {
				this.cancelBubble = true;
			};
			//强制结束事件传播并执行defaultOp
			eventArgs.flushEvent = function(){
				this.stopPropagation;
				Function.classOf(this.defaultOp)?this.defaultOp.call(this.target,this,self):null;
				this.preventDefault();
			};
			
			if (!syn) setTimeout(
				function(events,self) {
					var len = events.length
					return function() {
						events.run(eventArgs);
						if (self.eventAcceptors) {
							var ep = self.eventAcceptors[eventType];
							if (ep && !(eventArgs.cancelBubble) && isFunction(ep.acceptor.raiseEvent)) {
								if(ep.conv)
									eventArgs = ep.conv(ep.acceptor,self,eventArgs);
								
								
								if (ep.map)
									ep.acceptor.raiseEvent(ep.map, eventArgs)
								else
									ep.acceptor.raiseEvent(eventType, eventArgs)
							}
						};
						if (isFunction(eventArgs.defaultOp)) {
							eventArgs.defaultOp.call(eventArgs.target,eventArgs,self);
							eventArgs.defaultOp = null;
						};
					};
				} (events,self), 0);
			else {
				events.run(eventArgs);
			};
		};
		this.listen = function(eventType, closure, caller) {
			var events = this["on" + eventType];
			if (!events || (events && !(events instanceof Event))) {
				this["on" + eventType] = new Event(events);
				events = this["on" + eventType];
			};
			var deleg = new Delegate(closure, caller);
			events.include(deleg);
			return deleg;
		};
		this.addEventListener = this.listen;

		this.unlisten = function(eventType, closure) {
			var events = this["on" + eventType];
			if(arguments.length===2){
				if (!events || (events && !(events instanceof Event))) {
					this["on" + eventType] = new Event(events);
					events = this["on" + eventType];
				};

				events.exclude(closure);
				return closure;
			} else {
				this['on' + eventType]?this['on' + eventType].clear():null;
			};
		};
		this.removeEventListener = this.unlisten;
		this.removeEventListeners = function(et){
			this.unlisten(et);
		}
		//this.removeEventListeners = this.unlistenAll;
		
		this.setEventAcceptor = function(evtType, obj, map, conv) {
			if (!isString(evtType) || !obj) return;
			if (!this.eventAcceptors) this.eventAcceptors = {};
			this.eventAcceptors[evtType] = { acceptor: obj };
			if (String.classOf(map))
				this.eventAcceptors[evtType].map = map;
			if(Function.classOf(conv))
				this.eventAcceptors[evtType].conv = conv;
		};
		this.removeEventAcceptor = function() {
			if (!this.eventAcceptors) this.eventAcceptors = {};
			this.eventAcceptors[evtType] = null;
			delete this.eventAcceptors[evtType];
		};
		this.disableEvents = function() {
			this.eventDisabled = true;
		};
		this.enableEvents = function() {
			this.eventDisabled = false;
		};
	};
}

{ ability('taskPool','1.0.1') }
world.TaskPool = function(T){
	var G = function(length){this.machines = [];this.queue = [];this.length = length || 10};
	G.attach(world.Eventable);
	void function(){
		var grOps = function(e){
			//page.output.print(this.queue.length);
			if(this.queue.length>0) {
				var t = this.queue.shift()
				e.flushEvent(); // 终止事件
				acceptTask(this,e.target,t.args,t.callback);
			} else {
				var completed = true;
				for(var i=this.machines.length-1;i>=0;i--)
					if(this.machines[i].busy){
						completed = false;
						break;
					};
				if(completed) this.raiseEvent('alldone');	
			};
		};
		var matOps = function(){
			this.busy = false;
		};
		var acceptTask = function(g,m,args,callback){
			m.unlisten('success');
			m.unlisten('fail');
			if(Function.classOf(callback))
				m.listen('success',callback,m);
			m.listen('success',matOps,m);
			m.listen('success',grOps,g);
			m.listen('fail',matOps,m);
			m.listen('fail',grOps,g);
			m.accept(args);
			m.busy = true;
			return args;
		};
		G.method('accept',function(args,callback){
			var foundFree = false,freeID=0,m=null;
			for(var i=0;i<this.machines.length;i++){
				if(!this.machines[i].busy) {
					foundFree = true;
					freeID = i;
				};
			};
			if(foundFree){
				var m = this.machines[freeID];
			} else if(this.machines.length<this.length){
				var m = new T();
				this.machines.push(m);
			};
			if(m){
				acceptTask(this,m,args,callback);
			} else {
				this.queue.push({args:args,callback:callback});
			};
		});
	}();
	
	return G;
}

{ ability('ffDOMExtension', '1.0.0') }

//这些东西是给FF用滴
if (typeof (HTMLElement) != "undefined" && !window.opera) {
	HTMLElement.prototype.__defineGetter__("outerHTML", function() {
		var a = this.attributes, str = "<" + this.tagName, i = 0; for (; i < a.length; i++)
			if (a[i].specified) str += " " + a[i].name + '="' + a[i].value + '"';
		if (!this.canHaveChildren) return str + " />";
		return str + ">" + this.innerHTML + "</" + this.tagName + ">";
	});
	HTMLElement.prototype.__defineSetter__("outerHTML", function(s) {
		var r = this.ownerDocument.createRange();
		r.setStartBefore(this);
		var df = r.createContextualFragment(s);
		this.parentNode.replaceChild(df, this);
		return s;
	});
	HTMLElement.prototype.__defineGetter__("innerText", function() {
		return this.textContent;
	});
	HTMLElement.prototype.__defineSetter__("innerText", function(s) {
		this.textContent = s;
		return s;
	});
	HTMLElement.prototype.__defineGetter__("canHaveChildren", function() {
		return !/^(area|base|basefont|col|frame|hr|img|br|input|isindex|link|meta|param)$/.test(this.tagName.toLowerCase());
	});
};

{ ability('HTMLElement', '1.0.4') }
namespace('world.web');
with (world.web) {
	space.HTMLElement = function(domObj) {
		if (domObj instanceof arguments.callee)
			return domObj
		else if (!domObj || !(domObj.nodeType))
			return null
		else
			this.el = domObj;
	};
	void function() {
		var _floatZIndex = 1000; //挡住~~

		HTMLElement.prototype.front = function() {
			this.el.style.zIndex = _floatZIndex;
			_floatZIndex += 10;
		}
		HTMLElement.prototype.back = function() {
			this.el.style.zIndex = _floatZIndex;
			_floatZIndex += 10;
		}
	} ();

	// 属性
	HTMLElement.prototype.setAttribute = function(propName, value) {
		//this.el[propName] = value;
		return this.el.setAttribute(propName, value);
	};
	HTMLElement.prototype.getAttribute = function(propName) {
		return this.el.getAttribute(propName);
	};
	HTMLElement.prototype.attr = function(name, val) {
		if (!exists(val))
			return this.el.getAttribute(name)
		else
			this.el.setAttribute(name, val);
	};
	HTMLElement.prototype.tag = function() {
		return ((!this.el.tagName.match(/:/) ?
		((!this.el.scopeName || this.el.scopeName == '' || this.el.scopeName == "HTML") ? '' : this.el.scopeName + ':') : '')
		+ this.el.tagName).toLowerCase();
	};
	HTMLElement.prototype.setText = function(text) {
		if (/^(input)|(select)|(textarea)$/i.test(this.el.tagName))
			this.el.value = text;
		else
			this.el.innerText = text;
	};
	HTMLElement.prototype.html = function(text) {
		if (arguments.length == 1) {
			this.el.innerHTML = text;
			return this;
		}
		else
			return this.el.innerHTML
	};
	HTMLElement.prototype.getValue = function() {
		var o = this.el;
		while (o.firstChild && o.firstChild.nodeType == 1)
			o = o.firstChild;
		if (typeof o.form != "undefined") {
			if (o.type == "checkbox" || o.type == "radio") {
				return o.checked;
			}
			return o.value;
		}
		else
			return o.innerHTML;
	};
	HTMLElement.prototype.setValue = function(v) {
		var o = this.el;
		while (o.childNodes[0] && o.childNodes[0].nodeType == 1)
			o = o.childNodes[0];
		if (typeof o.form != "undefined") {
			if (o.type == "checkbox" || o.type == "radio") {
				o.checked = v;
				return this;
			}
			o.value = v;
			return this
		}
		else {
			o.innerHTML = v;
			return this;
		}
	};
	HTMLElement.prototype.val = function(v) {
		return ((arguments.length >= 1) ? this.setValue : this.getValue).apply(this, arguments);
	};


	// 巡游
	HTMLElement.prototype.parent = function() {
		return new world.web.HTMLElement(this.el.parentNode)
	};
	HTMLElement.prototype.next = function() {
		var z = this.el.nextSibling;
		while (z != null && z.nodeType != 1) z = z.nextSibling;
		if (z != null && z.nodeType == 1)
			return new HTMLElement(z)
		else
			return null;
	};
	HTMLElement.prototype.prev = function() {
		var z = this.el.previousSibling;
		while (z != null && z.nodeType != 1) z = z.previousSibling;
		if (z != null && z.nodeType == 1)
			return new HTMLElement(z)
		else
			return null;
	};
	HTMLElement.prototype.firstChild = function() {
		var z = this.el.firstChild;
		while (z != null && z.nodeType != 1) z = z.nextSibling;
		if (z != null && z.nodeType == 1)
			return new HTMLElement(z)
		else
			return null;
	};
	HTMLElement.prototype.child = function(n) {
		var z = this.firstChild();
		while (n > 0 && z != null) {
			z = z.next();
			n--;
		};
		return z || null;
	};
	// 结构检测
	if (world.environment.supports('compareDocumentPosition')) {
		HTMLElement.compare = function(a, b) {
			return a.el.compareDocumentPosition(b.el);
		};
	} else {
		HTMLElement.compare = function(a, b) {
			var a = a.el, b = b.el;
			return (a != b && a.contains(b) && 16) +
					  (a != b && b.contains(a) && 8) +
					  (a.sourceIndex >= 0 && b.sourceIndex >= 0 ?
					   (a.sourceIndex < b.sourceIndex && 4) +
					   (a.sourceIndex > b.sourceIndex && 2) :
					   1);
		};
	};

	// 改变结构
	HTMLElement.prototype.append = function(data) {
		if (!data) return this;
		if (data instanceof String) {
			this.el.innerHTML += data;
			return this
		}
		if (data instanceof HTMLElement) {
			this.el.appendChild(data.el)
			return this
		}
		if (data.nodeType == 1) try {
			this.el.appendChild(data);
			return this;
		} catch (e) { }
	};
	HTMLElement.prototype.appendText = function(data) {
		this.el.appendChild(document.createTextNode(data));
		return this;
	};
	HTMLElement.prototype.before = function(data, ref) {
		if (!data) return this;
		if (data instanceof String) {
			this.el.innerHTML = data + this.el.innerHTML;
			return this
		}
		if (data instanceof HTMLElement) {
			this.el.insertBefore(data.el, ref || this.el.firstChild)
			return this
		}
		if (data.nodeType == 1) try {
			this.el.insertBefore(data, ref || this.el.firstChild);
			return this;
		} catch (e) { }
	};
	HTMLElement.prototype.replace = function(to, from) {
		var _t = to.el || to;
		var _f = from.el || from
		if (from instanceof HTMLElement && to instanceof HTMLElement) {
			try {
				this.el.replaceChild(_t, _f);
				return this
			} catch (e) { }
		}
	};
	HTMLElement.prototype.clone = function(_b) {
		return new HTMLElement(this.el.cloneNode(_b));
	};

	// 事件
	if (world.environment.supports('IEEvent')) {
		var _STOPPROG = function() {
			window.event.cancelBubble = true
		};
		var _PREVDEFT = function() {
			window.event.returnValue = false;
		};
		var _LB = function(){
			return this.button===1;
		};
		var _RB = function(){
			return this.button===2;
		};
		HTMLElement.prototype.listen = function(evtType, evtHandler, owner, capturing, userArgs) {
			var $pointer = owner || this;
			var $handler;
			capturing = capturing || false;

			if (!this.el.handlers) this.el.handlers = {};
			if (!this.el.handlers[evtType]) this.el.handlers[evtType] = [];

			$handler = function() {
				var evt = window.event;
				if (userArgs) {
					for (var each in userArgs) {
						evt[each] = userArgs[each];
					}
				}
				evt.target = evt.srcElement;
				evt.relatedTarget = evt.fromElement || evt.toElement;
				evt.leftButton = _LB;
				evt.rightButton = _RB;
				evt.layerX = evt.offsetX;
				evt.layerY = evt.offsetY;
				evt.stopPropagation = _STOPPROG;
				evt.preventDefault = _PREVDEFT;
				try {
					evt.pageX = evt.clientX + document.body.scrollLeft// - document.body.clientLeft;
					evt.pageY = evt.clientY + document.body.scrollTop //- document.body.clientTop;
				} catch (e) { }
				evt.attrName = evt.propertyName;

				return evtHandler.call($pointer, evt)
			};
			this.el.handlers[evtType].push($handler);
			this.el.attachEvent("on" + evtType, $handler);
			$handler.capturing = capturing;
			return $handler;
		};

	} else if (world.environment.supports('DOMEvent')){
		Event.prototype.leftButton = function() { return this.button == 0 };
		Event.prototype.rightButton = function() { return this.button == 2 };
		HTMLElement.prototype.listen = function(evtType, evtHandler, owner, capturing, userArgs) {
			var $pointer = owner || this;
			var $handler;
			capturing = capturing || false;

			if (!this.el.handlers) this.el.handlers = {};
			if (!this.el.handlers[evtType]) this.el.handlers[evtType] = [];
			$handler = function(event) {
				if (userArgs) {
					for (var each in userArgs) {
						event[each] = userArgs[each];
					}
				}
				return evtHandler.call($pointer, event)
			};
			this.el.handlers[evtType].push($handler);
			this.el.addEventListener(evtType, $handler, capturing);
			$handler.capturing = capturing;
			return $handler;
		};
	};
	HTMLElement.prototype.addEventListener = HTMLElement.prototype.listen;

	HTMLElement.prototype.unlisten = function(evtType, evtHandler, capturing) {
		if(arguments.length===1){
			if (!this.el.handlers) return;
			var events = this.el.handlers[evtType];
			if (events && events instanceof Array) {
				while (events.length) {
					this.removeEventListener(evtType, events[0], events[0].capturing);
				}
			}
			this.el.handlers[evtType] = null;
		} else {
			capturing = capturing || false;
			if (typeof (evtHandler) == 'number' && this.el.handlers && this.el.handlers[evtType])
				evtHandler = this.el.handlers[evtType][evtHandler]
			if (this.el.removeEventListener) {
				this.el.removeEventListener(evtType, evtHandler, capturing);
			} else if (this.el.detachEvent) {
				this.el.detachEvent("on" + evtType, evtHandler);
			}
			//事件句柄解注册
			if (this.el.handlers) {
				var events = this.el.handlers[evtType];
				if (events && events instanceof Array) {
					for (i = 0; i < events.length; i++) {
						if (events[i] == evtHandler)
							events.splice(i, 1);
					};
				};
			};
			return evtHandler;
		};
	};
	HTMLElement.prototype.removeEventListener = HTMLElement.prototype.unlisten;
	HTMLElement.prototype.removeEventListeners = function(et){
		this.unlisten(et);
	};
	HTMLElement.prototype.setCapture = function() {
		if (window.captureEvents) window.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP);
		else this.el.setCapture();
	};
	HTMLElement.prototype.releaseCapture = function() {
		if (window.releaseEvents) window.releaseEvents(Event.MOUSEMOVE | Event.MOUSEUP);
		else this.el.releaseCapture();
	};
	HTMLElement.prototype.setCursor = function(type) {
		this.el.style.cursor = type;
	};
	// CSS
	HTMLElement.prototype.addClass = function(c) {
		this.el.className = c + ' ' + this.el.className;
		return this;
	};
	HTMLElement.prototype.removeClass = function(c) {
		this.el.className = this.el.className.replace(new RegExp('\\b' + c + '\\b', 'g'), '').replace(/\s+/g, ' ');
		return this;
	};
	HTMLElement.prototype.setCSS = function(attribute, value) {
		if (!value)
			this.el.attribute = attribute;
		else
			this.el.style[attribute] = value;
	};
	HTMLElement.prototype.setCSSText = function(ruleText) {
		this.el.style.cssText = ruleText;
	};
	if(world.environment.supports('currentStyle')){
		HTMLElement.prototype.getCSS = function(attribute, frame) {
			return this.el.currentStyle[attribute];
		};
	} else {
		HTMLElement.prototype.getCSS = function(attribute, frame) {
			frame = frame || self;
			return frame.getComputedStyle(this.el, "")[attribute];
		};
	};
	HTMLElement.prototype.getCSS = function(attribute, frame) {
		frame = frame || self;
		if (this.el.currentStyle) {
			return this.el.currentStyle[attribute];
		}
		else if (frame.getComputedStyle) {
			//attribute = attribute.replace(/([A-Z])/g, "-$1").toLowerCase();
			return frame.getComputedStyle(this.el, "")[attribute];
		}
	};
	HTMLElement.prototype.css = function(prop, va, frame) {
		frame = frame || self;
		if (arguments.length >= 2) this.setCSS(prop, va)
		else return this.getCSS(prop, frame)
	};

	// 位置
	HTMLElement.prototype.moveTo = function(x, y) {
		return this.setPosition(x, y);
	};
	HTMLElement.prototype.setAbsPosition = function(x, y) {
		this.el.style.position = "absolute";
		var pos = this.getPosition();
		var npos = this.getAbsPosition();

		this.setPosition(x - npos.x + pos.x, y - npos.y + pos.y);
	};
	HTMLElement.prototype.setPosition = function(x, y) {
		x != null || (x = this.getPosition().x);
		y != null || (y = this.getPosition().y);

		this.el.style.position = "absolute";
		this.el.style.left = x + "px";
		this.el.style.top = y + "px";
		return this.el;
	};
	if (world.environment.supports('BoundingRect')) {
		HTMLElement.prototype.getAbsPosition = function() {
			var box = this.el.getBoundingClientRect();
			//var rootNode = this.el.ownerDocument;
			var l = isWebKit?0:document.documentElement.scrollLeft || (document.body.scrollLeft || 0);
			var t = isWebKit?0:document.documentElement.scrollTop || (document.body.scrollTop || 0);
			return { x: box.left + l, y: box.top + t };
		};
		HTMLElement.prototype.getPosition = function() {
			var box = this.el.getBoundingClientRect();
			var pbox = this.offsetParent ? this.offsetParent.getBoundingClientRect() : document.body.getBoundingClientRect();
			return {
				x: box.left - pbox.left,
				y: box.top - pbox.top
			};
		};
	} else {
		void function() {
			var _GETSTYL = function(e, attribute, frame) {
				frame = frame || self;
				attribute = attribute.replace(/([A-Z])/g, "-$1").toLowerCase();
				return frame.getComputedStyle(e, "").getPropertyValue(attribute);
			};
			HTMLElement.prototype.getAbsPosition = function() {
				var pos = [this.el.offsetLeft, this.el.offsetTop];
				var op = this.el.offsetParent;
				if (op != this.el) {
					if (isOpera) {
						while (op) {
							pos[0] += op.offsetLeft;
							pos[1] += op.offsetTop;
							op = op.offsetParent;
						}
					} else {
						while (op) {
							pos[0] += op.offsetLeft + (parseInt(_GETSTYL(op, 'borderLeftWidth')) || 0) - op.scrollLeft;
							pos[1] += op.offsetTop + (parseInt(_GETSTYL(op, 'borderTopWidth')) || 0) - op.scrollTop;
							op = op.offsetParent;
						}
					}
				};
				return { x: pos[0], y: pos[1] };
			};
			HTMLElement.prototype.getPosition = function() {
				var pTarget = this.el;
				var _x = pTarget.offsetLeft;
				var _y = pTarget.offsetTop;
				return { x: _x, y: _y };
			};
		} ();
	};
	// 大小
	HTMLElement.prototype.resize = function(w, h) {
		if (w != null)
			this.el.style.width = w + "px";
		if (h != null)
			this.el.style.height = h + "px";
	};
	HTMLElement.prototype.size = function() {
		return { width: parseInt(this.el.clientWidth), height: parseInt(this.el.clientHeight) };
	};
	HTMLElement.prototype.scrollSize = function() {
		return { width: this.el.scrollWidth, height: this.el.scrollHeight };
	};
	HTMLElement.prototype.setFontColor = function(color) {
		this.el.style.color = color;
	};
	//获得鼠标相对于元素的位置
	HTMLElement.getMousePosition = function(evt) {
		var _x, _y;
		evt = evt || window.event;
		if (evt.layerX && evt.layerY) {
			_x = evt.layerX;
			_y = evt.layerY;
		}
		else {
			_x = evt.clientX + document.body.scrollLeft - document.body.clientLeft;
			_y = evt.clientY + document.body.scrollTop - document.body.clientTop;
		}
		return { x: _x, y: _y };
	};

	// 显示和隐藏
	HTMLElement.prototype.show = function() {
		this.el.style.display = "block";
	};
	HTMLElement.prototype.hide = function() {
		this.el.style.display = "none";
	};
	HTMLElement.prototype.appear = function() {
		this.el.style.visibility = 'visible';
	};
	HTMLElement.prototype.disappear = function() {
		this.el.style.visibility = 'hidden';
	};
	HTMLElement.prototype.visible = function() {
		return this.css('display') != "none" && this.css('visibility') != "hidden";
	};
	HTMLElement.prototype.toggle = function(_hideHdl, _showHdl) {
		this.el.style.display = (this.css('display') != "none") ? "none" : "block";
		if (_hideHdl && this.css('display') == "none") _hideHdl(this);
		else if (_showHdl) _showHdl(this);
	};
	HTMLElement.prototype.hideChildren = function() {
		if (this._hideChildren == true) return false;
		for (var i = 0; i < this.el.childNodes.length; i++) {
			var _c = this.el.childNodes[i];
			if (_c.nodeType == 1) {
				_c.setAttribute("_saveVisibility", _c.style.visibility);
				_c.style.visibility = "hidden";
			}
		}
		this._hideChildren = true;
		return true;
	};
	HTMLElement.prototype.showChildren = function() {
		for (var i = 0; i < this.el.childNodes.length; i++) {
			var _c = this.el.childNodes[i];
			if (_c.nodeType == 1) {
				_c.style.visibility = _c.getAttribute("_saveVisibility") || "visible";
			}
		}
		this._hideChildren = false;
		return true;
	};

	// 透明度
	if (world.environment.supports('CSSOpacity')) {
		HTMLElement.prototype.setOpacity = function(o) {
			o = (o < 0.01 ? 0 : (o > 0.995 ? 1 : o));
			this.css('opacity', o);
			return this;
		};
		HTMLElement.prototype.getOpacity = function() {
			return parseFloat(this.css('opacity')) || 1;
		};
	} else if (world.environment.supports('Filter')) {
		HTMLElement.prototype.setOpacity = function(o) {
			if (!/BasicImage/.test(this.css('filter')) && o <= 0.995) {
				this.el.style.filter += 'progid:DXImageTransform.Microsoft.BasicImage(opacity=' + o + ')';
			}
			o = (o < 0.01 ? 0 : (o > 0.995 ? 1 : o));
			if (o > 0.995) {
				if (this.el.filters.length == 1) this.el.style.removeAttribute('filter');
			}
			else this.el.filters('DXImageTransform.Microsoft.BasicImage').Opacity = o;
		};
		HTMLElement.prototype.getOpacity = function() {
			if (!/BasicImage/.test(this.css('filter'))) return 1;
			return this.el.filters('DXImageTransform.Microsoft.BasicImage').Opacity;
		};
	};
	HTMLElement.prototype.opacity = function(o) {
		return ((arguments.length >= 1) ? this.setOpacity : this.getOpacity).apply(this, arguments);
	};

	HTMLElement.prototype.trash = function() {
		$trash(this.el);
		this.el = null;
		this.unloaded = true;
	};
	HTMLElement.blackSheepWall = {
		show: function(opacity) {
			var _sheep = $.id("_megamijs_black_sheep_wall");
			if (!_sheep) {
				opacity = opacity || 0;
				var _div = $html("div");
				_div.el.style.position = "absolute";
				_div.el.id = "_megamijs_black_sheep_wall";
				_div.el.style.margin = "0 0 0 0";
				_div.setPosition(0, 0);
				_div.el.style.backgroundColor = "#444";
				_div.el.style.filter = "alpha(opacity=" + opacity + ")";
				_div.el.style.opacity = opacity;
				$body().appendChild(_div.el);
				var rect = pageRect();
				_div.el.style.width = rect.width;
				_div.el.style.height = rect.height;
			}
		},
		hide: function() {
			$body().removeChild($("_megamijs_black_sheep_wall"));
		}
	};
	HTMLElement.seal();

	{ ability('CSSStyleSheet', '1.0.0') }

	CSSStyleSheet = function() {
		this.constructor = arguments.callee;
	};
	CSSStyleSheet.load = function(fullPath, media) {
		media = media || "all";
		var link = document.createElement("link");
		link.setAttribute("href", fullPath);
		link.setAttribute("type", "text/css");
		link.setAttribute("rel", "stylesheet");
		link.setAttribute("rev", "stylesheet");
		link.setAttribute("media", media);
		var head = $_head();
		if (head) {
			head.appendChild(link);
		}
		return new CSSStyleSheet();
	};

	{ ability('build', '1.0.0') }

	space.build = function(tagname, attributes, children) {

		// If we were invoked with two arguments the attributes argument is
		// an array or string, it should really be the children arguments.
		if (arguments.length == 2 &&
					(attributes instanceof Array || isString(attributes))) {
			children = attributes;
			attributes = null;
		};

		// Create the element
		var e = new HTMLElement(document.createElement(tagname));

		// Set attributes
		if (attributes) {
			for (var name in attributes) {
				switch (name) {
					case 'css':
						var css = attributes[name];
						for (var prop in css)
							e.css(prop, css[prop]);
						break;
					default: e.attr(name, attributes[name]);
				};
			};
		}

		// Add children, if any were specified.
		if (children != null) {
			if (children instanceof Array) {  // If it really is an array
				for (var i = 0; i < children.length; i++) { // Loop through kids
					var child = children[i];
					if (typeof child == "string") {          // Handle text nodes
						e.appendText(child);
						continue;
					}
					e.append(child);  // Assume anything else is a Node
				}
			}
			else if (typeof children == "string") // Handle single text child
				e.appendText(children);
			else e.append(children);         // Handle any other single child
		}

		// Finally, return the element.
		return e;
	};

	/**
	* maker(tagname): return a function that calls make() for the specified tag.
	* Example: var table = maker("table"), tr = maker("tr"), td = maker("td");
	*/
	space.Builder = function(tag) {
		return function(attrs, kids) {
			if (arguments.length == 1) return build(tag, attrs);
			else return build(tag, attrs, kids);
		}
	};
	namespace('.tag');

	void function() {
		var HTMLTags = ['a', 'abbr', 'acronym', 'address', 'area', 'b', 'base', 'bdo', 'big', 'blockquote', 'br', 'button', 'caption', 'cite',
		'code', 'col', 'colgroup', 'dd', 'del', 'dfn', 'div', 'dl', 'dt', 'em', 'fieldset', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6',
		'hr', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'link', 'map', 'meta', 'noscript', 'object', 'ol', 'optgroup',
		'option', 'p', 'param', 'pre', 'q', 'samp', 'script', 'select', 'small', 'span', 'strong', 'style', 'sub', 'sup', 'table', 'tbody', 'td',
		'textarea', 'tfoot', 'th', 'thead', 'title', 'tr', 'tt', 'ul', 'var'];
		for (var i = 0; i < HTMLTags.length; i++) {
			tag[HTMLTags[i].toPascalCase()] = Builder(HTMLTags[i]);
		};
	} ();

};


{ ability('$query', '1.0.6') }

// world.$并不是一个"真"ns，它可是一个方法哦~
world.$ = function(e) {
	if (e) return new world.web.HTMLElement($.id(e))
	else return new Function();
};
world.$.space = world.$;
var $ = world.$;
world.$._ = function(id) {
	if (!id) return null;
	var domObj = $.id(id);
	if (!domObj || domObj.nodeType == 1)
		return domObj;     //获得DOM元素（若有）
	else
		return $.html(id); //创建tagName元素
}
var $_ = world.$._;
world.$.id = function(e) {
	return document.getElementById(e)
}
world.$.html = function(tagName, id) {
	if (tagName.nodeType == 1)
		return new world.web.HTMLElement(tagName);

	var domObj = document.createElement(tagName);
	if (id) domObj.setAttribute("id", id);
	var ret = new world.web.HTMLElement(domObj);
	return ret;
};
world.$.create = world.$.html;
var $html = world.$.html;

world.$.trash = function(node) {
	if (isIE) {
		setTimeout(CollectGarbage, 200);
	}
	if (node) {
		var _id = "_megami_trash_container";  //用来回收不要的DOM，避免内存泄漏
		var _trash = $_(_id);
		if (!_trash) {
			_trash = $html("megami:trash", _id).el;
			_trash.style.display = "none";
			$_body().appendChild(_trash);
		}
		_trash.appendChild(node);
		_trash.innerHTML = '';
		_trash = null;
		_node = null;
	}
}
var $trash = world.$.trash;

world.$.root = new world.web.HTMLElement(document.documentElement);

{ ability('controlCore', '1.0.4') }

namespace('world.control');
with (world.control) {
	/*
	*  UserControl接口是用户控件的基类。
	*  它包含一个load函数，来初始化这个用户控件，并和DOM关联。
	*  控件的类使用下面的格式书写：
	*  library.class
	*  megami默认的库为system。它位于ctl_system.js中。
	*  控件可以相互包含。
	*/
	space.UserControl = new Class()
	with(space.UserControl) {
		attach(world.Eventable);
		//属性映射时的内部属性名
		static('_protectedAttrName',
			'hideFocus,id,aria-level,class,disabled,contentEditable,aria-setsize,tabIndex,aria-posinset,className');
		field('uClass', 'UserControl');
		field('loaded',false);
		method('loadFace', function(face, parent, id) {
			//设定用户控件的HTML面
			if (!face) {
				var face = $html('megami:control', id);
				face.addClass(this.uClass);
				parent.append(face);
			};
			this.face = face;
			return face;
		});
		method('loadEvents', $void);
		method('load', function(face, parent, id) {
			this.loadFace(face, parent, id);
			this.loadEvents();
			this.loaded = true;
			this.raiseEvent('load');
		});
		method('unloadFace', $abstract); //卸载用户控件的HTML面
		method('unloadEvents', $abstract); //卸载用户控件的HTML面
		method('unload', function() {
			this.loaded = false;
			this.unloadEvents();
			this.unloadFace();
			this.raiseEvent('unload');
		});
		method('disable', function() {
			this.disabled = true;
			this.disableEvents();
		});
		method('enable', function() {
			this.disabled = false;
			this.enableEvents();
		});
		method('mapAttribute', function(name, donor) {
			var donor = donor || this.face;
			if (!donor || !(donor instanceof world.web.HTMLElement)) return;
			if(Function.classOf(this[name])) 
				this['set_'+name](donor.attr(name))
			else
				this[name] = donor.attr(name);
		});
	};


	space.Container = new Class(UserControl, function() {
		this.count = 0;
	});
	Container.method('load',function(f,p,i){
		this.loadFace(f, p, i);
		this.loadEvents();
		setupAll(this.face.el);
		this.loaded = true;
		this.raiseEvent('load');
	});
	Container.method('append', function(face) {
		this.face.append(face);
	});
	Container.method('addControl', function(ctl, id) {
		var id=id || ('CTL_'+(++ this.count));
		ctl.load(null, this.face, id);
		this[id] = ctl;
		this.raiseEvent('addedControl', { added: ctl, addedId: id });
		return ctl;
	});


	space.setup = function(element) {
		if (element) {
			var type = element.getAttribute('class') || element.getAttribute('className');
			if (world.assembly.reflect(type, world.control)) {
				var Class = world.assembly.reflect(type, world.control)
				var _control = new Class();
				var id = element.getAttribute('id') || ('Control_' + world.application.page.count);
				_control.load($html(element), $html(element.parentNode), id);
				page[id] = _control;
				page.count++;
			}
		} else throw new Error(notImplemented)
	};

	space.setupAll = function(node) {
		node = node || $_body();
		if (node.tagName.toString().toLowerCase() == 'megami:control' || node.tagName.toString().toLowerCase() == 'control')
			setup(node)
		else {
			var z = node.firstChild;
			while (z != null) {
				if (z.nodeType == 1) {
					var _z = z;
					z = z.nextSibling;
					setupAll(_z)
				} else z = z.nextSibling;
			};
		};
	};
};

{ ability('page', '1.0.5') }

//初始化应用程序
world.application.page = new world.control.Container();
var page = world.application.page;
page.count = 1;

{ ability('init','1.0.1') }
world.application.init = new world.Event();
world.application.init.include(function() {
	world.control.setupAll();
	world.$.body = $.html($_body());
	page.face = $.body;
});
var $init = world.$.init = function(f) {
	world.application.init.include(f);
};

if (window.addEventListener)
	window.addEventListener("load", function() { world.application.init.run() }, false);
else if (window.attachEvent)
	window.attachEvent("onload", function() { world.application.init.run() });
else window.onload = function() { world.application.init.run() };


{ ability('communicate', '1.0.1') }
/*
*   [Dandy:Communicate]
*   [交流]
*   包含AJAX功能
*/
namespace('world.ajax');
world.ajax.Request = function() {
	this.constructor = arguments.callee;
	this.XHR = world.assembly.getXHR();
};
with (world.ajax.Request) {
	attach(world.Eventable);
	attach(world.TaskMachine);
	property('async');
	//prototype.async(false);
	property('url');
	property('method');
	void function(){
		var defop = function(ea,x) { this.locked = false;clearTimeout(this.abortThread);};
		method('send', function(method,url,async,data,overtime) {
			if (this.locked) return;
			try {
				this.async(async);
				this.url(url);
				this.method(method || 'get');
				this.XHR.open(method, url, async);
				this.XHR.setRequestHeader("If-Modified-Since", "Thu, 01 Jan 1970 00:00:00 GMT");
				overtime = overtime || 10000;
				if (this.async()) {
					var self = this;
					this.XHR.onreadystatechange = function() {
						if (self.XHR.readyState===4) {
							if (self.XHR.status == 200 || self.XHR.status == 0 || self.XHR.status == 204 || self.XHR.status == 304)
								self.raiseEvent('success', { request: self.XHR, defaultOp:  defop});
							else
								self.raiseEvent('fail', { defaultOp: defop});
								
							self.locked = false;
						}
					};
					this.abortThread = setTimeout(function(self){
						return function(){
							self.XHR.abort();
							self.raiseEvent('fail',{defaultOp:defop});
							self.locked = false;
						}
					}(this),overtime);
				};
				this.locked = true;
				this.XHR.send(data || null);
			} catch (e) {
				this.raiseEvent('fail', { defaultOp: defop});
				self.locked = false;
			};
		});
	}();
	method('accept',function(args){
		this.send(args.method||'get',args.url,(args.async===undefined ? true:args.async),args.data);
	});
};

world.ajax.RequestPool = new world.TaskPool(world.ajax.Request);
// Stylesheeta FeDRO
// 2009