﻿/*
 *  Illis Library for Effects.
 *  Infinte
 *  
 *  The Future is Now.
 *  
 *  I Have a dream that the web will be standard and open.
 *  
 */

{ module('illis') }
{ version('1.0.5.20090916') }
{ license(2, 3, false) }

with(namespace('world.time')){
	{ ability('task', '1.0.2') }

	space.Task = function() { };
	Task.field('enter', null);
	Task.field('frame', null);
	Task.field('leave', null);

	{ ability('layer', '1.0.2') }
	
	space.layerPhase = {
		READY: { PH: 0 },   // 就绪
		RUNNING: { PH: 1 }, // 运行中
		PAUSED: { PH: 2 }   // 中断
	};
	space.Layer = new Class(null, function() {
		this.tasks = [];
		this.TID = 0;
		this.info = {
			phase: layerPhase.READY
		};
	});
	Layer.property('running', null, function() {
		return this.tasks[0];
	}, function(v) {
		this.transfer(v);
	});
	Layer.method('push', function(t) {
		this.tasks.push(t);
	});
	Layer.method('start', function() {
		if (this.tasks.length <= 0 || this.info.phase === layerPhase.RUNNING) return;
		if (this.info.phase === layerPhase.READY) {
			this.tasks[0].enter(this.info);
			this.info.frame = 0;
			this.info.prevFrame = 0;
			this.info.frameShift = 0;
			this.info.taskFrame = 0;
			this.info.taskFrameShift = 0;
		} else {
			this.info.frameShift = this.info.frame || 0;
			this.info.prevFrame = this.info.frame || 0;
			this.info.taskFrameShift = this.info.frame || 0;
		};
		this.info.startTime = new Date();
		this.info.phase = layerPhase.RUNNING;
		this.TID = setInterval(function(po) {
			return function() {
				po.info.frame = (new Date() - po.info.startTime) / 20 + po.info.frameShift;
				po.info.taskFrame = po.info.frame - po.info.taskFrameShift;
				po.info.frameSkip = po.info.frame - po.info.prevFrame;
				if (!isFunction(po.tasks[0].frame) || po.tasks[0].frame(po.info)) {
					po.skip();
				};
				po.info.prevFrame = po.info.frame;
			};
		} (this), 20);
	});
	Layer.method('skip', function() {
		if (this.tasks.length == 0) { this.finish(); return 1 };
		isFunction(this.tasks[0].leave) ? this.tasks[0].leave(this.info) : 0;
		this.tasks.shift(1);
		if (this.tasks.length == 0) { this.finish(); return 1 };
		isFunction(this.tasks[0].enter) ? this.tasks[0].enter(this.info) : 0;
		this.info.taskFrameShift = this.info.frame;
	});
	Layer.method('stop', function() {
		clearInterval(this.TID);
		this.info.phase = layerPhase.PAUSED;
	});
	Layer.method('finish', function() {
		this.stop();
		this.tasks.length && isFunction(this.tasks[0].leave) ? this.tasks[0].over(this.leave) : 0;
		this.tasks = []; // 清空任务
		this.info.phase = layerPhase.READY;
	});
	Layer.method('transfer', function(v) {
		this.tasks.length = 1;
		this.tasks[0] = v;
		isFunction(this.tasks[0].enter) ? this.tasks[0].enter(this.info) : 0;
		this.info.taskFrameShift = this.info.frame;
		if(this.info.phase !== layerPhase.RUNNING) this.start();
	});
	
	{ ability('timeLineService', '1.0.1') }

	void function() {
		var LID = 0;
		function dispatchLID() {
			LID += 1;
			return LID;
		};

		var layers = [];
		space.timeLineService = {};
		timeLineService.layer = function(id) {
			if (!id || id <= 0) id = dispatchLID();
			if (layers[id]) return layers[id];
			else {
				layers[id] = new Layer();
				layers[id].lid = id;
				return layers[id]
			};
		};
		timeLineService.clean = function() {
			for (var lid in layers) {
				if (layers[lid].info.phase === layerPhase.READY)
					delete layers[lid];
			};
		};
	} ();
};
var timeLineService = world.time.tineLineService;
with(namespace('world.time.interpolations')){
	space.linear = function(x){return x}
	space.square = function(x){return x*x}
};


// 用于HTMLElement的效果
void function() {
	var HTMLElement = world.web.HTMLElement;
	var FadeOutTask = new Class(world.time.Task, function(he, fc,callback) {
		this.enter = function(fi) {
			fi.completeness = fi.completeness || he.opacity() || 1;
			fi.iCompleteness = fi.completeness;
		}
		this.frame = function(fi) {
			fi.completeness = fi.iCompleteness - fi.taskFrame / fc;
			he.opacity(fi.completeness);
			return fi.taskFrame >= fi.iCompleteness * fc-0.01;
		}
		this.leave = function(fi) {
			he.opacity(0);
			fi.completeness = 0;
			if(callback)callback();
		};
	});
	var FadeInTask = new Class(world.time.Task, function(he,fc,callback) {
		this.enter = function(fi) {
			fi.completeness = fi.completeness || he.opacity() || 0;
			fi.iCompleteness = fi.completeness;
		}
		this.frame = function(fi) {
			fi.completeness = fi.iCompleteness + fi.taskFrame / fc;
			he.opacity(fi.completeness);
			return fi.taskFrame >= fc - fi.iCompleteness * fc-0.01;
		}
		this.leave = function(fi) {
			he.opacity(1);
			fi.completeness = 1;
			if(callback)callback();
		};
	});
	var PositionMoveTask = new Class(world.time.Task,function(he,dx,dy,fc,intp){
		this.enter = function(fi) {
			var hepos = he.getAbsPosition();
			fi.curX = hepos.x || 0;
			fi.curY = hepos.y || 0;
		}
		this.frame = function(fi) {
			he.setAbsPosition(
				fi.curX + intp(fi.taskFrame / fc)*(dx-fi.curX),
				fi.curY + intp(fi.taskFrame / fc)*(dy-fi.curY)
			);
			return fi.taskFrame >= fc;
		}
		this.leave = function(fi) {
			he.setAbsPosition(dx,dy);
			fi.curX = dx;
			fi.curY = dy;
		};
	});
	HTMLElement.method('getTimeLayer', function(aspect) {
		if (isNumber(this.el[aspect + 'LID']))
			return world.time.timeLineService.layer(this.el[aspect + 'LID']);
		else {
			var L = world.time.timeLineService.layer();
			this.el[aspect + 'LID'] = L.lid;
			return L;
		};
	});
	HTMLElement.method('fadeOut', function() {
		this.getTimeLayer('opacity').transfer(new FadeOutTask(this, 25));
	});
	HTMLElement.method('fadeIn', function() {
		this.getTimeLayer('opacity').transfer(new FadeInTask(this, 25));
	});
	HTMLElement.method('moveTo',function(dx,dy,fc,intp){
		this.getTimeLayer('position').transfer(new PositionMoveTask(this,dx,dy,fc || 50,intp || world.time.interpolations.linear));
	});
} ();

ability('JSONData', '1.0.1');
with (namespace('world.data')) {
	space.jsonT = function(self, rules) {
		var T = {
			output: false,
			init: function() {
				for (var rule in rules)
					if (rule.substr(0, 4) != "self")
					rules["self." + rule] = rules[rule];
				return this;
			},
			apply: function(expr) {
				var trf = function(s) {
					return s.replace(/{([A-Za-z0-9_\$\.\[\]\'@\(\)]+)}/g,
									  function($0, $1) { return T.processArg($1, expr); })
				},
				 x = expr.replace(/\[[0-9]+\]/g, "[*]"), res;
				if (x in rules) {
					if (typeof (rules[x]) == "string")
						res = trf(rules[x]);
					else if (typeof (rules[x]) == "function")
						res = trf(rules[x](eval(expr)).toString());
				}
				else
					res = T.eval(expr);
				return res;
			},
			processArg: function(arg, parentExpr) {
				var expand = function(a, e) { return (e = a.replace(/^\$/, e)).substr(0, 4) != "self" ? ("self." + e) : e; },
				 res = "";
				T.output = true;
				if (arg.charAt(0) == "@")
					res = eval(arg.replace(/@([A-za-z0-9_]+)\(([A-Za-z0-9_\$\.\[\]\']+)\)/,
									   function($0, $1, $2) { return "rules['self." + $1 + "'](" + expand($2, parentExpr) + ")"; }));
				else if (arg != "$")
					res = T.apply(expand(arg, parentExpr));
				else
					res = T.eval(parentExpr);
				T.output = false;
				return res;
			},
			eval: function(expr) {
				var v = eval(expr), res = "";
				if (typeof (v) != "undefined") {
					if (v instanceof Array) {
						for (var i = 0; i < v.length; i++)
							if (typeof (v[i]) != "undefined")
							res += T.apply(expr + "[" + i + "]");
					}
					else if (typeof (v) == "object") {
						for (var m in v)
							if (typeof (v[m]) != "undefined")
							res += T.apply(expr + "." + m);
					}
					else if (T.output)
						res += v;
				}
				return res;
			}
		};
		return T.init().apply("self");
	}
};

endmodule();