﻿/* **
*  Megami > Lutecia
*  Infinte & {S} & {N}
*  ~~ User is Touchable ~~
*/

{ module('lutecia') }
{ version('1.0.3.20090916') }
{ license(2, 1, true) }

{ needs('dandy', '*', '1.0.0') }
{ needs('dandy', 'HTMLElement', '1.0.0') }
{ needs('dandy', 'controlCore', '1.0.0') }

{ ability('systemctl', '1.0.1') }

namespace('world.control.system');
namespace('world.control.ui');
with (using(
	world, 
	world.web,
	world.control
)) {
	//控件组属性
	control.system.__menushown__ = null;
	var _z;
	system.button = new Class(UserControl);
	with (system.button) {
		field('uClass', 'system.button');
		method('loadFace', function(face, parent, id) {
			var _button = $html('button', id);
			var _caption = (face ? (face.attr('caption') || face.html()) : null) || '&nbsp;'
			_button.addClass('system.button');
			if (face)
				parent.replace(_button, face)
			else
				parent.append(_button);
			face = null;
			this.face = _button; //注册界面到控件
			this._span = $html('span');
			this.face.append(this._span);
			this.caption(_caption); //设置标签
			_button = null;
			return this;
		});
		void function() {
			var _handleClick = function() { //为节省内存不择手段啊！
				this.raiseEvent('click', {});
			}
			var _handleDoubleClick = function() {
				if (isIE) this.raiseEvent('click', {});
				this.raiseEvent('dblclick', {})
			};

			method('loadEvents', function() {
				this.face.listen('click', _handleClick, this, false);
				this.face.listen('dblclick', _handleDoubleClick, this, false);
			});
		} ();
		property('caption', '_caption', null,
			function(value) {
				if (this._span) this._span.html(value);
				else if (this.face) this.face.html('<span>' + value + '</span>');
				this._set_caption(value);
				return this;
			}
		);
		method('disable', function() {
			base('disable', this);
			this.face.addClass('disabled');
		});
		method('enable', function() {
			base('enable', this);
			this.face.removeClass('disabled');
		});
		method('detach', function() {
			this.face.removeEventListeners('click');
			this.face.removeEventListeners('dblclick');
			this.face = null;
			delete this.face;
		});
	};

	system.iconButton = new Class(system.button);
	with (system.iconButton) {
		method('load', function(f, p, id) {
			base('load', this, f, p, id);
			this.mapAttribute('image');
			this.face.addClass('iconed');
		});
		property('image', '_image', null, function(value) {
			this._set_image(value);
			this._span.css('backgroundImage', 'url(' + value + ')');
			return this;
		});
		property('imageSize', '_imagesize', null, function(value) {
			this._set_imageSize(value);
			this._span.css('paddingLeft', (value + 2) + 'px');
			return this;
		});
		method('showCaption', function() {

		});
	};

	system.field = new Class(UserControl);
	with (system.field) {
		field('uClass', 'system.field')
		method('loadFace', function(face, par, id) {
			base('loadFace', this, face, par, id);
			var _inputs = this.face.el.getElementsByTagName('input');
			if (!_inputs.length) {
				var _input = $html('input');
				this.face.append(_input);
			} else
				var _input = new HTMLElement(_inputs[0]);
			this.field = _input;
		})
		static('__changeHandler', function() {
			var oldValue = this.value();
			this.value(this.field.getValue());
			this.raiseEvent('change', { from: oldValue, to: this.value() });
		})
		method('loadEvents', function() {
			this.field.listen('change', system.field.__changeHandler, this);
		})
		property('value', null, null, function(v) {
			this._set_value(v);
			this.field.el.value = v;
		})
	};


	system.logWindow = new Class(UserControl);
	with (system.logWindow) {
		field('uClass', 'system.logWindow');
		method('print', function(message, cls) {
			this.face.html(this.face.html() + '<megami:log class="' + (cls || 'log') + '">' + ('' + message).replace(/ /g, '&nbsp;') + '</megami:log>');
			this.face.el.scrollTop = this.face.el.scrollHeight;
		});
		method('clear', function() {
			this.face.html('');
		});
	};

	system.progress = new Class(UserControl);
	with (system.progress) {
		field('uClass', 'system.progress');
		method('loadFace', function(f, p, i) {
			base('loadFace', this, f, p, i);
			var _field = $html('div');
			_field.addClass('field');
			this.face.append(_field);
			this.field = _field;
			_field = null;
		});
		property('value', null, null, function(v) {
			if (v > 100) v = 100;
			if (v < 0) v = 0;
			this._set_value(v);
			this.field.css('width', v + '%');
		});
		property('caption', null, null, function(v) {
			this._set_value(v);
			this.field.html(v.encodeHTML());
		});
	};

	// pulldown 下拉菜单
	system.pulldown = new Class(UserControl);
	with (system.pulldown) {
		field('uClass', 'system.pulldown');
		method('loadFace', function(f, p, i) {
			base('loadFace', this, f, p, i);
			var _ht = (this.face.attr('caption') || this.face.html());
			var _span = $html('span');
			_span.html(_ht);
			this.face.html('');
			this.face.append(_span);
			this.face.css('position', 'relative');
			var _pulldown = $html('div');
			_pulldown.addClass('pulldown').addClass('menu');
			this.face.append(_pulldown);
			this.menu = _pulldown;

			_span = null;
			_pulldown = null;
		});
	};
	void function() {
		function _handlePullDownClick() {
			system.menuService.showMenu(this.menu);
			this.face.front();
		};
		function _handlePullDownMenuClick(e) {
			e.stopPropagation();
		};
		system.pulldown.method('loadEvents', function() {
			this.face.listen('click', _handlePullDownClick, this);
			this.menu.listen('click', _handlePullDownMenuClick, this);
		});
	} ();

	system.picker = new Class(system.field);
	with (system.picker) {
		field('uClass', 'system.picker');
		method('loadFace', function(f, p, i) {
			base('loadFace', this, f, p, i);
			var _pullbutton = $html('megami:pulldownbutton');
			_pullbutton.html('pick');
			_pullbutton.addClass('pfButton');
			this.face.append(_pullbutton);
		});
	};
	system.dataSelector = new Class(system.field);
	with(system.dataSelector){
		property('data');
		property('displayData');
		method('update',function(newValue){
			var old = this.data();
			this.data(newValue);
			raiseEvent('change',{from:old,to:newValue,display:this.displayData()});
		});
	};

	system.tab = new Class(UserControl);
	/* to do */
	system.editable = new Class(UserControl);
	with (system.editable) {
		property('editing', Boolean);
		property('data');
		field('uClass', 'system.editable');
		method('edit', function() {
			this.face.addClass('editing');
		});
		method('update', function() {
			this.face.removeClass('editing');
		});
		method('cancel', function() {
			this.face.removeClass('editing');
			this.raiseEvent('cancel');
		});
	};


	/*
	MenuService是一个“服务”，它将附加下拉菜单管理功能到选定的控件。
	*/
	
	system.menuService = {};
	system.menuService.showen = [];
	system.menuService.showMenu = function(e) {
		e.addClass('show');
		system.menuService.showen.push(e);
		system.menuService.preventMenuHide = true;
	};
	system.menuService.hideMenu = function() {
		if (this.preventMenuHide)
			return this.preventMenuHide = false;
		var m;
		for (i = 0; i < this.showen.length; i++) {
			m = this.showen[i];
			m.removeClass('show');
		}
		this.showen = [];
		this.preventMenuHide = false;
	};
	system.menuService.preventMenuHide = false;

	/*
	DragService为控件提供拖动能力！
	*/
	system.dragService = {
		attach: function(elem, evt) {
			this.dragging = elem;
			var pos = elem.getAbsPosition();
			this.shiftX = (evt.clientX + document.documentElement.scrollLeft - pos.x);
			this.shiftY = (evt.clientY + document.documentElement.scrollTop - pos.y);
			this.oriX = pos.x;
			this.oriY = pos.Y;
		},
		detach: function(e) {
			if (Function.classOf(this.dragging.releaseDrag)) this.dragging.releaseDrag(e);
			if (e === this.dragging) this.dragging = null;
		},
		update: function(x, y) {
			this.dragging.setAbsPosition(x, y)
		},
		cancel: function() {
			this.dragging.setAbsPosition(this.oriX, this.oriY);
			this.detach(this.dragging);
		},
		dragging: null
	};

	$.root.listen('mousemove', function(e) {
		if (system.dragService.dragging !== null) {
			var x = e.clientX+document.documentElement.scrollLeft-system.dragService.shiftX;
			var y = e.clientY+document.documentElement.scrollTop-system.dragService.shiftY;
			system.dragService.update(x,y);
		};
	});
	$.root.listen('mouseup', function(e) {
		if (system.dragService.dragging !== null) {
			system.dragService.detach(system.dragService.dragging);
		};
	});
	// ui

	ui.gallery = new Class(UserControl);
	with (ui.gallery) {
		field('uClass', 'ui.gallery');
		field('images', []);
		field('current', 0);
		method('loadFace', function(f, p, i) {
			base('loadFace', this, f, p, i);
			this.goPrev = tag.A({ href: '#', title: '前一张' }).html('prev').addClass('prev');
			this.goNext = tag.A({ href: '#', title: '后一张' }).html('next').addClass('next');
			this.number = tag.Span();
			this.image = tag.Img();
			this.face.append(this.image).append(this.number).append(this.goPrev).append(this.goNext);
		});
		void function() {
			function _EHN(e) {
				if (!this.disabled) {
					this.next();
				}
				this.disable;
				e.preventDefault();
			}
			function _EHP(e) {
				if (!this.disabled) {
					this.previous();
				};
				this.disable;
				e.preventDefault();
			}
			function _IL(e) {
				this.enable();
			}
			method('loadEvents', function() {
				this.goNext.listen('click', _EHN, this);
				this.goPrev.listen('click', _EHP, this);
				this.image.listen('load', _IL, this);
				this.image.listen('error', _IL, this);
			});
		} ();
		method('resize', function(w, h) {
			this.width(w);
			this.height(h);
			return this;
		})
		property('width', Number, null, function(value) {
			this.face.css('width', value + 'px');
			this._set_width(value);
		});
		property('height', Number, null, function(value) {
			this.face.css('height', value + 'px');
			this._set_height(value);
		});
		method('showNumber', function(value) {
			this.number.show();
		});
		method('hideNumber', function(value) {
			this.number.hide();
		});

		method('show', function(n) {
			try {
				this.image.attr('src', this.images[n]);
				this.number.html((n + 1) + '/' + this.images.length);
				this.current = n;
			} catch (e) {

			}
		});
		method('next', function() {
			if (this.images.length) {
				this.current = (this.current + 1) % this.images.length;
				this.show(this.current);
			}
		});
		method('reload', function() {
			if (this.images.length) {
				this.show(this.current);
			}
		});
		method('previous', function() {
			if (this.images.length) {
				this.current = (this.current - 1) % this.images.length;
				while (this.current < 0) this.current += this.images.length;
				this.show(this.current);
			}
		});

		ui.editableText = new Class(system.editable);
		with (ui.editableText) {
			field('uClass', 'ui.editableText');
			method('loadFace', function(f, p, i) {
				base('loadFace', this, f, p, i);
				var data = (this.face.html() || '');
				this.face.html('');
				this.field = new tag.Input({ type: 'text' });
				this.span = new tag.Span();
				this.face.append(this.span).append(this.field);
				this.data(data);
			});
			method('unloadFace', function() {
				this.span.trash();
				this.field.trash();
				this.face.trash();
				this.span = null;
				this.field = null;
				this.face = null;
			});
			void function() {
				function _UPD(e) {
					this.update();
				};
				function _SWI(e) {
					this.edit();
				};
				method('loadEvents', function() {
					this.span.listen('click', _SWI, this);
					this.field.listen('blur', _UPD, this);
				});
				method('unloadEvents', function() {
					this.span.removeEventListeners('click');
					this.field.removeEventListeners('blur');
				});
			} ();
			method('edit', function() {
				base('edit', this);
				this.field.val(this.data());
				setTimeout(function(e) { return function() { e.field.el.focus(); e.field.el.select() } } (this), 0);
			});
			method('update', function() {
				var oldv = this.data();
				base('update', this);
				this.data(this.field.val());
				this.raiseEvent('change', { from: oldv, to: this.data() });
			});
			method('set_data', function(value) {
				this._set_data(value);
				this.span.html(value);
				this.field.val(value);
			});
			
		};
	};
};