﻿{ module('platina') }
{ version('1.0.0') }
{ license(2,2,true) }
{ ability('select_','1.0.0') }
world.$.select_ = function() {
/* 
	platina ver.1.0.0 
	A Compoent of megamijs,designed for DOM selecting;
	TODO:
	- nth-of-child
	- select in children,etc. 
*/
	function isString(e) {
		return (typeof e == 'string') || (e instanceof String)
	};
	var makeArray = function(array, results) {
		array = Array.prototype.slice.call(array, 0);

		if (results) {
			results.push.apply(results, array);
			return results;
		}

		return array;
	};

	// Perform a simple check to determine if the browser is capable of
	// converting a NodeList to an array using builtin methods.
	try {
		Array.prototype.slice.call(document.documentElement.childNodes, 0);

		// Provide a fallback method if it does not work
	} catch (e) {
		makeArray = function(array, results) {
			var ret = results || [];

			if (Object.prototype.toString.call(array) === "[object Array]") {
				Array.prototype.push.apply(ret, array);
			} else {
				if (typeof array.length === "number") {
					for (var i = 0, l = array.length; i < l; i++) {
						ret.push(array[i]);
					}
				} else {
					for (var i = 0; array[i]; i++) {
						ret.push(array[i]);
					}
				}
			}

			return ret;
		};
	};

	// op?
	var isOpera = /opera/i.test(navigator.userAgent);
	// ie?
	var isIE = !isOpera && /msie/i.test(navigator.userAgent);
	var hasDuplicate = false;


	//parser
	var chunker = /((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^[\]]*\]|['"][^'"]*['"]|[^[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?/g;
	var _ACCEPT = function(n) { return n };  // ACCEPT令牌
	var _AVOID = function() { return false };  // AVOID令牌
	var _DOCRANGE = function(n, p, a, d) { return n === d };  // DOCRANGE令牌
	var lxMCache = {}, lxSCache = {}; //lex缓存
	function lxMu(selector) {
		if (lxMCache.hasOwnProperty(selector)) return lxMCache[selector];
		var m, parts = [], ans = [], extra = '', oSelector = selector;
		while (selector) {
			chunker.lastIndex = 0;
			extra = '';
			parts = [];
			while ((m = chunker.exec(selector)) !== null) {
				parts.unshift(m[1]);
				if (m[2]) {
					ans.push(parts);
					parts = [];
					extra = RegExp.rightContext;
					break;
				};
			};
			selector = extra;
			if (!selector) ans.push(parts);
		};
		lxMCache[oSelector] = ans;
		return ans;
	};
	/*	
			_	>	~	+
	btr		-1	V	F	F
		
	*/
	function lxSing(s) {
		var ret = [lxSimp(s[0])], p = 1, lastFlex = -1, lastVert = -1;
		ret.rel = ['!'];
		ret.back = [];
		for (var i = 1; i < s.length; i++) {
			if (relation[s[i]]) {
				ret.rel[p] = s[i];
				switch (s[i]) {
					case ' ': ret.back[p] = -1; lastFlex = lastVert = p; break;
					case '>': ret.back[p] = lastVert; break;
					case '~': ret.back[p] = lastFlex; lastFlex = p; break;
					case '+': ret.back[p] = lastFlex; break;
				};
				i++;
				if (s[i])
					ret[p] = lxSimp(s[i]);
				else
					ret[p] = _DOCRANGE;

			} else {
				ret.rel[p] = ' ';
				ret.back[p] = -1; lastFlex = lastVert = p;
				ret[p] = lxSimp(s[i]);
			};
			p++;
		};
		return ret;
	};


	var mRex = {
		mID: /#((?:[\w\u00c0-\uFFFF_-]|\\.)+)(?![^\[]*\])(?![^\(]*\))/,
		mClass: /\.((?:[\w\u00c0-\uFFFF_-]|\\.)+)(?![^\[]*\])(?![^\(]*\))/,
		mAttr: /\[\s*((?:[\w\u00c0-\uFFFF_-]|\\.)+)\s*(?:(\S?=)\s*(['"]?)(.*?)\3|)\s*\](?![^\[]*\])(?![^\(]*\))/,
		//mChild: /:(only|nth|last|first)-child(?:\((even|odd|[\dn+-]*)\))?$/,
		//mPos: /:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^-]|$)$/,
		mPcl: /:((?:[\w\u00c0-\uFFFF_-]|\\.)+)(?:\((['"]*)((?:\([^\)]+\)|[^\2\(\)]*)+)\2\))?(?![^\[]*\])(?![^\(]*\))/
	};
	var mTag = /^((?:[\w\u00c0-\uFFFF\*_-]|\\.)+)/;

	var params = 'node,pcls,matt';
	var idtest = 'node.id === #';
	var tagTest = 'node.tagName === #';
	var scopeTest = 'node.scopeName === #';
	var classGen = 'var cln = node.className;';
	var classTest = '/(?:\\s|^)#(?:\\s|$)/.test(cln)';
	function toJSString(s) {
		return '"' + ("" + s).replace(/\\/g, '\\\\').replace(/\r?\n/g, '\\n').replace(/\t/g, '\\t').replace(/"/g, "\\\"") + '"'
	};
	function toRegexString(s) {
		return ("" + s).replace(/([+*.\[()\]{}\\])/g, '\\$1');
	};
	function attLet(pName) {
		if (/^[a-zA-Z_$][\w$]*$/.test(pName)) return 'node.' + pName;
		else return 'node.getAttribute(' + toJSString(pName) + ')';
	};
	function mLet(pName, o) {
		if (/^[a-zA-Z_$][\w$]*$/.test(pName)) return o + '.' + pName;
		else return o + '[' + toJSString(pName) + ']';
	};
	function compile(t, i, c, p, a) {
		var conditions = [];
		var pres = [];
		if (i) {
			conditions.push(idtest.replace(/#/, toJSString(i)));
		};
		if (t && t != '*') {
			if (isIE && /:/.test(t)) {
				var sc = t.split(':')[0];
				var tn = t.split(':')[1];
				conditions.push(scopeTest.replace(/#/, toJSString(sc)));
				conditions.push(tagTest.replace(/#/, toJSString(tn)));
			}
			else
				conditions.push(tagTest.replace(/#/, toJSString(t.toUpperCase())));
		};
		if (c && c.length) {
			pres.push(classGen);
			for (var i = c.length - 1; i >= 0; i--) {
				conditions.push(classTest.replace(/#/, toRegexString(c[i])));
			}
		};
		if (a && a.length) {
			for (var i = a.length - 1; i >= 0; i--) {
				conditions.push('matt(node,' + toJSString(a[i][0]) + ',' + toJSString(a[i][1]) + ',' + toJSString(a[i][2]) + ')');
			};
		};
		if (p && p.length) {
			for (var i = p.length - 1; i >= 0; i--) {
				if (p_classes[p[i][0]]) conditions.push(mLet(p[i][0], 'pcls') + '(node,' + toJSString(p[i][1]) + ')');
			};
		};
		conditions = 'if(node && ' + conditions.join(' && ') + ') return node;\nelse return false;';
		pres = pres.join(';');
		var f = new Function(params, pres + '\n' + conditions);
		f.tag = t;
		f.id = i;
		return f;
	};

	function lxSimp(sms) {
		//if (lxSCache.hasOwnProperty(sms)) return lxSCache[sms];
		var tag, id, cls = [], pcl = [], att = [], m, extra, oSmS = sms;
		if ((m = mTag.exec(sms)) !== null) {
			tag = m[1].replace(/\\/g, '');
			sms = sms.replace(mTag, '');
		} else { tag = '*' };
		while (sms) {
			extra = '';
			for (var each in mRex) {
				if ((m = mRex[each].exec(sms)) !== null) {
					switch (each) {
						case 'mID':
							if (id && id !== m[1]) return function() { return false };
							id = m[1].replace(/\\(.)/g, '$1'); break;
						case 'mClass':
							cls.push(m[1].replace(/\\(.)/g, '$1')); break;
						case 'mAttr':
							att.push([m[1].replace(/\\(.)/g, '$1'), m[2], (m[4] || '').replace(/\\(.)/g, '$1')]); break;
						case 'mPcl':
							pcl.push([m[1].replace(/\\(.)/g, '$1'), (m[3] || '').replace(/\\(.)/g, '$1')]); break;
					};
					extra = sms.replace(mRex[each], '');
					break;
				};
			};
			sms = extra;
		};
		if (!cls.length) cls = null;
		if (!pcl.length) pcl = null;
		if (!att.length) att = null;
		return compile(tag, id, cls, pcl, att);
	};


	var sortOrder;
	var relationCmp = {
		' ': function(p, n) { return false },
		'>': function(p, n) { return false },
		'~': function(p, n) { return false },
		'+': function(p, n) { return false }
	};

	if (document.documentElement.compareDocumentPosition) {
		sortOrder = function(a, b) {
			var ret = a.compareDocumentPosition(b) & 4 ? -1 : a === b ? 0 : 1;
			if (ret === 0) {
				hasDuplicate = true;
			}
			return ret;
		};
		var relationCmp = {
			' ': function(p, n) { return !!(p.compareDocumentPosition(n) & 16); },
			'>': function(p, n) { return n.parentNode === p },
			'~': function(p, n) { return !(p.compareDocumentPosition(n) & 16) && (p.compareDocumentPosition(n) & 4) },
			'+': function(p, n) { return false }
		};
	} else if ("sourceIndex" in document.documentElement) {
		sortOrder = function(a, b) {
			var ret = a.sourceIndex - b.sourceIndex;
			if (ret === 0) {
				hasDuplicate = true;
			}
			return ret;
		};
		var relationCmp = {
			' ': function(p, n) { return p.contains(n) },
			'>': function(p, n) { return n.parentNode === p },
			'~': function(p, n) { return p.parentNode === n.parentNode && p.sourceIndex < n.sourceIndex },
			'+': function(p, n) { return false }
		};
	} else if (document.createRange) {
		sortOrder = function(a, b) {
			var aRange = a.ownerDocument.createRange(), bRange = b.ownerDocument.createRange();
			aRange.selectNode(a);
			aRange.collapse(true);
			bRange.selectNode(b);
			bRange.collapse(true);
			var ret = aRange.compareBoundaryPoints(Range.START_TO_END, bRange);
			if (ret === 0) {
				hasDuplicate = true;
			}
			return ret;
		};
	};

	function _getTag(e, tag) {
		if (isIE && (/\:/.test(tag))) {
			var m = tag.split(':');
			var scope = m[0];
			var tagn = m[1];
			var A = e.getElementsByTagName(tagn);
			var _RET = [];
			for (i = 0; i < A.length; i++) {
				if (A[i].scopeName == scope) _RET.push(A[i]);
			};
			return _RET;
		} else
			return e.getElementsByTagName(tag);
	};

	function pSibling(el) {
		do {
			el = el.previousSibling;
		} while (el != null && el.nodeType != 1);
		return el;
	};
	function parent(el) {
		do {
			el = el.parentNode;
		} while (el != null && el.nodeType != 1);
		return el;
	};
	var p_classes = {
		'first-child': function(e) {
			while (e = e.previousSibling) {
				if (e.nodeType === 1) return false;
			}
			return true;
		},
		'last-child': function(e) {
			while (e = e.nextSibling) {
				if (e.nodeType === 1) return false;
			}
			return true;
		},
		'only-child': function(e) {
			return p_classes['first-child'](e) && p_classes['last-child'](e);
		},
		enabled: function(elem) {
			return elem.disabled === false && elem.type !== "hidden";
		},
		disabled: function(elem) {
			return elem.disabled === true;
		},
		checked: function(elem) {
			return elem.checked === true;
		},
		selected: function(elem) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			elem.parentNode.selectedIndex;
			return elem.selected === true;
		},
		parent: function(elem) {
			return !!elem.firstChild;
		},
		empty: function(elem) {
			return !elem.firstChild;
		},
		text: function(elem) {
			return "text" === elem.type;
		},
		radio: function(elem) {
			return "radio" === elem.type;
		},
		checkbox: function(elem) {
			return "checkbox" === elem.type;
		},
		file: function(elem) {
			return "file" === elem.type;
		},
		password: function(elem) {
			return "password" === elem.type;
		},
		submit: function(elem) {
			return "submit" === elem.type;
		},
		image: function(elem) {
			return "image" === elem.type;
		},
		reset: function(elem) {
			return "reset" === elem.type;
		},
		button: function(elem) {
			return "button" === elem.type || elem.nodeName.toUpperCase() === "BUTTON";
		},
		input: function(elem) {
			return /input|select|textarea|button/i.test(elem.nodeName);
		},
		root: function(e) {
			return e === document.documentElement;
		}
	};
	var _ATTMAP = {
		'class': 'className',
		'for': 'htmlFor'
	};
	function matchAtt(e, name, type, check) {
		var result = _ATTMAP[name] ? e[_ATTMAP[name]] : e.getAttribute(name), value = result + "";
		//if(!type) return e.hasAttribute(name);
		return result == null ?
				type === "!=" :
				type === "=" ?
				value === check :
				type === "*=" ?
				value.indexOf(check) >= 0 :
				type === "~=" ?
				(new RegExp('(?: |^)' + check + '(?: |$)').test(value)) :
				!check ?
				value && result !== false :
				type === "!=" ?
				value != check :
				type === "^=" ?
				value.indexOf(check) === 0 :
				type === "$=" ?
				value.substr(value.length - check.length) === check :
				type === "|=" ?
				value === check || value.substr(0, check.length + 1) === check + "-" :
				false;
	};
	var relation = {
		' ': function(e, s, d) {
			do {
				e = e.parentNode;
				if (e && s(e, p_classes, matchAtt, d)) return e;
			} while (e != null && e != d);
			return false;
		},
		'>': function(e, s, d) {
			return e && s(e.parentNode, p_classes, matchAtt, d) ? e.parentNode : false;
		},
		'~': function(e, s, d) {
			do {
				e = e.previousSibling;
				if (e && s(e, p_classes, matchAtt, d)) return e;
			} while (e != null);
			return false;
		},
		'+': function(e, s, d) {
			return e && s(pSibling(e), p_classes, matchAtt, d) ? pSibling(e) : false;
		}
	};
	/*function match(element, s, domain) {
	var e = element, i=0, r;
	if (!s) return element;
	if (!s[0](e,p_classes,matchAtt)) return false;
	for (i = 1; i < s.length; i++) {
	echo(s[i]);
	e = relation[s.rel[i]] (e, s[i], domain);
	if (!e) return false;
	};
	return element;
	};*/

	function getRelation(n, rf, s, piv, op, opi,dom) {
		if (!n) return false;
		var btr = 0, opiv = piv;
		var orn = n;
		var m = rf(n, s[piv],dom);
		//echo(m.tagName);
		if (m) return m;
		do {
			if (!m) {
				piv = s.back[piv];
				if (piv <= 0) return false;
				m = relation[s.rel[piv]](n, s[piv], dom);
			} else {
				// 推进
				n = m;
				piv++;
				m = relation[s.rel[piv]](n, s[piv] ,dom);
			};
		} while (piv != -1 && piv !== opiv);
		if (piv === opiv) {
			for (var i = opi + 1; i < op.length; i++) {
				if (op[i] === orn) op[i] = n;
			};
			return m;
		}
		else return false;
	};

	function flit(ele, s,d) {
		var oper = Array.prototype.slice.call(ele, 0);
		var elen = ele.length;
		for (var i = 0; i < elen; i++)
			oper[i] = s[0](oper[i], p_classes, matchAtt);
		for (var piv = 1; piv < s.length; piv++) {
			var relf = relation[s.rel[piv]];
			var relcmp = relationCmp[s.rel[piv]];
			o: for (i = 0; i < elen; i++)
				if (oper[i] !== false) {
				/*for (var j = 0; j < i; j++) if (oper[j] && relcmp(oper[j], oper[i])) {
				oper[i] = oper[j];
				continue o;
				};*/
				oper[i] = getRelation(oper[i], relf, s, piv, oper, i,d);
			};
		};

		for (i = 0; i < elen; i++)
			if (oper[i] === false) ele[i] = false;
	};
	function selectElement(selector, domain) {
		if (selector[0] === _AVOID) return [];
		var tag = selector[0].tag || '*', id = selector[0].id, _arr = [], _ans = [], result = [], mrx, e;
		if (isString(id)) {
			_arr = [].concat(domain.getElementById(id));
		} else {
			_arr = _getTag(domain, tag);
		};
		if (!_arr.length) return [];

		_ans = makeArray(_arr);
		_arr = [];

		if (!_ans.length) return [];

		//selector[0] = _ACCEPT;
		flit(_ans, selector,domain);

		for (i = 0; i < _ans.length; i++) { if (_ans[i] !== false) result.push(_ans[i]) };

		return result;
	};

	function unique(results) {
		if (sortOrder) {
			hasDuplicate = false;
			results.sort(sortOrder);
			if (hasDuplicate) {
				for (var i = 1; i < results.length; i++) {
					if (results[i] === results[i - 1]) {
						results.splice(i--, 1);
					}
				}
			}
		}
	};

	function select(selector, domain, existing) {
		var mu = lxMu(selector);
		var domain = domain || document;
		var result = [];
		var existing = existing || [];
		if (mu.length == 1 && existing.length == 0)
			return selectElement(lxSing(mu[0]), domain);
		else {
			result = existing;
			for (var i = 0; i < mu.length; i++) {
				result = result.concat(selectElement(lxSing(mu[i]), domain));
			}
		};
		unique(result);
		return result;
	};

	//public interface
	return select;

} ();