<?php

class Explorer
{
    function dir_walk($dir, $types = null, $recursive = false, $baseDir = '')
    {

        $dir_contents = null;

        //make sure the directory has a trailing slash, otherwise this function wont work!
        if (substr($dir, -1) != '/')
        {
            $dir .= '/';
        }

        if ($dh = opendir($dir))
        {
            while (($file = readdir($dh)) !== false)
            {
                if ($file === '.' || $file === '..')
                {
                    continue;
                }

                if (is_file($dir . $file))
                {
                    if (is_array($types))
                    {
                        if (!in_array(strtolower(pathinfo($dir . $file, PATHINFO_EXTENSION)), $types, true))
                        {
                            continue;
                        }
                    }

                    $this_mp3 = $this->get_meta($dir . $file);

                    $dir_contents[] = $this_mp3;
                    //$dir_contents[] =$ThisFileInfo;
                }
                else if (is_dir($dir . $file))
                {
                    $dir_contents[] = "<a href=index.php?browse=" . urlencode($dir . $file) . ">$file</a>";

                    if ($recursive)
                    {
                        dir_walk($dir . $file . DIRECTORY_SEPARATOR, $callback, $types, $recursive, $baseDir . $file . DIRECTORY_SEPARATOR);
                    }
                }
            }

            closedir($dh);

            return $dir_contents;
        }
        else
        {
            echo "Error opening directory";
            return false;
        }
    }





    function get_meta($files)
    {
        $ajax = false;
        $mp3s = array();

        require_once('getid3/getid3/getid3.php');
        $getID3 = new getID3;

        if (!is_array($files))
        {
            $files[] = $files;
        }


        foreach ($files as $file)
        {

            $ThisFileInfo = $getID3->analyze($file['mp3']);
            getid3_lib::CopyTagsToComments($ThisFileInfo);

            if (isset($ThisFileInfo['error'][0]))
                $ThisFileInfo['comments_html']['title'][0] = 'Error processing file';

            $cover = $this->cover_art($file['mp3']);


            $this_mp3 = array(
                'artist' => @$ThisFileInfo['comments_html']['artist'][0],
                'name' => @$ThisFileInfo['comments_html']['title'][0],
                'album' => @$ThisFileInfo['comments_html']['album'][0],
                'play_length' => @$ThisFileInfo['playtime_string'],
                'path' => @$ThisFileInfo['filename'],
                'cover' => $cover,
                'mp3' => isset($file['mp3']) ? $file['mp3'] : '',
                'ogg' => isset($file['ogg']) ? $file['ogg'] : ''
            );

            $mp3s[] = $this_mp3;
        }

        return $mp3s;
    }





    function cover_art($file)
    {
        require_once('getid3/getid3/getid3.php');
        $getID3 = new getID3;
        $getID3->option_tag_id3v2 = true; # Don't know what this does yet
        $getID3->analyze($file);
        $getID3->option_tags_images = true;

        if (isset($getID3->info['id3v2']['APIC'][0]['data']))
        {
            $cover = 1;
        } elseif (isset($getID3->info['id3v2']['PIC'][0]['data']))
        {
            $cover = 1;
        } else
        {
            $cover = 0;
        }

        return $cover;
    }





    function generate_playlist($files)
    {
        $playlist = ' <ul class="playlist">';

        if (is_array($files))
        {
            $count = 0;
            foreach ($files as $file)
            {
                $count++;
                $path = $file['path'];
                $title = $file['title'];
                $playlist .= "<li><a href=$path class='media' rel='music/images/$count.jpg'>$title</a></li>";
            }
        }

        $playlist .= '</ul>';

        return $playlist;
    }
}


if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest')
{

    $data = $_POST;

    $dispatch = isset($data['dispatch']) ? $data['dispatch'] : false;

    if ($dispatch)
    {
        $explorer = new Explorer();
        $data = isset($data['data']) ? $data['data'] : null;

        echo json_encode($explorer->$dispatch($data));
    }
}

?>