/**
 * YESBRAIN Javascript Library;
 * @author gongji
 */

	/*
	 * Update SQL Language
	 * Can use basic update language
	 */

YESBRAIN.JSQL.UPDATE = {
	parseTable : function(sql){
		//var sql = "select * from test";
		var re = new RegExp(/\s*update\s+(.+)\s+set/ig);
		var ree;
		var res;
		res = re.exec(sql);
		if(res) {
			return res[1];
		}
		else {
			return null;
		}
	},
	
	parseSettings : function(sql) {
		var re = new RegExp(/\s+where\s+/ig);
		var ree;
		var res;
		if(re.exec(sql)) {
			ree = new RegExp(/set\s+(.+)\s+where/ig);
		} else {
			ree = new RegExp(/set\s+(.+)$/ig);
		};
		res = ree.exec(sql);
		if(res) {
			return res[1]
		}
		else {
			return null;
		}
	},
	
	splitSettings : function(settings) {
		var settingsArr;
		var res;
		settingsArr = settings.split(',');
		for(var i=0;i<settingsArr.length;i++) {
			var re = new RegExp(/\s*(.+)\s*/ig);
			res = re.exec(settingsArr[i]);
			if(res) {
				settingsArr[i] = res[1];
			};
		};
		return settingsArr;
	},
	
	parseConditions : function(sql) {
		//var sql = "select * from test where a=a group by order by ";
		var res;
		var ree;
		var re = new RegExp(/\s+where\s+/ig);
		if(re.exec(sql)) {
			ree = new RegExp(/where(.+)$/ig);
			res = ree.exec(sql);
		} else {
			return "true";
		};
		if(res) {
			return res[1]
		}
		else {
			return null;
		}
	},
	
	
	equallike : function(Str, likeStr) {

		likeStr = likeStr.replace(/\%/ig,".+");
		likeStr = likeStr.replace(/\?/ig,".?");
		likeStr = likeStr.replace(/\*/ig,".?");
		var re2 = new RegExp(likeStr);
		re2.ignoreCase = true;
		re2.global = true;
		var ok = re2.exec(Str);
		return ok;
	},
	
	splitConditions : function(conditions) {
		var conditionsArr;
		var re = new RegExp(/(and|or)/ig);
		var re2 = new RegExp(/([^<=>])\=/ig);
		var re3 = new RegExp(/\s+(.+)\s+like\s+(.+)/ig);
		var res = '';
		conditionsArr = conditions.split(re);
		for(var i=0;i<conditionsArr.length;i++) {
			curCondition = conditionsArr[i];
			curCondition = curCondition.replace(re2,"$1==");
			curCondition = curCondition.replace(re3," equallike($1,$2)");
			conditionsArr[i] = curCondition;
		};
		for (var i = 0; i < conditionsArr.length; i++) {
			var tmpStr = conditionsArr[i];
			if (tmpStr.toLowerCase() == 'and') {
				tmpStr = '&&';
			}
			else if (tmpStr.toLowerCase() == 'or') {
				tmpStr = '||';
			};
			res = res + tmpStr;
		};
		return res;
	},
	
	executeUpdate : function(sql) {
		var table = this.parseTable(sql);
		table = eval(table);
		var settings = this.parseSettings(sql);
		var settingsArr = this.splitSettings(settings);
		
		var conditions = this.parseConditions(sql);
		conditions = this.splitConditions(conditions);
		
		var effectrowcount = 0;
		if(table.length<1) {return 0};
		for(var i=0;i<table.length;i++) {
			with(table[i]) {
				var equalreturn = eval(conditions);
				if (equalreturn) {
					for(var j=0;j<settingsArr.length;j++) {
						var setting = settingsArr[j];
						eval(setting);
					};
					effectrowcount++;
				}
			}
		};
		return effectrowcount;
	}
};