/**
 * YESBRAIN Javascript Library;
 * @author gongji
 */

	/*
	 * JSQL SQL Language
	 * Can use basic sql language
	 */

YESBRAIN.namespace("JSQL");

YESBRAIN.JSQL = function(SQL) {
	this.JSQL.SQL = SQL;
	return this.JSQL;
};

JSQL = YESBRAIN.JSQL;

YESBRAIN.JSQL.InMemory = function(){
	if(!this.JSQLConfig) {
		this.JSQLConfig = {};
	};
	this.JSQLConfig.DoInMemory = true;
	this.JSQLConfig.DoOnServer = this.JSQLConfig.DoOnServer ? true : false;
	this.JSQLConfig.DoForDOM = this.JSQLConfig.DoForDOM ? true : false;
	return this;
};
YESBRAIN.JSQL.OnServer = function(){
	if(!this.JSQLConfig) {
		this.JSQLConfig = {};
	};
	this.JSQLConfig.DoOnServer = true;
	this.JSQLConfig.DoInMemory = this.JSQLConfig.DoInMemory ? true : false;
	this.JSQLConfig.DoForDOM = this.JSQLConfig.DoForDOM ? true : false;
	return this;
};
YESBRAIN.JSQL.ForDOM = function(){
	if(!this.JSQLConfig) {
		this.JSQLConfig = {};
	};
	this.JSQLConfig.DoForDOM = true;
	this.JSQLConfig.DoInMemory = this.JSQLConfig.DoInMemory ? true : false;
	this.JSQLConfig.DoOnServer = this.JSQLConfig.DoOnServer ? true : false;
	return this;
};
YESBRAIN.JSQL.executeSQL = function(){
	var sql;
	if(YESBRAIN.lang.isFunction(this)) {
		if(this.SQL) {
			sql = this.SQL;
			this.SQL = null;
		} else {
			alert("SQL command needed!");
			return null;
		};
	} else {
		sql = this.toString();
	};
	
	if(!this.JSQLConfig) {
		this.JSQLConfig = {};
	};
	if((this.JSQLConfig.DoInMemory==null)||this.JSQLConfig.DoInMemory) {
		var MemoryReturn = YESBRAIN.JSQL.Memory.executeSQL(sql);
	};
	if(this.JSQLConfig.DoOnServer) {
		var ServerReturn = YESBRAIN.JSQL.Server.executeSQL(sql);
	};
	if(this.JSQLConfig.DoForDOM) {
		var DOMReturn = YESBRAIN.JSQL.DOM.executeSQL(sql);
	};
	var returnArr = [];
	if(MemoryReturn!=null) {
		returnArr.push(MemoryReturn);
	};
	if(ServerReturn!=null) {
		returnArr.push(ServerReturn);
	};
	if(DOMReturn!=null) {
		returnArr.push(DOMReturn);
	};
	if(returnArr.length == 1) {
		return returnArr[0];
	}
	else if(returnArr.length<1) {
		return null;
	}
	else {
		return returnArr;
	};
	//return YESBRAIN.JSQL.InMemory.executeSQL(this);
};
YESBRAIN.JSQL.querySQL = function(){
	return this.executeSQL();
};

YESBRAIN.JSQL.execute = function(){
	return this.executeSQL();
};

YESBRAIN.JSQL.query = function(){
	return this.executeSQL();
};


/*
String.prototype.JSQLConfig = {
		DoInMemory : null,
		DoOnServer : null,
		DoForDOM : null
};
*/

String.prototype.InMemory = YESBRAIN.JSQL.InMemory;
String.prototype.OnServer = YESBRAIN.JSQL.OnServer;
String.prototype.ForDOM = YESBRAIN.JSQL.ForDOM;
String.prototype.executeSQL = YESBRAIN.JSQL.executeSQL;
String.prototype.querySQL = YESBRAIN.JSQL.querySQL;
String.prototype.execute = YESBRAIN.JSQL.execute;
String.prototype.query = YESBRAIN.JSQL.query;


