/**
 * RoomList Javascript Library;
 * @author gongji
 */
YESBRAIN.namespace("YESBRAIN.hotelmanage");
YESBRAIN.hotelmanage.room = function(overrides) {
	this.ID = '';
	this.Price = 0;
	this.State = '';
	this.InDays = 0;
	this.roomlist = {};

	for(var i in overrides) {
		this[i] = overrides[i];
	};

	this.remove = function() {
		return this.roomlist.remove(this);
	};
	this.addto = function(roomlist) {
		roomlist.add(this);
	};
};


YESBRAIN.hotelmanage.roomlist = function() {
	
	/*
	 * private:
	 * List For Rooms;
	 */
	this._list = [];
	
	/*
	 * public:
	 * Add Room To RoomList;
	 */
	this.add = function(room) {
		if(YESBRAIN.lang.isString(room)) {
			room = new YESBRAIN.hotelmanage.room({ID: room});
		}
		room.roomlist = this;
		this._list.push(room);
		return room;
	};
	
	/*
	 * public:
	 * Delete Room From RoomList;
	 */
	this.remove = function(room) {
		if(YESBRAIN.lang.isString(room)) {
			room = new YESBRAIN.hotelmanage.room({ID: room});
		}		
		var success = false;
		for(var i=0;i<this._list.length;i++){
			if(room.ID==this._list[i].ID) {
				this._list.splice(i,1);
				i = i - 1;
				success = true;
			}
		}; 
		return success;
	};
	
	/* javascript 1.6 以前版本需要扩展
	 * public:
	 * 
	this.indexOf = function(room) {
		for(var i = this._list.length; i-- && this._list[i] !== room;); 
		return i;
	};
	*/
	
	/*
	 * public:
	 * Query Index Of Room In RoomList;
	 */
	this.indexOf = function(room) {
		return this._list.indexOf(room);
	};
	
	/*
	 * public:
	 * Switch Two Rooms;
	 */
	this.Switch = function(index1,index2) {
		if(!YESBRAIN.lang.isNumber(index1)) {
			index1 = this.indexOf(index1);
		};
		if(!YESBRAIN.lang.isNumber(index2)) {
			index2 = this.indexOf(index2);
		};
		var tmproom = this._list[index1];
		this._list[index1] = this._list[index2];
		this._list[index2] = tmproom;
	};
	
	/*
	 * public:
	 * Query Room(s) From RoomList;
	 * return Room Or A List Of Rooms;
	 */
	this.query = function(rooms) {
		
		/*
		 * private
		 * Test Is Rooms Equal;
		 */
		var equalTo = function(queryroom,room) {
			for(var p in queryroom) {
				if(queryroom[p]!=room[p]) {
					return false;
				};
			};
			return true;
		};
		
		var queryone = function(room) {
			for(var i=0;i<this._list.length;i++) {
				if(equalTo(room,this._list[i])) {
					return this._list[i];
				}
			};
			return null;
		};
		
		var returnrooms = [];
		if(!YESBRAIN.lang.isArray(rooms)){
			rooms = [rooms];
		};
		for(var i=0;i<rooms.length;i++) {
			var returnroom = queryone.call(this,rooms[i]);
			if(returnroom!=null) {
				returnrooms.push(returnroom);
			};
		};
		
		if(returnrooms.length==1) {
			return returnrooms[0];
		} else if (returnrooms.length<1) {
			return null
		} else {	
			return returnrooms;
		}
	};
	
	/*
	 * public:
	 * Get One Room From RoomList;
	 */
	this.get = function(id) {
		if(YESBRAIN.lang.isNumber(id)) {
			return this._getroomByIndex(id);
		} else if (YESBRAIN.lang.isString(id)) {
			return this._getroomByID(id);
		} else if (YESBRAIN.lang.isObject(id)) {
			id = id.ID;
			return this._getroomByID(id);
		} else {
			return null;
		};
	};

	/*
	 * public:
	 * Get Room List;
	 */
	this.getlist = function() {
		return _list;
	};
	
	/*
	 * private:
	 * Get One Room From RoomList By RoomID;
	 */
	this._getroomByID = function(ID) {
		for(var i = this._list.length; i-- && this._list[i].ID !== ID;); 
		if(i>=0) {
			return this._list[i];
		} else {
			return null;
		};
	};
	
	/*
	 * private:
	 * Get One Room From RoomList By Room Index In List;
	 */	
	this._getroomByIndex = function(index) {
		return this._list[index];
	};
	
	/*
	 * public:
	 * Get Room List Count;
	 */		
	this.count = function() {
		return this._list.length;
	};
};