/*--------------------------------------------------------------------------------
 $ ĵWndX.js
 $ ܣװĴapiض
 $ ڣ2007-10-09 15:47
 $ ߣLovelyLife
 $ ʼLife.qm@gmail.com
 $ Ȩ: ޸İȨ
 $ powered by Javascriptר[http://onlyaa.com] All rights reservered.
----------------------------------------------------------------------------------*/

// global const variables definition
var CONST = {
/*-------------WINDOWS DEFINE -----------------------------*/
	REGISTEREDWND :		0x0001,
	REGISTEREDTITLE :	0x0002,
	SW_SHOW: 			0x0003,
	SW_HIDE: 			0x0004,
	SW_RESIZE	:		0x0008,
/*-------------WINDOWS STYLE DEFINE ʹǰλΪPWWINDOWSʽ-----------------------------
	----------------------------------------------
	STYLE: |0|0|0|0|0|0|0|0|
	----------------------------------------------*/
// window style
	STYLE_DEFAULT :		0x01,
	STYLE_TITLE:		0x02,
	STYLE_MENU :		0x03,
	STYLE_TOOLBAR :		0x08,
	STYLE_STATUS:		0x10,
	STYLE_RESIZABLE:	0x20,

// size status
	STYLE_MAX :			0x40,
	STYLE_MIN :			0x80,
	STYLE_CLOSE :		0x100,
	STYLE_FIXED :		0x200,
	STYLE_POPUP :		0x400,

	STYLE_CHILD :		0x800,
	STYLE_MULTIWINDOW :	0x1000,
	STYLE_ICON :		0x2000,
	MIN_HEIGHT:			26,
	MIN_WIDTH:			140,
	
// size text
	SIZE_MIN:			'0',
	SIZE_CLOSE:			'r',
	SIZE_MAX:			'1',
	SIZE_NORMAL:		'2',
	SIZE_RESIZE :		'3',
	SIZE_DRAGING:		'4',
	SIZE_RESIZING :		'5',
	SIZE_MINING :		'6',
/*-------------DIALOG DEFINE --------------------------------*/
	NORMAL :            '0',
	MODE:	            '1',
	MODELESS:           '2',
	IDOK :              '1',
	IDCANCEL :          '0'
};

// define event id 
var HTML_EVENT_CLICK 		= 'onclick'
var HTML_EVENT_DBLCLICK 	= 'ondblclick'
var HTML_EVENT_MOUSEDOWN 	= 'onmousedown'
var HTML_EVENT_MOUSEUP		= 'onmouseup'
var HTML_EVENT_MOUSEMOVE	= 'onmousemove'
var HTML_EVENT_MOUSEOUT		= 'onmouseout'
var HTML_EVENT_MOUSEOVER	= 'onmouseover'
var HTML_EVENT_KEYDWON		= 'onkeydown'
var HTML_EVENT_KEYUP		= 'onkeyup'
var HTML_EVENT_KEYPRESS		= 'onkeypress'
var HTML_EVENT_FOCUS		= 'onfocus'
var HTML_EVENT_BLUR			= 'onblur'

// message id
var WM_CLOSE = 0x0;

// documentelement¼lpfunc
// element¼
function $AttachEventListener(element, evt, lpfunc) {
	element = $(element);
	if (element.addEventListener){
		//element.addEventListener(evt, lpfunc, false);
	} else if (element.attachEvent){
		element.attachEvent(evt, lpfunc);
	}
}

/*-------------------------------------------------------------------------
	you must defined the function MessageProcedure in the handle as a memeber
---------------------------------------------------------------------------*/

function $SendMessage(handle, msgtype, MSG) {
	if( $IsNull(handle) ) { return; }
	if($(handle).MessageProcedure) {
		$(handle).MessageProcedure(msgtype, MSG);
	}	else {
		alert('MessageProcedure not defined');
	}
}

// RECTṹ
function __RECT(top, left, bottom, right) {
	this.top = top;
	this.left = left;
	this.bottom = bottom;
	this.right = right;
}
__GLOBALS['resourceHandle'] = __PANELWORK.__xmldoc(__RESOURCE__);
__GLOBALS['MIN_HEIGHT'] = 32;
__GLOBALS['MIN_WIDTH'] = 180;

if( !__GLOBALS['resourceHandle'] ) {
	alert('Դļʧ...' + __RESOURCE__);
}

// global windows	
__GLOBALS['vtable'] = document.body;
__GLOBALS['vtable'].wnds = new __LIST();
__GLOBALS['vtable'].actvieWnd = null;
var __DEBUG__MODE = true;

/*-----------------------------------------------------------------
	common APIs
-------------------------------------------------------------------*/

// for xquery
function selectSingleElement(XQL) {
    return __GLOBALS['resourceHandle'].documentElement.selectSingleNode(XQL);
}

// check the statement wether be null
function $IsNull(statement) {
	return  (statement == null);	
}

// check the obj wether be Object or defined
function $defined(obj){
	if( obj == undefined )
		return false;
	return $IsNull(obj);
}

// check the parameter func wether be Function
function $IsFunction(func) {
	return func instanceof Function;
}

/*-----------------------------------------------------------------
	windows APIs
-------------------------------------------------------------------*/

function $RegisterWindow(wndNode) {
	if( $IsNull(wndNode) ) {
		alert('wndNode is null');
		return;
	}
	var parent = $GetParentWindow(wndNode);
	if( $IsNull(parent) ){
		alert('register error, invalid parent');
		return;
	}
	parent.wnds.push(wndNode);
}

function $UnRegisterWindow(wndNode) {
	if( $IsNull(wndNode) ) {
		alert('wndNode is null');
		return;
	}
	var parent = $GetParentWindow(wndNode);
	if( $IsNull(parent) ){
		alert('unregister error, invalid parent');
		return;
	}
	parent.wnds.remove(wndNode);
}

function $IsWindow(wndNode){
	var parent = $GetParentWindow(wndNode);
	if( $IsNull(parent) ){
		return false;
	}
	return !$IsNull(parent.wnds.find(wndNode));
}

function $CreateWindow(wndName, wndTitle, ws, left, top, width, height, pParent){
	var wnd = $CreateWindowEx(wndName, wndTitle, ws, left, top, width, height, pParent);
	return wnd;
}

function $ShowWindow(wndNode, ws){
	if( ws == CONST['SW_SHOW'] ){
		wndNode.style.display = '';
		if( $IsWindow(wndNode) )
			$ActivateWindow(wndNode);
	} else if( ws == CONST['SW_HIDE'] ) {
		wndNode.style.display = 'none';
	}
}

function $IsStyle(cs, style){
	return ((cs & style) == style) || (cs & CONST['STYLE_DEFAULT'] == CONST['STYLE_DEFAULT'] );
}

function $IsWithStyle(style, wstyle) {
	return ((style & wstyle) == style);
}

// do modifying
function $IsMaxWindow(wndNode) {
	if( !$IsWindow(wndNode) ) {
		alert('error')
		return false;
	}
	var ws = $GetWindowStyle(wndNode);
	if( $IsStyle(ws, CONST['STYLE_MAX']) && (CONST['SIZE_MAX'] == $GetWindowStatus(wndNode))) {
		return true;	
	} else {	return false;	}
}

function $DestroyWindow(wndNode){
	var parent = $GetParentWindow(wndNode);
	if( $IsNull(parent)) {
		__PANELWORK.__alert('system error, close window exception[the window have not been registered]');
		return;
	}
	$RemoveWindow(wndNode);
	$UnRegisterWindow(wndNode);
	wndNode = 0;
	var wnd = $GetTopWindow(parent);
	if( $IsNull(wnd) )
		return;
	if( $IsWindow(wnd) ){
		$ActivateWindow(wnd);
	}
}

function $RemoveWindow(wndNode){
	wndNode.parentNode.removeChild(wndNode);
}

function $GetActiveWindow(wndNode){
	if( $IsWindow(wndNode.activeWnd) )
		return wndNode.activeWnd;
	else
		return null;
}

function $GetWindowZIndex(wndNode){
	return parseInt(wndNode.style.zIndex);;
}

var  $ActivateWindowEvent = function(wndNode){
	return function(){
		$ActivateWindow(wndNode);
	};
}

/*----------------------------------------------------
 ڼģʽ $ActiveWindow
 input: wndNode - the specified window
 no return;
 principle:
 	there are two window modals, one is modal ,the other is modaless
------------------------------------------------------*/
function $ActivateWindow(wndNode){
// ڵ⣬ ûעᵽϵͳб
// ʱеʱϵͳ޼ڣڹرʱϵͳĬϵļڵΪzIndex
// У²
	if( !$IsWindow(wndNode))
		return;
	if( $GetModalType(wndNode) == CONST['MODE'] ){
		$ActivateWindow($GetParentWindow(wndNode));
		$MaskWindow($GetParentWindow(wndNode), true);
	}
	var ws = $GetWindowStyle(wndNode);
	// 浱ǰ
	var ActiveWnd = $GetActiveWindow(__GLOBALS['vtable']);

	var zIndex = 10;	// ĬϵĴ
	// õǰڵļ
	if( !$IsNull(ActiveWnd) ){ // ѾڼڵĻҪڵʽĳɷǼ״̬
		//__PANELWORK.__display(ActiveWnd.szTitle);
		if( (ActiveWnd == wndNode) ){ // ǰΪʱֱӷ
			return;
		} else if($IsStyle(ws, CONST['STYLE_CHILD'])) {
			if($GetActiveWindow(ActiveWnd) == wndNode){
				return;
			}
		}
		$SetWindowActive(ActiveWnd, false);
		if( !$IsNull($GetTopWindow()))
			zIndex = $GetWindowZIndex($GetTopWindow())+1;
	}
	var hwndactive = null;	// 
	if( $IsStyle(ws, CONST['STYLE_CHILD']) ) {
		// ӴڵĻӦýƵڣ ڵļΪӴ
		//alert('child')
		hwndactive = $GetParentWindow(wndNode);
		$SetWindowZIndex(hwndactive, zIndex);
		zIndex = zIndex + 1;
		atvwnd = $GetActiveWindow(hwndactive);
		var z = 0;
		if( !$IsNull(atvwnd) ) {
			z = $GetWindowZIndex(atvwnd) + 1;
		}
		$SetWindowZIndex(wndNode, z);
		hwndactive.activeWnd = wndNode;
	} else {
		hwndactive = wndNode;
	}
	$SetWindowZIndex(hwndactive, zIndex);
	$SetWindowActive(hwndactive, true);
	// ģʽԻĻ򼤻ڱ__GLOBALS['vtable'].activeWnd
	if( $GetModalType(hwndactive) == CONST['mode'] )
		__GLOBALS['vtable'].activeWnd = $GetParentWindow(hwndactive);
	else
		__GLOBALS['vtable'].activeWnd = hwndactive;
}

/*----------------------------------------------------
 ʧȥ $DeactiveWindow
 input: wndNode - the specified window
 no return;
 function:
 	set the specified window deactive;
------------------------------------------------------*/
function $SetWindowActive(wndNode, IsActive){
	if(!$IsWindow(wndNode)) {	return; }
	var style;
	style = (IsActive) ? 'clsActiveTitle' : 'clsNoActiveTitle';
	var ws = $GetWindowStyle(wndNode);
	var titleHandle = $GetTitle(wndNode);
	if( $IsStyle(ws, CONST['STYLE_MULTIWINDOW']) ) { // ര
		titleHandle.className = style;
		var ActiveWnd = $GetActiveWindow(wndNode);
		if( $IsNull(ActiveWnd) )
			return;
		titleHandle = $GetTitle(ActiveWnd);
		titleHandle.className = style;
	} else {
		titleHandle.className = style;
	}		
}

function $GetModalWindow(wndNode){
	if( $IsNull(wndNode.modalWnd) )
		return wndNode;
	else
		return $GetModalWindow(wndNode.modalWnd);
}

function $MaxizeWindow(wndNode){
	if( !$IsWindow(wndNode) ){ return; }
	var ws = $GetWindowStyle(wndNode);
	if( !$IsStyle(ws, CONST['STYLE_MAX']) ) {	return; }
	if( $GetWindowStatus(wndNode) == CONST['SIZE_MAX'] ) { return; };
	var parent = $GetParentWindow(wndNode);
	var width, height;
	if( parent == document.body ) {
		width = Math.max(document.body.clientWidth - 2, document.body.scrollWidth);
		height = Math.max(document.body.clientHeight - 1, document.body.scrollHeight);
	} else if( $IsWindow(parent) ) {
		width  = Math.max($GetClient(parent).clientWidth - 2, $GetClient(parent).scrollWidth);
		height = Math.max($GetClient(parent).clientHeight - 1, $GetClient(parent).scrollHeight);
	} else {	return;	}
	$ChangeCtrlButton(wndNode, CONST['SIZE_MAX'], CONST['SIZE_NORMAL']);
	$SetWindowPosition(wndNode, 0, 0, width, height);
	$SetWindowStatus(wndNode, CONST['SIZE_MAX']);
}

function $RestoreWindow(wndNode){
	if( !$IsWindow(wndNode) ) {	return; }	
	$ChangeCtrlButton(wndNode, CONST.SIZE_MAX, CONST.SIZE_MAX);
	$MoveTo(wndNode, wndNode.rleft, wndNode.rtop);
	$ResizeTo(wndNode, wndNode.rwidth, wndNode.rheight);
	$SetWindowStatus(wndNode, CONST['SIZE_NORMAL']);
}

function $MinimizeWindow(wndNode){
	if( !$IsWindow(wndNode)) { return; }
	if( $GetWindowStatus(wndNode) == CONST['SIZE_NIN'] )
		return;
	var ws = $GetWindowStyle(wndNode);
	if( $IsStyle(ws, CONST['STYLE_FIXED'])) { return; }
	wndNode.width = 0;
	wndNode.style.width = 0;
	var width, height;
	if( parent == document.body ){
		width = document.body.clientWidth;
		height = document.body.clientHeight;
	} else if( $IsWindow(parent) ) {
		width  = $GetClient(parent).clientWidth;
		height = $GetClient(parent).clientHeight;
	} else {	return;	}
	$SetTitleWidth(wndNode, 85);
	$MoveTo(wndNode, 0, height - __GLOBALS['MIN_HEIGHT']);
	$ResizeTo(wndNode, __GLOBALS['MIN_WIDTH'], __GLOBALS['MIN_HEIGHT']);
	$ChangeCtrlButton(wndNode, CONST['SIZE_MAX'], CONST['SIZE_MAX']);
	$SetWindowStatus(wndNode, CONST['SIZE_MIN']);
}

function $GetMinizeWindowLength(){
	var len = 0;
	var node = __GLOBALS['vtable'].wnds.begin();
	if( node == __GLOBALS['vtable'].wnds.end() )
		return len;
	for( topWnd = node.key;node != __GLOBALS['vtable'].wnds.end(); node = node.next ){
		if( $GetWindowStatus(node.key) == CONST['SIZE_MIN'] ) { len++; }
		else { continue; }
	}
	return len;
}

/*-----------------------------------------------------------------
	windows APIs Set Methods
-------------------------------------------------------------------*/

function $SetWindowPosition(wndNode, left, top, width, height) {
    $SaveRectForWindow(wndNode);
    $MoveTo(wndNode, left, top);
    $ResizeTo(wndNode, width, height);
}

function $SetTitleText(wndNode, title){
	if(!$IsWindow(wndNode)) {return;}
	wndNode.szTitle = title;
	wndNode.hTitleContent.innerHTML = title;
	
}

function $SaveRectForWindow(wndNode) {
    if( $GetWindowStatus(wndNode) == CONST['SIZE_NORMAL'] ) {
	    wndNode.rtop    = __PANELWORK.__parseInt(wndNode.style.top);
	    wndNode.rleft   = __PANELWORK.__parseInt(wndNode.style.left);
	    wndNode.rwidth  = __PANELWORK.__parseInt(wndNode.style.width);
	    wndNode.rheight = __PANELWORK.__parseInt(wndNode.style.height);
    }
}

function $SetTitleWidth(wndNode, width){
	if( !$IsWindow(wndNode) )
		return;
	$GetTitleContent(wndNode).style.width = width + 'px';	
}

function $SetTitleHeight(wndNode, height){
	if( !$IsWindow(wndNode) )
		return;
	$GetTitleContent(wndNode).style.height= height+ 'px';	
}

function $SetWindowStatus(wndNode, status) {
	if( !$IsWindow(wndNode) )
		return;
	wndNode.statusType  = status;	
}

function $SetWindowZIndex(wndNode, zIndex) {
	if( !$IsWindow(wndNode) )
		return;
	if( isNaN(parseInt(zIndex)) ){
		alert('valid number of zIndex');
		return;
	}
	wndNode.style.zIndex = zIndex;
}

function $SetActiveWindow(wndNode){
	if( !$IsWindow(wndNode) )
		return;
	var parent = $GetParentWindow(wndNode);
	parent.activeWnd = wndNode;
}

function $ChangeCtrlButton(wndNode, type, dsttype){
	var btn;
	if( !$IsWindow(wndNode) )
		return;
	if( type == CONST.SIZE_MIN )
		btn = $GetMinCtrlButton(wndNode);
	else if( type == CONST.SIZE_MAX )
		btn = $GetMaxCtrlButton(wndNode);
	btn.value = dsttype;
}


/*-----------------------------------------------------------------
	windows APIs Get Methods
-------------------------------------------------------------------*/

function $GetScrollInfo() {     
	var t, l, w, h;
	if (document.documentElement && (document.documentElement.scrollTop || document.documentElement.scrollLeft) ) { 
		t = document.documentElement.scrollTop;
		l = document.documentElement.scrollLeft; 
		w = document.documentElement.scrollWidth;         
		h = document.documentElement.scrollHeight;     
	} else if (document.body) {         
		t = document.body.scrollTop;         
		l = document.body.scrollLeft;
		w = document.body.scrollWidth;         
		h = document.body.scrollHeight;     
	}     
	return { t: t, l: l, w: w, h: h }; 
} 

function $GetParentWindow(wndNode) {
	if( wndNode )
		return 	wndNode.parentHandle; 
	else
		return null;
}

function $GetTitleText(wndNode){
	if(!$IsWindow(wndNode)) {return;}
	return wndNode.szTitle = title;	
}

function $GetSubWindowLength(wndNode){
	if( !$IsWindow(wndNode) )
		return 0;
	return wndNode.wnds.length;
}

function $GetSubWindow(wndNode){
	if( wndNode.wnds.length > 0 ) {
		return wndNode.wnds;
	} else {
		return null;
	}
}
function $GetMinCtrlButton(wndNode){
	if( !$IsWindow(wndNode) )
		return;
	return wndNode.min;
}

function $GetMaxCtrlButton(wndNode){
	if( !$IsWindow(wndNode) )
		return null;
	return wndNode.max;
}

function $GetTitleContent(wndNode){
	if( !$IsWindow(wndNode) )
		return null;
	return wndNode.hTitleContent;
}

function $GetTitle(wndNode){
	if( !$IsWindow(wndNode) )
		return null;
	return wndNode.hTitle;
}


function $GetWindowStatus(wndNode){
	if( !$IsWindow(wndNode) )
		return null;
	return wndNode.statusType ;
}

function $GetWindowStyle(wndNode){
	if( !$IsWindow(wndNode) ) { return null; }
	return wndNode.wstyle;
}

function $GetClient(wndNode){
	if( !$IsWindow(wndNode) ) {	return null; }
	return wndNode.hClientArea;
}

function $GetTopWindow(){
	var topWnd;
	var node = null;
	var parentWnd;
	if( arguments.length > 0 && $IsWindow(arguments[0]) ) {
		parentWnd = arguments[0];
	} else {
		parentWnd = __GLOBALS['vtable'];
	}
	var wnds = $GetSubWindow(parentWnd);
	if( $IsNull(wnds) )
		return null;
	node = wnds.begin();
	if( node == wnds.end() ) {	return null; }
	for( topWnd = node.key;node != wnds.end(); node = node.next ){
		if( parseInt(node.key.style.zIndex) > parseInt(topWnd.style.zIndex) )
			topWnd = node.key;
	}
	return topWnd;
}

// ʾ
function $GetModalZIndex(wndNode) {
	var node;
	for(node = $GetModalWindow(wndNode); $GetModalWindow(node) != null; node = $GetModalWindow(wndNode)) {}
	return $GetWindowZIndex(node);
}

function $GetRect(wndNode) {
	var top = __PANELWORK.__parseInt(wndNode.style.top);
	var left = __PANELWORK.__parseInt(wndNode.style.left);
	var bottom = __PANELWORK.__parseInt(wndNode.style.top) + __PANELWORK.__parseInt(wndNode.style.height);
	var right = __PANELWORK.__parseInt(wndNode.style.left) + __PANELWORK.__parseInt(wndNode.style.width);
	return new __RECT(top, left, bottom, right);
}

function $MoveTo(wndNode, x, y){
	if( !$IsWindow(wndNode) ) {
  	if(__DEBUG__MODE) { alert('Ч...');}
    return;
  }
	wndNode.nTop = y;
	wndNode.nLeft = x;
	wndNode.style.top = wndNode.nTop + 'px';
	wndNode.style.left = wndNode.nLeft + 'px';
}

function $ResizeTo(wndNode, width, height){
	if( !$IsWindow(wndNode) ) {
  	    if(__DEBUG__MODE) { alert('Ч...');}
        return;
    }
    
    if(typeof(wndNode.onresize) == 'function') {
        //alert('onresize()');
        wndNode.onresize();
    }
	width = __PANELWORK.__parseInt(width);
	height = __PANELWORK.__parseInt(height);
	wndNode.width = width;
	wndNode.height = height;
	wndNode.style.width = width + 'px';
	wndNode.style.height = height + 'px';
	
	var client = $GetClient(wndNode);	// ػͻ
	var title  = $GetTitle(wndNode);
	var ws = $GetWindowStyle(wndNode);
	if( $IsStyle(ws, CONST['STYLE_TITLE'])) {
	    client.style.height = Math.max(height - title.offsetHeight - 0, 0);
	} else {
	    client.style.height = Math.max(height - 0, 0);
	}
}
/*-----------------------------------------------------------------
	windows APIs resource api include all of templates resource
-------------------------------------------------------------------*/

function $createHR(){
	var hr = document.createElement('TABLE');
	var tr = hr.insertRow(0);
	tr.insertCell(0)
	hr.style.height = '5px';
	hr.style.width = '98%';
	hr.style.margin = '3 0 0 3';
	hr.style.borderTop = '1px solid #999';
	return hr;
}

/*----------------------------------------------------------------------
 $ load resource from configure XML file
------------------------------------------------------------------------*/

function LoadFromResource(uID){
	var XQL = '/resource/menu[@id="system_menu"]/templates[@id="' + uID + '"]';
	var handle = selectSingleElement(XQL); 
	if( $IsNull(handle) ) {return false; }
	return handle;
}

function LoadMenu(hwnd, uID) {
	var _this = this;
	var handle = LoadFromResource(uID);
	if( !handle) { return false; }
	var children = handle.getElementsByTagName('item');
	if( children.length < 1 ) { return; }
	var type, func, str;

	__GLOBALS['contextmenu'].clear();
	for(var i=0; i<children.length; i++ ){
	    with(children[i]) {
		    type = getAttribute('type');
		    if( type == 'menuitem') {
			    var span = null;
			    span = document.createElement('DIV');
			    span.className = 'clsMenuItemOut';
			    span.style.padding = '4 4 4 5px';
			    var font = document.createElement('FONT');
			    span.appendChild(font);
			    span.hFont = font;

			    __GLOBALS['contextmenu'].hwnd.appendChild(span);
			    font.style.fontSize = '12px';

			    if( getAttribute('status') == 'disabled' ){ font.disabled = true; }

			    func = getAttribute('lpfunc');
			    str =  getAttribute('icon');
			    font.innerText = (str.length >= 1) ? (str.substring(0, 1) + '  ') : '    ';
			    font.innerText += getAttribute('caption');
			    font.title = getAttribute('title');
			    span.lpfunc = func;

			    span.onmouseover = function(){ this.className = 'clsMenuItemOver'; };
			    span.onmouseout = function(){ this.className = 'clsMenuItemOut';  };
			    span.onmousedown = function(){
				    if( this.hFont.disabled == true ){
					    __GLOBALS['contextmenu'].visible = true;
					    return;
				    }
				    __GLOBALS['contextmenu'].hide();
				    try{
					    func = eval(this.lpfunc);
					    func(hwnd);
				    }catch(e){ alert(e.description)}
			    }
		    }else if( type == 'seperator' ){ __GLOBALS['contextmenu'].hwnd.appendChild($createHR()); }
	    }
	}
};

__GLOBALS['contextmenu'] = {
	hwnd : null,
	handle : null,
	visible : false,
	init : function(){
		this.hwnd = document.createElement('DIV');
		_this = this;
		// create when the document loading completely
		window.attachEvent('onload', function(){
			document.body.appendChild(_this.hwnd);
			_this.hwnd.style.cssText = 'position: absolute; display: none; width: 190px; padding: 2; border: 1px solid #999; background: #FFF; z-Index: 100000;cursor: default;';
				document.body.attachEvent('onmousedown', function(){
			    if( _this.visible == true){ 
			        _this.visible=false; 
			        return;
			    }
			    _this.hide()
		    })
		});
		
		// when the ie resizing hide the contextmenu
		window.attachEvent('onresize', function() {
			_this.hide();
		});
		
		// when the ie lose focus hiding the contextmenu
		window.attachEvent('onblur', function() {
			_this.hide();
		})
	},
	load : function(h, uID){
		
	},
	show : function(){
	  this.hwnd.style.display = '';
		var scroll = $GetScrollInfo();
		var left = 0, top = 0;
		if((event.clientX + this.hwnd.offsetWidth) > document.body.clientWidth)
		    left = event.clientX  + scroll.l - this.hwnd.offsetWidth - 2;
		else
		    left = event.clientX + scroll.l;
		
		if( (event.clientY + this.hwnd.offsetHeight) > document.body.clientHeight)
		    top = event.clientY  + scroll.t - this.hwnd.offsetHeight - 2;
		else
		    top = event.clientY + scroll.t;
		this.hwnd.style.left = left;
		this.hwnd.style.top = top; 
		document.onmousewheel = function() {	return false;	}
	},
	hide : function(){
		document.onmousewheel = null;
		this.hwnd.style.display = 'none';
	},

	clear : function(){
		this.hwnd.innerHTML = '';
		this.handle = null;
	}
}


function $CreateWindowEx(wndName, wndTitle, ws, left, top, width, height, pParent){
	var hwnd = document.createElement('DIV');
	hwnd.IsSubWnd = false;
	hwnd.wstyle = ws;	// ʽ
	hwnd.wnds = new __LIST();	
	hwnd.activeWnd = null;	// ǰӴھ
	hwnd.modalwnd = null;	// ӸôڵģʽԻ
	hwnd.maskWnd = document.createElement('DIV');	//
	hwnd.maskWnd.className = 'clsMaskWindow';
	__GLOBALS['vtable'].appendChild(hwnd.maskWnd);
	var cs = $GetWindowStyle(pParent);
	if( $IsStyle(cs, CONST['STYLE_MULTIWINDOW']) && $IsStyle(ws, CONST['STYLE_CHILD']) ) {
		// Ӵ
		$GetClient(pParent).appendChild(hwnd);
		hwnd.parentContainer = pParent;
		hwnd.parentHandle = pParent;
	} else {
		// ͨô, صͨbody
		__GLOBALS['vtable'].appendChild(hwnd);
		hwnd.parentContainer = __GLOBALS['vtable'];
		hwnd.parentHandle = ( $IsWindow(pParent)) ? pParent : __GLOBALS['vtable'];
	}

	hwnd.szName = ( wndName != '' )? wndName : 'WndX - PanelWork WndX';		// 
	hwnd.szTitle = ( wndTitle != '' )? wndTitle : 'WndX - PanelWork WndX';	// ʽ
	if( !isNaN(top)) {
		hwnd.nTop = hwnd.rtop = top;
		hwnd.style.top = top; // ڶλ
	}
	if( !isNaN(left)) {
		hwnd.nLeft = hwnd.rleft = left;
		hwnd.style.left = left; // ߾
	}
	
	if( !isNaN(width) ) {
		hwnd.nWidth = hwnd.rwidth = width;
		hwnd.style.width = width;				// ڿ
	}
	if( !isNaN(height) ) {
		hwnd.nHeight = hwnd.rheight = height;
		hwnd.style.height = height;				// ڿ
	}

	// 
	if( !$IsStyle(ws, CONST['STYLE_FIXED']) ){ $MakeResizable(hwnd);}
	$SaveRectForWindow(hwnd);
	hwnd.setAttribute('$IsWindow', CONST['REGISTEREDWND']);
	hwnd.attachEvent('onmousedown', $ActivateWindowEvent(hwnd));
	hwnd.className = 'clsWindows';
	hwnd.modeType = CONST['NORMAL'];
	hwnd.statusType  = CONST['SIZE_NORMAL'];
	// initial title bar
	if( $IsStyle(ws, CONST['STYLE_TITLE']) ) {
		hwnd.hTitle = document.createElement('DIV');
		hwnd.hTitle.className = 'clsActiveTitle';
		hwnd.hTitle.onselectstart = function(){return false;};
		hwnd.appendChild(hwnd.hTitle);
		hwnd.hTitle.oncontextmenu = function(){
		  var status = $GetWindowStatus(hwnd);
		  var type = 'system_wnd_normal';
		  if( status == CONST['SIZE_MIN'] ) {
				type = 'system_wnd_min';
			} else if(status == CONST['SIZE_MAX']) {
			    type = 'system_wnd_max';
			} 
			LoadMenu(hwnd, type);			
			__GLOBALS['contextmenu'].show();
			return false;
		}
		hwnd.hTitle.attachEvent('ondblclick', function(){
			if( !$IsStyle(ws, CONST['STYLE_MAX']) )
				return;
			if(hwnd.max.value.toString() == CONST['SIZE_NORMAL'].toString()){
				$RestoreWindow(hwnd);
			}else{
				$MaxizeWindow(hwnd);
			}
		});
		hwnd.hTitle.setAttribute('$IsWindow', CONST['REGISTEREDTITLE']);
		
		if( $IsStyle(ws, CONST['STYLE_ICON'])) {
		    hwnd.hIcon = document.createElement('IMG');
		    hwnd.hIcon.src = 'images/panelwork.JPG';
		    hwnd.hIcon.className = 'clsIcon';
		    hwnd.hTitle.appendChild(hwnd.hIcon);
		}
		
		var oc = document.createElement('SPAN');
		hwnd.hTitleContent = oc;
		oc.className = 'clsTitleContent';
		hwnd.hTitle.appendChild(hwnd.hTitleContent);
		hwnd.hTitleContent.innerText = hwnd.szTitle;
		hwnd.hTitleContent.style.width = hwnd.offsetWidth - ((hwnd.hIcon) ? hwnd.hIcon.offsetWidth : 0 ) - 90;	// 
		if( $IsStyle(ws, CONST['STYLE_CLOSE'])) {
			hwnd.close = $CreateCtrlButton(CONST['SIZE_CLOSE'], $DestroyWindow, hwnd );
		}
		if( $IsStyle(ws, CONST['STYLE_MAX']) ) {
			hwnd.max = $CreateCtrlButton(CONST['SIZE_MAX'], function(){
			    if(hwnd.statusType  != CONST['SIZE_MAX']){  
			    	$MaxizeWindow(hwnd); 
			    } else { 
			    	$RestoreWindow(hwnd);   
			    }
		    }, 
		    hwnd );
		}
		if( $IsStyle(ws, CONST['STYLE_MIN']) ) {
			hwnd.min = $CreateCtrlButton(CONST['SIZE_MIN'], function(){$MinimizeWindow(hwnd);}, hwnd );
		}
	}
	hwnd.hClientArea = document.createElement('DIV');
	hwnd.hClientArea.className = 'clsClientArea';
	hwnd.appendChild(hwnd.hClientArea);
	hwnd.style.display = 'none';
	return hwnd;
}

function $CreateCtrlButton(type, lpfuncEvent, pParentWnd){
	var hwnd = document.createElement('input');	
	hwnd.type = 'button';
	pParentWnd.hTitle.appendChild(hwnd);
	hwnd.value = type;
	hwnd.className = 'clsCtrlButtonOut';
	hwnd.onmouseover = function() { this.className='clsCtrlButtonOver';};
	hwnd.onmouseout = function() { this.className='clsCtrlButtonOut';};
	hwnd.onmouseup = function() { lpfuncEvent(pParentWnd) };
	return hwnd;
}

function $GetMaskWindow(wndNode){
	if( !$IsWindow(wndNode) ) { return null; }
	return wndNode.maskWnd;
}

/*-----------------------------------------------------------------
 $MaskWindow
 $parameter: wndNode - which will be masked
 			 bMask - if mask or not
 $date: 2008-05-11
-------------------------------------------------------------------*/

function $MaskWindow(wndNode, bMask){
	if( !$IsWindow(wndNode) ) {	return; }
	$ActivateWindow(wndNode);	// ǰȼʹwndNode߲
	var maskWnd = $GetMaskWindow(wndNode);	// ִھ䴰ڵ
	var nIndex = $GetWindowZIndex(wndNode);
	if( bMask ) {		// ָô
		var rect = $GetRect(wndNode);	// øôڵλã ʾִ
		maskWnd.style.display = '';
		with(maskWnd.style) {
			top = rect.top;
			left = rect.left;
			width = rect.right - rect.left + 10;
			height = rect.bottom - rect.top + 10;	
			zIndex = nIndex + 1;
			background = '#F8F8F8';
		}
	} else {	// ȡ
		maskWnd.style.display = 'none';
	}
}

function $MakeResizable(obj){
	var d=7;
	var widthmax = __GLOBALS['MIN_WIDTH'];
	var heightmax = __GLOBALS['MIN_HEIGHT'];
	var l,t,r,b,ex,ey,cur;
	obj.attachEvent('onmousedown',mousedown);
	obj.attachEvent('onmouseup',mouseup);
	obj.attachEvent('onmousemove',mousemove);
	function mousedown(){
		if(( $GetWindowStatus(obj) == CONST['SIZE_MAX'] )){	return;	}
		if(event.button==1&&obj.style.cursor){
			$SetWindowStatus(obj, CONST['SIZE_RESIZING']);
    	obj.setCapture();
		}
	}
	function mouseup(){
		if(( $GetWindowStatus(obj) == CONST['SIZE_MAX'] )){
			return;	
		}
	    if(event.button==1&& ($GetWindowStatus(obj) == CONST['SIZE_RESIZING'] )){
			obj.draging = false;
			$SetWindowStatus(obj, CONST['SIZE_NORMAL']);
			obj.releaseCapture();
		}
	}
	function mousemove(){
	  var status = $GetWindowStatus(obj);
		if(( status == CONST['SIZE_MAX'] ) || ( status == CONST['SIZE_FIXED']) || (status == CONST['SIZE_MIN'])){
			return;	
		}
		if(( status == CONST['SIZE_RESIZING'] )){
			var dx=event.screenX-ex;
			var dy=event.screenY-ey;
			if(cur.indexOf('w')>-1) l+=dx;
			else if(cur.indexOf('e')>-1) r+=dx;
			if(cur.indexOf('n')>-1) t+=dy;
			else if(cur.indexOf('s')>-1) b+=dy;
			var s=obj.style;
			var ll, tt, ww, hh;
			if(r-l > widthmax){
				s.left=l;
				s.width = r-l;
				if( $IsWindow(obj) ){
					$SetTitleWidth(obj, r - l - 90)
				}
			}
			if(b-t>heightmax){
				s.top=t;
				s.height=b-t;
			}
		    $ResizeTo(obj, s.width, s.height);
			ex+=dx;
			ey+=dy;
		}else if( event.srcElement == obj ){
			var x=event.offsetX,y=event.offsetY;
			var c=obj.currentStyle;
			w=parseInt(c.width),h=parseInt(c.height);
			cur=y<d?'n':h-y<d?'s':'';
			cur+=x<d?'w':w-x<d?'e':'';
			if(cur){
				obj.style.cursor=cur+'-resize';
				l=parseInt(c.left);
				t=parseInt(c.top);
				r=l+w;
				b=t+h;
				ex=event.screenX;
				ey=event.screenY;
			}else if(obj.style.cursor) {
				obj.style.cursor='';
			}
		}else{
			obj.style.cursor = '';
		}
	}
}

/*---------------------------------------------------------
 $ ݽ DataExchange
 $ ʵʵ:
 		<input id='ddx'/>
		<input id='ddx2'/>
		<button onclick="nDDX.Update2Ctrl(); ">Updata2Ctrl()</button>
		<button onclick="nDDX.Update2Var();">Updata2Var()</button>
 		<script>
		var g_var = new __DDXITEM(1);
		var g_var2 = new __DDXITEM(2);
		var nDDX = new __DATAEXCHANGE;

		window.attachEvent('onload', function() {
			nDDX.HTML_TEXT(ddx, g_var);
			nDDX.HTML_TEXT(ddx2, g_var2);
		})
		<script>
-----------------------------------------------------------*/
var __DDXITEM = __CLASS.create();
var __DATAEXCHANGE = __CLASS.create();

__DDXITEM.prototype = {
	key : null,	type : '',	e : null,
	_initialize : function(v) {
		this.key = v;
		this.type = typeof(v); 
	},
	toString : function() {	return this.key;},
	type : function() {return this.type;	},
	set : function(v) {	this.key = v;	},
	get : function() {	return this.key; },
	setElement: function(e) {	this.e = e; },
	getElement : function() {	return this.e;},
	value2element : function() { this.e.value = this.key; },
	element2value : function() { this.key = this.e.value; }
};

__DATAEXCHANGE.prototype = {
	item : [],	// 
	_initialize : function(areaObj) {
		
	},
	HTML_TEXT : function(IID, varObj) {
		this.item.push(varObj);
		varObj.setElement($(IID));
	},
	Update2Ctrl : function() {
		var iLen = this.item.length;
		if( iLen < 1) {return;}
		for( var i = 0; i < iLen; i++ ) {
			this.item[i].value2element();
		}
	},
	Update2Var : function() {
		var iLen = this.item.length;
		if( iLen < 1) {return;};
		for( var i = 0; i < iLen; i++ ) {
			this.item[i].element2value();
		}
	}
}



/*-----------------------------------------------------------------
 $ class __DIALOG
 $ dialog base class
 $ date: 2007-11-20
-------------------------------------------------------------------*/
var __DIALOG = __CLASS.create();
__DIALOG.prototype = {
	hwnd : null,
	DataExchanger : new __DATAEXCHANGE,
	_initialize : function(uTemplate, hParent) {
		var self = this;
		var left = 0, top = 0;
		var res = this._loadResource(uTemplate);
		if( $IsNull(res) ) {
			alert('Դʧ'+uTemplate+'...');
			return;
		}
		var width, height;
		var title, ws, panel;
		width = res.getAttribute('width');
		height = res.getAttribute('height');
		title =  res.getAttribute('title');
		panel = res.getAttribute('container')
		
		width = ($IsNull(width)) ? 500 : width;
		height = ($IsNull(height)) ? 300 : height;
		title = $IsNull(title) ? 'panelwork window' : title;
		
		var tws = res.getAttribute('wstyle')
		tws = tws.split('|');
		
		for(var i = 0; i < tws.length; i++) {  ws = ws | CONST[tws[i]];	}
		
		if( !$IsWindow(hParent) ){
			hParent = null;
			left = (document.body.clientWidth - width ) / 2;;
			top =  (document.body.clientHeight - height ) / 2;;
		} else {
			left = hParent.nLeft;
			top = hParent.nTop;
		}
		this._initialDialog();
		this.hwnd = $CreateWindow('dialog', title, ws, left, top, width, height, hParent);
		$RegisterWindow(this.hwnd);
		$ResizeTo(this.hwnd, width, height);
		if(!$IsNull(panel)) {
			if(panel != "") {
				var c = $(panel);
				if( c.getAttribute('tagName').toLowerCase() == 'textarea' ) {	$GetClient(this.hwnd).innerHTML = c.value; }
			}
		}
	},
	
	_initialDialog : function(){
		// do other initial
	},
	
	_loadResource : function(uTemplate) {
		var xql = '/resource/dialog/templates[@id="user_defined_dialog"]/item[@id="'+uTemplate+'"]';
		var t = selectSingleElement(xql);
		return t;
	},
	
	doModal : function(){
		this.hwnd.modeType = CONST['MODE'];
		var parent = $GetParentWindow(this.hwnd);
		$MaskWindow(parent, true);
		parent.modalWnd = this.hwnd;
		var self = this;
		this.hwnd.close.onmouseup = function() {
				$EndDialog(self, CONST['IDCANCEL']); 
		};
		$ShowWindow(this.hwnd, CONST['SW_SHOW']);
		$ResizeTo(this.hwnd, this.hwnd.nWidth, this.hwnd.nHeight);
	},
	
	create : function(){
		this.hwnd.modeType = CONST['MODELESS'];
		var parent = $GetParentWindow(this.hwnd);
		parent.wnds.push(this.hwnd);
		$ShowWindow(this.hwnd, CONST['SW_SHOW']);
	},
	
	UpdateData : function(IsUpdate2Variable) {
		if( !IsUpdate2Variable ) 
			this.DataExchanger.Update2Ctrl()
		else
			this.DataExchanger.Update2Var();
	},
	DDX_VALUE : function(element, varobj) {
		this.DataExchanger.HTML_TEXT(element, varobj);
	}
};

function $GetModalType(wndNode){
	if( !$IsWindow(wndNode) ) {	return; }
	return wndNode.modeType;
}

function $GetWindow(dlg){
	if(!dlg) { return null; }
	if(dlg.hwnd) { return dlg.hwnd; }
	return null;
}

function $EndDialog(dlg) {
  var wnd = null;
  hwnd = $IsWindow(dlg) ? dlg : $GetWindow(dlg);
	var parent = $GetParentWindow(hwnd);
	$MaskWindow(parent, false);
	$ActivateWindow(parent);
	$DestroyWindow(hwnd);
	dlg = null;
	delete dlg;
	if( arguments.length > 1 )  
		return arguments[1];
	else 
		return CONST['IDCANCEL'];
}


var self;
var __DRAGWND = __CLASS.create();
__DRAGWND.prototype = {
	hDragWnd : null,
	ie  : document.all,
	nn6 : document.getElementById&&!document.all,
	isdrag : false,
	x : 0,
	y : 0,
	nTX : 0,
	nTY : 0,
	_initialize : function(){
		self = this;		// thisָ뵽¼
		document.onmousedown = self._initdragment; 
		document.onmouseup   = function(){ self.isdrag=false; };//$SaveRectForWindow(self.hDragWnd);
	},

	_initdragment : function(e){
		if(event.button == 2){	return;	} // Ҽ϶
		var oDragHandle = self.nn6 ? e.target : event.srcElement; // ȡͣڵĶ
		if( oDragHandle.tagName.toLowerCase() == 'SPAN'.toLowerCase() ){
			if( oDragHandle.parentNode.parentNode.hTitleContent ==	oDragHandle ){
				oDragHandle = oDragHandle.parentNode;
			}
		}
		if(oDragHandle.tagName == 'DIV' ){		// ʱ֧DIV϶
			if(oDragHandle.getAttribute('$IsWindow')==CONST['REGISTEREDTITLE'] && oDragHandle.parentNode.getAttribute('$IsWindow')==CONST['REGISTEREDWND']){
				self.isdrag = true; 
				self.hDragWnd = oDragHandle.parentNode; 
				self.nTY = parseInt(self.hDragWnd.style.top+0); 
				self.y = self.nn6 ? e.clientY : event.clientY; 
				self.nTX = parseInt(self.hDragWnd.style.left+0); 
				self.x = self.nn6 ? e.clientX : event.clientX;
				document.onmousemove=self._moveMouse; 
				return false; 
			}
		}
	},
		
	_moveMouse : function(e){
		var wndNode = self.hDragWnd;
		if(!$IsWindow(wndNode)) { return false; }
		if (self.isdrag && !$IsMaxWindow(wndNode)) {
			//var scroll = $GetScrollInfo();
			var x = (self.nn6?(self.nTX+e.clientX-self.x):(self.nTX+event.clientX-self.x));
			var y = (self.nn6?(self.nTY+e.clientY-self.y):(self.nTY+event.clientY-self.y));
			$MoveTo(wndNode, x, y);
			return false; 
		}
	}
};

/*-----------------------------------------------------------------
	$MessageBox
-------------------------------------------------------------------*/
var MSGBOX_YES = 0x0001;	// 
var MSGBOX_NO = 0x0002;		// 
var MSGBOX_CANCEL = 0x0004;	// ȡ
var MSGBOX_YESNO = MSGBOX_YES | MSGBOX_NO;	// /
var MSGBOX_YESNOCANCEL	= MSGBOX_YES | MSGBOX_NO | MSGBOX_CANCEL;	// //ȡ

function $MessageBox(title, msg, ws, lpfuncObj) {
    var msgdlg = new __DIALOG('musicboxfolder', this);
    if(lpfuncObj) {
    	if(lpfuncObj.onok) {
    		msgdlg.onok = lpfuncObj.onok;
    	}
    	if(lpfuncObj.onno) {
    		msgdlg.onno = lpfuncObj.onno;
    	}
    	if(lpfuncObj.oncancel) {
    		msgdlg.oncancel= lpfuncObj.oncancel;
    	}
    }
	var hwnd = $GetWindow(msgdlg);
	$SetTitleText(hwnd, title);
	// $EndDialog(msgdlg);
	if(!ws) {
	    //ws = MB_YESNO;
	}
    $CreateIndirectMsgBox(msgdlg, msg, ws);
	msgdlg.doModal();
	$ResizeTo(hwnd, 350, 200);
	
}



function $CreateIndirectMsgBox(dlg, msg, ws) {
    // initial struct
    var hclient = $CreateHTMLObject('TABLE');
    var row1 = hclient.insertRow();
    var row2 = hclient.insertRow();
    var cell1 = row1.insertCell();
    var cell2 = row2.insertCell();
    
    // with row1
    var p = $CreateHTMLObject('P');
    cell1.appendChild(p);
    var d = $CreateHTMLObject('DIV');
    d.style.overflow = 'auto';
    d.innerHTML = '<pre>' + msg + '</pre>';
    p.appendChild(d);
    if(!ws) {
    	ws = MSGBOX_YES;
    }
    var btn1, btn2, btn3;
    if( $IsWithStyle(MSGBOX_YES, ws) ) {
    	btn1 = $CreateHTMLObject('BUTTON');
    	btn1.className = 'sysbtn';
    	btn1.innerText = '    ';
    	cell2.appendChild(btn1);
    	btn1.onclick = function(){
    		if(dlg.onok){
    			dlg.onok();
    		}
    		$EndDialog(dlg);
    	}
    }
    if( $IsWithStyle(MSGBOX_NO, ws) ) {
    	btn2 = $CreateHTMLObject('BUTTON');
    	btn2.className = 'sysbtn';
    	btn2.innerText = '    ';
    	cell2.appendChild(btn2);
    	btn2.onclick = function(){
    		if(dlg.onno){
    			dlg.onno();
    		}
    		$EndDialog(dlg);
    	}
    }

	if( $IsWithStyle(MSGBOX_CANCEL, ws) ) {
    	btn3 = $CreateHTMLObject('BUTTON');
    	btn3.className = 'sysbtn';
    	btn3.innerText = ' ȡ ';
    	cell2.appendChild(btn3);
    	btn3.onclick = function(){
    		if(dlg.oncancel){
    			dlg.oncancel();
    		}
    		$EndDialog(dlg);
    	}
    }
    
    
    // initial style
    with(hclient) {
        height = '99.7%';  
        border ='0'; 
        align  ='center' ;
        cellPadding='0' ;
        cellSpacing='0' ;
        style.cssText ='width: 100%; border: 0px solid #CCC; font-size: 14px; color: #ccc;';
    }
    row1.vAlign  = 'top';
    row2.style.background = '#F1F1F1';
    
    cell1.height = '100%';
    cell1.style.cssText = 'padding-top:8px;padding-bottom:8px;padding-left:6px;padding-right:6px;color: #666;';
     
    cell2.height = '30' 
    cell2.align  = 'right';
    cell2.style.cssText ='padding-left:6px; border: 1px solid #CCCCCC; padding-right: 5px;';
    $GetClient(dlg.hwnd).appendChild(hclient);  //'<pre>' + msg + '</pre><br>';
    dlg.hwnd.onresize = function() {
        if(hclient) {
            hclient.style.width = $GetClient(this).offsetWidth - 2;
        }
        
    }

}


function InitializeComCtrl() {
	__GLOBALS['contextmenu'].init();	// ʼҼ˵
  new __DRAGWND();
}

InitializeComCtrl();