/*--------------------------------------------------------------------
 $ this is a part of Javascript Foundation Classes Framework that is  
 $ used for javascript panel work programing. all is free, but reserved
 $ by author.
 $ date: 21:56 2007-11-27
 $ author: Lovely Life
 $ All rights reservered; life.qm@gmail.com
-----------------------------------------------------------------------*/

// this only constructor for creating other class
var __CLASS = {
	create: function() {
		return function() {
			this._initialize.apply(this, arguments);	
		};
	}
};

function $defined(vars){
	return vars != undefined;	
}

var __GLOBALS = {
	vtable : null,
	resourceHandle : null,
	contextmenuHandle : null 
};

/*--------------------------------------------------------------------------------
 $ basic  type list definition
----------------------------------------------------------------------------------*/
var __NODE = __CLASS.create();	//бڵṹ
var __LIST = __CLASS.create();	// 

__NODE.prototype = {
	next : null,
	prev : null,
	key  : null,
	_initialize : function(key) {
		this.key = key;
	}
}

__LIST.prototype = {
	head : null,	// ͷ
	tail : null,	// β
	current: null,
	length : 0,
	_initialize : function(){
		this.head = new __NODE(null);
		this.tail = new __NODE(null);
		this.head.next = this.tail;
		this.tail.prev = this.head;
		this.current = this.head;
	},
	
	begin : function(){	return this.head.next; },	// not head	use as STL
	
	end : function(){	return this.tail;	},
	
	len : function(){	return this.length;	},
	
	item : function() {	return this.current.key; },
	
	moveNext : function() {	this.current = this.current.next;	},
	
	movePrev : function(){	this.current = this.current.prev;	},
	
	push : function(key){
		var node = new __NODE(key);
		this.tail.prev.next = node;
		node.prev = this.tail.prev;
		node.next = this.tail;
		this.tail.prev = node;
		this.length++;
	},
	
	insert : function(key) {
		var node = new __NODE(key);
		this.tail.prev.next = node;
		node.prev = this.tail.prev;
		node.next = this.tail;
		this.tail.prev = node;
		this.length++;
	},
	
	remove : function(key){
		var node = this.find(key);
		if( node == null ){	return false;	}
		this.removeNode(node);
	},
	
	removeNode : function(node) {
		node.prev.next = node.next;
		node.next.prev = node.prev;
		this.length--;
	},
	
	clear : function(){
		for(var node = this.begin(); node != this.end(); node = node.next){
			this.removeNode(node);
		}
	},
	
	find : function(key){
		for(var node = this.begin(); node != this.end(); node = node.next){
			if( node.key == key )	return node;
		}
		return null;
	},
	
	toString : function(){
		var i = 0;
		var str = "";
		for(var node = this.begin(); node != this.end(); node = node.next){
			str += "Node["+i+"]: " + node.key + "\n";
			i++;
		}
		return str;
	}
};

var __PANELWORK = {

	__alert : function(msg) {
		alert(msg);
	},

	__getworkpath : function() {
		var local = location.href.toString();
		var filepath = local.substring(0, local.lastIndexOf("\/")+1); // get current path with "file:///"
		filepath = filepath.substring(("file:///").length, filepath.length);
		return(filepath);
	},
	
	__getobject : function(objstr) {
	    if( typeof objstr != 'object') {
	        return document.getElementById(objstr);
	    } else {
	        return objstr;
	    }
	},

	__include : function(filename) {
		var src = this.__getworkpath()+filename;
		document.write("<script src="+src+"></scr"+"ipt"+">");
	},
	
	__createFuncHandle : function(){
		return function(){
			alert(arguments.length);
		}
	},

	__xmldoc : function (dname){
		var xmlDoc;
		// code for IE
		if (window.ActiveXObject){
			xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
		}
		// code for Mozilla, Firefox, Opera, etc.
		else if (document.implementation && document.implementation.createDocument){
			xmlDoc=document.implementation.createDocument("","",null);
		}else{
			alert('Your browser cannot handle this script');
		}
		xmlDoc.async=false;
		var ret = xmlDoc.load(dname);
		if( ret )
			return(xmlDoc);
		else
			return(ret);
	},

	__isIE6 : function() {
		if((navigator.appVersion.indexOf("MSIE   6.") == -1) 
			 || (navigator.appVersion.indexOf("MSIE   7.") == -1))
			return true;
		else
			return false
	},
	
	__isInRect : function(pt, rect){
		if( (pt instanceof __POINT) && (rect instanceof __RECT) ){
			if( (pt.x <= rect.right) && (pt.x >=rect.left) ){
				if( (pt.y >= rect.top) && (pt.y <= rect.bottom) ){
					return true;
				}
			}
		}
		return false;
		
	},
	
	__sleep : function(numberMillis) {
		var now = new Date();
		var exitTime = now.getTime() + numberMillis;
		while (true) {
			now = new Date();
			if (now.getTime() > exitTime)
				return;
		}
	},
	
	__display : function(obj){
		var str = "";
		if( typeof obj == String ){
			str = obj;
		} else {	
			for(var p in obj )
				if( p == 'innerHTML' || p == 'outerHTML' ) {
					str += "["+p+"]:<br><textarea cols=30 rows=30>"+obj[p]+"</textarea>\n";
				} else {
					str += "["+p+"]:"+obj[p]+"\n";
				}
			
		}
		prop.innerHTML = "<pre>" + str + "</pre>";
		return str;
	},

	__return : function(errmsg) {
		location.href = "err.html?" + errmsg;
	},
	
	// convert lib
	// convert var to number type if var is not a num then return 0;
	__parseInt : function(num){
		var t = parseInt(num);
		if( isNaN(t) )
			return 0;
		return t
	}
// code end here
};

/*------------------------------------------------------
 $ common library 
--------------------------------------------------------*/
function $(objstr) {
    return __PANELWORK.__getobject(objstr);
}

function $CreateHTMLObject(tagName) {
    return document.createElement(tagName);
}

function $CreateFSOHandle(){
	return (new ActiveXObject('Scripting.FileSystemObject'));
}

function $DestroyFSOHandle(fso) {
	delete fso;
	fso = null;
}

function $RemoveExtensions(fname) {
		fname = fname.toString();
		var ff = fname.split('.');
		return ff[0];
}

function $GetAbsPosition(element) {
	var w = element.offsetWidth;
	var h = element.offsetHeight;
	var t = element.offsetTop;
	var l = element.offsetLeft;
	while(element = element.offsetParent){
		t+=element.offsetTop;
		l+=element.offsetLeft;
	}
	return { width : w, height : h,	left : l,	top : t	}
}

document.write("<div style=\"display:none;\">panelwork output</div>")