﻿/*-------------------------------------------------------
  UI library
  function: select 美化
  date: 2008-06-12
  author: lovelylife
  the component can be used as UI.components[id]
---------------------------------------------------------*/

var __SELECT = __CLASS.create();

__SELECT.prototype = {
	hwnd : null,        // select 控件显示区域
	selwnd : null,      // 弹出的列表选择窗口
	htmlSelect : null,  // 绑定的select控件
	binited : false,	// for select
	binited2 : false,	// for hwnd
	_initialize : function(HTMLSelect) {
		var _this = this;
		_this.htmlSelect = HTMLSelect;
		_this.htmlSelect.style.display = 'none';
		_this.hwnd = $CreateHTMLObject('DIV');
		_this.selwnd = $CreateHTMLObject('DIV');
		HTMLSelect.parentNode.appendChild(this.hwnd);
		document.body.appendChild(this.selwnd);
		_this.hwnd.style.cssText = 'width: 100%; height: 22px; padding: 3px;overflow:hidden; font-size: 12px;text-overflow:ellipsis;white-space: nowrap;';
		_this.selwnd.style.cssText = 'position: absolute; background: black; display: none;';
		_this.hwnd.onclick = function(){
			if(!_this.binited) { _this.initChild(_this.htmlSelect); }
			var pos = $GetAbsPosition(this);
			_this.selwnd.style.left = pos.left;
			_this.selwnd.style.top = pos.top;
			_this.selwnd.style.width = pos.width - 15;
			_this.selwnd.style.display = (_this.selwnd.style.display == '' )?'none':'';
			document.body.attachEvent('onclick', function(){
				if((event.srcElement != _this.hwnd) && (event.srcElement != _this.selwnd))
					_this.selwnd.style.display = 'none';
			});
		}
		_this.update();
	},
	
	initChild : function(htmlSelect) {
		var len = this.selwnd.childNodes.length;
		for(var i=0; i < len; i++) {
			this.selwnd.childNodes[i].style.width = htmlSelect.parentNode.offsetWidth - 22;
		}
	},
	
	update : function() {
	    var _this = this;
	    _this.selwnd.innerHTML = '';
	    var len = this.htmlSelect.options.length;
		for(var i=len-1; i >= 0; i--) {
			var op = _this.htmlSelect.options(i);
			var li = $CreateHTMLObject('div');
			_this.selwnd.appendChild(li);
			li.style.cssText = 'overflow:hidden; font-size: 12px;text-overflow:ellipsis; color: #A0F224; display: block; border: 1px solid black; cursor: default; padding: 2px;';
			li.innerText = op.value;
			li.title = op.value;
			li.alt = i;
			if(op.selected == true) {
				_this.hwnd.innerHTML = '<font face="Wingdings 3" style="font-size: 9px;">q</font> '+ op.text;
			}
			li.onclick = function() {
			    if(this.innerText == _this.htmlSelect.value) {  return;  }
				if( !_this.binited2 ) {
					_this.hwnd.style.width = _this.htmlSelect.parentNode.offsetWidth - 20;
				}
				_this.htmlSelect.selectedIndex = this.alt;
				_this.hwnd.innerHTML = '<font face="Wingdings 3" style="font-size: 9px;">q</font> ' + this.innerText;
				_this.hwnd.title = this.innerText;
				_this.selwnd.style.display = 'none';
				_this.itemChange(this);
			}
			li.onmouseover = function() {
				this.style.border = '1px solid red';
			}
			
			li.onmouseout = function() {
				this.style.border = '1px solid black';
			}
		}
	
	},
	// 清理视图select控件的数据
	clear : function() {
	    while(this.htmlSelect.length > 0) {
	        this.htmlSelect.remove(0);
	    }
	    this.update();
	},
	
	// virtual function to be overrided
	itemChange      : function(item) {},
	itemClick       : function(item) {},
	itemDblClick    : function(item) {},
	itemContextMenu : function(item) {},
	itemMouseOver   : function(item) {},
	itemMouseOut    : function(item) {},
	itemMouseOver   : function(item) {},
	itemKeyDown     : function(item) {},
	itemKeyUp       : function(item) {}
}