package
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.*;
	
	public class Gallery extends MovieClip
	{
		private var imagesToShow : Number = 4;
		public var spaceBetween : Number = 20;
		public var defaultWidth : Number = 195;
		private var backend : String = 'backend.php';
		
		private var xmlLoader:URLLoader = new URLLoader();
		private var xdata : XML;
		public var images : Array = new Array();
		private var orgImgId : Number;
		private var skipTo : Number = 0;
		private var loaded : Boolean = false;
		
		public var imagesClip : MovieClip = new MovieClip();
		public var stageWidth : Number;
		
		public function Gallery() : void
		{
			stageWidth = stage.stageWidth;
			theHandle.addEventListener( "sliding", slide );
			
			imagesClip.y = 180;
			addChild( imagesClip );

			xmlLoader.load( new URLRequest( backend + "?" + new Date().valueOf() ) );
			xmlLoader.addEventListener( Event.COMPLETE, loadImages );
			
		}
			  
		private function loadImages( _e : Event ) : void
		{
			xdata = new XML( _e.target.data );
			var i : Number = 0;
			for each( var img:XML in xdata.img )
			{
				images[i] = new Img( img, this );
				images[i].x = 200 * i;
				images[i].id = i;
				i++;
			}
			goTo( 0 );
		}
		
		private function slide( _e : Event ) : void
		{			
			var percent : Number = ( theHandle.goToX - slider.x ) / ( slider.width - theHandle.width );
			var imgId : Number = Math.round(percent * ( images.length - 1 ));
			
			goTo( imgId );
		}
		
		private function goTo( imgId : Number ) : void
		{
			var direction : Number;
			if ( orgImgId != imgId )
			{
				if ( imgId > orgImgId  ) direction = 1;
				else direction = -1;
				
				for ( var i : Number = - Math.floor(imagesToShow/2); i <= Math.floor(imagesToShow/2); i++ )
				{
					if( imgId + i < images.length && imgId + i >= 0 ) images[imgId + i].makeActive( i, direction );
				}
				
				for( var j : Number = 0; j < imagesClip.numChildren; j++ )
				{
					var tile : Img = imagesClip.getChildAt(j) as Img;
					if ( tile.id < imgId - Math.floor(imagesToShow/2) || tile.id >  imgId + Math.floor(imagesToShow/2) ) tile.deActive( direction );
				}
				countTxt.text = imgId + 1 + "/" + images.length;
			}
			orgImgId = imgId;			
		}
	}
}