package
{
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.Bitmap;
	import flash.text.TextField;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.events.*;
	import fl.transitions.easing.*;
	import flash.text.TextFormat;
	import gs.TweenLite;
	import fl.motion.easing.*;
	import flash.text.TextFieldAutoSize;
	
	
	public class Img extends MovieClip
	{
		public var active : Boolean = false;
		public var id : Number;
		private var src : String;
		public var imageLoader:Loader = new Loader();
		private var orgWidth:Number = 0;
		private var orgHeight:Number = 0;
		private var main : Gallery;
		private var deactivating : Boolean = false;

		public function Img( load : String, m : Gallery ) : void
		{
			orgWidth = width;
			orgHeight = height;
			main = m;
			src = load;	
			alpha = 0;
		}
		
		public function loadImage() : void
		{
			if ( numChildren < 3 )
			{
				imageLoader.load( new URLRequest( "img/" + src ) ); 
				imageLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, displayImage );
			}
		}
		
		private function displayImage( _e : Event ) : void
		{
			if ( main.images[id + 1] != null && !main.images[id + 1].parent ) main.images[id + 1].loadImage();
			Bitmap( imageLoader.content ).smoothing = true;
			imageLoader.x = main.spaceBetween/2 - ( orgWidth /2 );
			imageLoader.y = main.spaceBetween/2 -( orgHeight /2 );
			addChild( imageLoader );

			var descr : TextField = new TextField();
			descr.text = src;
			descr.y = ( orgHeight /2 ) - 27;
			descr.x = 10 - ( orgWidth /2 );
			descr.autoSize = TextFieldAutoSize.LEFT;   
			descr.embedFonts = true;
			
			var format : TextFormat = new TextFormat("cFont", 15, 0);   
			format.color = 0x5B4846;    
			descr.setTextFormat( format );   
			
			addChild( descr );
		}
		
		public function makeActive( position : Number, direction : Number ) : void
		{
			deactivating = false;
			if ( parent == null ) 
			{
				x = ( direction == 1 ? main.stageWidth + main.defaultWidth * 2 : - main.defaultWidth * 2 );
				alpha = 0;
				main.imagesClip.addChild( this );
			}
			visible = true;
			if ( numChildren < 3 ) loadImage();
			parent.setChildIndex(this, ( parent.numChildren-1 ) - Math.abs( position ) );
			
			var extra : Number =  Math.round( position * ( main.defaultWidth + main.spaceBetween ) );
			var newX : Number = ( Math.round( ( main.stageWidth / 2 ) /* - ( main.defaultWidth / 2 )*/ ) + extra );
			flyTo( newX, false, (position == 0 ? 1.2 : 1 )  );
		}
		
		public function deActive( direction : Number ) : void
		{
			if ( ! deactivating )
			{
				active = false; 
				var moveTo : Number = ( direction != 1 ? main.stageWidth + main.defaultWidth * 2 : parent.x - main.defaultWidth * 2 );
				flyTo( moveTo, true );
				deactivating = true;
			}			
		}
		
		private function flyTo( newX : Number, removeAfter : Boolean, scale : Number = 1 ) : void
		{
			var tweeningOptions : Object = new Object;
			tweeningOptions.x = newX;
			
			if ( removeAfter )
			{
				tweeningOptions.ease = Linear.easeIn;
				tweeningOptions.alpha = 0;
				tweeningOptions.scaleX = tweeningOptions.scaleY = 0.3;
				tweeningOptions.visible = false;
			}
			else
			{
				tweeningOptions.scaleX = tweeningOptions.scaleY = scale;
				tweeningOptions.rotation = (Math.random() * 20) - 10;
				tweeningOptions.ease = Back.easeOut;
				tweeningOptions.alpha = 1;
			}
			TweenLite.to ( this, 0.4, tweeningOptions );
		}
		
		private function motionEnd () : void
		{ 
			visible = false;
		}
	}
}