// Download by http://www.jb51.net
YAO.adBox = function(){
	var Y = YAO, 
	D = window.document, 
	body = D.body, 
	head = D.getElementsByTagName('head')[0], 
	IE6 = Y.userAgent.ie === 6 ? true : false, 
	HOST = 'http://www.yaohaixiao.com/', 
	SWFJS_PATH = HOST + 'js/swfobject.js',
	LATER_TIME = 5000,
	FLASH_VER = '8',
	WIDTH = 326,
	HEIGHT = 276,
	CONTENT_WIDTH = 320, 
    CONTENT_HEIGHT = 240, 
	SCROLL_SPEED = 50,
	COMPONENTS = {
		WINDOW: 'y-adwindow',
		TITLEBAR: 'y-adtitlebar',
		TITLE: 'y-adtitle',
		CLOSEBTN: 'y-adclosebar',
		CLOSEBTN_TIP: '关闭窗口',
		CONTENT: 'y-adcontent',
		IMAGE: 'y-adimage',
		LINK: 'y-adlink',
		FLASH: 'adflash',
		VIDEO: 'advideo',
		MESSAGE: 'y-admessage',
		MSG_INFO: 'y-admsg-info',
		MSG_VIEW: 'y-admsg-view',
		MSG_VIEW_TIP: '查看详情',
		MSG_IMG: 'y-admsg-image'
	}, 
	
	position = 'RIGHT', 
    showTime = 10, 
    isDisplay = false, 
	isScroll = true,
    
	adWindow = null, 
    title = 'YAO Popup Advertisement Box', 
    closeBtn = null, 
	content = null, 
	imgAd = {
		link: null,
		img: null,
		href: '',
		src: ''
	}, 
	swfAd = {
		flash: null,
		src: ''
	}, 
	flvAd = {
		player: null,
		SRC: HOST + 'swf/flvplayer.swf',
		playlist: ''
	}, 
	msgAd = {
		message: null,
		title: '',
		href: '',
		text: '',
		img: null,
		src: ''
	},
	createAdBox = function(){
		// 创建关闭按钮
		closeBtn = Y.Builder.node('a', {
			id: COMPONENTS.CLOSEBTN,
			href: "#closeAd",
			tilte: COMPONENTS.CLOSEBTN_TIP
		}, COMPONENTS.CLOSEBTN_TIP);
		
		// 创建广告内容容器
		content = Y.Builder.node('div', {
			id: COMPONENTS.CONTENT
		});
		
		adWindow = Y.Builder.node('div', {
			id: COMPONENTS.WINDOW
		}, [Y.Builder.node('div', {
			id: COMPONENTS.TITLEBAR
		}, [Y.Builder.node('h2', {
			id: COMPONENTS.TITLE
		}, title), closeBtn]), content]);
		Y.setStyle(adWindow, 'display', 'none');
		body.appendChild(adWindow);
		
		// 判断将什么内容添加到内容容器中
		if (imgAd.img) {
			content.appendChild(imgAd.img);
		}
		else {
			if (msgAd.message) {
				content.appendChild(msgAd.message);
			}
		}
	};
	
	return {		
		img: function(config){
			if (!config.src || !config.href) {
				return false;
			}
			
			var that = this;
			
		    imgAd.src = config.src;
			imgAd.href = config.href;	
			if (config.position && Y.isString(config.position)) {
				position = config.position.toUpperCase();
			}
		    if (config.title) {
				title = config.title;
			}
			if(config.showtime && Y.isNumber(config.showtime) && config.showtime >= 1){
				showTime = config.showtime;
			}
			if(Y.isBoolean(config.scroll) && !config.scroll){
				isScroll = false;
			}
			
			imgAd.img = Y.Builder.node('img', {
				id: COMPONENTS.IMAGE,
				src: imgAd.src,
				alt: title
			});
			imgAd.link = Y.Builder.node('a', {
				id: COMPONENTS.LINK,
				title: title,
				href: imgAd.href
			}, imgAd.img);
			
			if (imgAd.img.complete) {
				this.show();
			}
			else {
				Y.on(imgAd.img, 'load', function(){
					that.show.call(that);
				});
			}
		},
		swf: function(config){
			if (!config.src) {
				return false;
			}
			
			var that = this, callback = function(){
				that.show();
				swfAd.flash = new SWFObject(swfAd.src, COMPONENTS.FLASH, CONTENT_WIDTH, CONTENT_HEIGHT, FLASH_VER);
				swfAd.flash.addParam('wmode', 'transparent');
				swfAd.flash.write(COMPONENTS.CONTENT);
			};
			
			swfAd.src = config.src;
			if (config.position && Y.isString(config.position)) {
				position = config.position.toUpperCase();
			}
		    if (config.title) {
				title = config.title;
			}
			if(config.showtime && Y.isNumber(config.showtime) && config.showtime >= 1){
				showTime = config.showtime;
			}
			if(Y.isBoolean(config.scroll) && !config.scroll){
				isScroll = false;
			}
			
			Y.loadScript(SWFJS_PATH, callback);
		},
		flv: function(config){
			if (!config.playlist) {
				return false;
			}
			
			var that = this, callback = function(){
				that.show();
				
				flvAd.flvPlayer = new SWFObject(flvAd.SRC, COMPONENTS.VIDEO, CONTENT_WIDTH, CONTENT_HEIGHT, FLASH_VER);
				flvAd.flvPlayer.addParam('wmode', 'transparent');
				flvAd.flvPlayer.addParam('allowfullscreen', 'true');
				flvAd.flvPlayer.addParam('allowscriptaccess', 'always');
				flvAd.flvPlayer.addVariable('width', CONTENT_WIDTH);
				flvAd.flvPlayer.addVariable('height', CONTENT_HEIGHT);
				flvAd.flvPlayer.addVariable('file', flvAd.playlist);
				flvAd.flvPlayer.addVariable('autostart', 'true');
				flvAd.flvPlayer.addVariable('overstretch', 'fit');
				flvAd.flvPlayer.addVariable("usefullscreen", "true");
				flvAd.flvPlayer.addVariable('showstop', 'true');
				flvAd.flvPlayer.addVariable('showdownload', 'true');
				flvAd.flvPlayer.addVariable('screencolor', '0x000000');
				flvAd.flvPlayer.addVariable('backcolor', '0xCCCC66');
				flvAd.flvPlayer.addVariable('frontcolor ', '0xFFFFFF');
				flvAd.flvPlayer.addVariable('lightcolor', '0x000000');
				flvAd.flvPlayer.addVariable('autoscroll', 'true');
				flvAd.flvPlayer.addVariable('shuffle', 'false');
				flvAd.flvPlayer.addVariable("enablejs", "true");
				flvAd.flvPlayer.addVariable("javascriptid", "jsflvplayer");
				flvAd.flvPlayer.write(COMPONENTS.CONTENT);
			};
			
			flvAd.playlist = config.playlist;
			if (config.position && Y.isString(config.position)) {
				position = config.position.toUpperCase();
			}
			if (config.title) {
				title = config.title;
			}
			showTime = config.showtime || 0;
			if(Y.isBoolean(config.scroll) && !config.scroll){
				isScroll = false;
			}
			
			Y.loadScript(SWFJS_PATH, callback);
		},
		msg: function(config){
			if (!config.href || !config.text) {
				return false;
			}
			
			var that = this, 
			msgInfo = Y.Builder.node('p', {
				id: COMPONENTS.MSG_INFO
			}), 
			msgContent = D.createDocumentFragment();
			
			msgAd.href = config.href;
			msgAd.text = config.text;
			if(config.src){
				msgAd.src = config.src;
			}
			if (config.position && Y.isString(config.position)) {
				position = config.position.toUpperCase();
			}
			if (config.title) {
				title = config.title;
			}
			showTime = config.showtime || 0;	
			if(Y.isBoolean(config.scroll) && !config.scroll){
				isScroll = false;
			}		
			
			if (msgAd.src) {
				msgAd.img = Y.Builder.node('a', {
					href: msgAd.href,
					title: title
				}, Y.Builder.node('img', {
					id: COMPONENTS.MSG_IMG,
					alt: title,
					src: msgAd.src
				}));
				msgContent.appendChild(msgAd.img);
			}
			msgContent.appendChild(Y.Builder.text(msgAd.text));
			msgInfo.appendChild(msgContent);
			
			msgAd.message = Y.Builder.node('div', {
				id: COMPONENTS.MESSAGE
			}, [msgInfo, Y.Builder.node('p', {
				id: COMPONENTS.MSG_VIEW
			}, Y.Builder.node('a', {
				href: msgAd.href
			}, COMPONENTS.MSG_VIEW_TIP))]);
			
			this.show();
		},	
		show: function(){
			if (!isDisplay) {
				var that = this;
				createAdBox();
				Y.fixPosition(adWindow, position, WIDTH, HEIGHT, isScroll);
				Y.on(closeBtn, 'click', function(event){
					var evt = event || window.event;
					that.close.call(that);
					Y.stopEvent(evt);
				});
				
				Y.on(window, 'resize', function(){
					Y.fixPosition(adWindow, position, WIDTH, HEIGHT, false);
				});
					
				if (IE6) {
					Y.on(window, 'scroll', function(){
						Y.fixPosition(adWindow, position, WIDTH, HEIGHT, false);
					});
				}
				
				setTimeout(function(){
					var left = 0, top = 0; 
					
					Y.setStyle(adWindow, 'display', 'block');
					isDisplay = true;			
					left = parseInt(Y.getStyle(adWindow, 'left'), 10);
					top = parseInt(Y.getStyle(adWindow, 'top'), 10) - HEIGHT;	
					if (isScroll && position !== 'CENTER') {
						Y.moveElement(adWindow, left, top, SCROLL_SPEED);
					}
					
					if (imgAd.img || swfAd.flash || (flvAd.player && showTime) || (msgAd.message && showTime)) {
						if (isScroll && position !== 'CENTER') {
							setTimeout(function(){
								Y.moveElement(adWindow, left, top + HEIGHT, SCROLL_SPEED, function(){
									that.close.call(that);
								});
							}, showTime * 1000);
						}
						else {
							setTimeout(function(){
								that.close.call(that);
							}, showTime * 1000);
						}
					}
					
				}, LATER_TIME);
			}
		},
		close: function(){
			if (isDisplay) {
				Y.purge(closeBtn);
				body.removeChild(adWindow);
				isDisplay = false;
			}
		}
	};
}();
