/**
 +-------------------------------------------------------------------
 * 360展示展品
 +-------------------------------------------------------------------
 * @version    1.0.0 beta
 * @since      2014.12.12
 * @author     lee
 * @site 	   www.sucaijiayuan.com
 +-------------------------------------------------------------------
 */
var helloBox = {
	data: {
		pathPattern: false,
		imgLoaded: 0,
		imgTotal: 64,
		imgArray: [],
		startPosition: 0,
		imgCurrent: 1
	},

    init: function() {
		helloBox.data.pathPattern = $('#box').attr('path_pattern');
        helloBox.loadingImg();
    },

	loadingImg: function() {
		var src = helloBox.data.pathPattern.replace('###', helloBox.data.imgLoaded + 1);
		var img = new Image();
		img.src = src;
        $(img).load(function() {
            helloBox.loadedImg(img);
        }).error(function() {
			$('#mask').find('em.loading p').text("加载失败");
        })
    },

    loadedImg: function(img) {
		var src = img.src;
        var img = $('<img>').attr('src', src);
        $('#imgbox').append(img);
		helloBox.data.imgArray[++helloBox.data.imgLoaded] = src;
        $('#mask').find('em.loading p').text("Loading" + Math.floor(helloBox.data.imgLoaded / helloBox.data.imgTotal * 100) + "%");

        if (helloBox.data.imgLoaded == helloBox.data.imgTotal) {
			$('#mask').animate({
				'filter' : 'alpha(Opacity=0)',
				'opacity' : 0
			}, 300);
			$('#box').html('<img src="' + helloBox.data.imgArray[1] + '" />');

			$('#prev').hover(function(){
				helloBox.timer1 = setInterval(helloBox.preving, 30);
			}, function(){
				helloBox.stoppreving();
			});

			$('#next').hover(function(){
				helloBox.timer2 = setInterval(helloBox.nexting, 30);
			}, function(){
				helloBox.stopnexting();
			});

			$('#mask').bind('mousedown touchstart', function(e) {
				if (e.type == "touchstart") {
					helloBox.data.startPosition = window.event.touches[0].pageX;
				} else {
					helloBox.data.startPosition = e.pageX;
				}
				helloBox.data.touched = true;
				return false;
			});

			$(document).bind('mouseup touchend', function() {
				helloBox.data.touched = false;
			});

			$(document).bind('mousemove touchmove', function(e) {
				if (helloBox.data.touched) {
					if (e.type == "touchmove") {
						var endPosition = window.event.targetTouches[0].pageX;
					} else {
						var endPosition = e.pageX;
					}

					if (Math.abs(helloBox.data.startPosition - endPosition) >= 4) {
						if (helloBox.data.startPosition - endPosition >= 4) {
							helloBox.data.imgCurrent++;
							if (helloBox.data.imgCurrent > helloBox.data.imgTotal) {
								helloBox.data.imgCurrent = 1;
							}
						} else {
							helloBox.data.imgCurrent--;
							if (helloBox.data.imgCurrent < 1) {
								helloBox.data.imgCurrent = helloBox.data.imgTotal;
							}
						}
						helloBox.data.startPosition = endPosition;
						$('#box').html('<img src="' + helloBox.data.imgArray[helloBox.data.imgCurrent] + '" />');
					}
				}
			});
        } else {
			$('#box').html('<img src="' + src + '" />');
            helloBox.loadingImg();
        }
    },

	preving: function() {
		helloBox.data.imgCurrent++;
		if (helloBox.data.imgCurrent > helloBox.data.imgTotal) {
			helloBox.data.imgCurrent = 1;
		}				
		$('#box').html('<img src="' + helloBox.data.imgArray[helloBox.data.imgCurrent] + '" />');
    },

	stoppreving: function() {
		clearInterval(helloBox.timer1);
    },

	timer1: function() {
    },

	nexting: function() {
		helloBox.data.imgCurrent--;
		if (helloBox.data.imgCurrent < 1) {
			helloBox.data.imgCurrent = helloBox.data.imgTotal;
		}
		$('#box').html('<img src="' + helloBox.data.imgArray[helloBox.data.imgCurrent] + '" />');
    },

	stopnexting: function() {
		clearInterval(helloBox.timer2);
    },

	timer2: function() {
    }
};
$(document).ready(helloBox.init);