import React = require('react');
import {render, cleanup, fireEvent} from 'react-testing-library';
import '../../../src/themes/default';
import {
    render as amisRender
} from '../../../src/index';
import {makeEnv, wait} from '../../helper';
import { clearStoresCache } from '../../../src/factory';

afterEach(() => {
    cleanup();
    clearStoresCache();
});

test('Renderer:checkboxes', async () => {
    const {
        getByText,
        container
    } = render(amisRender({
        type: 'form',
        title: 'The form',
        controls: [
            {
                name: 'checkboxes',
                type: 'checkboxes',
                label: 'Checkboxes',
                columnsCount: 1,
                options: [
                    {
                        label: 'Option A',
                        value: 'a'
                    },
                    {
                        label: 'Option B',
                        value: 'b'
                    },
                    {
                        label: 'Option C',
                        value: 'c'
                    },
                    {
                        label: 'Option D',
                        value: 'd'
                    }
                ]
            },
            {
                type: 'static',
                name: 'checkboxes',
                label: '当前值'
            }
        ],
        submitText: null,
        actions: []
    }, {}, makeEnv()));
    expect(container).toMatchSnapshot();
    await wait(100);
    fireEvent.click(getByText(/Option A/));
    await wait(100);
    fireEvent.click(getByText(/Option B/));
    await wait(100);
    expect(container).toMatchSnapshot();
});