import React = require('react');
import {render, cleanup, fireEvent} from 'react-testing-library';
import '../../../src/themes/default';
import {
    render as amisRender
} from '../../../src/index';
import {makeEnv, wait} from '../../helper';
import { clearStoresCache } from '../../../src/factory';

afterEach(() => {
    cleanup();
    clearStoresCache();
});

test('Renderer:radios', async () => {
    const {
        getByText,
        container
    } = render(amisRender({
        type: 'form',
        title: 'The form',
        controls: [
            {
                name: 'radios',
                type: 'radios',
                label: 'radios',
                columnsCount: 1,
                options: [
                    {
                        label: 'Option A',
                        value: 'a'
                    },
                    {
                        label: 'Option B',
                        value: 'b'
                    },
                    {
                        label: 'Option C',
                        value: 'c'
                    },
                    {
                        label: 'Option D',
                        value: 'd'
                    }
                ]
            },
            {
                type: 'static',
                name: 'radios',
                label: '当前值'
            }
        ],
        submitText: null,
        actions: []
    }, {}, makeEnv()));
    expect(container).toMatchSnapshot();
    fireEvent.click(getByText(/Option A/));
    expect(container).toMatchSnapshot();
});