import React = require('react');
import {render} from 'react-testing-library';
import '../../../src/themes/default';
import {
    render as amisRender
} from '../../../src/index';
import { makeEnv } from '../../helper';

test('Renderer:rating', async () => {
    const {
        container
    } = render(amisRender({
        type: 'form',
        api: '/api/xxx',
        controls: [
            {
                type: 'rating',
                name: 'a',
                label: 'rating',
                value: 3,
                count: 5,
                half: true,
                readOnly: false
            }
        ],
        title: 'The form',
        actions: []
    }, {}, makeEnv({
    })));

    expect(container).toMatchSnapshot();
});