---
title: 多语言
---

amis 中对多语言的支持有两方面：

1. amis 内部组件的多语言，比如日期组件中的日期
1. JSON 配置中的多语言，比如配置中的 label 值

## amis 内部组件多语言

分为 JS SDK 和 React 两种用法。

### JS SDK

从 1.1.0 版本开始已经自带英文翻译，所以只需要在 props 里设置 locale 即可。

```javascript
let amisScoped = amis.embed(
  '#root',
  {
    type: 'page',
    title: '表单页面',
    body: {
      type: 'form',
      mode: 'horizontal',
      api: '/saveForm',
      controls: [
        {
          label: 'Name',
          type: 'text',
          name: 'name'
        }
      ]
    }
  },
  {
    locale: 'en-US'
  }
);
```

### React

React 版本中没有内置英文翻译，需要自己 import，使用如下方法：

```javascript
import 'amis/lib/locale/en-US';
```

在渲染 amis 组件的时候设置 locale 为 en-US

```javascript
{
  renderAmis(
    {
      type: 'page',
      title: '简单页面',
      body: '内容'
    },
    {
      locale: 'en-US'
    }
  );
}
```

## JSON 配置中设置多语言

在 JSON 配置中，也可以设置不同语言下的不同展现，比如前面设置了 `locale` 为 `en-US`，这时在任意 JSON 配置中都能使用 `en-US` 对象来覆盖这个语言下的效果。

```schema: scope="body"
{
  "type": "form",
  "controls": [{
    "type": "text",
    "name": "name",
    "label": "姓名：",
    "en-US": {
      "label": "username: "
    }
  }]
}
```

请点击上方的切换语言下拉框切换到英文，就能看到 `label` 属性被替换了，除了 `label` 以外，还可以覆盖其他任意属性，比如将 type 换成其他。

## 扩展内置组件的语言

如果想扩展其他语言，首先参考 `https://github.com/baidu/amis/blob/master/src/locale/en-US.ts` 文件，然后参考后面的示例注册新语言，未翻译的文字都将使用中文。

> 目前这种方式将会在未来修改，为了支持更多语言而不再使用中文为 key

### JS SDK 扩展方法

```javascript
let amisLib = amisRequire('amis');
amisLib.registerLocale('jp', {
  'Form.submit': '送信'
});
```

### React 扩展方法

```javascript
import {registerLocale} from 'amis';
registerLocale('jp', {
  'Form.submit': '送信'
});
```
