-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.54-log
-- Host           : 127.0.0.1:3306
-- Database       : dd2
-- 
-- Part : #1
-- Version : #v1.2.6
-- Date : 2019-01-17 10:07:14
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', 'pc首页幻灯1', '', '/public/upload/other/2018/10/08/2c9d5f1d9d1a650ffe510d9b9096cc12.png', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1538986658', '1538986658');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', 'pc首页幻灯2', '', '/public/upload/other/2018/10/08/b2fd559c59c554b2fa9211d0e1017f28.png', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1538986667', '1538986667');
INSERT INTO `ey_ad` VALUES ('3', '2', '1', '栏目banner图', '', '/public/upload/other/2018/10/09/7383a49543688bf086c5e862c8e4e12f.png', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1539049572', '1539049572');
INSERT INTO `ey_ad` VALUES ('4', '3', '1', '手机幻灯1', '', '/public/upload/other/2018/10/10/61a040dbf5b12c60dc20a72222ca1eb8.png', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1539140601', '1539140601');
INSERT INTO `ey_ad` VALUES ('5', '3', '1', '手机幻灯2', '', '/public/upload/other/2018/10/10/27a8b76589cb84cb658fd550336ac97e.png', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1539140611', '1539140611');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) DEFAULT '' COMMENT '广告位置名称',
  `width` smallint(5) unsigned DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned DEFAULT '0' COMMENT '广告位高度',
  `intro` text COMMENT '广告描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', 'pc端首页幻灯片', '1440', '432', '', '1', 'cn', '0', '1538986641', '1538986641');
INSERT INTO `ey_ad_position` VALUES ('2', '栏目banner图', '1440', '252', '', '1', 'cn', '0', '1539049545', '1539049545');
INSERT INTO `ey_ad_position` VALUES ('3', '手机端首页幻灯', '455', '163', '', '1', 'cn', '0', '1539140545', '1539140545');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '7959ec68e999edd0380ff0809f76fa42', '1547690665', '127.0.0.1', '2', 'u12tieui1mdlmp12645hfob7fn', '0', '-1', 'cn', '1', '1547690658', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) DEFAULT NULL COMMENT '管理员id',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT NULL COMMENT 'url',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('107', '1', '后台登录', '127.0.0.1', '/login.php/Admin/login.html', '1540347868');
INSERT INTO `ey_admin_log` VALUES ('108', '1', '后台登录', '127.0.0.1', '/login.php', '1540450658');
INSERT INTO `ey_admin_log` VALUES ('109', '1', '后台登录', '127.0.0.1', '/login.php', '1545961038');
INSERT INTO `ey_admin_log` VALUES ('110', '1', '后台登录', '127.0.0.1', '/login.php', '1547690665');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `author` varchar(200) DEFAULT '' COMMENT '编辑者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(200) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='资讯表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '6', '0', '关于我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1538984362', '0');
INSERT INTO `ey_archives` VALUES ('2', '10', '6', '0', '加盟优势', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1538984564', '1538991741');
INSERT INTO `ey_archives` VALUES ('3', '14', '6', '0', '联系我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1538984617', '1538994065');
INSERT INTO `ey_archives` VALUES ('4', '3', '1', '0', '产品名称六', '/public/upload/article/2018/10/08/e0d63858ad1b2886d79a6cc9b288d806.png', '0', '0', '0', '0', '0', '', '288', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987562', '1539589011');
INSERT INTO `ey_archives` VALUES ('5', '3', '1', '0', '产品名称五', '/public/upload/article/2018/10/08/7038842422df7bf9dda5d33707441200.png', '0', '0', '0', '0', '0', '', '199', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987579', '1539589017');
INSERT INTO `ey_archives` VALUES ('6', '3', '1', '0', '产品名称四', '/public/upload/article/2018/10/08/cd9eebf7c90d4a9379b1ba9aa512bf93.png', '0', '0', '0', '0', '0', '', '150', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987599', '1539589027');
INSERT INTO `ey_archives` VALUES ('7', '3', '1', '0', '产品名称三', '/public/upload/article/2018/10/08/b50d539e4704c386746249a4d44538bd.png', '0', '0', '0', '0', '0', '', '152', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987622', '1539589032');
INSERT INTO `ey_archives` VALUES ('8', '3', '1', '0', '产品名称二', '/public/upload/article/2018/10/08/603097f850712c9ad21266131d05143f.png', '0', '0', '0', '0', '0', '', '127', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987644', '1539589038');
INSERT INTO `ey_archives` VALUES ('9', '3', '1', '0', '产品名称一', '/public/upload/article/2018/10/08/e8668322be456577adc0167f400c5163.png', '0', '0', '0', '0', '0', '', '203', '0', '', '0', '', '', '传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。', '1', '100', 'cn', '0', '1538987664', '1539589051');
INSERT INTO `ey_archives` VALUES ('10', '11', '1', '0', '拜访拥有5亿粉丝的21位自媒体大佬后，我得出22条结论', '/public/upload/remote/2018/10/08/5bbb1a3fcdd47.png', '0', '0', '0', '0', '0', '', '139', '0', '', '0', '', '', '2017年，头部自媒体大号的大佬在焦虑哪些问题？做哪些尝试和创新？本文作者花了5天时间跑了北上广等6个城市，拜访调研了21位头部自媒体人，并写下了这份关于城市自媒体账号、营销号和原创号的总结和结论。其中一些思考，对正在进行内容创业的人来说，可能颇具启发意义。一我在微信领域里创业3年多，见证了移动互联网、微信、微信公众平台的飞速发展，也看到很多才华横溢的年轻人凭借良好商业嗅觉，把握住了微信粉丝红利和内容红利，实现了自身财富的飞跃式增长。这个行业飞速发展，每天都在变化中，很多自媒体人都有危机意识，在焦虑和不安中度过，主要原因表现在：1.微信阅读打开率持续下滑。微信到底还能火多久？2.粉丝对内容越来越挑剔，对内容的要求越来越高。如何制造优质内容？3.涨粉越来越困难。出路在哪里？4.很多头部账号是草根创业，后来已实现公司化运营，这在公司管理、财务管理等方面对创始人提出越来越大的挑战。', '1', '100', 'cn', '0', '1538988586', '1538988586');
INSERT INTO `ey_archives` VALUES ('11', '11', '1', '0', '微信运营日志这么做！早日升职加薪', '/public/upload/remote/2018/10/08/5bbb1ac787b41.png', '0', '0', '0', '0', '0', '', '295', '0', '', '0', '', '', '我捉摸着，很多做微信运营的，90%的人不会做运营日志，这也是很多新人没有计划也没有成长的一个原因。微信不是简单的每天发发文章，这只能叫微信编辑，在运营的层次上并不能给你带来多少收货。很多人的困境在于，大多数公众号的都处在基础阶段，要粉丝没粉丝，公司的成长又受限，作为一个普通的人，我们真的很难做出多大的丰功伟绩。所以，我们大多数人都在不断的跳槽，希望能遇到一个好的平台一个好老板。当然，不是每个人运气都那么好，我们90%的人都肩负着通过微信运营，改变着公司的发展，老板的期望，以及自己的无奈。还是那句话，既然选择了，就跪着走下去。即时没有丰功伟绩，至少也学到了一定的套路。所以，运营日志就很重要。我的建议是，在你开始运营公众号的时候，在你每发一篇文章的时候，你都通过表格做下记录。由于长度问题，我把表格的设置内容分成了两行，看得懂就好...作为一个运营日志，我为何要做这些统计？1、特殊节日：这个不用说了，特殊节日的特殊话题，是不是更能获得阅读量？2、日期/推送时间/周几，为什么把时间记录的这么详细呢？在通过的一些测试中发现，推送时间似乎变的不重要，也就是说你认为的早上9点钟比下午4点钟效果好，但', '1', '100', 'cn', '0', '1538988725', '1538988725');
INSERT INTO `ey_archives` VALUES ('12', '11', '1', '0', '论手机网站建设的重要性！', '/public/upload/remote/2018/10/08/5bbb1cbe2d8de.png', '0', '0', '0', '0', '0', '', '277', '0', '', '0', '', '', '伴随着科技信息的的发展，个人智能手机越来越普及，已经成为人们生活必备的物品之一，手机遍布了各个阶层、各个年龄段，甚至世界的各个角落。传统网站不能通过手机访问，或者访问的效果体验度差，将损失企业的潜在客户和降低公司的形象，，如今手机上网已是一种时尚趋势，现在流行通过手机和电脑都能访问的手机网站，实现随时、随地、随身访问，让您的客户真正实现随时随地找到您。手机网站被称为互联网的第二个机会，手机网站则被誉为企业的第二生命，所以，手指网站建设已经是企业发展不可缺少的一部分了。企业在手机上建设自己的手机网站，可以多渠道展示企业风采、传播企业文化、树立企业形象、提高企业知名度。企业通过手机网站可介绍企业的基本情况，使经销商和用户更多的知道您的存在；可以宣传您的产品和服务的优势，让经销商和用户在比较中了解您、走近您、直到选择您；企业员工可以利用手机快捷地了解公司动态，方便外界进行各种信息沟通，增多寻求合资与合作的机会。', '1', '100', 'cn', '0', '1538989233', '1538989233');
INSERT INTO `ey_archives` VALUES ('13', '11', '1', '0', '如何选择网站关键词?', '', '0', '0', '0', '0', '0', '', '188', '0', '', '0', '', '', '网站关键词是SEO优化的核心，关键词的选择将直接影响网站优化推广效果及网站的价值，选择关键词应该注意一下几点：&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;考虑用户搜索习惯，而并非企业名称或产品名称，尤其是对于一种新的产品，当市场还没有人知道的时候，自然不会有人去搜索这个关键词，因此选择关键词首先就应该去分析你的目标群体会在搜索引擎中搜索哪些关键词，而你应该选择那些与你的产品相关并能为你的销售带来帮助的关键词。&nbsp;&nbsp;中小企业切忌不要将自己的公司名称或品牌作为主要关键词，因为在你的目标群体中，很多人是没有听说过你的公司和品牌的，小企业做产品，对于中小企业来说，客户一般都是通过产品和服务来了解你的公司和品牌的，因此，网站关键词如果设置为公司名称，则不能达到良好的营销效果。&nbsp;&nbsp;关键词不宜过长，太长的关键词很少会有人搜索；点击量不宜太热，点击量太大搜索的人越多那么竞争也就会越激烈；同时关键词也不能太冷门，冷门关键词排到第一位也不会有多少人搜索访问，具体可以参考“百度指数”中的关键词访问量。&nbsp;&nbsp;碰到热门关键词时，最好在关键词', '1', '100', 'cn', '0', '1538989268', '1538989268');
INSERT INTO `ey_archives` VALUES ('14', '11', '1', '0', '建站随谈如何建一个大气的企业网站', '', '0', '0', '0', '0', '0', '', '249', '0', '', '0', '', '', '绝大多数的网站项目需求设计方案都有一个共通点：设计要求一定要“大气”。“大气”这个原本陌生的词汇渐渐占领了我的设计思路，有种盲从地被强奸的感觉。其实，说实话，如果你让现今的小企业来对你的设计做些要求的话，从专业角度出发，他们可能连一个起码的要求都提不出来。我也曾经试探性地问过一些客户最基本的设计上的需求。比如网站的基本色调之类的，往往得到的答复就是：你们看着办吧，什么颜色好看用什么颜色。这种对自身企业不负责任的回答，难免会在一定程度上影响到设计人员的设计方向。回到文章标题提到的“大气”上来。这个词汇在字典里的具体含义我不清楚，但大多数的企业客户都是义正严词地白纸黑字写在了需求说明里。可能这就是他们在对你的设计效果没有丝毫建设性要求之后，不经大脑思索就硬生生地强加给设计人员的最无理的要求了。但，如何做的大气，他们也拿不定注意的，某些客户可能只是为了掩饰自己的轻浮，而不得不做出的一个颇具风范的补充罢了。对于设计人员来说，“大气”真的是非常头痛的问题。因为“大气”这东西不是说做就能做出来的，这不是一个实际存在的物体，只可意会不可言传。飘朵白云，放个飞机等等只能说明自己的庸俗，更有甚者，万般强', '1', '100', 'cn', '0', '1538989399', '1538989399');
INSERT INTO `ey_archives` VALUES ('15', '11', '1', '0', '电子商务网站建设技术：怎样修改网站标题', '', '0', '0', '0', '0', '0', '', '283', '0', '', '0', '', '', '作为一个优化人员，在接到优化的单子时候，第一件要做的是什么?观察网站结构，做出具体的优化步骤方案。一般来说，网站的标题是非常重要的事情，对于搜索引擎来说，网站的标题是一个网站的门户与窗口，要想达到好的排名效果，恰当的标题与描述是必须修改的。　　根据自己的经验给大家一些小的提示：　　1、网站的标题要分批次更改　　2、更改顺序-由后向前批次更改，也就是先改分页的，然后慢慢到首页。　　3、在搜索引擎中网站排名好的主要关键词最后更改　　例如我的一个网站，现有的标题为：“味多美网址导航、免费收录网站，按来路自动排行，自动收录”，要改为：以免费收录为主的关键词，并且主做“收录”这个词　　步骤：　　1)方法：把“味多美网址导航、免费收录网站，按来路自动排行，自动收录”改成：“味多美网址导航，收录，免费收录网站，按来路自动排行，自动收录”　　2)等收录后再加第二个词　　改：味多美网址导航，收录，收录网址，免费收录网站，按来路自动排行，自动收录　　3)再收录后　　因为要主做收录　　改：“味多美网址导航，收录，收录网址，免费收录网站，网址收录，自动收录”　　以上都是经验之谈，望希望能够对大家有所帮助!　　', '1', '100', 'cn', '0', '1538989432', '1538989432');
INSERT INTO `ey_archives` VALUES ('16', '11', '1', '0', '网站建设新标准——建站与优化结合', '', '0', '0', '0', '0', '0', '', '193', '0', '', '0', '', '', '电商时代已经势不可挡。而随着电商时代的来临。越来越多的人所关注的不是那种如淘宝、京东之类电子商城，而是自己企业的网站，因为那块蛋糕已经被分完了。传统的网站建设已经不能满足现在企业的需要了。他们需要的不仅仅是一个展示企业的一个网站，而是需要一个能帮助企业获得订单或者创造价值的网站。于是，众多的目光纷纷投向了搜索引擎。当然百度竞价是一个烧钱的无底洞，不是所有的企业都能承受得起的，所以越来越多的目光都被集中在搜索引擎优化中，而如何将网站建设与网站优化相结合，则是目前网络公司急需解决的一个大问题。在这里笔者提几点关于网站建设程序开发中所需要注意的SEO细节。　　第一，网站的树形结构。这是一个大的方向。网站建设人员在建站的时候往往很容易忽视这个问题。首先要知道一点，一个页面处于根目录下的第几级页面将直接决定了spider对其权重的判断，这也是树形结构为什么如此重要的原因。而spider的爬行顺序一般都是由主页，到二级目录，然后是三级目录，当你把所有的页面放在一起的时候，很明显，这是不利于爬行的。这对于网站SEO来说是一个非常头疼的问题，因为一旦做好了，如果要修改这些路径，是非常麻烦的。　　第二，', '1', '100', 'cn', '0', '1538989481', '1538989481');
INSERT INTO `ey_archives` VALUES ('17', '11', '1', '0', '奇迹由你创造 网站建设成功经验谈', '', '0', '0', '0', '0', '0', '', '230', '0', '', '0', '', '', '互联网行业应该算国内开放度、自由度最高的行业之一。进入这个行业几乎没有门槛。这里不会嫌贫爱富，这里没有所谓的潜规则，这里不用请客吃饭，只要你拥有创业的梦想、有一个好点子，互联网就可能为你开启财富之门。这个神奇的新兴行业不知道制造了多少财富的神话与奇迹。笔者做网站建设已经有五年的经历了，希望能把一些做网站的经验与教训同大家一起分享。一、你做好艰苦创业的准备了么？很多菜鸟可能是怀着这种心理开始做网站的，即：坐在电脑旁打打字就能赚钱，只要网站做好了，它时时刻刻都可以为我赚钱，甚至在我睡觉的时候。这种想法的潜台词是，很多新手认为做网站是很轻松的事情。殊不知，天下没有免费的午餐，人们的收获通常是同付出成正比的。所以，要做一个成功的网站，辛苦的劳动是必须的。我经常告诫一些刚入行的朋友：“做网站，首先要做好吃苦的准备，否则你将一事无成。”找笔者做网站的朋友可以说是成百上千了。可是，真正能够坚持下来的朋友凤毛麟角。这里的原因非常多，我想非常重要的原因可能是：你从一开始就没有做好艰苦创业的心理准备。二、万事开头难。辛辛苦苦做好了一个网站，网站却没有流量，这是很多新手站长面临的问题。很多人因此退却了，败下', '1', '100', 'cn', '0', '1538989500', '1538989500');
INSERT INTO `ey_archives` VALUES ('18', '11', '1', '0', '分享新手网站建设到优化推广7部曲', '', '0', '0', '0', '0', '0', '', '267', '0', '', '0', '', '', '我们每天都会看到无数个新网站出现，也会看到无数个旧网站关闭；我们每天都会看到很多站长欢呼雀跃自己的网站收录提高，排名提升，也会看到很多站长痛哭流涕说网站降权，排名下降，收录大跌。种种的网络喜怒哀乐每天都这么上演。包括我在内也同样的经受一轮又一轮的折磨。我们没有选择，只能继续学习、交流、再学习，提升自己的技术和技能，尤其是我们这种做网站推广的站长，需要的是承受力还有更好的心脏抗压能力。关于新网站的建设，每个人都有每个人的经验，理论几天几夜都说不完，今天是我第一次发表投稿文章，希望与大家分享我对新网站建设的点点看法。希望能和网络上的朋友们交流。让我们一起见证新网站的从无到有。第一点，新网站域名的选择。域名是网站、公司、产品的品牌形象，就好像我们人名一样，需要天天使用、传播，告诉别人。如果选择的不好，太长或者难以记忆，那自己也看着别扭，也会影响我们的转化率。如果我来选择网站的域名，我考虑在6个字符之内，与公司的们名字，产品以及网站主题相关即可。简单好记的域名最为重要。关于后缀的选择，如果很注重品牌形象，我认为必须选择COM，如果就简单的主题推广，后缀无所谓，好记就可以。对于其他后缀是不是需要', '1', '100', 'cn', '0', '1538989608', '1538989608');
INSERT INTO `ey_archives` VALUES ('19', '11', '1', '0', '浅谈如何做好网站的目录规划', '', '0', '0', '0', '0', '0', '', '173', '0', '', '0', '', '', '一个网站的组成无非就是内容和框架，如果要做SEO当然还有外链，今天这里主要讲框架里面的一个细节，就是如何布置网站的目录。一、目录是什么。目录是什么，一般目录就是分页信息的首页，也就是内页的分类列表的第一个页面，这个页面可以是一个以/结尾的文件夹，也可以是一个文件，看个人喜好了。二、目录的作用。网站里面都会用到新闻中心此类的页面，其实这个里面还是有大学问的，大家都知道假如网站权重一样的话，一级目录比一级页面在搜索引擎中的排名要好，换句话讲，就是一些长尾关键词可以用一级目录来规划，比如那些无搜索量有下拉框或者相关搜索里面有的那些词（百度指数少于50），我们可以把他整到目录的首页，作为目录关键词。三、目录的优缺点。优点：目录的可以继承主站的权重，如果网站权重不错，一旦收录排名就会很不错，而且具有收录快，稳定（只要主站权重还在），外链需求量较少等。缺点：不利于长期发展，在一些比较热门的关键词面前，很多人都用顶级域名来作站，这时候你和他们竞争起来就相对疲软。一般比较适合一些短暂的关键词，比如某某节日，某某事件等等，我们可以给他开发一个专题目录，像这种来得快去得快的东西最适合目录做。四、如何规划。', '1', '100', 'cn', '0', '1538989630', '1538989630');
INSERT INTO `ey_archives` VALUES ('20', '9', '1', '0', '荣誉证书四', '/public/upload/article/2018/10/08/4c704641dfa014628ebb75ae570dbd45.png', '0', '0', '0', '0', '0', '', '234', '0', '', '0', '', '', '公司于2015年获得某某荣誉......', '1', '100', 'cn', '0', '1538991097', '1539597644');
INSERT INTO `ey_archives` VALUES ('21', '9', '1', '0', '荣誉证书三', '/public/upload/article/2018/10/08/17e628c44f16153e2b891aa17eb41350.png', '0', '0', '0', '0', '0', '', '174', '0', '', '0', '', '', '公司于2015年获得某某荣誉......', '1', '100', 'cn', '0', '1538991190', '1539597656');
INSERT INTO `ey_archives` VALUES ('22', '9', '1', '0', '荣誉证书二', '/public/upload/article/2018/10/08/ecd468e30a9d37d31891e74891de182e.png', '0', '0', '0', '0', '0', '', '106', '0', '', '0', '', '', '公司于2015年获得某某荣誉......', '1', '100', 'cn', '0', '1538991233', '1539597665');
INSERT INTO `ey_archives` VALUES ('23', '9', '1', '0', '荣誉证书一', '/public/upload/article/2018/10/08/bd4a9d6eb954a0836453961f64d0d3ef.png', '0', '0', '0', '0', '0', '', '153', '0', '', '0', '', '', '公司于2015年获得某某荣誉......', '1', '100', 'cn', '0', '1538991255', '1539597676');
INSERT INTO `ey_archives` VALUES ('24', '12', '1', '0', '店面展示四', '/public/upload/article/2018/10/08/c4b859420bbefa69306871775cb87a05.png', '0', '0', '0', '0', '0', '', '281', '0', '', '0', '', '', '广州某某门店，价位低，服务好。', '1', '100', 'cn', '0', '1538993600', '1539588783');
INSERT INTO `ey_archives` VALUES ('25', '12', '1', '0', '店面展示三', '/public/upload/article/2018/10/08/65c426c96de2a1843cd1d7265d3bebee.png', '0', '0', '0', '0', '0', '', '159', '0', '', '0', '', '', '深圳广州某某门店，价位低，服务好。', '1', '100', 'cn', '0', '1538993631', '1539588795');
INSERT INTO `ey_archives` VALUES ('26', '12', '1', '0', '店面展示二', '/public/upload/article/2018/10/08/20c92a50fca659a538185b1ea81d3ea4.png', '0', '0', '0', '0', '0', '', '122', '0', '', '0', '', '', '上海某某门店，价位低，服务好。', '1', '100', 'cn', '0', '1538993654', '1539588807');
INSERT INTO `ey_archives` VALUES ('27', '12', '1', '0', '店面展示一', '/public/upload/article/2018/10/08/da9dd2b521f2ad722aa831227e17a2f6.png', '0', '0', '0', '0', '0', '', '236', '0', '', '0', '', '', '武汉某某门店，价位低，服务好。', '1', '100', 'cn', '0', '1538993689', '1539588817');

-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '0');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '0');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '6', '6', '0', '关于我们', 'guanyuwomen', '/html/guanyuwomen', '', '0', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984362', '1538984362');
INSERT INTO `ey_arctype` VALUES ('2', '1', '1', '0', '产品展示', 'chanpinzhanshi', '/html/chanpinzhanshi', 'PRODUCTS', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984395', '1538986861');
INSERT INTO `ey_arctype` VALUES ('3', '1', '1', '2', '香辣虾', 'xianglaxia', '/html/chanpinzhanshi/xianglaxia', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984417', '1538986861');
INSERT INTO `ey_arctype` VALUES ('4', '1', '1', '2', '麻辣蟹', 'malaxie', '/html/chanpinzhanshi/malaxie', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984431', '1538986861');
INSERT INTO `ey_arctype` VALUES ('5', '1', '1', '2', '麻辣鸭脖', 'malayabo', '/html/chanpinzhanshi/malayabo', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984447', '1538986861');
INSERT INTO `ey_arctype` VALUES ('6', '1', '1', '2', '麻辣毛肚', 'malamaodu', '/html/chanpinzhanshi/malamaodu', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984466', '1538986861');
INSERT INTO `ey_arctype` VALUES ('7', '1', '1', '2', '赠送饮品', 'zengsongyinpin', '/html/chanpinzhanshi/zengsongyinpin', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984483', '1538986861');
INSERT INTO `ey_arctype` VALUES ('8', '1', '1', '2', '特热底料', 'terediliao', '/html/chanpinzhanshi/terediliao', '', '1', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984501', '1538986861');
INSERT INTO `ey_arctype` VALUES ('9', '1', '1', '0', '资质荣誉', 'zizhirongyu', '/html/zizhirongyu', '', '0', '', '/public/upload/arctype/2018/10/10/1e11daa4dc39efe229d94d5b70cc8230.png', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984545', '1539143042');
INSERT INTO `ey_arctype` VALUES ('10', '6', '6', '0', '加盟优势', 'jiamengyoushi', '/html/jiamengyoushi', '', '0', '', '/public/upload/arctype/2018/10/08/6a49ada98af83219146db2ccd6b4da76.png', 'lists_single.htm', '', '', '', '核心价值观：诚信、创新、服务 企业核心： 诚信  企业精神： 团结拼搏、开拓求实、满足用户、科技进步。   客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢得客户的理解、尊重和支持。 市场：为客户降低采购成本和风险，为客户投资提供切实保障。  发展：追求永续发展的目标，并把它建立在客户满意的基础上。   关于“为合作伙伴创造价值” 公司认为客户、供应商、公司股东、公司员工 ...', '100', '0', '0', '0', '0', '1', 'cn', '1538984564', '1538991741');
INSERT INTO `ey_arctype` VALUES ('11', '1', '1', '0', '新闻资讯', 'xinwenzixun', '/html/xinwenzixun', '', '0', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984582', '1538984582');
INSERT INTO `ey_arctype` VALUES ('12', '1', '1', '0', '店面展示', 'dianmianzhanshi', '/html/dianmianzhanshi', '', '0', '', '', 'lists_article_product.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984597', '1538984597');
INSERT INTO `ey_arctype` VALUES ('13', '8', '8', '0', '客户留言', 'kehuliuyan', '/html/kehuliuyan', '', '0', '', '/public/upload/arctype/2018/10/10/f57e3ef4fcf95fca40e697fe461db7fe.png', 'lists_guestbook.htm', '', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984608', '1539144216');
INSERT INTO `ey_arctype` VALUES ('14', '6', '6', '0', '联系我们', 'lianxiwomen', '/html/lianxiwomen', '', '0', '', '/public/upload/arctype/2018/10/08/f863027e37355867b9b84d39318d97ce.png', 'lists_single.htm', '', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1538984617', '1538994065');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('1', '4', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb162f3ea31.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589011', '1539589011');
INSERT INTO `ey_article_content` VALUES ('2', '5', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb164a9c867.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589017', '1539589017');
INSERT INTO `ey_article_content` VALUES ('3', '6', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb165f33d50.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589027', '1539589027');
INSERT INTO `ey_article_content` VALUES ('4', '7', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb1676cb48f.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589032', '1539589032');
INSERT INTO `ey_article_content` VALUES ('5', '8', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb168b7db16.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589038', '1539589038');
INSERT INTO `ey_article_content` VALUES ('6', '9', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb16a33c983.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;传统的麻辣烫口味比较单一，要么辣要么麻，如今麻辣烫口味繁多，有麻辣味的、有鸡汤味的、有酸辣味的，满足多元舌尖需要。我们的麻辣烫店，没有豪华的装修，却能让你饱尝美味，让挑战你的舌尖。红汤麻辣烫，口味不凡，食客喜爱。&lt;/p&gt;', '1539589051', '1539589051');
INSERT INTO `ey_article_content` VALUES ('7', '10', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;a href=&quot;http://upload.chinaz.com/2017/0223/17022314280097108.jpg&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb1a3fcdd47.png&quot; style=&quot;border: 0px;&quot;/&gt;&lt;/a&gt;&lt;/p&gt;&lt;p&gt;2017年，头部自媒体大号的大佬在焦虑哪些问题？做哪些尝试和创新？本文作者花了5天时间跑了北上广等6个城市，拜访调研了21位头部自媒体人，并写下了这份关于城市自媒体账号、营销号和原创号的总结和结论。其中一些思考，对正在进行内容创业的人来说，可能颇具启发意义。&lt;/p&gt;&lt;p&gt;一&lt;/p&gt;&lt;p&gt;我在微信领域里创业3年多，见证了移动互联网、微信、微信公众平台的飞速发展，也看到很多才华横溢的年轻人凭借良好商业嗅觉，把握住了微信粉丝红利和内容红利，实现了自身财富的飞跃式增长。&lt;/p&gt;&lt;p&gt;这个行业飞速发展，每天都在变化中，很多自媒体人都有危机意识，在焦虑和不安中度过，主要原因表现在：&lt;/p&gt;&lt;p&gt;1. 微信阅读打开率持续下滑。微信到底还能火多久？&lt;/p&gt;&lt;p&gt;2. 粉丝对内容越来越挑剔，对内容的要求越来越高。如何制造优质内容？&lt;/p&gt;&lt;p&gt;3. 涨粉越来越困难。出路在哪里？&lt;/p&gt;&lt;p&gt;4. 很多头部账号是草根创业，后来已实现公司化运营，这在公司管理、财务管理等方面对创始人提出越来越大的挑战。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538988616', '1538988616');
INSERT INTO `ey_article_content` VALUES ('8', '11', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb1ac787b41.png&quot; style=&quot;border: 0px;&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;我捉摸着，很多做微信运营的，90%的人不会做运营日志，这也是很多新人没有计划也没有成长的一个原因。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;微信不是简单的每天发发文章，这只能叫微信编辑，在运营的层次上并不能给你带来多少收货。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;很多人的困境在于，大多数公众号的都处在基础阶段，要粉丝没粉丝，公司的成长又受限，作为一个普通的人，我们真的很难做出多大的丰功伟绩。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;所以， 我们大多数人都在不断的跳槽，希望能遇到一个好的平台一个好老板。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;当然，不是每个人运气都那么好，我们90%的人都肩负着通过微信运营，改变着公司的发展，老板的期望，以及自己的无奈。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;还是那句话，既然选择了，就跪着走下去。即时没有丰功伟绩，至少也学到了一定的套路。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;所以，运营日志就很重要。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;我的建议是，在你开始运营公众号的时候，在你每发一篇文章的时候，你都通过表格做下记录。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb1ac805954.png&quot; style=&quot;border: 0px;&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;由于长度问题，我把表格的设置内容分成了两行，看得懂就好...&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;作为一个运营日志，我为何要做这些统计？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;1、特殊节日：这个不用说了，特殊节日的特殊话题，是不是更能获得阅读量？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;2、日期/推送时间/周几，为什么把时间记录的这么详细呢？在通过的一些测试中发现，推送时间似乎变的不重要，也就是说你认为的早上9点钟比下午4点钟效果好，但是你发现如果你的选题做的好，任何时间的推送似乎都能获得比较多的阅读。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;举个例子：我在新榜中关注了几个汽车排名靠前的公众号，推送时间都是下班时间，也有晚上21点的，按人之情理，下班时间都在开车哪有时间看公众号，但是他们阅读依然很高。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;就是通过这种长期的关注和总结，你会慢慢发现，你可能纠结的推送时间不是那么重要。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;周五以及周末是个非常特殊的时段，你可能会发现一些公众号到了周五以及周末，推送时间会有所不同。周末，你就可以选择换个时间推送。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;记录好时间，你可以进行一段时间的测试，然后发现自己公众号的规律。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;3、标题：关于标题，说法就比较多了，很多人都觉得标题就是一张效果图，取得好的，能获得更多的关注，至于读者阅读的程度，那就要看内容质量了。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这部分的锻炼是长期的，需要自己不断的去思考尝试，同时可以记录竞品每天的标题（关于竞品的分析，可以查看前期文章）&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;4、阅读量/转发量/粉丝增长，这些一方面是领导的KPI要求，一方面也是你观察数据不断自我提升的参考。为什么这篇内容阅读这么高，转发这么高，粉丝增长这么多。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;一般来说都是成正比的关系，但是大多数你会发现，他们有时候成反比关系。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;譬如借助热点，你的阅读量很高，但是转发和粉丝增长很少。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;譬如你的一篇很实用的文章，阅读量不是特别高，但是增长与阅读的比值很高。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这些数据的长期统计，将会对你的内容方向有比较好的指导意义。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;5、心得体会，相当于你每天的总结。譬如今天你发现了一个好的想法，情人节我搞个特殊的关注语。情人节结束，你发现你忘记更改了，当你每天看一遍运营日志，你就会知道，还有什么东西没做。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538988759', '1538988759');
INSERT INTO `ey_article_content` VALUES ('9', '12', '&lt;p style=&quot;text-align: center;&quot;&gt;伴随着科技信息的的发展，个人智能手机越来越普及，已经成为人们生活必备的物品之一，手机遍布了各个阶层、各个年龄段，甚至世界的各个角落。传统网站不能通过手机访问，或者访问的效果体验度差，将损失企业的潜在客户和降低公司的形象，，如今手机上网已是一种时尚趋势，现在流行通过手机和电脑都能访问的手机网站，实现随时、随地、随身访问，让您的客户真正实现随时随地找到您。手机网站被称为互联网的第二个机会，手机网站则被誉为企业的第二生命，所以，手指网站建设已经是企业发展不可缺少的一部分了。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;企业在手机上建设自己的手机网站，可以多渠道展示企业风采、传播企业文化、树立企业形象、提高企业知名度。企业通过手机网站可介绍企业的基本情况，使经销商和用户更多的知道您的存在；可以宣传您的产品和服务的优势，让经销商和用户在比较中了解您、走近您、直到选择您；企业员工可以利用手机快捷地了解公司动态，方便外界进行各种信息沟通，增多寻求合资与合作的机会。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/remote/2018/10/08/5bbb1cbe2d8de.png&quot; alt=&quot;1484299046503816.jpg&quot; style=&quot;border: 0px;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989255', '1538989255');
INSERT INTO `ey_article_content` VALUES ('10', '13', '&lt;p&gt;网站关键词是SEO优化的核心，关键词的选择将直接影响网站优化推广效果及网站的价值，选择关键词应该注意一下几点：&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 考虑用户搜索习惯，而并非企业名称或产品名称，尤其是对于一种新的产品，当市场还没有人知道的时候，自然不会有人去搜索这个关键词，因此选择关键词首先就应该去分析你的目标群体会在搜索引擎中搜索哪些关键词，而你应该选择那些与你的产品相关并能为你的销售带来帮助的关键词。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 中小企业切忌不要将自己的公司名称或品牌作为主要关键词，因为在你的目标群体中，很多人是没有听说过你的公司和品牌的，小企业做产品，对于中小企业来说，客户一般都是通过产品和服务来了解你的公司和品牌的，因此，网站关键词如果设置为公司名称，则不能达到良好的营销效果。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 关键词不宜过长，太长的关键词很少会有人搜索；点击量不宜太热，点击量太大搜索的人越多那么竞争也就会越激烈；同时关键词也不能太冷门，冷门关键词排到第一位也不会有多少人搜索访问，具体可以参考“百度指数”中的关键词访问量。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 碰到热门关键词时，最好在关键词前面或后面加上地域限制，譬如“塑钢门窗”，这个关键词竞争是非常激烈，但是“长沙塑钢门窗”就比较好做了，而且如果你做的是有地域限制的业务，那么其他地方搜索到你的网站也没有多大意义。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; 标题关键词应该控制在1-3个之间，除非第四个以后的关键词是比较冷门的，否则在标题中添加多个关键词是没有任何意义的，反而会影响主关键词的排名。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989300', '1538989300');
INSERT INTO `ey_article_content` VALUES ('11', '14', '&lt;p style=&quot;text-align: center;&quot;&gt;绝大多数的网站项目需求设计方案都有一个共通点：设计要求一定要“大气”。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;“大气”这个原本陌生的词汇渐渐占领了我的设计思路，有种盲从地被强奸的感觉。其实，说实话，如果你让现今的小企业来对你的设计做些要求的话，从专业角度出发，他们可能连一个起码的要求都提不出来。我也曾经试探性地问过一些客户最基本的设计上的需求。比如网站的基本色调之类的，往往得到的答复就是：你们看着办吧，什么颜色好看用什么颜色。这种对自身企业不负责任的回答，难免会在一定程度上影响到设计人员的设计方向。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;回到文章标题提到的“大气”上来。这个词汇在字典里的具体含义我不清楚，但大多数的企业客户都是义正严词地白纸黑字写在了需求说明里。可能这就是他们在对你的设计效果没有丝毫建设性要求之后，不经大脑思索就硬生生地强加给设计人员的最无理的要求了。但，如何做的大气，他们也拿不定注意的，某些客户可能只是为了掩饰自己的轻浮，而不得不做出的一个颇具风范的补充罢了。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;对于设计人员来说，“大气”真的是非常头痛的问题。因为“大气”这东西不是说做就能做出来的，这不是一个实际存在的物体，只可意会不可言传。飘朵白云，放个飞机等等只能说明自己的庸俗，更有甚者，万般强调一定要在首页加上企业老总的照片，放上音乐播放器等等，这就是他们心中的“大气”。然而，这些所谓的“大气”并没能增加网站的优势，反而，更凸显了企业的无为。我们此时所要做的就是开导教化，规劝他们千万不要把自己的企业站做成一个娱乐场所，要娱乐，去那些门户网站就够了，他们什么都有，你想不到的都有。但往往这些建议都会被他们抛掷脑后，“我让你怎么做你就怎么做好了，又不会少你一分！”但凡听到类似这样的话的，这个企业绝对不是什么有实力的。做纺织的放个飞机表明自己的高度；做物流的放个唱着交响乐的音乐播放器表明自己深度。。。这样就大气了吗？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;在网上找到一个这样对商业网站的定义，感觉概括的比较全面：“大气”是指突出要表现的主题,并加以适当的夸张，弱化辅助的图形，减少干扰的元素。同时通过色彩的搭配，元素的使用及比例等，形成考究的视觉中心，把“气”留住，让画面有良好的节奏感。这是一个比较高的境界，需要设计师不断的提高自身的修养与审美意识。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;对于一个大气的商业网站来说，首先，页面布局设计就是一个非常有学问值得推敲的问题。布局合理有序，突出重点，简洁而不简单；单一而不单调；层次分明；设计元素协调；能更好地满足用户的需求，引导用户方便快捷地实现功能，第一时间找到自己要做的，下一步去哪，当前所在位置等等；给用户一种畅通无阻畅快淋漓的感觉，虽然是第一次访问，但已是似曾相识信手拈来。这样的大气来的更且实际。因为，飞机不会让用户想到你的纺织品有多么的精致，交响乐也不能让用户看到你的物流服务有多好。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;一个网站就象一个人，合理的信息架构是骨架，丰富生动的信息内容是血肉，而界面是皮肤，贯穿始末的易用性等用户体验是内在的修养气质。这一切相辅相成缺一不可。所以一个有魅力的人其魅力所在绝不仅仅是因为有光鲜夺目的面孔，而更应是举手投足间不经意流露出的内在气质。网站也是如此，如果没有一副好的骨架，没有血肉，徒有一个好外表，最终还是会让人弃若鄙履的，这样又何谈“大气”呢？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;企业网站不应只是一个光鲜华丽又孤芳自赏的橱窗广告，偶尔引来人驻足却又拉开了距离，让人亲近不得。企业网站更应该象是一个以用户为中心的亲切的便民窗口（像小区里的小卖部，它比市中心的商场超市更能满足周围住户的需求，而且更快速直接），能帮助人理解企业的价值主张，找到所需的产品或服务，建立友好的信任感，并以此为基础实现自身的赢利目标。可用性与赢利能力相结合，并兼顾界面的美观，企业网站建设只有做到了这一切，才能称之为“大气”。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;绝大多数的网站项目需求设计方案都有一个通点：设计要求一定要“大气”。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;“大气”这个原本陌生的词汇渐渐占领了我的设计思路，有种盲从地被强奸的感觉。其实，说实话，如果你让现今的小企业来对你的设计做些要求的话，从专业角度出发，他们可能连一个起码的要求都提不出来。我也曾经试探性地问过一些客户最基本的设计上的需求。比如网站的基本色调之类的，往往得到的答复就是：你们看着办吧，什么颜色好看用什么颜色。这种对自身企业不负责任的回答，难免会在一定程度上影响到设计人员的设计方向。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;回到文章标题提到的“大气”上来。这个词汇在字典里的具体含义我不清楚，但大多数的企业客户都是义正严词地白纸黑字写在了需求说明里。可能这就是他们在对你的设计效果没有丝毫建设性要求之后，不经大脑思索就硬生生地强加给设计人员的最无理的要求了。但，如何做的大气，他们也拿不定注意的，某些客户可能只是为了掩饰自己的轻浮，而不得不做出的一个颇具风范的补充罢了。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;对于设计人员来说，“大气”真的是非常头痛的问题。因为“大气”这东西不是说做就能做出来的，这不是一个实际存在的物体，只可意会不可言传。飘朵白云，放个飞机等等只能说明自己的庸俗，更有甚者，万般强调一定要在首页加上企业老总的照片，放上音乐播放器等等，这就是他们心中的“大气”。然而，这些所谓的“大气”并没能增加网站的优势，反而，更凸显了企业的无为。我们此时所要做的就是开导教化，规劝他们千万不要把自己的企业站做成一个娱乐场所，要娱乐，去那些门户网站就够了，他们什么都有，你想不到的都有。但往往这些建议都会被他们抛掷脑后，“我让你怎么做你就怎么做好了，又不会少你一分！”但凡听到类似这样的话的，这个企业绝对不是什么有实力的。做纺织的放个飞机表明自己的高度；做物流的放个唱着交响乐的音乐播放器表明自己深度。。。这样就大气了吗？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;在网上找到一个这样对商业网站的定义，感觉概括的比较全面：“大气”是指突出要表现的主题,并加以适当的夸张，弱化辅助的图形，减少干扰的元素。同时通过色彩的搭配，元素的使用及比例等，形成考究的视觉中心，把“气”留住，让画面有良好的节奏感。这是一个比较高的境界，需要设计师不断的提高自身的修养与审美意识。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;对于一个大气的商业网站来说，首先，页面布局设计就是一个非常有学问值得推敲的问题。布局合理有序，突出重点，简洁而不简单；单一而不单调；层次分明；设计元素协调；能更好地满足用户的需求，引导用户方便快捷地实现功能，第一时间找到自己要做的，下一步去哪，当前所在位置等等；给用户一种畅通无阻畅快淋漓的感觉，虽然是第一次访问，但已是似曾相识信手拈来。这样的大气来的更且实际。因为，飞机不会让用户想到你的纺织品有多么的精致，交响乐也不能让用户看到你的物流服务有多好。&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;一个网站就象一个人，合理的信息架构是骨架，丰富生动的信息内容是血肉，而界面是皮肤，贯穿始末的易用性等用户体验是内在的修养气质。这一切相辅相成缺一不可。所以一个有魅力的人其魅力所在绝不仅仅是因为有光鲜夺目的面孔，而更应是举手投足间不经意流露出的内在气质。网站也是如此，如果没有一副好的骨架，没有血肉，徒有一个好外表，最终还是会让人弃若鄙履的，这样又何谈“大气”呢？&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;企业网站不应只是一个光鲜华丽又孤芳自赏的橱窗广告，偶尔引来人驻足却又拉开了距离，让人亲近不得。企业网站更应该象是一个以用户为中心的亲切的便民窗口（像小区里的小卖部，它比市中心的商场超市更能满足周围住户的需求，而且更快速直接），能帮助人理解企业的价值主张，找到所需的产品或服务，建立友好的信任感，并以此为基础实现自身的赢利目标。可用性与赢利能力相结合，并兼顾界面的美观，企业网站建设只有做到了这一切，才能称之为“大气”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989426', '1538989426');
INSERT INTO `ey_article_content` VALUES ('12', '15', '&lt;p&gt;作为一个优化人员，在接到优化的单子时候，第一件要做的是什么?观察网站结构，做出具体的优化步骤方案。一般来说，网站的标题是非常重要的事情，对于搜索引擎来说，网站的标题是一个网站的门户与窗口，要想达到好的排名效果，恰当的标题与描述是必须修改的。&lt;/p&gt;&lt;p&gt;　　根据自己的经验给大家一些小的提示：&lt;/p&gt;&lt;p&gt;　　1、网站的标题要分批次更改&lt;/p&gt;&lt;p&gt;　　2、更改顺序-由后向前批次更改，也就是先改分页的，然后慢慢到首页。&lt;/p&gt;&lt;p&gt;　　3、在搜索引擎中网站排名好的主要关键词最后更改&lt;/p&gt;&lt;p&gt;　　例如我的一个网站，现有的标题为：“味多美网址导航、免费收录网站，按来路自动排行，自动收录”，要改为：以免费收录为主的关键词，并且主做“收录”这个词&lt;/p&gt;&lt;p&gt;　　步骤：&lt;/p&gt;&lt;p&gt;　　1)方法：把“味多美网址导航、免费收录网站，按来路自动排行，自动收录” 改成：“味多美网址导航，收录，免费收录网站，按来路自动排行，自动收录”&lt;/p&gt;&lt;p&gt;　　2)等收录后再加第二个词&lt;/p&gt;&lt;p&gt;　　改：味多美网址导航，收录，收录网址，免费收录网站，按来路自动排行，自动收录&lt;/p&gt;&lt;p&gt;　　3)再收录后&lt;/p&gt;&lt;p&gt;　　因为要主做收录&lt;/p&gt;&lt;p&gt;　　改：“味多美网址导航，收录，收录网址，免费收录网站，网址收录，自动收录”&lt;/p&gt;&lt;p&gt;　　以上都是经验之谈，望希望能够对大家有所帮助!&lt;/p&gt;&lt;p&gt;　　最后，需要和大家说明的是，在seo的角度来讲，修改网站标题对网站的排名影响很大，网站的标题须在网站定位后尽量就不要再修改，尤其是更要避免频繁修改title的事情。毕竟频繁的修改title，会导致被K的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989451', '1538989451');
INSERT INTO `ey_article_content` VALUES ('13', '16', '&lt;p&gt;电商时代已经势不可挡。而随着电商时代的来临。越来越多的人所关注的不是那种如淘宝、京东之类电子商城，而是自己企业的网站，因为那块蛋糕已经被分完了。传统的网站建设已经不能满足现在企业的需要了。他们需要的不仅仅是一个展示企业的一个网站，而是需要一个能帮助企业获得订单或者创造价值的网站。于是，众多的目光纷纷投向了搜索引擎。 当然百度竞价是一个烧钱的无底洞，不是所有的企业都能承受得起的，所以越来越多的目光都被集中在搜索引擎优化中，而如何将网站建设与网站优化相结合，则是目前网络公司急需解决的一个大问题。在这里笔者提几点关于网站建设程序开发中所需要注意的SEO细节。&lt;/p&gt;&lt;p&gt;　　第一，网站的树形结构。这是一个大的方向。网站建设人员在建站的时候往往很容易忽视这个问题。首先要知道一点，一个页面处于根目录下的第几级页面将直接决定了spider对其权重的判断，这也是树形结构为什么如此重要的原因。而spider的爬行顺序一般都是由主页，到二级目录，然后是三级目录，当你把所有的页面放在一起的时候，很明显，这是不利于爬行的。这对于网站SEO来说是一个非常头疼的问题，因为一旦做好了，如果要修改这些路径，是非常麻烦的。&lt;/p&gt;&lt;p&gt;　　第二，网站的代码。百度虽然一直都在重复声明已经在完善对于动态页面的收录情况，但是事实告诉我们，它只是一直在声明，却从未做到过。网站建设或者网站的程序人员需要注意的是在网站的开发过程中，不到万不得已千万别用动态，用伪静态都行。继而就是网站的样式标签和JS调用了。这也是网站建设过程中一个非常需要关注的问题。CSS样式表和网站的JS文件并不是拿来看的，它可以有效的减少spider对于网站爬行的量，让spider在爬行你网站的时候更为简单，快捷，给蜘蛛好感。所以笔者友情提示下，网站的样式与JS尽量写在CSS与JS里面，别给网站增加压力。还有就是代码的类型了。很多的代码都已经被越来越多的优化引擎所淘汰。如以前的table标签，现在就越来越被spider所不喜欢了，现在的spider喜欢的是DIV。还有一点就是网站SEO优化非常重要的，那就是title、keywords和description标签了。网站程序人员在程序开发的时候务必要注意二级或者三级页面的这些问题，因为如果能做到统一好，就不需要再后期进行修改了。&lt;/p&gt;&lt;p&gt;　　第三，架构上的合理。spider对于网站的抓取仅限于文本这是一个众所周知的潜规则。而一个网站90%左右的文本类型基本上都集中于产品页与新闻页中，故如何能让这两个页面被spider所抓取是建站的时候 要考虑的问题之一，比如多增加这些页面的入口等。当然这些页面的价值体现了，最终还是要返回给主页的。这时候面包屑的标签就体现出来了。所有二级页面三级页面的权重传递几乎都是依靠面包屑标签来传递的。这也是为什么网站优化人员一直重视它的原因。&lt;/p&gt;&lt;p&gt;　　当然，一个成功的优化网站还有很多细节需要注意，笔者也只是列举了几个自己觉得重要的东西。虽然只是几点，但是我相信，当网站建设人员在建站的时候能注意到上述的几个细节，网站优化的工作将轻松许多，至少在网站优化的过程中可以省去很多站内的繁琐事物，这能大大提高工作效率。我想这样的网站不管对于一个网络公司或者对于客户都是非常想看到的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989497', '1538989497');
INSERT INTO `ey_article_content` VALUES ('14', '17', '&lt;p&gt;互联网行业应该算国内开放度、自由度最高的行业之一。进入这个行业几乎没有门槛。这里不会嫌贫爱富，这里没有所谓的潜规则，这里不用请客吃饭，只要你拥有创业的梦想、有一个好点子，互联网就可能为你开启财富之门。这个神奇的新兴行业不知道制造了多少财富的神话与奇迹。笔者做网站建设已经有五年的经历了，希望能把一些做网站的经验与教训同大家一起分享。&lt;/p&gt;&lt;p&gt;一、你做好艰苦创业的准备了么？&lt;/p&gt;&lt;p&gt;很多菜鸟可能是怀着这种心理开始做网站的，即：坐在电脑旁打打字就能赚钱，只要网站做好了，它时时刻刻都可以为我赚钱，甚至在我睡觉的时候。这种想法的潜台词是，很多新手认为做网站是很轻松的事情。殊不知，天下没有免费的午餐，人们的收获通常是同付出成正比的。所以，要做一个成功的网站，辛苦的劳动是必须的。我经常告诫一些刚入行的朋友：“做网站，首先要做好吃苦的准备，否则你将一事无成。” 找笔者做网站的朋友可以说是成百上千了。可是，真正能够坚持下来的朋友凤毛麟角。这里的原因非常多，我想非常重要的原因可能是：你从一开始就没有做好艰苦创业的心理准备。&lt;/p&gt;&lt;p&gt;二、万事开头难。&lt;/p&gt;&lt;p&gt;辛辛苦苦做好了一个网站，网站却没有流量，这是很多新手站长面临的问题。很多人因此退却了，败下阵来了。实际上，网站建设是一个循序渐进的过程。网站流量更是一个逐步积累的过程。刚开始做站的时候，可以不要将注意力放在网站流量上。我们还是在提高网站自身质量上多花些时间吧，可能在不久的一个将来，突然发现，我们已经离成功很近了。&lt;/p&gt;&lt;p&gt;三、不要做独行侠，一加一大于二。&lt;/p&gt;&lt;p&gt;做网站很辛苦，这是老站长们的共识。我们要做的工作很多：维护网站，管理服务器，做网站推广等等。这么多事情，你就是有三头六臂，也不可能面面俱到。很多朋友刚开始做网站的时候，还是信心满满，可是这样忙忙碌碌的节奏，你能适应的了么，你能坚持下来么。那有没有想过找些合作伙伴？大家分工协作，各管一摊，做网站的效率肯定会大大提升。赶快加入一个团队吧！&lt;/p&gt;&lt;p&gt;四、不要闭门造车，多看看周围的世界。&lt;/p&gt;&lt;p&gt;不要埋头于自己的网站。多看看周围的站长朋友都再做什么？埋头苦干，可能会做出一些成绩，但更多的可能是走入一些死胡同。具体的做法是，多浏览各大站长咨询类网站。比如站长之家。网站上有很多网站建设与推广技巧的优秀文章，我们可以学习到很多建站知识。另外：也可以多加入一些站长QQ群，或者多浏览一些站长类的论坛，包括微薄。同其他站长多聊一下建站的心得。日积月累，你肯定能收获颇丰。&lt;/p&gt;&lt;p&gt;五、免费的东西往往是最贵的。&lt;/p&gt;&lt;p&gt;收费模式与免费模式之争由来已久。两种模式都有大量互联网企业成功的例子。国内的免费风潮曾经风起云涌。从网络游戏平台的免费，到由360引起的杀毒软件行业由收费模式到免费模式的集体转身。似乎，免费成了国内互联网的大趋势。然而，苹果公司收费模式的成功，又让众多人惊呼：免费时代要终结了。依笔者搞网站建设的应验来看，我们还是要尽量避开免费模式的陷阱，尽量选择收费的产品。像免费空间、免费域名、免费的网站程序模板，还是不要用了。至于原因，笔者也有使用免费域名的惨痛教训，这里就不再展开。这个问题我会在不久以后作一篇详细地论述。&lt;/p&gt;&lt;p&gt;六、让你的脑子动起来。&lt;/p&gt;&lt;p&gt;做优秀的网站是需要一点智商的，这一点没有人能否认。一个好点子往往可以成就一个传奇。像众所周知的hao123，导航之家，还有twitter、微博，都是经典的成功案例。所以我们在工作之余，要让你的脑子动起来，多思考一些创意。说不定，下一个让互联网震撼的人就是你。&lt;/p&gt;&lt;p&gt;以上是笔者在做网站建设以来的一些感悟。希望能够对您的互联网之路有所启发。有梦想就有希望，我们每个人都可能成为奇迹。希望我们都能扬起理想的风帆，到达成功的彼岸。&lt;/p&gt;&lt;p&gt;　　&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989515', '1538989515');
INSERT INTO `ey_article_content` VALUES ('15', '18', '&lt;p&gt;我们每天都会看到无数个新网站出现，也会看到无数个旧网站关闭；我们每天都会看到很多站长欢呼雀跃自己的网站收录提高，排名提升，也会看到很多站长痛哭流涕说网站降权，排名下降，收录大跌。种种的网络喜怒哀乐每天都这么上演。包括我在内也同样的经受一轮又一轮的折磨。我们没有选择，只能继续学习、交流、再学习，提升自己的技术和技能，尤其是我们这种做网站推广的站长，需要的是承受力还有更好的心脏抗压能力。&lt;/p&gt;&lt;p&gt;关于新网站的建设，每个人都有每个人的经验，理论几天几夜都说不完，今天是我第一次发表投稿文章，希望与大家分享我对新网站建设的点点看法。希望能和网络上的朋友们交流。让我们一起见证新网站的从无到有。&lt;/p&gt;&lt;p&gt;第一点，新网站域名的选择。域名是网站、公司、产品的品牌形象，就好像我们人名一样，需要天天使用、传播，告诉别人。如果选择的不好，太长或者难以记忆，那自己也看着别扭，也会影响我们的转化率。如果我来选择网站的域名，我考虑在6个字符之内，与公司的们名字，产品以及网站主题相关即可。简单好记的域名最为重要。关于后缀的选择，如果很注重品牌形象，我认为必须选择COM，如果就简单的主题推广，后缀无所谓，好记就可以。对于其他后缀是不是需要保护，我认为不需要。一个就可以了。&lt;/p&gt;&lt;p&gt;第二点，新网站程序的选择。关于程序，选择主流的CMS，如果自己有技术能力或者经济能力，最好能定制一款自己的网站系统，有利于搜索引擎以及网站的安全。网站一定要静态或者伪静态，这样有利于搜索引擎的收录和排名。&lt;/p&gt;&lt;p&gt;第三点，新网站空间的选择。网站空间是网站效果以及排名的关键要素之一。首先空间一定要稳定，不能经常打不开或者速度慢，这会影响网站的收录和排名，以及快照的更新。千万不要为了省点小钱，而用免费空间。如果你连空间域名都在考虑是不是节省，那就不要做网站了。如果有条件的站长，可以选择用独立IP的空间。购买空间一定要购买正规主机商的，个人的一定要朋友正在使用或者自己认识的。因为骗子实在太多。&lt;/p&gt;&lt;p&gt;第四，新网站的更新与收录。新网站内容开始的时候不要求多，每天几篇更新即可，具体还是看你网站的内容和丰富度，最为关键的就是网站需要保持更新，而且需要原创更新，不要为了更新而随意添加文章。因为你的更新的基础是不是扎实，严重关系到你未来网站的收录和持久性。&lt;/p&gt;&lt;p&gt;第五，外链接建设。新网站的外链接建设需要慢，就像小火一样慢慢炖。一天在10-15个外链接即可。一般这样的新网站是1周即可收录，大家最为要关注在周四，因为周四是百度收录周期，一定要保证网站的稳定空间。外链接建设不要群发，一定要手工。我们可以看到有很多群发软件，而且吹嘘的很好，好像可以一夜暴富一样，效果我不怀疑，肯定是有的，而且我也在找有没有合适的软件，我最近也想入手一个。网站初期阶段，一定要手工发布，因为成功率和量自己好把握。&lt;/p&gt;&lt;p&gt;第六，观察。观察网站的收录情况，快照，以及外链接数的增加幅度。一切要在可控的掌握下，迅速提高。观察空间的使用，如果是共享IP看看有可能IP问题，大部分网站是不是收录正常，如果大部分都正常那就没问题，反之需要考虑换空间。所以建议有条件用独立IP空间。&lt;/p&gt;&lt;p&gt;第七，持续执行。有一定的效果后，我们还是需要持续更新，因为你不做，你的竞争对手在做。所以我们只能坚持。谁叫我们命苦呢。即便到第一名，也需要做，观察同行的情况，更新量，外链接等等。&lt;/p&gt;&lt;p&gt;以上7点方法是我个人在做新网站的时候经验分享。因为方法可能大家都知道，主要还是看每个人的执行力，执行力不同，效果就不同。歇息了半年，重新回到网络，希望与更多的朋友交流。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989626', '1538989626');
INSERT INTO `ey_article_content` VALUES ('16', '19', '&lt;p&gt;一个网站的组成无非就是内容和框架，如果要做SEO当然还有外链，今天这里主要讲框架里面的一个细节，就是如何布置网站的目录。&lt;/p&gt;&lt;p&gt;一、目录是什么。&lt;/p&gt;&lt;p&gt;目录是什么，一般目录就是分页信息的首页，也就是内页的分类列表的第一个页面，这个页面可以是一个以/结尾的文件夹，也可以是一个文件，看个人喜好了。&lt;/p&gt;&lt;p&gt;二、目录的作用。&lt;/p&gt;&lt;p&gt;网站里面都会用到新闻中心此类的页面，其实这个里面还是有大学问的，大家都知道假如网站权重一样的话，一级目录比一级页面在搜索引擎中的排名要好，换句话讲，就是一些长尾关键词可以用一级目录来规划，比如那些无搜索量有下拉框或者相关搜索里面有的那些词（百度指数少于50），我们可以把他整到目录的首页，作为目录关键词。&lt;/p&gt;&lt;p&gt;三、目录的优缺点。&lt;/p&gt;&lt;p&gt;优点：目录的可以继承主站的权重，如果网站权重不错，一旦收录排名就会很不错，而且具有收录快，稳定（只要主站权重还在），外链需求量较少等。&lt;/p&gt;&lt;p&gt;缺点：不利于长期发展，在一些比较热门的关键词面前，很多人都用顶级域名来作站，这时候你和他们竞争起来就相对疲软。&lt;/p&gt;&lt;p&gt;一般比较适合一些短暂的关键词，比如某某节日，某某事件等等，我们可以给他开发一个专题目录，像这种来得快去得快的东西最适合目录做。&lt;/p&gt;&lt;p&gt;四、如何规划。&lt;/p&gt;&lt;p&gt;如何规划好网站的目录，力求做到两个统一。&lt;/p&gt;&lt;p&gt;1、地址统一，这里的统一主要就是斜杆问题，因为地址不一样的话链到的地方就不一样了，个人觉得所有的目录都应该加上斜杆，否则你会被收录两个一模一样的页面，无故被分担掉权重。&lt;/p&gt;&lt;p&gt;2、链接关键词统一，这个很好理解，就跟内链是一样的，如果我们有多个关键词，可从外链方面予以扩展，但是内部一定要统一。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538989648', '1538989648');
INSERT INTO `ey_article_content` VALUES ('17', '20', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/d229903cd72b13ae110ff514222bfe01.jpg&quot; title=&quot;d229903cd72b13ae110ff514222bfe01.jpg&quot; alt=&quot;d229903cd72b13ae110ff514222bfe01.jpg&quot;/&gt;&lt;/p&gt;', '1539597644', '1539597644');
INSERT INTO `ey_article_content` VALUES ('18', '21', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/762e7d0592f54361ed337038d8a91ffd.jpg&quot; title=&quot;762e7d0592f54361ed337038d8a91ffd.jpg&quot; alt=&quot;762e7d0592f54361ed337038d8a91ffd.jpg&quot;/&gt;&lt;/p&gt;', '1539597656', '1539597656');
INSERT INTO `ey_article_content` VALUES ('19', '22', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/ec65844dd420162fc066493e2e3d6295.jpg&quot; title=&quot;ec65844dd420162fc066493e2e3d6295.jpg&quot; alt=&quot;ec65844dd420162fc066493e2e3d6295.jpg&quot;/&gt;&lt;/p&gt;', '1539597665', '1539597665');
INSERT INTO `ey_article_content` VALUES ('20', '23', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/7ca3bd2e5548e155b715eecfcac19719.jpg&quot; title=&quot;7ca3bd2e5548e155b715eecfcac19719.jpg&quot; alt=&quot;7ca3bd2e5548e155b715eecfcac19719.jpg&quot;/&gt;&lt;/p&gt;', '1539597676', '1539597676');
INSERT INTO `ey_article_content` VALUES ('21', '24', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/59e70125d18e9d9024b9c9d9ab32b6c3.jpg&quot; title=&quot;59e70125d18e9d9024b9c9d9ab32b6c3.jpg&quot; alt=&quot;59e70125d18e9d9024b9c9d9ab32b6c3.jpg&quot;/&gt;&lt;/p&gt;', '1539588783', '1539588783');
INSERT INTO `ey_article_content` VALUES ('22', '25', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/5feade5abf71636d316c3bf2bab36038.jpg&quot; title=&quot;5feade5abf71636d316c3bf2bab36038.jpg&quot; alt=&quot;5feade5abf71636d316c3bf2bab36038.jpg&quot;/&gt;&lt;/p&gt;', '1539588795', '1539588795');
INSERT INTO `ey_article_content` VALUES ('23', '26', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/0f27b75e8c06168d613868ca204d70ea.jpg&quot; title=&quot;0f27b75e8c06168d613868ca204d70ea.jpg&quot; alt=&quot;0f27b75e8c06168d613868ca204d70ea.jpg&quot;/&gt;&lt;/p&gt;', '1539588807', '1539588807');
INSERT INTO `ey_article_content` VALUES ('24', '27', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/10/15/cc012315bdd5d9e4e0a152f446bcb110.jpg&quot; title=&quot;cc012315bdd5d9e4e0a152f446bcb110.jpg&quot; alt=&quot;cc012315bdd5d9e4e0a152f446bcb110.jpg&quot;/&gt;&lt;/p&gt;', '1539588817', '1539588817');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` text COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207843', '0');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207846', '0');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` varchar(128) NOT NULL DEFAULT '' COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091575', '1533091575');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091601', '1533091601');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091624', '1533091624');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092214', '1533092214');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092246', '1533092246');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092381', '1533092381');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '封面图', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092398', '1533092398');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092439', '1533092439');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092454', '1533092454');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092468', '1533092468');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092484', '1533092484');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '编辑者', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092498', '1533092498');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092512', '1533092512');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092534', '1533092534');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092553', '1533092553');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092698', '1533092698');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092713', '1533092713');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092725', '1533092725');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092739', '1533092739');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092753', '1533092753');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092766', '1533092766');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359739', '1533359739');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359588', '1533359588');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359752', '1533359752');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464715', '1533464715');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464713', '1533464713');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');

-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '0', '1547690665');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '0', '4', '0', '1547690665');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '0', '2', '0', '1547690665');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '8', '1509197711', '1547690665');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '6', '1523091961', '1547690665');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '0', '3', '1523929121', '1547690665');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '500', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|iso|doc|xsl|ppt|wps', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '465', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'xxxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', 'xxxxxxxxxxx', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '特色小吃店面加盟网站模板', 'web', '', 'cn', '0', '1545961301');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/public/upload/system/2018/10/08/dd7a03557045faf0e1565ab2a11b4950.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://127.0.0.2', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', '琼ICP备xxxxxxxx号', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2012-2018 某某餐饮 版权所有', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '&gt;', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '特色小吃店面加盟网站模板', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '6e27af8a47788c33317c98fd9b0d8e03', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('58', 'web_attr_3', '/public/upload/system/2018/10/08/f3ec661cb3d32bd27905ada023d659f0.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('59', 'web_attr_2', '0898-08980898', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('60', 'web_attr_1', '诚信为本：市场永远在变，诚信永远不变。', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('61', 'web_attr_4', '13866668888', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_attr_5', '海南省海口市', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'mAN9eyusmbqmBgcsFLFbpHSi', 'php', '', 'cn', '0', '1547690822');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '-1', 'web', '', 'cn', '0', '1547690659');
INSERT INTO `ey_config` VALUES ('81', 'seo_rewrite_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('82', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'web_attr_6', 'admin@youweb.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('85', 'web_attr_7', '0000-000-000', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('86', 'web_attr_8', '/public/upload/system/2018/10/10/4092d62b40472f6b7c7b81cf5694ad82.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('87', 'web_attr_9', '13876458888', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('88', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_sql_mode', 'NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('90', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('91', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('92', 'system_version', 'v1.2.6', 'system', '', 'cn', '0', '1547690669');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '公告', 'web_attr_1', '0', 'cn', '1538984808', '1538984808');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '热线电话', 'web_attr_2', '0', 'cn', '1538985131', '1538985130');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', '加盟图', 'web_attr_3', '3', 'cn', '1538991626', '1538991626');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '手机', 'web_attr_4', '0', 'cn', '1538994098', '1538994098');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '地址', 'web_attr_5', '0', 'cn', '1538994115', '1538994115');
INSERT INTO `ey_config_attribute` VALUES ('6', 'web', '邮箱', 'web_attr_6', '0', 'cn', '1538994141', '1538994141');
INSERT INTO `ey_config_attribute` VALUES ('7', 'web', '传真', 'web_attr_7', '0', 'cn', '1539048722', '1539048722');
INSERT INTO `ey_config_attribute` VALUES ('8', 'web', '手机logo', 'web_attr_8', '3', 'cn', '1539139532', '1539139532');
INSERT INTO `ey_config_attribute` VALUES ('9', 'web', '手机', 'web_attr_9', '0', 'cn', '1539153446', '1539153446');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';


-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_guestbook_attribute`
-- -----------------------------
INSERT INTO `ey_guestbook_attribute` VALUES ('1', '姓名', '13', '0', '', '100', 'cn', '0', '1539075954', '1539075954');
INSERT INTO `ey_guestbook_attribute` VALUES ('2', '手机', '13', '0', '', '100', 'cn', '0', '1539075961', '1539075961');
INSERT INTO `ey_guestbook_attribute` VALUES ('3', '留言内容', '13', '2', '', '100', 'cn', '0', '1539075969', '1539075969');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';


-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';


-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('1', '1', '微信小程序开发教程', 'http://www.yiyongtong.com/', '', '100', '1', '', '', '1', 'cn', '0', '1539047533', '1539047533');
INSERT INTO `ey_links` VALUES ('2', '1', '织梦58源码', 'http://www.dede58.com/', '', '100', '1', '', '', '1', 'cn', '0', '1539047549', '1539047549');
INSERT INTO `ey_links` VALUES ('3', '1', '素材58', 'http://www.sucai58.com/', '', '100', '1', '', '', '1', 'cn', '0', '1539047565', '1539047565');
INSERT INTO `ey_links` VALUES ('4', '1', '搜海口', 'http://www.souhaikou.com/', '', '100', '1', '', '', '1', 'cn', '0', '1539047578', '1539047578');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('1', '1', '1', '&lt;p&gt;核心价值观：诚信、创新、服务&lt;/p&gt;&lt;p&gt;企业核心： 诚信&amp;nbsp;&lt;/p&gt;&lt;p&gt;企业精神： 团结拼搏、开拓求实、满足用户、科技进步。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢得客户的理解、尊重和支持。&lt;/p&gt;&lt;p&gt;市场：为客户降低采购成本和风险，为客户投资提供切实保障。&amp;nbsp;&lt;/p&gt;&lt;p&gt;发展：追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;关于“为合作伙伴创造价值”&lt;/p&gt;&lt;p&gt;公司认为客户、供应商、公司股东、公司员工等一切和自身有合作关系的单位和个人都是自己的合作伙伴，并只有通过努力为合作伙伴创造价值，才能体现自身的价值并获得发展和成功。&lt;/p&gt;&lt;p&gt;关于“诚实、宽容、创新、服务”&lt;/p&gt;&lt;p&gt;公司认为诚信是一切合作的基础，宽容是解决问题的前提，创新是发展事业的利器，服务是创造价值的根本。公司会坚持持续改进、满足顾客期望、 确保品质第一、开拓全球市场。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1539049113', '1539049113');
INSERT INTO `ey_single_content` VALUES ('2', '2', '10', '&lt;p&gt;一、全方位支持 &amp;nbsp; 全天候指导&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 专业的营运指导团队在全国不间断地回指导，定期上门教学培训，24小时疑问解答，使每家店都体验到“保姆式”立体服务。公司总长期为加盟店培训人员提供直营店实地培训课，让每一个学员都能得到理论与实践相结合的强化锻炼。&amp;nbsp;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;二、专业指导 &amp;nbsp;专家诊断&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 专业餐饮团队总结多年的成功经验，整合出一套从经营到管理，从产品到工艺上既简单实用的开店方法。让加盟投资者快速成为专业餐饮人。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;三、品质统一 &amp;nbsp;技术简单&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 率先进行烹饪技术革命，核心配料采用标准化的中央配送，使店面操作工艺由繁到简，去掉了技术门槛又节省了人力成本。原辅料的集约化采购和标准化配送，使每家店在保持品质和风味统一的同时，最大程度降低了营运成本，提高单店在市场经营中的竞争力。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;四、著名品牌 &amp;nbsp;掌控核心&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 连续多年被评为“著名商标”，一直以来受到广大食客的追捧。秉承世代相传的工艺配方，所掌控的核心调味料用十几种天然原辅料进行炒制而成，完全达到了产品的自然鲜美，在市场中永远保持独一无二地位。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;五、打破传统加盟政策 &amp;nbsp; &amp;nbsp;谛造永久事业平台&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp;始终奉行“成就别，成就自己”的经营理念，首家推出“终身一费制”的加盟政策，完全打破了传统年度加盟费和月度管理费的收费行规，从更大程度上降低了加盟商投资成本。从而，激发了许多成功加盟店在一个区域不断扩张发展，创造了一个投资者能稳定、低成本、永久发展的事业平台。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;六、统一配料 标准制作&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp;“特有的工艺配方，独特的工艺，现代化标准流程，让各经营店铺产品品质和口味都达到了统一的保障，使技一般工作者只需通过15天的培训就能轻松成为合格的美食技师。烹饪技术的快速速成，核心配料的独家统一配制，让加盟店永远摆脱了被厨师控制投资人的局面。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;七、多元投资 &amp;nbsp;多店连锁&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp;现代的市场投资必须学会分散才能更好地控制风险。风味餐饮店凭借其投资少，特色鲜明，用工量少等经营特点，实现了投资一家中餐或火锅的成本，则可以投资10家及以上的南粉北面餐饮店，受到许多投资者的青睐，也让每一个餐饮投资者实现“多元投资，多店连锁”事业发展渠道。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;八、成功经营，共创共享&lt;/p&gt;&lt;p&gt;&amp;nbsp; &amp;nbsp; 现代餐饮店在市场中必须是“有特色才有市场，有管理才有利润，有品质才有未来”，凭借15年总结的成功经验，在经营模式上包容了特色化、多元化、规模化、精细化的特点，让加盟商能快速地适应每一个市场。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1538991807', '1538991807');
INSERT INTO `ey_single_content` VALUES ('3', '3', '14', '&lt;p&gt;地址：海南省海口市&lt;/p&gt;&lt;p&gt;电话：0898-08980898&lt;/p&gt;&lt;p&gt;邮编：000000&lt;/p&gt;&lt;p&gt;邮箱：admin@youweb.com&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;iframe class=&quot;ueditor_baidumap&quot; src=&quot;/public/plugins/Ueditor/dialogs/map/show.html#center=110.325526,20.04405&amp;zoom=13&amp;width=530&amp;height=340&amp;markers=110.325526,20.04405&amp;markerStyles=l,A&quot; frameborder=&quot;0&quot; width=&quot;534&quot; height=&quot;344&quot;&gt;&lt;/iframe&gt;&lt;/p&gt;', '1539073780', '1539073780');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned DEFAULT '0',
  `total` int(10) unsigned DEFAULT '0',
  `weekcc` int(10) unsigned DEFAULT '0',
  `monthcc` int(10) unsigned DEFAULT '0',
  `weekup` int(10) unsigned DEFAULT '0',
  `monthup` int(10) unsigned DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(20) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='页面美化参数设置';


-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件应用表';

