<?php
namespace app\common\validate;

use think\Session;
use think\Validate;
use app\common\model\Admin as AD;

class Admin extends Validate

{
     protected $rule = [
	 'photo|手机号'=>'require|regex:^1\d{10}|unique:user|token',
	 'pass|密码'=>'require|min:6',
	 'repass|密码'=>'require|min:6|confirm:pass',
	 'email|邮箱'=>"require|regex:^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z0-9]{2,6}$|unique:user",
	 'name|用户名'=>'require|min:6|unique:user',
	 'user|用户名'=>'require|min:5|max:50|chsDash|token',
	 'password|密码'=>'require|min:6|max:50|vali:password',
	 'passwordg|密码'=>'require|min:6|max:50|isVali:passwordg',
	 'code|验证码'=>'require|length:4|number|isCode:code',
	 ];

    //定义验证提示
    protected $message = [
        'photo.unique'     => '该手机号已存在',
		'photo.token'     => '数据超时,请重新提交',
        'photo.require' => '手机号不能为空',
        'photo.regex'     => '手机号不正确',
		'repass.require'=>"密码不能为空",
		'pass.min'=>"密码长度不能少于6位",
		'repass.confirm'=>"两次输入密码不一致",
		'repass.min'=>"密码长度不能少于6位",
		'email.require'=>"邮箱不能为空",
		'email.regex'=>"邮箱格式不正确",
		'pass.require'=>"密码不能为空",
		'email.unique'=>"邮箱已经存在",
		'user.token'=>'数据超时,请重新提交',
		'code.length'=>'验证码错误',
		'code.number'=>'验证码错误'
    ];

    //定义验证场景
    protected $scene = [
        'addUser'  =>  ['name','photo','email','pass','repass'],
		'editUser'=>['name'=>['require','min'],'photo'=>['require','regex:^1\d{10}','token']],
        'sende'=>['user','password'],
        'login'=>['user','passwordg','code']		
    ];
	protected function vali($value,$rulw,$data){
        $da=AD::getByUser($data['user']);
		if($da){
			if(md6($value,$da['password'])){
				return ['code'=>1,'data'=>$da];
			}else{
				return "密码错误";
			}
		}else{
			return "没有该管理员";
		}
    }
	protected function isVali($value,$rulw,$data){
        $da=AD::getByUser($data['user']);
		if($da){
			if(md6($value,$da['password'])){
				return true;
			}else{
				return "密码错误";
			}
		}else{
			return "没有该管理员";
		}
    }
	protected function isCode($value,$rule,$data){

		if(session("?admin_code")){
			if(session("admin_code")==$value){
				session(null);
				$da=AD::getByUser($data['user']);
				if($da['state']!=1){
					return "账号被停用";
				}else{
					session("adname",$da['user']);
					session("is_admin",$da['id']);
					return true;
				}
			}else{
				return "验证码错误";
			}
		}else{
			return "验证码失效";
		}
    }
}