<?php
namespace app\common\validate;

use think\Session;
use think\Validate;
use app\common\model\User as U; 
use app\common\model\LoginLog;

class User extends Validate

{
     protected $rule = [
	 'photo|手机号'=>'require|regex:^1\d{10}|unique:user|number',
	 'pass|密码'=>'require|min:6|chsDash|max:50',
	 'repass|密码'=>'require|min:6|confirm:pass|chsDash|max:50',
	 'email|邮箱'=>"require|email|unique:user|max:50",
	 'user|用户名'=>'require|min:6|max:50|unique:user|chsDash',
	 'code|验证码'=>'require|isCode:code',
	 'name|用户名'=>"require|chsDash|max:50",
	 'password|密码'=>'require|min:6|isPass:password|chsDash|max:50',
	 'tel|手机号'=>'require|regex:^1\d{10}|chsDash|isName:tel',
	 'mcode|验证码'=>'require|yzmCode:code',
	 'ps1|密码'=>'require|min:6|chsDash|max:50',
	 'ps2|重复密码'=>'require|min:6|chsDash|max:50|confirm:ps1',
	 'qq|QQ号'=>'require|min:6|max:50|number',
	 'passa|原密码'=>'require|chsDash|sinmd6:passa',
	 'tradePwd|交易密码'=>'require|chsDash|min:6|max:50',
	 'codeTran'=>'require|isTran:codeTran',
	 ];

    //定义验证提示
    protected $message = [
        'photo.unique'     => '该手机号已存在',
        'photo.require' => '手机号不能为空',
        'photo.regex'     => '手机号不正确',
		'repass.require'=>"密码不能为空",
		'pass.min'=>"密码长度不能少于6位",
		'repass.confirm'=>"两次输入密码不一致",
		'repass.min'=>"密码长度不能少于6位",
		'pass.require'=>"密码不能为空",
		'user.require'=>'必须输入用户名',
		'user.min'=>'用户名必须大于6个字符',
		'user.unique'=>'用户名已经存在',
		'name.require'=>'请输入用户名或手机号',
		'name.chsDash'=>'非法输入',
		'password.chsDash'=>'非法输入',
		'name.token'=>'操作失效',
		'ps2.confirm'=>'两次密码不一致',
		'code:length'=>'验证码为4位',
		'tradePwd.require'=>'密码不能为空',
		'tradePwd.chsDash'=>'非法字符',
		'tradePwd.min'=>'密码长度最小6位，最大50位',
		'tradePwd.max'=>'密码长度最小6位，最大50位',
		'codeTran.require'=>'验证码不能为空',
		'codeTran.require'=>'验证码错误',
    ];

    //定义验证场景
    protected $scene = [
        'send' => ['photo','user'],
		'Code'=>['photo','user','code'],
        'add'=>['photo','user','pass'],
        'login'=>['name','password'],
		'logincode'=>['tel','code'],
        'finda'=>['tel','code'],
        'findedit'=>['tel','pass','repass'],
        'edit'=>['mcode','passa','ps1','ps2'],
        'editTran'=>['tradePwd','codeTran']		
    ];
	protected function isCode($value){
        if($value==session("code_phone")){
			//session("code_phone",null);
            return true;
        }else{
            return "验证码错误";
        }
    }
	protected function yzmCode($value){
        if(!captcha_check($value)){
			return "验证码错误";
            
        }else{
            return true;
        }
    }
	protected function isTran($value){
        if(session('codeTran')!=$value){
			return "验证码错误";
        }else{
			session('codeTran',null);
            return true;
        }
    }
	protected function sinmd6($value,$rule,$data){
		$u=U::get(['id'=>session('user_id')]);
	   if($u){
		   if($data['cz']==2){
			   if(md6($value,$u['jiaoyimima'])===true || empty($u['jiaoyimima'])){
				   return true;
			   }else{
				   return "原交易密码错误";
			   }
		   }else{
			   if(md6($value,$u['password'])===true){
				   return true;
			   }else{
				   return "原密码错误";
			   }
		   }
        }else{
            return "非法提交";
        }
    }
	protected function edCode($value){
        if($value==session("code")){
			session("code",null);
            return true;
        }else{
            return "验证码错误";
        }
    }
	protected function isName($value){
        if(U::getByPhoto($value)){
            return true;
        }else{
            return "非法提交";
        }
    }
	
	protected function isPass($value,$rule,$data){
       $u=U::get(['user|photo'=>$data['name']]);
	   if($u){
		   if(md6($value,$u['password'])===true){
			   $token=makeToken();
			   $u->token=$token;
			   $u->timeout=strtotime("+1 days");
			   $u->old_login_time=$u->login_time;
			   $u->old_ip=$u->ip;
			   $u->login_time=time();
			   $u->ip=getip();
			   if(!$u->adress){
				   $u->adress=huoip($u->ip);
			   }
			   $u->assets=cookie('qrcode');
			   $u->save();
			   session("token",$token);
			   session("user_id",$u['id']);
			   LoginLog::addLog($u['id'],"登陆成功",1);
			   return true;
		   }else{
			   LoginLog::addLog($u['id'],"密码错误",1);
			   return "密码错误";
		   }
	   }else{
		   return "用户不存在";
	   }
    }
	
}