<?php
namespace app\api\controller;

use data\service\ThirdParty;

class UniApp extends BaseApi{
    /**
     * 检测openid是否已存在
     */
    public function checkOpenidIsExits(){
        $title = "检测openid是否已存在";
        
        $type = $this->get('type', 'oauth');
        $provider = $this->get('provider', '');
        $openid = $this->get('openid', '');
        $unionid = $this->get('unionid', '');
        
        if (empty($provider)) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数provider']);
        if (empty($openid)) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数openid']);
        
        $third_party = new ThirdParty();
        $data = $third_party->checkOpenidIsExits($type, $provider, $openid, $unionid);
        return $this->outMessage($title, $data);
    }
    
    /**
     * 账号绑定和完善
     */
    public function account(){
        $title = '绑定账号和完善信息';
        
        $params['mode'] = $this->get('mode', 'bind'); // 模式 bind:绑定已有账号  perfect:完善信息
        $params['provider'] = $this->get('provider', ''); // 授权服务提供商
        $params['openid'] = $this->get('openid', '');
        $params['unionid'] = $this->get('unionid', '');
        $params['account'] = $this->get('account', ''); // 账号
        $params['password'] = $this->get('password', ''); // 密码
        $params['avatar'] = $this->get('avatar', ''); // 头像
        $params['nickname'] = $this->get('nickname', ''); // 昵称
        
        if (empty($params['provider'])) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数provider']);
        if (empty($params['openid'])) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数openid']);
        if (empty($params['account'])) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数account']);
        if (empty($params['password'])) return $this->outMessage($title, ['code' => -1, 'message' =>'缺少必要参数password']);
                
        $third_party = new ThirdParty();
        $data = $third_party->authAfter($params);
        
        return $this->outMessage($title, $data);
    }
    
    /**
     * 获取openid
     */
    public function getOpenid(){
        $title = '获取openid';
        $provider = $this->get('provider', '');
        if (empty($this->uid)) {
            return $this->outMessage($title, "", '-9999', "无法获取会员登录信息");
        }
        $third_party = new ThirdParty();
        $openid = $third_party->getOpenid($provider, $this->uid);
        return $this->outMessage($title, ['openid' => $openid]);
    }
}