<?php
/**
 * Niushop商城系统 - 团队十年电商经验汇集巨献!
 * =========================================================
 * Copy right 2015-2025 山西牛酷信息科技有限公司, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: http://www.niushop.com.cn
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用。
 * 任何企业和个人不允许对程序代码以任何形式任何目的再发布。
 * =========================================================
 * @author : niuteam
 * @date : 2015.1.17
 * @version : v1.0.0.0
 */
namespace data\model;

use data\model\BaseModel as BaseModel;
/**
 * 限时折扣商品表
 *  discount_goods_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '主键',
  discount_id int(11) NOT NULL COMMENT '对应活动',
  start_time datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '开始时间',
  end_time datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT '结束时间',
  goods_id int(11) NOT NULL COMMENT '商品ID',
  status tinyint(1) NOT NULL DEFAULT 0 COMMENT '状态',
  discount tinyint(1) NOT NULL COMMENT '活动折扣或者减现信息',
  PRIMARY KEY (discount_goods_id)
 */
class NsShopOrderGoodsAccountViewModel extends BaseModel {

    protected $table = 'ns_order_goods';
    
    /**
     * 获取列表返回数据格式
     * @param unknown $page_index
     * @param unknown $page_size
     * @param unknown $condition
     * @param unknown $order
     * @return unknown
     */
    public function getViewList($page_index, $page_size, $condition, $order){
    
        $queryList = $this->getViewQuery($page_index, $page_size, $condition, $order);
        $queryCount = $this->getViewCount($condition);
        $list = $this->setReturnList($queryList, $queryCount, $page_size);
        return $list;
    }
    /**
     * 获取列表
     * @param unknown $page_index
     * @param unknown $page_size
     * @param unknown $condition
     * @param unknown $order
     * @return \data\model\multitype:number
     */
    public function getViewQuery($page_index, $page_size, $condition, $order)
    {
        //设置查询视图
        $viewObj = $this->alias('nog')
        ->join('ns_shop_order_account_records nsoar','nog.order_goods_id = nsoar.order_goods_id','left')
        ->field('nsoar.*, nog.goods_id, nog.goods_name, nog.order_status ');
        $list = $this->viewPageQuery($viewObj, $page_index, $page_size, $condition, $order);
        return $list;
    }
    /**
     * 获取列表数量
     * @param unknown $condition
     * @return \data\model\unknown
     */
    public function getViewCount($condition)
    {
        $viewObj = $this->alias('nog')
        ->join('ns_shop_order_account_records nsoar','nog.order_goods_id = nsoar.order_goods_id','left')
        ->field('nsoar.*, nog.goods_id, nog.goods_name, nog.order_status ');
        $count = $this->viewCount($viewObj,$condition);
        return $count;
    }
    public function getShopsGoodsSalesNum($condition){
        $sales_num = $this->alias('nog')
        ->join('ns_shop_order_account_records nsoar','nog.order_goods_id = nsoar.order_goods_id','left')
        ->field('nsoar.*, nog.goods_id, nog.goods_name, nog.order_status, nog.num ')
        ->where($condition)
        ->sum("nog.num");
        return $sales_num;
    }
    public function getShopGoodsPlatformMoney($condition){
        $sales_num = $this->alias('nog')
        ->join('ns_shop_order_account_records nsoar','nog.order_goods_id = nsoar.order_goods_id','left')
        ->field('nsoar.*, nog.goods_id, nog.goods_name, nog.order_status, nog.num ')
        ->where($condition)
        ->sum("nsoar.platform_money");
        return $sales_num;
    }
    public function getShopGoodsPlatformRefundMoney($condition){
        $sales_num = $this->alias('nog')
        ->join('ns_shop_order_account_records nsoar','nog.order_goods_id = nsoar.order_goods_id','left')
        ->field('nsoar.*, nog.goods_id, nog.goods_name, nog.order_status, nog.num ')
        ->where($condition)
        ->sum("nsoar.platform_refund_money");
        return $sales_num;
    } 
}