<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : imxml.php
 * ....Ntalker接口
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Fri May 15 09:13:58 CST 2009
 */

require_once('../../global.inc.php');

class imClass extends CommonFrameWork  {
	var $querytype;
	var $querysid;
	var $queryusername;
	var $queryuserid;
	var $querysrcuid;
	var $newbuddyname;
	var $newbuddyid;
	var $delbuddyid;
	
	function main(){
		//语言包
		$this->getlang("ntalker");
		echo ("<?xml version='1.0' encoding='". $this->_configinfo['websit']['ncharset'] ."'?>");
		echo ("<imxml  encoding='". $this->_configinfo['websit']['ncharset'] ."'>");
		
		$this->querytype = isset ( $this->_input['query'] ) ? $this->_input['query'] : null;
		$this->querysid = isset ( $this->_input['sid'] ) ? $this->_input['sid'] : null;
		$this->queryusername = isset ( $this->_input['username'] ) ? $this->_input['username'] : null;
		$this->queryuserid = isset ( $this->_input['uid'] ) ? $this->_input['uid'] : null;
		$this->querysrcuid = isset ( $this->_input['srcuid'] ) ? $this->_input['srcuid'] : null;
		$this->newbuddyname = isset ( $this->_input['newbuddyname'] ) ? $this->_input['newbuddyname'] : null;
		$this->newbuddyid = isset ( $this->_input['newbuddyid'] ) ? $this->_input['newbuddyid'] : null;
		$this->delbuddyid = isset ( $this->_input['delbuddyid'] ) ? $this->_input['delbuddyid'] : null;
		if (! $this->querytype) {
			echo ("<error>no valid query param</error>");
			echo ("</imxml>");
			return;
		}
		
		switch ($this->querytype){
			case 'imxmlversion':
				$this->_imxmlversion();
				break;
			case 'login':
				$this->_login();
				break;
			case 'userprofile':
				$this->_userprofile();
				break;
			case 'buddylist':
				$this->_buddylist();
				break;
			case 'addbuddy':
				$this->_addbuddy();
				break;
			case 'delbuddy':
				$this->_delbuddy();
				break;
			case 'confirmbuddy':
				$this->_confirmbuddy();
				break;
			case 'useractivity':
				$this->_useractivity();
				break;
			case 'buddylistactivity':
				$this->_buddylistactivity();
				break;
			case 'siteactivity':
				$this->_siteactivity();
				break;
			case 'reversebuddylist':
				$this->_reversebuddylist();
				break;
			case 'visitorlist'://uch
				$this->_visitorlist();
				break;
			case 'notifyimaction':
				$this->_notifyimaction();
				break;
			case 'siteprofile':
				$this->_siteprofile();
				break;
		}
		echo ("</imxml>");
	}
	
	/**
	 * 功能：返回imxml接口的版本号
	 */
	function _imxmlversion(){
		echo "<version>2.0.0</version>";
  		echo "<for>ShopNC ". $this->_systeminfo['version']['revision'] ."</for>";
  		echo "<build>20090317</build>";
	}
	
	/**
	 * 功能：验证用户是否登陆
	 */
	function _login(){
		$this->_check_login();
	}
	
	/**
	 * 功能：查看用户个人信息
	 */
	function _userprofile(){
		$this->_check_login();
		if (intval($this->_input['destid']) > 0){
			$member_info = $this->_get_member_info($this->_input['destid']);
			echo "<userprofile>";
			echo "<uid>". $member_info['member_id'] ."</uid>";
			echo "<name>". $member_info['login_name'] ."</name>";
			echo "<nick/>";
			echo "<icon/>";
			echo "<privacy>0</privacy>";
			echo "<usergroup/>";
			echo "<isshowemail>true</isshowemail>";
			echo "<email>". $member_info['email'] ."</email>";
			echo "<profileinfo/>";
			echo "<profileurl>".$this->_configinfo['websit']['site_url'].'/store/index.php?userid='.$member_info['member_id']."</profileurl>";
			echo "<isshowprofile>false</isshowprofile>";
			echo "<money/>";
			$sex = ($member_info['gender']=='m')?'male':'female';
			echo "<sex>". $sex ."</sex>";
			echo "<bday>". $member_info['birthday'] ."</bday>";
			echo "<country/>";
			echo "<province/>";
			echo "<city/>";
			echo "<signature/>";
			echo "<userapp>";
			echo "	<userapp1>";
			echo "		<name>". $this->_lang['langWebImViewHisShop'] ."</name>";
			echo "		<url>".$this->_configinfo['websit']['site_url'].'/store/index.php?userid='.$member_info['member_id']."</url>";
			echo "		<icon />";
			echo "	</userapp1>";
			echo "	<userapp2>";
			echo "		<name>". $this->_lang['langWebImViewHisProduct'] ."</name>";
			echo "		<url>".$this->_configinfo['websit']['site_url'].'/home/product.php?shopname='.$member_info['login_name']."</url>";
			echo "		<icon />";
			echo "	</userapp2>";
			echo "</userapp>";
			echo "<myapp>";
			echo "	<myapp1>";
			echo "		<name>". $this->_lang['Product'] ."</name>";
			echo "		<url>".$this->_configinfo['websit']['site_url'].'/member/own_shop.php?action=view'."</url>";
			echo "		<icon />";
			echo "	</myapp1>";
			echo "	<myapp2>";
			echo "		<name>" . $this->_lang['langWebImViewMyProduct'] . "</name>";
			echo "		<url>".$this->_configinfo['websit']['site_url'].'/member/own_product_list.php?action=list'."</url>";
			echo "		<icon />";
			echo "	</myapp2>";
			echo "</myapp>";
			echo "</userprofile>";
		}
	}
	
	/**
	 * 功能：获取好友列表的信息
	 */
	function _buddylist(){}
	
	/**
	 * 功能：添加好友
	 */
	function _addbuddy(){}
	
	/**
	 * 功能：删除好友
	 */
	function _delbuddy(){}
	
	/**
	 * 功能：处理好友请求
	 */
	function _confirmbuddy(){}
	
	/**
	 * 功能：查询在线聊友的最近动态，包括发帖、回帖、上传照片等
	 */
	function _useractivity(){
		require_once("commonpage.class.php");
		$obj_page = new CommonPage();
		require_once('product.class.php');
		$obj_product = new ProductClass();
		$condition['member'] = $this->_input['destid'];
		$condition['order'] = 'p_start_time';
		$obj_page->pagebarnum(10);
		$product_array = $obj_product->getProductList($obj_condition,$obj_page,'member');
		echo "<useractivity>";
		if (is_array($product_array)){
			foreach ($product_array as $k => $v){
				echo "<activity>";
				echo "	<uid>" . $v['member_id'] . "</uid>";
				echo "	<name>" . $v['shopmaster'] . "</name>";
				echo "	<type>" . $this->_lang['langWebImProduct'] . "</type>";
				echo "	<title>" . $v['p_name'] . "</title>";
				echo "	<content>" . $v['p_name'] . "</content>";
				echo "	<time>". date("Y-m-d",$v['p_start_time']) ."</time>";
				$html_url = "/html/user/".$v['pc_id']."/item_detail-".$v['p_code'].'.html';
				if ($this->_configinfo['productinfo']['ifhtml'] == '1' && file_exists(BasePath.$html_url)){
					$url = $this->_configinfo['websit']['site_url'].$html_url;
				}else {
					$url = $this->_configinfo['websit']['site_url'].'/home/product.php?action=view&pid='.$v['p_code'];
				}
				echo "	<url>". $url ."</url>";
				if ($v['p_pic'] != ''){
					echo "	<image>" . $this->_configinfo['websit']['site_url'] .'/'.$v['small_pic'] . "</image>";
				}else {
					echo "	<image/>";
				}
				echo "</activity>";
				unset($html_url,$url);
			}
		}
		echo "</useractivity>";
		unset($obj_page,$obj_product);
	}
	
	/**
	 * 功能：查询所有好友的最近动态，包括发帖、回帖、上传照片等
	 */
	function _buddylistactivity(){
		require_once("commonpage.class.php");
		$obj_page = new CommonPage();
		require_once('product.class.php');
		$obj_product = new ProductClass();
		$condition['order'] = 'p_start_time';
		$obj_page->pagebarnum(10);
		$product_array = $obj_product->getProductList($obj_condition,$obj_page,'member');
		echo "<buddylistactivity>";
		if (is_array($product_array)){
			foreach ($product_array as $k => $v){
				echo "<activity>";
				echo "	<uid>" . $v['member_id'] . "</uid>";
				echo "	<name>" . $v['shopmaster'] . "</name>";
				echo "	<type>" . $this->_lang['langWebImProduct'] . "</type>";
				echo "	<title>" . $v['p_name'] . "</title>";
				echo "	<content>" . $v['p_name'] . "</content>";
				echo "	<time>". date("Y-m-d",$v['p_start_time']) ."</time>";
				$html_url = "/html/user/".$v['pc_id']."/item_detail-".$v['p_code'].'.html';
				if ($this->_configinfo['productinfo']['ifhtml'] == '1' && file_exists(BasePath.$html_url)){
					$url = $this->_configinfo['websit']['site_url'].$html_url;
				}else {
					$url = $this->_configinfo['websit']['site_url'].'/home/product.php?action=view&pid='.$v['p_code'];
				}
				echo "	<url>". $url ."</url>";
				if ($v['p_pic'] != ''){
					echo "	<image>" . $this->_configinfo['websit']['site_url'] .'/'.$v['small_pic'] . "</image>";
				}else {
					echo "	<image/>";
				}
				echo "</activity>";
				unset($html_url,$url);
			}
		}
		echo "</buddylistactivity>";
		unset($obj_page,$obj_product);
	}
	
	/**
	 * 功能：查询网站的最近动态，包括热帖、新帖
	 */
	function _siteactivity(){
		require_once("commonpage.class.php");
		$obj_page = new CommonPage();
		require_once('product.class.php');
		$obj_product = new ProductClass();
		$condition['order'] = 'p_start_time';
		$obj_page->pagebarnum(10);
		$product_array = $obj_product->getProductList($obj_condition,$obj_page,'member');
		echo "<newactivity>";
		if (is_array($product_array)){
			foreach ($product_array as $k => $v){
				echo "<activity>";
				echo "	<uid>" . $v['member_id'] . "</uid>";
				echo "	<name>" . $v['shopmaster'] . "</name>";
				echo "	<type>" . $this->_lang['langWebImProduct'] . "</type>";
				echo "	<title>" . $v['p_name'] . "</title>";
				echo "	<content>" . $v['p_name'] . "</content>";
				echo "	<time>". date("Y-m-d",$v['p_start_time']) ."</time>";
				$html_url = "/html/user/".$v['pc_id']."/item_detail-".$v['p_code'].'.html';
				if ($this->_configinfo['productinfo']['ifhtml'] == '1' && file_exists(BasePath.$html_url)){
					$url = $this->_configinfo['websit']['site_url'].$html_url;
				}else {
					$url = $this->_configinfo['websit']['site_url'].'/home/product.php?action=view&pid='.$v['p_code'];
				}
				echo "	<url>". $url ."</url>";
				if ($v['p_pic'] != ''){
					echo "	<image>" . $this->_configinfo['websit']['site_url'] .'/'.$v['small_pic'] . "</image>";
				}else {
					echo "	<image/>";
				}
				echo "</activity>";
				unset($html_url,$url);
			}
		}
		echo "</newactivity>";
		unset($obj_page,$obj_product);
	}
				
	/**
	 * 返回反向好友列表的信息，格式与buddylist接口完全一致（只去除buddygroup子节点）
	 */
	function _reversebuddylist(){}
			
	/**
	 * 返回我的空间访客列表的信息
	 */
	function _visitorlist(){}
	
	/**
	 * 功能：将用户在IM上积分转换为网站积分
	 */
	function _notifyimaction(){}
		
	/**
	 * 返回网站的配置信息
	 */
	function _siteprofile(){
		echo "<havebuddylist>false</havebuddylist>";
		echo "<isbuddyboth>false</isbuddyboth>";
		echo "<emailofflinemessage>false</emailofflinemessage>";
		echo "<forbiddenwordslist/>";
		echo "<domainlogolarge></domainlogolarge>";
		echo "<software>custom</software>";
		echo "<softwareversion>". $this->_systeminfo['version']['revision'] ."</softwareversion>";
		echo "<language>".strtolower($this->_configinfo['websit']['ncharset'])."</language>";
	}
	
	/**
	 * 验证会员登录状态
	 */
	function _check_login(){
		require_once('member.class.php');
		$obj_member = new MemberClass();
		$member_array = $obj_member->getMemberInfo(array('id'=>$this->queryuserid));
		if (!empty($member_array)){
			echo "<sessionvalide>true</sessionvalide>";
		}else {
			echo "<sessionvalide>false</sessionvalide>";
			if ($this->querytype == 'useractivity'){
				echo "<userkeyvalide/>";
			}
		}
		unset($obj_member,$member_array);
	}
	
	/**
	 * 取会员信息
	 */
	function _get_member_info($member_id){
		require_once('member.class.php');
		$obj_member = new MemberClass();
		$member_array = $obj_member->getMemberInfo(array('id'=>$member_id),'*','more');
		unset($obj_member);
		return $member_array;
	}
}

$im_manage = new imClass();
$im_manage->main();
unset($im_manage);
?>