<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : ntalker.php
 * ....ntalker 前台调用文件
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Tue May 19 15:48:02 CST 2009
 */
//session_start();
require ("../../global.inc.php");

class imConfigClass extends CommonFrameWork {
	/**
	 * 取会员信息
	 */
	function getMemberSessionInfo(){
		//判断插件是否能使用
		require_once("app_module.class.php");
		$obj_app_class = new AppModuleClass();
		$app_array = $obj_app_class->getAppModuleRowBySign('ntalker');
		unset($obj_app_class);
		if ($app_array['app_module_state'] == '0' && $app_array['app_module_install'] == '1'){
			$member_info = array();
			$member_info['uid'] = $_SESSION['s_login']['id'];
			$member_info['username'] = $_SESSION['s_login']['name'];
			$member_info['sessionid'] = session_id();
			return $member_info;
		}else {
			return false;
		}
	}
	
	/**
	 * 返回配置信息
	 */
	function _get_config_info(){
		return $this->_configinfo;
	}
}

/**
 * 取会员内容
 */
$im_config_class = new imConfigClass();
$member_info = $im_config_class->getMemberSessionInfo();
if ($member_info === false){
	exit;
}
$myuid = $member_info['uid'];
$myusername = $member_info['username'];
$mysessionid = $member_info['sessionid'];
//取配置文件
$config_info = $im_config_class->_get_config_info();
/**
 * 数据缓存
 */
require_once ('Cache/Lite.php');
//设置缓存参数，缓存目录为当前目录下tmp，请保证tmp目录可读写，缓存时间设为1天
$now = time ();
$options = array ('automaticSerialization' => 'true', 'cacheDir' => './tmp/', 'lifeTime' => $config_info['cookie']['cookie_expire'] );
$catchid = "onlineuserscache";
$Cache_Lite = new Cache_Lite ( $options );
if ($usersdata = $Cache_Lite->get( $catchid )) { //找到缓存对象，则从其中查找访问者数据
	if (isset ( $usersdata [$myuid] )) { //如果找到访问者ID对应的缓存数据，则更新访问时间参数
		$usersdata [$myuid] ["updatetime"] = $now;
	} else { //如果没有找到访问者ID对应的缓存数据，则生成该用户数据，放入缓存
		$usersdata [$myuid] = array ();
		$usersdata [$myuid] ["uid"] = $myuid;
		$usersdata [$myuid] ["username"] = $myusername;
		$usersdata [$myuid] ["createtime"] = $now;
		$usersdata [$myuid] ["updatetime"] = $now;
		$usersdata [$myuid] ["userip"] = $_SERVER ["REMOTE_ADDR"];
	}
} else { //没有找到缓存数据，则生成缓存对象
	$usersdata = array ();
	$usersdata [$myuid] = array ();
	$usersdata [$myuid] ["uid"] = $myuid;
	$usersdata [$myuid] ["username"] = $myusername;
	$usersdata [$myuid] ["createtime"] = $now;
	$usersdata [$myuid] ["updatetime"] = $now;
	$usersdata [$myuid] ["userip"] = $_SERVER ["REMOTE_ADDR"];
}
//枚举当前站内所有用户列表
$newusersdata = array ();
foreach ( $usersdata as $key => $userdata ) {
	$newusersdata [$key] = $userdata;
	if ($userdata ["updatetime"] + $im_keeponline_time < $now) { //删除已经掉线的用户
		unset ( $array [$key] );
	} else { //在先用户如果不是本人，则显示用户在线图标，可以点击进行聊天
		//保存所有有效用户到新的数组$newusersdata中去，新数组中删除了已经掉线用户
		$newusersdata [$key] = $userdata;
	}
}
$Cache_Lite->save ( $newusersdata, $catchid );
/**
 * ntalker输出内容
 */
require_once('imconfig.inc.php');
?>
document.write('<script language="javascript" type="text/javascript">');
document.write("im_connectIM('<?php echo $im_siteid; ?>','<?php echo $myuid; ?>', '<?php echo $myusername; ?>', '<?php echo $mysessionid; ?>', '','');");
document.write('<'+'/script>');