<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : area.class.php   FILE_PATH : \multishop\classes\application\shop_pay.class.php
 * ....空间管理
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net
 * @author ShopNC Develop Team 
 * @package
 * @subpackage
 * @version Tue Jun 29 15:02:45 CST 2008
 */

class spaceClass extends FrameWork {
	/**
	 * 空间用户列表
	 *
	 * @param array $condition
	 * @param $obj_page
	 * @return array
	 */
	function getSpaceList( $condition, $obj_page ){
		$condition_str = $this->_conditionSpaceSearch( $condition );
		$space_array = $GLOBALS['db']->GetList($condition_str,&$obj_page,"space","*",0,"opendate desc");
		return $space_array;
	}	
	/**
	 * 构造空间检索条件
	 *
	 * @param array $condition
	 * @return string
	 */
	function _conditionSpaceSearch ( $condition ) {
		$condition_str = "";
		//按照用户名
		if ( $condition['search_type'] == "username" ) {
			$condition_str .= " where username like '%" . trim( $condition['keywords'] ) . "%'";
		}
		//按照空间名称
		if ( $condition['search_type'] == "spacename" ) {
			$condition_str .= " where spacename like '%" . trim( $condition['keywords'] ) . "%'";
		}		
		return $condition_str;
	}
	/**
	 * 统计分类下的日志数量
	 *
	 * @param int $uid
	 * @return array/boolean
	 */
	function countBlogNum ( $uid ) {
		if ( intval( $uid ) > 0 ) {
			return $GLOBALS['db']->GetJoinList(&$obj_page,array("space_category","space_blog"),"left join",array("space_blog.category = space_category.caid"),array('caid','count(*) as num'),"where space_blog.uid = '" . $uid . "'",0,array(),array("caid",""));			
		} else {
			return false;
		}
	}
	/**
	 * 删除日志分类
	 *
	 * @param int $id
	 * @param int $uid
	 * @return boolean
	 */
	function delCategory ( $id, $uid ) {
		if ( intval( $id ) > 0 && intval( $uid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($id,"space_category","caid"," and uid = '" . $uid . "' ");
		} else {
			return false;
		}
					
	}
	/**
	 * 编辑分类
	 *
	 * @param array $input
	 * @return boolean
	 */
	function updateCategory ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['name']	= $input['txtName'];
			return $GLOBALS['db']->UpdateRows("space_category", $valueArray, "uid = '" . intval ( $input['uid'] ) . "' and caid = '" . intval( $input['caid'] ) . "'");			
		} else {
			return false;
		}
	}
	/**
	 * 获取分类信息
	 *
	 * @param int $uid
	 * @param int $id
	 * @param string $fields
	 * @return array
	 */
	function getCategory ( $id, $uid, $fields="*" ) {
		if ( intval( $id ) > 0 && intval( $uid ) > 0 ) {
			$category_array = $GLOBALS['db']->GetTheRow("where uid = '" . $uid . "' and caid = '" . $id . "'","space_category",$fields);
			return $category_array;					
		} else {
			return false;
		}
	}
	/**
	 * 日志分类列表
	 *
	 * @param int $uid
	 * @param int $obj_page
	 * @return array
	 */
	function getCategoryList ( $uid, $obj_page ) {
		if ( intval( $uid ) > 0 ) {
			$category_array = $GLOBALS['db']->GetList("where uid in ($uid)",&$obj_page,"space_category","*",0,"dateline desc");
			return $category_array;			
		} else {
			return false;
		}
	}
	/**
	 * 添加日志分类
	 *
	 * @param arrray $input
	 * @return boolean
	 */
	function addCategory ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid'] = $input['uid'];
			$valueArray['name'] = $input['txtName'];
			$valueArray['dateline'] = time();
			return $GLOBALS['db']->InsertRow ( $valueArray, 'space_category', 'caid' ) ;			
		} else {
			return false;
		}
	}
	/**
	 * 删除收藏
	 *
	 * @param int $id
	 * @param int $uid
	 * @return boolean
	 */
	function delCollection ( $id, $uid ) {
		if ( intval( $id ) > 0 && intval( $uid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($id,"space_collection","collid"," and myuid = '" . $uid . "' ");	
		} else {
			return false;
		}
	}
	/**
	 * 获取收藏列表
	 *
	 * @param int $uid
	 * @param obj $obj_page
	 * @return array
	 */
	function getCollectionList ( $uid, $obj_page ) {
		if ( intval( $uid ) > 0 ) {
			$collection_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_collection","space"),"inner join",array("space_collection.uid=space.uid"),array("*","username"),"where space_collection.myuid = '" . $uid . "'",0,array("dateline desc"));		
			return $collection_array;				
		} else {
			return false;
		}
	}
	/**
	 * 获取收藏信息
	 *
	 * @param int $id
	 * @param string $idtype
	 * @param int $myuid
	 * @param string $fields
	 * @return array
	 */
	function getCollection ( $id, $idtype, $myuid, $fields="*" ) {
		if ( intval ( $id ) > 0 && intval( $myuid ) > 0 ) {
			$collection_array = $GLOBALS['db']->GetTheRow("where id = '" . $id . "' and idtype = '" . trim( $idtype ) . "' and myuid = '" . $myuid . "'","space_collection",$fields);
			return $collection_array;				
		} else {
			return false;	
		}
	}
	/**
	 * 收藏
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addCollection ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid'] = $input['id'];
			$valueArray['id'] = $input['id'];
			$valueArray['myuid'] = $input['myuid'];
			$valueArray['idtype'] = $input['type'];
			$valueArray['dateline'] = time();
			return $GLOBALS['db']->InsertRow ( $valueArray, 'space_collection', 'collid' ) ;				
		} else {
			return false;
		}	
	}
	/**
	 * 统计评论
	 *
	 * @param int $id
	 * @return int
	 */
	function countComment ( $id ) {
		if ( intval( $id ) > 0 ) {
			return $GLOBALS['db']->CountRows("space_comment", "id = '" . $id . "'");			
		} else {
			return false;
		}
	}
	/**
	 * 删除一条评论
	 *
	 * @param int $id
	 * @param int $uid
	 * @return boolean
	 */
	function delSpaceComment ( $id, $uid ) {
		if ( intval( $id ) > 0 && intval( $uid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($id,"space_comment","cid"," and (uid = '" . $uid . "' or authorid = '" . $uid . "') ");		
		} else {
			return false;
		}
	}
	/**
	 * 删除一条评论(系统)
	 *
	 * @param int $cid
	 * @return boolean
	 */
	function delSpaceCommentSys ( $cid ) {
		if ( intval( $cid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($cid,"space_comment","cid");				
		} else {
			return false;
		}
	}		
	/**
	 * 获取一条评论
	 *
	 * @param int $id
	 * @param string $fields
	 * @return array
	 */
	function getOneCommnet ( $id, $fields="*" ) {
		if ( intval( $id ) > 0 ) {
			$comment_array = $GLOBALS['db']->GetTheRow("where cid = '" . $id . "'","space_comment",$fields);
			return $comment_array;				
		} else {
			return false;
		}
	}
	/**
	 * 获取评论列表
	 *
	 * @param int $id
	 * @param obj $obj_page
	 * @return array
	 */
	function getCommentList ( $id, $obj_page ) {
		if ( intval( $id ) > 0 ) {
			$comment_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_comment","member","space"),"left join",array("space_comment.authorid=member.member_id","space_comment.authorid=space.uid"),array("*","login_name","picture"),"where space_comment.id = '" . $id . "'",0,array("dateline desc"));		
			return $comment_array;			
		} else {
			return false;
		}
	}
	/**
	 * 增加评论
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addCommnet ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid'] = $input['uid'];
			$valueArray['id'] = $input['id'];
			$valueArray['authorid'] = $input['authorid'];
			$valueArray['author'] = $input['author'];
			$valueArray['ip'] = $input['ip'];
			$valueArray['dateline'] = time();
			$valueArray['message'] = $input['message'];
			return $GLOBALS['db']->InsertRow ( $valueArray, 'space_comment', 'cid' ) ;				
		} else {
			return false;
		}
	}
	/**
	 * 获取推荐商品
	 *
	 * @param string $ids
	 * @param string $fields
	 * @param object $obj_page
	 * @return array/boolean
	 */
	function getCommnedProdut ( $ids, $fields="*", $obj_page="" ) {
		if ( $ids != '' ) {
			$product_array = $GLOBALS['db']->GetList("where p_id in ($ids)",&$obj_page,"product",$fields="*");
			return $product_array;				
		} else {
			return false;
		}
	}
	/**
	 * 近期访客列表
	 *
	 * @param int $uid
	 * @param int $num
	 * @param object $obj_page
	 * @return array/boolean
	 */
	function getIndexVisitorList ( $uid, $num=12, $obj_page="" ) {	
		if ( intval( $uid ) > 0 ) {
			$visitor_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_visitor","member","space"),"left join",array("space_visitor.vuid=member.member_id","space_visitor.vuid=space.uid"),array("*","login_name","picture"),"where space_visitor.uid = '" . $uid . "'",$num,array("dateline desc"));
			return $visitor_array;				
		} else {
			return false;
		}
	}
	/**
	 * 更新访问记录的时间
	 *
	 * @param int $uid
	 * @param int $vuid
	 * @return boolean
	 */
	function updateSapceVisitor ( $uid, $vuid ) {
		if ( intval( $uid ) > 0 && intval( $vuid ) > 0 ) {
			return $GLOBALS['db']->UpdateRows("space_visitor", array( "dateline" => time() ), "uid = '" . $uid . "' and vuid = '" . $vuid . "'");
		} else {
			return false;
		}
	}
	/**
	 * 根据uid, vuid获取访问记录
	 *
	 * @param int $uid
	 * @param int $vuid
	 * @param string $fields
	 * @return array/boolean
	 */
	function getSpaceVisitor ( $uid, $vuid, $fields="*" ) {
		if ( intval( $uid ) > 0 && intval( $vuid ) > 0 ) {
			$visitor_array = $GLOBALS['db']->GetTheRow("where uid = '" . $uid . "' and vuid = '" . $vuid . "'","space_visitor",$fields);
			return $visitor_array;	
		} else {
			return false;
		}
	}
	/**
	 * 增加访问者记录
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addSapceVisitor ( $input ) {
		if ( is_array( $input ) &&  intval( $input['uid'] ) > 0 ) {
			$valueArray = array();
			$valueArray['uid'] 	= $input['uid'];	//被访问uid
			$valueArray['vuid'] = $input['vuid'];	//访问者uid
			$valueArray['vusername'] = $input['vusername'];	//访问者用户名
			$valueArray['dateline'] = time();	//访问日期
			return $GLOBALS['db']->InsertRow ( $valueArray, 'space_visitor', 'uid' ) ;				
		} else {
			return false;
		}
	}
	/**
	 * 更新空间信息
	 *
	 * @param int $uid
	 * @param array $input
	 * @return boolean	 
	 */
	function updateSpace ( $uid, $input ) {
		if ( intval( $uid ) > 0 && is_array( $input )) {
			$valueArray = array();
			if ( is_array ( $input ) ) {
				foreach ( $input as $k => $v ) {
					if ( $v != '' ) {
						$valueArray[$k] = $v;
					}
				}
			}
			return $GLOBALS['db']->UpdateRow($uid, $valueArray, "space", "uid");			
		} else {
			return false;
		}
	}
	/**
	 * 更新访问人数
	 *
	 * @param int $uid
	 * @return boolean
	 */
	function updateSpaceView ( $uid ) {
		if ( intval( $uid ) > 0 ) {
			$valueArray = array();
			$valueArray = array("visitday"=>"visitday + 1","visitsum"=>"visitsum + 1");
			return $GLOBALS['db']->UpdateRows('space',$valueArray," uid = '" . $uid . "'","formula");			
		} else {
			return false;
		}
	}
	/**
	 * 获取会员信息
	 *
	 * @param int $uid
	 * @param string $fields
	 * @return array/boolean
	 */
	function getMemberInfo ( $uid, $fields="*" ) {
		if ( intval( $uid ) > 0 ) {
			$member_array = $GLOBALS['db']->GetTheRow("where member_id = '" . $uid . "'","member",$fields);
			return $member_array;			
		} else {
			return false;
		}
	}
	/**
	 * 添加空间信息
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addSpace ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid'] 	= $input['uid'];	//uid
			$valueArray['username'] 	= $input['username'];	//用户名
			$valueArray['spacename'] 	= $input['spacename'];	//空间名称
			$valueArray['idiograph'] 	= $input['idiograph'];	//个性签名
			$valueArray['opendate'] 	= time();	//开通日期
			$result = $GLOBALS['db']->InsertRow ( $valueArray, 'space', 'uid' ) ;
			return $result;			
		} else {
			return false;
		}
	}
	/**
	 * 获取空间信息(根据uid或用户名)
	 *
	 * @param int/string $nameorid
	 * @param sting $fields
	 * @param int $type
	 * @return array/boolean
	 */
	function getSpaceInfo ( $nameorid, $fields="*", $type=0 ) {
		if ( $type == 1 ) {
			if ( $nameorid != '' ) {
				$space_array = $GLOBALS['db']->GetTheRow("where username = '" . $nameorid . "'","space",$fields);
				return $space_array;					
			} else {
				return false;
			}
		} else {
			if ( intval( $nameorid ) > 0 ) {
				$space_array = $GLOBALS['db']->GetTheRow("where uid = '" . $nameorid . "'","space",$fields);
				return $space_array;				
			} else {
				return false;
			}			
		}	
	}
	/**
	 * 解除好友关系
	 *
	 * @param int $id
	 * @return boolean
	 */
	function delFriend ( $id ) {
		if ( intval( $uid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow(intval( $id ),"space_friend","id");			
		} else {
			return false;
		}
	}
	/**
	 * 获得符合条件的好友记录id
	 *
	 * @param array $condition
	 * @param string $fields
	 * @return array/boolean
	 */
	function getFriendInfoId ( $condition, $fields="*" ) {
		if ( is_array( $condition ) && intval( $condition['uid'] ) > 0 && intval( $condition['friendid'] ) > 0 ) {
			$friend_array = $GLOBALS['db']->GetTheRow(" where uid = '" . $condition['uid'] . "' and friendid = '" . $condition['friendid'] . "' ","space_friend",$fields);
			return $friend_array['id'];			
		} else {
			return false;
		}
	}	
	/**
	 * 更新好友验证状态
	 *
	 * @param int $id
	 * @param int $status
	 * @return boolean
	 */
	function updateFriendStatus ( $id, $status ) {
		if ( intval( $id ) > 0 ) {
			$result = $GLOBALS['db']->UpdateRow($id, array( 'status' => $status ), "space_friend", "id");
			return $result;			
		} else {
			return false;
		}
	}
	/**
	 * 好友请求列表
	 *
	 * @param int $uid
	 * @param obj $obj_page
	 * @return array/boolean
	 */
	function getSpaceFriendInviteList ( $uid, $obj_page ) {
		if ( intval( $uid ) > 0 ) {
			$friend_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_friend","member"),"inner join",array("space_friend.friendid=member.member_id"),array("*","login_name"),"where space_friend.uid='" . $uid . "' and space_friend.status = 0");
			return $friend_array;			
		} else {
			return false;
		}
	}	
	/**
	 * 好友列表
	 *
	 * @param int $uid
	 * @param obj $obj_page
	 * @return array/boolean
	 */
	function getSpaceFriendList ( $uid, $obj_page="" ) {
		if ( intval( $uid ) > 0 ) {
			$friend_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_friend","space","member"),"left join",array("space_friend.friendid=space.uid","space_friend.friendid=member.member_id"),array("*","picture"),"where space_friend.uid='" . $uid . "' and space_friend.status = 1");
			return $friend_array;
		} else {
			return false;
		}
	}
	/**
	 * 根据id获取好友信息
	 *
	 * @param int $id
	 * @param string $fields
	 * @return array/boolean
	 */
	function getFriendInfo ( $id, $fields="*" ) {
		if ( intval( $id ) > 0 ) {
			$friend_array = $GLOBALS['db']->GetTheRow("where id = '" . $id . "'","space_friend",$fields);
			return $friend_array;			
		} else {
			return false;
		}
	}
	/**
	 * 添加好友
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addSpaceFriend ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid'] 	= $input['uid'];	//uid
			$valueArray['friendid'] 	= $input['friendid'];	//好友uid
			$valueArray['fusername'] 	= $input['fusername'];	//好友用户名
			$valueArray['note'] 	= $input['txtNote'];	//附言
			if ( $input['status'] != '' ) {
				$valueArray['status'] 	= $input['status'];	//状态
			}
			$valueArray['dateline'] 	= time();	//日期
			$result = $GLOBALS['db']->InsertRow ( $valueArray, 'space_friend', 'id' ) ;
			return $result;				
		} else {
			return false;
		}
	}
	/**
	 * 更新留言
	 *
	 * @param int $messageid
	 * @param array $input
	 * @return boolean
	 */
	function updateSpaceMessage ( $messageid, $input ) {
		if ( intval( $messageid ) > 0 && is_array( $input ) ) {
			$valueArray = array();
			$valueArray['subject'] = $input['subject'];
			$result = $GLOBALS['db']->UpdateRow($messageid, $valueArray, "space_message", "messageid");	
			return $result;			 
		} else {
			return false;
		}
	}
	/**
	 * 根据messageid获取留言信息
	 *
	 * @param int $messageid
	 * @param string $fields
	 * @return array/boolean
	 */
	function getSpaceMessage ( $messageid ) {
		if ( intval( $messageid ) > 0 ) {
			$message_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_message","member"),"inner join",array("space_message.send = member.member_id"),array("*","login_name"),"where messageid = '" . $messageid . "'");
			return $message_array;				 
		} else {
			return false;
		}
	}
	/**
	 * 删除留言
	 *
	 * @param array $input
	 * @return boolean
	 */
	function delMessage ( $input ) {
		if ( intval( $input['id'] ) > 0 && intval( $input['receive'] ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($input['id'],"space_message","messageid"," and receive='" . $input['receive'] . "'");			
		} else {
			return false;
		}
	}
	/**
	 * 删除一条留言(系统)
	 *
	 * @param int $messageid
	 * @return boolean
	 */
	function delSpaceMessageSys ( $messageid ) {
		if ( intval( $messageid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($messageid,"space_message","messageid");				
		} else {
			return false;
		}
	}		
	/**
	 * 留言列表
	 *
	 * @param int $uid
	 * @param obj $obj_page	  
	 * @return array/boolean
	 */
	function getMessageList ( $uid, $obj_page="" ) {
		if ( intval( $uid ) > 0 ) {
			$message_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_message","member","space"),"left join",array("space_message.send = member.member_id","space_message.send = space.uid"),array('*',"login_name","picture"),"where receive = '" . $uid . "'",10,array("dateline desc"));
			return $message_array;			
		} else {
			return false;
		}
	}
	/**
	 * 添加留言
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addSpaceMessage ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['subject'] 	= $input['subject'];	//内容
			$valueArray['send'] 	= $input['send'];	//发送人		
			$valueArray['receive'] 	= $input['receive'];	//接收人		
			$valueArray['dateline'] 	= time();	//日期
			$result = $GLOBALS['db']->InsertRow ( $valueArray, 'space_message', 'messageid' ) ;
			return $result;				
		} else {
			return false;
		}
	}
	/**
	 * 统计日志阅读次数
	 *
	 * @param int $blogid
	 * @return boolean
	 */
	function countBlogView ( $blogid ) {
		if ( intval( $blogid ) > 0 ) {
			$valueArray = array();
			$valueArray = array("viewnum"=>"viewnum + 1");
			return $GLOBALS['db']->UpdateRows('space_blog',$valueArray," blogid = '" . $blogid . "'","formula");			
		} else {
			return false;
		}
	}
	/**
	 * 编辑日志
	 *
	 * @param array $input
	 * @return boolean
	 */
	function updateSapceBlog ( $input ) {
		if ( is_array( $input ) && intval( $input['blogid'] ) > 0 ) {
			$valueArray = array();
			$valueArray['title'] 	= $input['txtTitle'];	//标题
			$valueArray['subject'] 	= $input['txtSubject'];	//内容
			$valueArray['classid'] 	= 0;	//类别
			if ( $input['product'] != '' ) {
				$valueArray['productid'] = implode( ",", $input['product'] );
				$valueArray['classid'] 	= 1;
			}		
			if ( $input['category'] != '' ) {
				$valueArray['category'] = $input['category'];	//分类		
			}		
			$result = $GLOBALS['db']->UpdateRow($input['blogid'], $valueArray, "space_blog", "blogid");
			return $result;			
		} else {
			return false;
		}
	}
	/**
	 * 根据blogid,uid获取日志
	 *
	 * @param int $blogid
	 * @param int $uid
	 * @param string $fields
	 * @return array/boolean
	 */
	function getSpaceBlog ( $blogid, $uid="", $fields="*" ) {
		if ( intval( $blogid ) > 0 ) {
			$where = "";
			if ( intval( $uid ) > 0 ) {
				$where = " and uid = '" . intval ( $uid ) . "'";
			}
			$blog_array = $GLOBALS['db']->GetTheRow("where blogid = '" . intval ( $blogid ) . "' $where ","space_blog",$fields);
			return $blog_array;			
		} else {
			return false;
		}
	}
	/**
	 * 转载日志
	 *
	 * @param  array $input
	 * @return boolean
	 */
	function addSapceBlogReship ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid']		= $input['uid']; //uid
			$valueArray['username']	= $input['username']; //username
			$valueArray['title'] 	= $input['title'];	//标题
			$valueArray['subject'] 	= $input['subject'];	//内容
			$valueArray['classid'] 	= $input['classid'];	//类别
			$valueArray['productid'] 	= $input['productid'];	//精品推荐
			$valueArray['reship'] 	= 1;	//转载标识
			$valueArray['dateline'] = time();	//日期
			$result = $GLOBALS['db']->InsertRow($valueArray, 'space_blog', 'blogid');
			return $result;			
		} else {
			return false;
		}
	}	
	/**
	 * 添加日志
	 *
	 * @param  array $input
	 * @return boolean
	 */
	function addSapceBlog ( $input ) {
		if ( is_array( $input ) ) {
			$valueArray = array();
			$valueArray['uid']		= $input['uid']; //uid
			$valueArray['username']	= $input['username']; //username
			$valueArray['title'] 	= $input['txtTitle'];	//标题
			$valueArray['subject'] 	= $input['txtSubject'];	//内容
			$valueArray['classid'] 	= 0;	//类别
			if ( $input['category'] != '' ) {
				$valueArray['category'] = $input['category'];	//分类		
			}
			$valueArray['dateline'] = time();	//日期
			if ( $input['product'] != '' ) {
				$valueArray['productid'] = implode( ",", $input['product'] );
				$valueArray['classid'] 	= 1;
			}
			$result = $GLOBALS['db']->InsertRow($valueArray, 'space_blog', 'blogid');
			return $result;			
		} else {
			return false;
		}
	}
	/**
	 * 获取首页日志列表
	 *
	 * @param int $uid
	 * @return array
	 */
	function getIndexBlogList ( $uid, $type=0, $obj_page = "" ) {
		if ( intval( $uid ) > 0 ) {
			$blog_array = $GLOBALS['db']->GetList("where uid = '" . $uid . "' and classid = '" . $type . "'",&$obj_page,"space_blog","*",10,"dateline desc");
			return $blog_array;				
		} else {
			return false;
		}
	}
	/**
	 * 日志列表
	 *
	 * @param int $uid
	 * @param obj $obj_page
	 * @return array
	 */
	function getSpaceBlogList ( $uid, $obj_page="", $type=0, $classid="" ) {
		if ( intval( $uid ) > 0 ) {
			$where = "";
			if ( intval( $classid ) > 0 ) {
				$where = " and  space_blog.category = '" . $classid . "' ";
			}
			$blog_array = $GLOBALS['db']->GetJoinList(&$obj_page,array("space_blog","space_category"),"left join",array("space_blog.category=space_category.caid"),array('*','name'),"where space_blog.uid = '" . $uid . "' and space_blog.classid = '" . $type . "' $where ",$count=0,array("dateline desc"));
			return $blog_array;			
		} else {
			return false;
		}
	}
	/**
	 * 删除一条日志
	 *
	 * @param int $blogid
	 * @param int $uid
	 * @return boolean
	 */
	function delSpaceBlog ( $blogid, $uid ) {
		if ( intval( $blogid ) > 0 && intval( $uid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($blogid,"space_blog","blogid"," and uid='" . $uid . "'");				
		} else {
			return false;
		}
	}
	/**
	 * 删除一条日志(系统)
	 *
	 * @param int $blogid
	 * @return boolean
	 */
	function delSpaceBlogSys ( $blogid ) {
		if ( intval( $blogid ) > 0 ) {
			return $GLOBALS['db']->DeleOneRow($blogid,"space_blog","blogid");				
		} else {
			return false;
		}
	}	
	/**
	 * 获取所有日志
	 *
	 * @param object $obj_page
	 * @return array
	 */
	function getBlogAllList ( $condition , $obj_page ) {
		if ( intval( $condition['uid'] ) > 0 ) {
			$condition_str = $this->_conditionBlogSearch( $condition );
			$blog_array = $GLOBALS['db']->GetList($condition_str,&$obj_page,"space_blog","*",0,"dateline desc");
			return $blog_array;					
		} else {
			return false;
		}
	}
	/**
	 * 构造日志检索条件
	 *
	 * @param array $condition
	 * @return string
	 */
	function _conditionBlogSearch ( $condition ) {
		$condition_str = "where uid = '" . $condition['uid'] . "' ";
		//按照日志类型名称
		if ( $condition['classid'] != "" ) {
			$condition_str .= " and classid = '" . intval( $condition['classid'] ) . "'";
		}	
		if ( $condition['keywords'] != "" ) {
			$condition_str .= " and title like '%" . trim( $condition['keywords'] ) . "%'";		
		}
		return $condition_str;
	}
	/**
	 * 获取所有评论
	 *
	 * @param array $condition
	 * @param object $obj_page
	 * @return array
	 */
	function getCommentAllList ( $condition , $obj_page ) {
		if ( intval( $condition['uid'] ) > 0 ) {
			$condition_str = $this->_conditionCommentSearch( $condition );
			$comment_array = $GLOBALS['db']->GetList($condition_str,&$obj_page,"space_comment","*",0,"dateline desc");
			return $comment_array;
			return $blog_array;					
		} else {
			return false;
		}				
	}
	/**
	 * 构造评论检索条件
	 *
	 * @param array $condition
	 * @return string
	 */	
	function _conditionCommentSearch ( $condition ) {
		$condition_str = "where authorid = '" . $condition['uid'] . "'";
		if ( $condition['keywords'] != '' ) {
			$condition_str .= " and message like '%" . trim( $condition['keywords'] ) . "%' ";			
		}	
		return $condition_str;
	}
	/**
	 * 获取所有留言
	 *
	 * @param array $condition
	 * @param object $obj_page
	 * @return array/boolean
	 */	
	function getMessageAllList ( $condition , $obj_page ) {
		if ( intval( $condition['uid'] ) > 0 ) {
			$condition_str = $this->_conditionMessageSearch( $condition );
			$message_array = $GLOBALS['db']->GetList($condition_str,&$obj_page,"space_message","*",0,"dateline desc");
			return $message_array;			
		} else {
			return false;
		}
	}
	/**
	 * 构造留言检索条件
	 *
	 * @param array $condition
	 * @return array
	 */		
	function _conditionMessageSearch ( $condition ) {	
		$condition_str = "where send = '" . $condition['uid'] . "' or receive = '" . $condition['uid'] . "'";
		if ( $condition['keywords'] != '' ) {
			if ( $condition['search_type'] == 'send' ) {
				$condition_str = "where send = '" . $condition['uid'] . "'";
			}
			if ( $condition['search_type'] == 'receive' ) {
				$condition_str = "where receive = '" . $condition['uid'] . "'";
			}						
			$condition_str .= " and subject like '%" . trim( $condition['keywords'] ) . "%' ";			
		}
		return $condition_str;
	}
}
?>