<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php
 * ....空间信息管理
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat May 09 08:40:39 CST 2009
 */

require_once("../../global.inc.php");

class SysSpaceClass extends SystemFrameWork{
	/**
	 * 空间对象
	 *
	 * @var obj
	 */
	var $obj_space;	
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	/**
	 * 应用对象
	 *
	 * @var obj
	 */
	var $obj_app_class;
	function SysSpaceClass(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('space','system','system');
		/**
		 * 模板输出
		 */
		$this->output('app_module',$this->default_app_array);
	}				
	function main () {
		/**
		 * 创建空间对象
		 */
		if (!is_object($this->obj_space)){
			require_once("space.class.php");
			$this->obj_space = new spaceClass();
		}		
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		/**
		 * 创建应用对象
		 */
		if (!is_object($this->obj_app_class)){
			require_once("app_module.class.php");
			$this->obj_app_class = new AppModuleClass();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("ajaxcommonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		switch ( $this->_input['action'] ) {
			case 'del_one_message':
				$this->_del_one_message ();
				break;
			case 'view_message':
				$this->_view_message ();
				break;
			case 'del_message':
				$this->_del_message ();
				break;
			case 'message_list':
				$this->_ajax_list_message ();
				break;
			case 'del_comment':
				$this->_del_comment ();
				break;
			case 'comment_list':
				$this->_ajax_list_comment ();
				break;			
			case 'del_blog':
				$this->_del_blog ();
				break;
			case 'blog_list':
				$this->_ajax_list_blog ();
				break;
			case 'change_state':
				$this->_change_state ();
				break;
			case 'ajax_list':
				$this->_ajax_list_space();
				break;						
			case 'manage_modi':
				$this->_manage_modi();
				break;
			case 'manage_update':
				$this->_manage_update();
				break;							
			case 'setup':
				$this->_setup();
				break;
			case 'setup_save':
				$this->_setup_save();
				break;	
			case 'unsetup':
				$this->_unsetup();
				break;
			case 'unsetup_save':
				$this->_unsetup_save();
				break;						
		}
	}
	/**
	 * 删除一条留言
	 *
	 */
	function _del_one_message () {
		if ( $this->_input['messageid'] != '' ) {
			 if ($this->obj_space->delSpaceMessageSys( intval($this->_input['messageid']) ) ) {
			 	Common::outMessage("json",$this->_lang['langSpaceMessageDeleteSucc'],1);
			 } else {
			 	Common::outMessage("json",$this->_lang['langSpaceMessageDeleteFalse'],0);
			 }
		}
	}
	/**
	 * 查看留言
	 *
	 */
	function _view_message () {
		if ( $this->_input['messageid'] != '' ) {
			//获取留言信息
			$message_array = $this->obj_space->getSpaceMessage ( $this->_input['messageid'] );
			//获取接收人
			$member_array = $this->obj_space->getMemberInfo ( $message_array[0]['receive'], 'login_name'  );
			$message_array[0]['receive'] = $member_array['login_name'];
		}
		/**
		 * 页面输出
		 */
		$this->output( "message_array", $message_array );
		$this->output( 'uid', $this->_input['uid'] );			
		$this->showpage( "sys_message.view" );
	}
	/**
	 * 删除留言(多条)
	 *
	 */
	function _del_message () {
		if ( is_array( $this->_input['messageid'] ) ){
			foreach ( $this->_input['messageid'] as $k => $v ){
				$this->obj_space->delSpaceMessageSys( intval($v) );
			}
			Common::outMessage("json",$this->_lang['langSpaceMessageDeleteSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['langSysSpaceDelMessageSelect'],0);
		}				
	}
	/**
	 * 留言列表
	 *
	 */
	function _ajax_list_message () {
		$condition['uid'] = $this->_input['uid'];	
		$condition['search_type'] = $this->_input['search_type'];					
		$condition['keywords'] = $this->_input['keywords'];			
		//获取留言列表
		$this->obj_page->pagebarnum(10);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$message_array = $this->obj_space->getMessageAllList( $condition, $this->obj_page );
		//时间、搜索关键字处理
		if ( is_array( $message_array ) ) {
			foreach ( $message_array as $k => $v ) {
				$message_array[$k]['dateline'] = date( "Y-m-d", $v['dateline'] );
				$message_array[$k]['subject'] = preg_replace("/(\<[^\<]*\>|\r|\n|\s|\[.+?\])/is", ' ', $message_array[$k]['subject']);		
				$message_array[$k]['subject'] = Common::cutstr ( $message_array[$k]['subject'], 30);
				$message_array[$k]['subject']  = str_replace( array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $message_array[$k]['subject'] );					
			}			
		}
		$page_list = $this->obj_page->show(1);	
		/**
		 * 页面输出
		 */
		$this->output( "message_array", $message_array );
		$this->output('curpage',$this->obj_page->nowindex);
		$this->output('page_list',$page_list);	
		$this->output('condition',$this->_input);
		$this->output('uid',$this->_input['uid']);						
		$this->showpage( "sys_message.list" );			
	}
	/**
	 * 删除评论
	 *
	 */
	function _del_comment () {
		if ( is_array( $this->_input['cid'] ) ){
			foreach ( $this->_input['cid'] as $k => $v ){
				$this->obj_space->delSpaceCommentSys( intval($v) );
			}
			Common::outMessage("json",$this->_lang['langDeleteCommentSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['langSysSpaceDelCommentSelect'],0);
		}		
	}
	/**
	 * 评论列表
	 *
	 */
	function _ajax_list_comment () {
		$condition['uid'] = $this->_input['uid'];	
		$condition['search_type'] = $this->_input['search_type'];					
		$condition['keywords'] = $this->_input['keywords'];			
		//获取评论列表
		$this->obj_page->pagebarnum(10);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$comment_array = $this->obj_space->getCommentAllList( $condition, $this->obj_page );
		//时间、搜索关键字处理
		if ( is_array( $comment_array ) ) {
			foreach ( $comment_array as $k => $v ) {
				$comment_array[$k]['dateline'] = date( "Y-m-d", $v['dateline'] );
				$comment_array[$k]['message_cut'] = Common::cutstr( $v['message'], 30 );
				if ( $this->_input['keywords'] != '' ) {
					$comment_array[$k]['message_cut'] = $this->keywords_add_red( $this->_input['keywords'], $comment_array[$k]['message_cut'] );
				} 			
			}			
		}
		$page_list = $this->obj_page->show(1);	
		/**
		 * 页面输出
		 */
		$this->output( "comment_array", $comment_array );
		$this->output('curpage',$this->obj_page->nowindex);
		$this->output('page_list',$page_list);	
		$this->output('condition',$this->_input);	
		$this->output('uid',$this->_input['uid']);					
		$this->showpage( "sys_comment.list" );	
	}
	/**
	 * 删除日志
	 *
	 */
	function _del_blog () {
		if ( is_array( $this->_input['blogid'] ) ){
			foreach ( $this->_input['blogid'] as $k => $v ){
				$this->obj_space->delSpaceBlogSys( intval($v) );
			}
			Common::outMessage("json",$this->_lang['langSpaceBlogDeleteSucc'],1);
		}else {
			Common::outMessage("json",$this->_lang['langSysSpaceDelBlogSelect'],0);
		}
	}
	/**
	 * 日志列表
	 *
	 */
	function _ajax_list_blog () {
		$condition['uid'] = $this->_input['uid'];			
		$condition['search_type'] = $this->_input['search_type'];			
		$condition['classid'] = $this->_input['blog_type'];			
		$condition['keywords'] = $this->_input['keywords'];		
		//获取日志列表
		$this->obj_page->pagebarnum(10);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$blog_array = $this->obj_space->getBlogAllList( $condition, $this->obj_page );
		//时间、搜索关键字处理
		if ( is_array( $blog_array ) ) {
			foreach ( $blog_array as $k => $v ) {
				$blog_array[$k]['dateline'] = date( "Y-m-d", $v['dateline'] );
				$blog_array[$k]['title_cut'] = Common::cutstr( $v['title'], 20 );
				if ( $condition['search_type'] == 'username' ) {
					$blog_array[$k]['username'] = $this->keywords_add_red( $this->_input['keywords'], $v['username'] );
				} else {
					$blog_array[$k]['title_cut'] = $this->keywords_add_red( $this->_input['keywords'], $blog_array[$k]['title_cut'] );	
				}				
			}			
		}
		$page_list = $this->obj_page->show(1);	
		/**
		 * 页面输出
		 */
		$this->output( "blog_array", $blog_array );
		$this->output('curpage',$this->obj_page->nowindex);
		$this->output('page_list',$page_list);	
		$this->output('condition',$this->_input);			
		$this->output('uid',$this->_input['uid']);			
		$this->showpage( "sys_blog.list" );		
	}	
	/**
	 * 修改空间状态
	 */
	function _change_state(){
		switch ($this->_input['state']){
			case '0'://开启
				$msg = $this->_lang['langSysSpaceOpenSucc'];
				break;
			case '1'://关闭
				$msg = $this->_lang['langSysSpaceCloseSucc'];
				break;
			default:
				Common::outMessage("json",$this->_lang['errSpaceStateIsWrong'],0);
		}
		if ( $this->_input['uid'] != '' ){
			$value_array = array();
			$uid = intval( $this->_input['uid'] );
			$value_array['ifclose '] = $this->_input['state'];
			if ( $this->obj_space->updateSpace( $uid, $value_array ) ) {
				Common::outMessage("json",$msg,1);	
			} else {
				Common::outMessage("json",$this->_lang['langSysSpaceOperationFalse'],0);
			}
		}else {
			Common::outMessage("json",$this->_lang['errSpaceStateFail'],0);
		}
	}	
	/**
	 * 空间用户列表
	 *
	 */
	function _ajax_list_space () {
		$condition['search_type'] = $this->_input['search_type'];			
		$condition['keywords'] = $this->_input['keywords'];			
		//列表
		$this->obj_page->pagebarnum(10);
		$this->obj_page->nowindex = $this->_input['curpage']?$this->_input['curpage']:1;
		$space_array = $this->obj_space->getSpaceList( $condition, $this->obj_page );
		//处理时间,搜索关键字
		if ( is_array( $space_array ) ) {
			foreach ( $space_array as $k => $v ) {
				$space_array[$k]['opendate'] = date( "Y-m-d", $v['opendate'] );
				if ( $condition['search_type'] == 'username' ) {
					$space_array[$k]['username'] = $this->keywords_add_red( $this->_input['keywords'], $v['username'] );
				} else {
					$space_array[$k]['spacename'] = $this->keywords_add_red( $this->_input['keywords'], $v['spacename'] );	
				}
			}
		}
		$page_list = $this->obj_page->show(1);
		/**
		 * 页面输出
		 */
		$this->output( "space_array", $space_array );
		$this->output('curpage',$this->obj_page->nowindex);
		$this->output('page_list',$page_list);	
		$this->output('condition',$this->_input);			
		$this->showpage( "sys_space.list" );
	}
	/**
	 * 关键字加红
	 *
	 * @param string $keywords
	 * @param string $content
	 * @return string
	 */
	function keywords_add_red ( $keywords, $content ) {
		$content_red = str_replace( $keywords, "<font color='red'>".$keywords."</font>", $content );
		return $content_red;
	}
	/**
	 * 修改
	 */
	function _manage_modi(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_space.manage_modi');
	}	
	/**
	 * 保存修改
	 */
	function _manage_update(){
		/**
		 * 验证提交的数据
		 */
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_id'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['langSysCIDErr']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_name'],"require"=>"true","message"=>$this->_lang['errSysAppManageNameIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sort'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errSysAppManageSortNotNumber']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","message"=>$this->_lang['errSysAppManagePathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManagePathIsIllegal']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","message"=>$this->_lang['errSysAppManageSysPathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManageSysPathIsIllegal']));
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$error = $this->formatError($error);
			Common::outMessage("json",$error,0);
		}else{
			//更新
			$value_array = array();
			$value_array['app_module_id'] = $this->_input['app_module_id'];
			$value_array['app_module_name'] = $this->_input['app_module_name'];
			$value_array['app_module_sort'] = $this->_input['app_module_sort'];
			$value_array['app_module_path'] = $this->_input['app_module_path'];
			$value_array['app_module_sys_path'] = $this->_input['app_module_sys_path'];
			$value_array['app_module_state'] = $this->_input['app_module_state'];
			$result = $this->obj_app_class->updateAppModule($value_array);
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSysAppManageUpdateIsFail'],0);
			}else {
				//修改文件夹名
				if ($this->default_app_array['app_module_sys_path'] != $this->_input['app_module_sys_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->default_app_array['app_module_sys_path'],BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->_input['app_module_sys_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManageSysPathRenameIsFail'],0);
					}
				}
				if ($this->default_app_array['app_module_path'] != $this->_input['app_module_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'],BasePath.'/app/'.$this->_input['app_module_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManagePathRenameIsFail'],0);
					}
				}
				Common::outMessage("json",$this->_lang['langSysAppManageUpdateIsSucc'],1);
			}
		}
	}	
	/**
	 * 安装
	 */
	function _setup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_space.setup');
	}
	/**
	 * 保存安装
	 */
	function _setup_save(){
		/**
		 * 验证提交的数据
		 */
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_name'],"require"=>"true","message"=>$this->_lang['errSysAppManageNameIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sort'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errSysAppManageSortNotNumber']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","message"=>$this->_lang['errSysAppManagePathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManagePathIsIllegal']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","message"=>$this->_lang['errSysAppManageSysPathIsEmpty']));
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sys_path'],"require"=>"true","validator"=>"NoChinese","message"=>$this->_lang['errSysAppManageSysPathIsIllegal']));
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$error = $this->formatError($error);
			Common::outMessage("json",$error,0);
		}else{
			//第一次安装
			if ($this->default_app_array['app_module_first_install'] == '0'){
				//安装数据库
				$database_result = $this->obj_app_class->setupAppModuleDatabase($this->default_app_array['app_module_path']);
				if ($database_result !== true){
					Common::outMessage("json",$this->_lang['errSysAppManageSqlIsEmpty'],0);
				}
			}
			//更新
			$value_array = array();
			$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
			$value_array['app_module_name'] = $this->_input['app_module_name'];
			$value_array['app_module_sort'] = $this->_input['app_module_sort'];
			$value_array['app_module_path'] = $this->_input['app_module_path'];
			$value_array['app_module_sys_path'] = $this->_input['app_module_sys_path'];
			$value_array['app_module_state'] = $this->_input['app_module_state'];
			$value_array['app_module_install'] = '1';
			$value_array['app_module_first_install'] = '1';
			$result = $this->obj_app_class->updateAppModule($value_array);
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSysAppManageSetupIsFail'],0);
			}else {
				//修改文件夹名
				if ($this->default_app_array['app_module_sys_path'] != $this->_input['app_module_sys_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->default_app_array['app_module_sys_path'],BasePath.'/app/'.$this->default_app_array['app_module_path'].'/'.$this->_input['app_module_sys_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManageSysPathRenameIsFail'],0);
					}
				}
				if ($this->default_app_array['app_module_path'] != $this->_input['app_module_path']){
					if (!rename(BasePath.'/app/'.$this->default_app_array['app_module_path'],BasePath.'/app/'.$this->_input['app_module_path'])){
						Common::outMessage("json",$this->_lang['errSysAppManagePathRenameIsFail'],0);
					}
				}
				Common::outMessage("json",$this->_lang['langSysAppManageSetupIsSucc'],1);
			}
		}
	}
	/**
	 * 卸载
	 */
	function _unsetup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_space.unsetup');
	}		
	/**
	 * 卸载保存
	 */
	function _unsetup_save(){
		//更新
		$value_array = array();
		$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
		$value_array['app_module_state'] = '1';
		$value_array['app_module_install'] = '0';
		$result = $this->obj_app_class->updateAppModule($value_array);
		if ($result !== true){
			Common::outMessage("json",$this->_lang['errSysAppManageUnsetupNotExistOne']. BasePath.'/app/'.$this->default_app_array['app_module_path'] .$this->_lang['errSysAppManageUnsetupNotExistTwo'],0);
		}else {
			Common::outMessage("json",$this->_lang['langSysAppManageUnsetupIsSucc'],1);
		}
	}		
}
$space = new SysSpaceClass();
$space->main();
unset($space);
?>