<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : supply.class.php
 * ....供求信息类
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Wed Apr 29 15:04:58 CST 2009
 */

class supplyClass extends FrameWork {
	
	/**
	 * 供求信息列表
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return array
	 */
	function getSupplyList($condition,&$obj_page){
		$condition_str = $this->_conditionSearch($condition);
		$supply_array = $GLOBALS['db']->GetJoinList(
			$obj_page,
			array('supply','member'),
			"left join",
			array('supply.s_member_id=member.member_id'),
			array('*','login_name as s_member_name'),
			$condition_str
		);
		return $supply_array;
	}
	
	/**
	 * 构造检索条件
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return string
	 */
	function _conditionSearch($condition){
		$condition_str = '';
		//
		if ($condition['state'] != '') {
			$condition_str .= " and supply.s_state='" . $condition['state'] . "'";
		}
		if ($condition['keyword'] != '') {
			$keyword = str_replace('　',' ',$condition['keyword']);
			$keyword = explode(' ',trim($keyword));
			if (!empty($keyword)){
				foreach ($keyword as $k => $v){
					$keyword_line[] = "supply.s_title like '%" . trim($v) . "%'";
				}
				$condition_str .= " and (". implode(' or ',$keyword_line) .")";
			}
		}
		if ($condition['type'] != '') {
			$condition_str .= " and supply.s_type='" . $condition['type'] . "'";
		}
		if ($condition['quality'] != '') {
			$condition_str .= " and supply.s_quality='" . $condition['quality'] . "'";
		}
		if ($condition['class_id'] != '') {
			$condition_str .= " and (supply.s_class_id = '" . $condition['class_id'] . "'";

			//搜索子分类
			require_once("productclass.class.php");
			$obj_search_cate = new ProductCategoryClass();
			$class_array = $obj_search_cate->listClassDetail();
			if(!is_array($class_array)){
				$class_array = array();
			}
			$id = $condition['class_id'];
			$result = array();
			$search_cate = $obj_search_cate->getArrayById($class_array,$result,$id);
			if("" != $search_cate){
				$category_sql = "";
				foreach ($search_cate as $value){
					$category_sql .= " or supply.s_class_id = '" . $value['id'] . "'";
				}
			}
			$condition_str .= $category_sql . ")";
			unset($obj_search_cate);
		}
		if ($condition['recommend'] != '') {
			$condition_str .= " and supply.s_recommend='" . $condition['recommend'] . "'";
		}
		if ($condition['member_id'] != '') {
			$condition_str .= " and supply.s_member_id='" . $condition['member_id'] . "'";
		}
		if ($condition['anymous'] != '') {
			$condition_str .= " and supply.s_anonymous='" . $condition['anymous'] . "'";
		}
		if ($condition['username'] != ''){
			$condition_str .= " and member.login_name like '%" . $condition['username'] . "%'";
		}
		if ($condition['have_pic'] != ''){
			$condition_str .= " and supply.s_pic != ''";
		}
		if ($condition['full_contact'] != ''){
			$condition_str .= " and (supply.s_qq != '' and supply.s_msn != '' and supply.s_phone != '' and supply.s_email != '')";
		}
		if ($condition['valdate'] != ''){
			$condition_str .= " and supply.s_valdate='" . $condition['valdate'] . "'";
		}
		
		if ($condition['start_price'] != ''){
			$condition_str .= " and supply.s_price >= '" . $condition['start_price'] . "'";
		}
		if ($condition['end_price'] != ''){
			$condition_str .= " and supply.s_price <= '" . $condition['end_price'] . "'";
		}
		
		
		if ($condition['sort'] == '' || $condition['sort'] == 1) {
			$condition_str .= " order by supply.s_id desc";
		}elseif ($condition['sort'] == 2) {
			$condition_str .= " order by supply.s_lastretime desc";
		}elseif ($condition['sort'] == 3) {
			$condition_str .= " order by supply.s_id desc limit 0,10";
		}elseif ($condition['sort'] == 4)  {
			$condition_str .= " order by supply.s_time desc";
		}elseif ($condition['sort'] == 5)  {
			$condition_str .= " order by supply.s_click desc";
		}
		return $condition_str;
	}

	/**
	 * 获取单条供求信息
	 *
	 * @param int $supply_array
	 */
	function getOneSupply($sid=''){
		if (intval($sid) > 0) {
			$supply_array = $GLOBALS['db']->GetOneJoinArray(
				array('supply','member'),
				"left join",
				array('supply.s_member_id=member.member_id'),
				array('*','login_name as s_member_name'),
				"and s_id=' " . $sid . " '"
			);
			
			return $supply_array;
		}else {
			return false;
		}
	}
	
	/**
	 * 添加信息
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return bool
	 */
	function addSupply($input){
		if (is_array($input)){
			$value_array = array();
			foreach ($input as $k => $v){
				$value_array[$k] = $v;
			}
			$result = $GLOBALS['db']->InsertRow($value_array, 'supply', 's_id');
			return $result;
		}else {
			return false;
		}
	}

	/**
	 * 添加回复的供求信息
	 *
	 * @param array $input
	 * @return boolean
	 */
	function addSupplyRe($input){
		if (is_array($input)){
			$value_array = array();
			foreach ($input as $k => $v){
				$value_array[$k] = $v;
			}
			$result = $GLOBALS['db']->InsertRow($value_array, 'supply_reply', 'sr_id');
			return $result;
		}else {
			return false;
		}
	}

	/**
	 * 回复信息列表
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return array
	 */
	function getSupplyReList($condition,&$obj_page){
		$condition_str = $this->_conditionSearchRe($condition);
		
		$supply_re_array = $GLOBALS['db']->GetJoinList(
			$obj_page,
			array('supply_reply','member'),
			"left join",
			array('supply_reply.sr_member=member.member_id'),
			array('*','login_name as sr_member_name'),
			$condition_str
		);
		return $supply_re_array;
	}
	
	/**
	 * 构造检索条件
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return string
	 */
	function _conditionSearchRe($condition){
		$condition_str = '';
		//状态
		if ($condition['state'] != ''){
			$condition_str .= " and supply_reply.sr_state='" . $condition['state'] . "'";
		}
		//信息ID
		if ($condition['sid'] != ''){
			$condition_str .= " and supply_reply.sr_s_id='" . $condition['sid'] . "'";
		}
		//排序
		if ($condition['order_by'] != ''){
			$condition_str .= " order by ".$condition['order_by'];
		}else {
			$condition_str .= 'order by supply_reply.sr_id asc';
		}
		return $condition_str;
	}

	/**
	 * 增加点击次数
	 *
	 * @param unknown_type $input
	 * @return unknown
	 */
	function updateClickSupply($input){
		$value_array = array();
		$value_array['s_click'] = 's_click+'.intval($input["s_click"]);
		$result = $GLOBALS['db']->UpdateRow($input["s_id"], $value_array, 'supply','s_id',true);
		return $result;
	}

	/**
	 * 更新信息回复时间和数量
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return bool
	 */
	function updateSupplyReNum($input){
		$value_array = array();
		$value_array['s_renum'] 			= 	's_renum+'.intval($input["s_renum"]);
		$value_array['s_last_member_id'] 	= 	$input["s_last_member_id"];
		$value_array['s_lastretime']		=	$input["s_lastretime"];
		$result = $GLOBALS['db']->UpdateRow($input["s_id"], $value_array, 'supply','s_id',true);
		return $result;
	}
	
	/**
	 * 更新供求信息
	 * @author ShopNC Develop Team     
	 * @param  $input $member_id会员ID
	 * @return bool
	 */
	function updateSupply($input,$member_id=0){
		if (is_array($input)){
			$value_array = array();
			foreach ($input as $k => $v){
				$value_array[$k] = $v;
			}
			if (intval($member_id) > 0){
				$condition = " s_member_id='" . intval($member_id) . "' and";
			}
			$condition .= " s_id='" . $value_array["s_id"] . "'";
			$result = $GLOBALS['db']->UpdateRows('supply',$value_array,$condition);
			return $result;
		}else {
			return false;
		}
	}
	
	/**
	 * 删除信息
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return int/bool/object/array/string
	 */
	function delSupply($sid,$member_id=0){
		if (intval($sid) > 0) {
			if (intval($member_id) > 0){
				$condition = " and s_member_id='" . $member_id . "'";
			}
			$del_rs = $GLOBALS['db']->DelRow(intval($sid),'supply','s_id',$condition);
			return $del_rs;
		}
	}
	
	/**
	 * 取指定ID的留言信息
	 * @author ShopNC Develop Team     
	 * @param  $srid 留言ID
	 * @return array
	 */
	function getOneReSupply($srid){
		if (intval($srid) > 0) {
			$supply_rearray = $GLOBALS['db']->GetOneRow($srid,"supply_reply","sr_id");
			return $supply_rearray;
		}else {
			return false;
		}
	}
	
	/**
	 * 更新回复信息
	 * @author ShopNC Develop Team     
	 * @param  $input $member_id会员ID
	 * @return bool
	 */
	function updateReSupply($input,$member_id=0){
		if (is_array($input)){
			$value_array = array();
			foreach ($input as $k => $v){
				$value_array[$k] = $v;
			}
			if (intval($member_id) > 0){
				$condition = " sr_member='" . intval($member_id) . "' and";
			}
			$condition .= " sr_id='" . $value_array["sr_id"] . "'";
			$result = $GLOBALS['db']->UpdateRows('supply_reply',$value_array,$condition);
			return $result;
		}else {
			return false;
		}
	}
	/**
	 * 删除回复信息
	 * @author ShopNC Develop Team     
	 * @param  
	 * @return int/bool/object/array/string
	 */
	function delReSupply($srid,$member_id=0){
		if (intval($srid) > 0) {
			if (intval($member_id) > 0){
				$condition = " and sr_member='" . $member_id . "'";
			}
			$del_rs = $GLOBALS['db']->DelRow(intval($srid),'supply_reply','sr_id',$condition);
			return $del_rs;
		}
	}
}
?>