<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php
 * ....供求
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Wed Apr 29 09:29:29 CST 2009
 */

require_once('../../global.inc.php');

class ShowSupplyManage extends CommonFrameWork {
	/**
	 * 供求对象
	 *
	 * @var obj
	 */
	var $obj_supply;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 商品类别对象
	 *
	 * @var obj
	 */
	var $obj_product_category;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	
	function ShowSupplyManage(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('supply','home');
	}
	
	function main(){
		/**
		 * 创建应用对象
		 */
		if (!is_object($this->obj_supply)){
			require_once("supply.class.php");
			$this->obj_supply = new supplyClass();
		}
		/**
		 * 创建商品分类对象
		 */
		if (!is_object($this->obj_product_category)){
			require_once("productclass.class.php");
			$this->obj_product_category = new ProductCategoryClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 获取回复列表
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
			$this->obj_page->new_style = true;
			$this->obj_page->orange_style = true;
		}
		
		switch ($this->_input['action']){
			case 'list':
				$this->_list();
				break;
			case 'add':
				$this->isMember(0);
				$this->_add();
				break;
			case 'save':
				$this->isMember(0);
				$this->_save();
				break;
			case "check_code":
				$this->_check_code();
				break;
			case "view":
				$this->_view();
				break;
			case 'save_re':
				$this->_save_re();
				break;
			case 'pic_add':
				$this->_pic_add();
				break;
			case "pic_del":
				$this->_pic_del();
				break;
			default:
				$this->_list();
		}
	}
	
	
	/**
	 * 信息列表
	 */
	function _list(){
		/**
		 * 检索条件
		 */
		$condition['keyword'] = $this->_input['keyword'];
		$condition['type'] = $this->_input['type'];
		$condition['quality'] = trim($this->_input['quality']);
		$condition['state'] = 1;
		$condition['class_id'] = $this->_input['class_id'];
		$condition['listtype']  = $this->_input['listtype'];
		$condition['recommend']  = $this->_input['recommend'];
		$condition['have_pic']  = $this->_input['have_pic'];
		$condition['full_contact']  = $this->_input['full_contact'];
		$condition['valdate']  = $this->_input['valdate']?$this->_input['valdate']*24*3600:'';
		$condition['start_price']  = floatval($this->_input['start_price']);
		$condition['end_price']  = floatval($this->_input['end_price']);
		$condition['member_id']  = intval($this->_input['member_id']);
		if ($condition['member_id'] != ''){
			$condition['anymous'] = '1';
		}
		$condition['sort'] = $this->_input['orderby'];
		
		$this->obj_page->pagebarnum(10);
		$supply_array = $this->obj_supply->getSupplyList($condition,$this->obj_page);
		$page_list = $this->obj_page->show(8);
		//处理时间、名称、所属类别的显示
		if (is_array($supply_array)){
			foreach ($supply_array as $k=>$v){
				$supply_array[$k] = $this->_format_supply_info($v);
			}
		}
		//信息数量
		$num_list = $this->obj_supply->getSupplyList($condition,$page);
		$supply_number = count($num_list);
		//取商品类别的递归排序
		if (intval($this->_input['class_id']) > 0){
			$product_cate_path = $this->_get_product_class_path(intval($this->_input['class_id']));
		}
		//右侧的搜索和推荐
		$this->_supply_right();
		/**
		 * 页面输出
		 */
		$this->output('page_list',$page_list);
		$this->output('supply_array',$supply_array);
		$this->output('supply_number',$supply_number);
		$this->output('product_cate_path',$product_cate_path);
		$this->output('condition',$this->_input);
		$this->showpage('supply.list');   
	}
	
	/**
	 * 添加
	 */
	function _add(){		
		if ($_SESSION['s_login']['id'] != '') {
			//取得发布者资料
			$member_info = $this->obj_member->getMemberInfo(array("id"=>$_SESSION['s_login']['id']),'*','more');
			//
			$is_member = 1;
		}
		//对用户电话的处理
		$phone = '';
		$phone .= $member_info['mobilephone']?$member_info['mobilephone'].',':'';
		$phone .= $member_info['phone']?$member_info['phone'].',':'';
		$phone .= $member_info['otherphone']?$member_info['otherphone']:'';
		//商品类别
		$array = $this->obj_product_category->listClassDetail();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0') {
					$ProductCateArray[] = $v;
				}
			}
		}
		
		//右侧的搜索和推荐
		$this->_supply_right();
		
		/**
		 * 页面输出
		 */
		$this->output('ProductCateArray',$ProductCateArray);
		$this->output('product_id',$product_id);
		$this->output('is_member',$is_member);
		$this->output('phone',$phone);
		$this->output('member_info',$member_info);
		$this->showpage('supply.add');
	}
	
	/**
	 * 保存信息
	 */
	function _save(){
		/**
		 * 验证表单信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["class_id"],"require"=>"true","message"=>$this->_lang['errSupplyClassIsEmtpy']),
			array("input"=>$this->_input["supplyTitle"],"require"=>"true","message"=>$this->_lang['errSupplyTitleIsEmtpy']),
			array("input"=>$this->_input["Content"],"require"=>"true","message"=>$this->_lang['errSupplyContentIsEmtpy'])
		);
		$error = $this->obj_validate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			if (strtoupper($this->_input['code']) != strtoupper($_SESSION['seccode'])){
				$this->redirectPath("error","",$this->_lang['errSupplyCodeIsWrong']);
			}
			$value_array = array();
			switch ($this->_input["valdate"]){
				case '1':
					$value_array['s_valdate'] = 24*3600*5;
					break;
				case '2':
					$value_array['s_valdate'] = 24*3600*15;
					break;
				case '3':
					$value_array['s_valdate'] = 24*3600*30;
					break;
				case '4':
					$value_array['s_valdate'] = 24*3600*30*4;
					break;
				case '5':
					$value_array['s_valdate'] = 0;
					break;
			}
			$value_array["s_qq"]			=	$this->_input["qq"];
			$value_array["s_msn"]			=	$this->_input["msn"];
			$value_array["s_skype"]			=	$this->_input["skype"];
			$value_array["s_wangwang"]		=	$this->_input["wangwang"];
			$value_array["s_class_id"]		=	$this->_input["class_id"];
			$value_array["s_type"]			=	$this->_input["radioType"];
			$value_array["s_quality"]		=	$this->_input["radioQuality"];
			$value_array["s_title"]			=	$this->_input["supplyTitle"];
			$value_array["s_content"]		=	$this->_input["Content"];
			$value_array["s_phone"]			=	$this->_input["phone"];
			$value_array["s_email"]			=	$this->_input["mail"];
			$value_array["s_pic"]			=	$this->_input["p_pic"];
			$value_array["s_price"]			=	$this->_input["s_price"]?$this->_input["s_price"]:0;
			$value_array["s_price_face"]	=	$this->_input["s_price_face"]==1?1:2;
			$value_array['s_time']			=	time();
			//判断是否为匿名发布
			if ($this->_input['anonymous'] == 2) {
				//判断是否为登陆用户匿名发布
				if ($_SESSION['s_login']['id'] == '') {
					$value_array['s_member_id']	=	0;
				}else {
					$value_array['s_member_id']	=	$_SESSION['s_login']['id'];
				}
				$value_array['s_anonymous']	=	$this->_input['anonymous'];
			}else {
				$value_array['s_member_id']	=	$_SESSION['s_login']['id'];
				$value_array['s_anonymous']	=	1;
			}
			$value_array['s_click']		=	0;
			$value_array['s_renum']		=	0;
			$value_array['s_state']		=	1;
			//供求信息入库
			$result = $this->obj_supply->addSupply($value_array);
			//提示信息
			if ($result !== true){
				$this->redirectPath('error','',$this->_lang['errSupplyAddIsFail']);
			}else {
				$this->redirectPath('succ','app/'.$this->default_app_array['app_module_path'].'/index.php',$this->_lang['langSupplyAddIsSucc']);
			}
		}
	}
	
	/**
	 * 信息浏览
	 */
	function _view(){
		$sid = $this->_input["sid"];
		//更新点击数
		if (!isset($_COOKIE[$this->_input["sid"]]) && $this->_input["curpage"] == '') {
			$update_click['s_click'] = 1;
			$update_click['s_id'] = $sid;
			$update_click_num = $this->obj_supply->updateClickSupply($update_click);
			setcookie($this->_input["sid"],time()+3600);
		}
		//信息内容
		$supply_array = $this->obj_supply->getOneSupply($sid);
		$supply_array = $this->_format_supply_info($supply_array);
		//当为游客时强制为匿名回复
		if ($_SESSION['s_login'] != '') {
			$is_member = 1;
		}
		//得到类别信息
		$cate_string = $this->_get_product_class_path($supply_array['s_class_id']);
		//回复列表
		$this->_get_supply_re_list($supply_array['s_id']);
		//搜索该会员发布的相关供求信息
		if ($supply_array['s_member_id'] != 0 && $supply_array['s_anonymous'] == 1){
			$condition['member_id']  = $supply_array['s_member_id'];
			$condition['anymous'] = '1';
			$condition['sort'] = $this->_input['orderby'];
			$this->obj_page->pagebarnum(10);
			$relate_supply = $this->obj_supply->getSupplyList($condition,$this->obj_page);
			if (!empty($relate_supply)){
				foreach ($relate_supply as $k => $v){
					$relate_supply[$k]['short_content'] = Char_class::cut_str(strip_tags($v['s_content']),95,0,$this->_configinfo['websit']['ncharset']);
				}
			}
		}
		//右侧的搜索和推荐
		$this->_supply_right();	
		/**
		 * 页面输出
		 */
		$title_p_name = $supply_array['s_title'].' - ';
		$keyword_p_name = ','.$supply_title;
		$this->output("title_message", $title_p_name);
		$this->output("keyword_message", $keyword_p_name);
		$this->output('cate_string',$cate_string);
		$this->output('supply_array',$supply_array);
		$this->output('is_member',$is_member);
		$this->output('relate_supply',$relate_supply);
		$this->showpage("supply.view");
	}
	
	/**
	 * 取指定信息的回复信息
	 */
	function _get_supply_re_list($s_id){
		$this->obj_page->pagebarnum(7);
		$condition['state'] = '1';
		$condition['sid'] = $s_id;
		$supply_re_array = $this->obj_supply->getSupplyReList($condition,$this->obj_page);
		$page_list = $this->obj_page->show(8);
		//处理时间、回复者名称的显示
		if (is_array($supply_re_array)){
			foreach ($supply_re_array as $k=>$v){
				//回复时间
				$supply_re_array[$k]['sr_time'] = $v['sr_time']?date("Y-m-d H:i",$v['sr_time']):'';
			}
		}
		//全部留言
		$condition['state'] = '1';
		$condition['sid'] = $s_id;
		$re_number = count($this->obj_supply->getSupplyReList($condition,$obj_page));
		/**
		 * 模板输出
		 */
		$this->output('page_list',$page_list);
		$this->output('re_number',$re_number);
		$this->output('supply_re_array',$supply_re_array);
		return true;
	}
	
	/**
	 * 取商品类别的递归路径
	 */
	function _get_product_class_path($class_id){
		//得到类别信息
		$cate_row = $this->obj_product_category->getPClassRow($class_id);
		$cate_array=array();
		for ($j=0;$j<4;$j++){
			if ($cate_row['pc_name'] != '') {
				$cate_array[] = "<a href='index.php?action=list&class_id=".$cate_row['pc_id']."'>".$cate_row['pc_name']."</a>";
			}
			if ($cate_row['pc_u_id'] != '0'){
				$cate_row = $this->obj_product_category->getPClassRow($cate_row['pc_u_id']);
			}else {
				break;
			}
		}
		//对得到的类别数组反排序
		$cate_string = "";
		for($i=count($cate_array);$i>=0;$i--){
			if ($cate_array[$i] != ""){
				$cate_string .= $cate_array[$i];
			}
		}
		return $cate_string;
	}
	
	/**
	 * 格式化信息的内容
	 */
	function _format_supply_info($supply_array){
		if (!is_array($supply_array)){
			$this->redirectPath('error','',$this->_lang['errSupplyIsEmpty']);
		}
		$supply_array['short_title'] = Char_class::cut_str($supply_array['s_title'],16,0,$this->_configinfo['websit']['ncharset']);
		if ($supply_array['s_valdate'] != 0){
			$supply_array['remain_time'] = ($supply_array['s_time']+$supply_array['s_valdate']-time())>0?ceil(number_format(($supply_array['s_time']+$supply_array['s_valdate']-time())/(60*60*24),2)):0;
		}else {
			$supply_array['remain_time'] = -1;
		}
		$supply_array['s_time'] = $supply_array['s_time']?date("m".$this->_lang['langSupplyMonth']."d".$this->_lang['langSupplyDay'],$supply_array['s_time']):'';
		$supply_array['s_type'] = ($supply_array['s_type']==1)?$this->_lang['langSupplyTypeQiu']:$this->_lang['langSupplyTypeGone'];
		$supply_array['s_quality'] = ($supply_array['s_quality']==1)?$this->_lang['langSupplyQualityOne']:$this->_lang['langSupplyQualityTwo'];
		$supply_array['short_content'] = Char_class::cut_str(strip_tags($supply_array['s_content']),40,0,$this->_configinfo['websit']['ncharset']);
		//有效期
		switch ($supply_array['s_valdate']){
			case 0:
				$supply_array['s_valdate'] = $this->_lang['langSupplyValdateNone'];
				break;
			case 24*3600*5:
				$supply_array['s_valdate'] = $this->_lang['langSupplyValdateFiveDay'];
				break;
			case 24*3600*15:
				$supply_array['s_valdate'] = $this->_lang['langSupplyValdateHalfMonth'];
				break;
			case 24*3600*30:
				$supply_array['s_valdate'] = $this->_lang['langSupplyValdateOneMonth'];
				break;
			case 24*3600*30*4:
				$supply_array['s_valdate'] = $this->_lang['langSupplyValdateOneQuarter'];
				break;
		}
		//图片字符串进行处理,输出原图
		if ($supply_array['s_pic'] != ''){
			$supply_array['s_pic'] = explode('|',trim($supply_array['s_pic'],'|'));
			$spic_arr = array();
			foreach ($supply_array['s_pic'] as $k=>$v){
				$v = str_replace('_small','',$v);
				if (file_exists(BasePath.'/'.$v) && $v != '') {
					$supply_array['spic_arr'][] = $v;
					unset($temp);
				}
			}
		}
		return $supply_array;
	}
	
	/**
	 * 搜索与推荐页面
	 */
	function _supply_right(){
		//左上侧 类别搜索
		$condition['parent_id'] = intval($this->_input['class_id'])?intval($this->_input['class_id']):'0';
		$search_cate_array = $this->obj_product_category->getProductClass($condition);
		//列表导航类别名称
		if (intval($this->_input['class_id']) > 0){
			$product_cate_array = $this->obj_product_category->getPClassRow(intval($this->_input['class_id']));
		}
		/**
		 * 页面输出
		 */
		$this->output('product_cate_array',$product_cate_array);
		$this->output('search_cate_array',$search_cate_array);
	}
	
	/**
	 * 判断验证码
	 */
	function _check_code(){
		$code = $this->_input['checkcode'];
		if (strtoupper($code) == strtoupper($_SESSION['seccode'])){
			echo 1;//正确
		}else {
			echo 2;//错误
		}
	}
	
	/**
	 * 保存回复信息
	 */
	function _save_re(){
		/**
		 * 验证表单信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["retitle"],"require"=>"true","message"=>$this->_lang['errSupplyTitleIsEmtpy']),
			array("input"=>$this->_input["ReContent"],"require"=>"true","message"=>$this->_lang['errSupplyContentIsEmtpy'])
		);

		$error = $this->obj_validate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else {
			$supply_array = $this->obj_supply->getOneSupply(intval($this->_input["sid"]));
			if ($supply_array['s_member_id'] == $_SESSION['s_login']['id']){
				$this->redirectPath("error","",$this->_lang['errSupplyReSelf']);
			}
			//发送短信
			if ($this->_input['setMsg'] == '1'){
				//新增一条站内短消息
				$value_array = array();
				$value_array['member_name'] = 0;//系统发送
				$value_array['txtReceive_name'] = $supply_array['s_member_name'];//接收人用户名
				$value_array['txtTitle'] = '您发布的供求信息有人回复';//标题
				$value_array['txtContent'] = addslashes($this->_lang['langSupplySetMsgContent']."<a href='". $this->_configinfo['websit']['site_url'] ."/app/". $this->default_app_array['app_module_path'] ."/index.php?action=view&sid=".$supply_array['s_id']."'>". $supply_array['s_title'] ."</a>");//内容
				require_once("message.class.php");
				$obj_message = new MessageClass();
				$obj_message->addMessage($value_array);
				unset($obj_message);
			}
			
			$value_array = array();
			$value_array["sr_s_id"] = $this->_input["sid"];
			$value_array['sr_member'] = $_SESSION['s_login']['id']?$_SESSION['s_login']['id']:0;
			$value_array["sr_title"] = $this->_input["retitle"];
			$value_array["sr_content"] = $this->_input["ReContent"];
			$value_array["sr_time"] = time();
			$value_array["sr_state"] = 1;
			$value_array['sr_anonymous'] = ($this->_input['anonymous']==2)?2:1;
			//回复信息入库
			$result = $this->obj_supply->addSupplyRe($value_array);
			//更新主表提示信息
			if ($result !== true) {
				$this->redirectPath("error","",$this->_lang['errSupplyAddIsFail']);
			}else {
				//更新最后回复时间、用户和回复数
				$update_replay = array();
				$update_replay['s_id'] = $this->_input["sid"];
				$update_replay['s_renum'] = 1;
				$update_replay['s_last_member_id'] = $value_array['sr_member'];
				$update_replay['s_lastretime'] = time();
				$this->obj_supply->updateSupplyReNum($update_replay);
				
				$this->redirectPath("succ","",$this->_lang['langSupplyAddIsSucc']);
			}
		}
	}
	
	/**
	 * 增加图片
	 */
	function _pic_add(){
		if(isset($_FILES['txtPpic']['name']) and $_FILES['txtPpic']['name'] != ''){
			require_once("uploadfile.class.php");
			$upload = new UploadFile();
			$upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);
			//上传商品图片
			$filename = $upload->upfile("txtPpic");
			//按比例生成图片
			$resize_width = $this->_configinfo['productinfo']['imageresize_width'];
			$resize_height = $this->_configinfo['productinfo']['imageresize_height'];
			$cut = $this->_configinfo['productinfo']['imageresize_ifcut'];
			if ($filename !== false){
				include_once ('resizeImage.class.php');
				//判断图片大小
				$image_info = getimagesize($filename['filename']);
				$width = $image_info[0];
				$height = $image_info[1];
				if ($width > $height){//用宽度
					$pic_param = $width;
					$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_width'],2);
				}else {//用高度
					$pic_param = $height;
					$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_height'],2);
				}
				//小图
				if (intval($small_percent) > 1){
					$obj_small = new resizeImage($filename['filename'],intval($width/$small_percent),intval($height/$small_percent),$cut);
				}elseif (intval($small_percent) == 1){
					//取与标准尺寸的差值
					$pic_percent = $small_percent;
					$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
					$small_width = intval($width*($pic_percent));
					$small_height = intval($height*($pic_percent));
					$obj_small = new resizeImage($filename['filename'],$small_width,$small_height,$cut);
				}else {
					$obj_small = new resizeImage($filename['filename'],$width,$height,$cut);
				}
			}
			$arr = @explode('.',$filename["getfilename"]);
			$return_name = $arr[0].'_small.'.$arr[1];
			unset($upload,$arr);
			Common::outMessage("json",$return_name,1);
		}else {
			//输出信息
			Common::outMessage("json",$this->_lang['errSupplyPicIsWrong'],0);
		}
	}
	
	/**
	 * 删除图片
	 */
	function _pic_del(){
		if ($this->_input['pic_name'] != ''){
			//将传过来的图片名称分别整理为原有图片，中号和大号图片,全部删除
			$arr = explode('.',$this->_input['pic_name']);
			$arr[0] = @str_replace('_small','',$arr[0]);
			if (file_exists(BasePath.'/'.$arr[0].'.'.$arr[1])){
				unlink(BasePath.'/'.$arr[0].'.'.$arr[1]);
			}
			if (file_exists(BasePath.'/'.$arr[0].'_small.'.$arr[1])){
				unlink(BasePath.'/'.$arr[0].'_small.'.$arr[1]);
			}
			unset($arr);
			//输出信息
			Common::outMessage("json",'SUCC',1);
		}else {
			//输出信息
			Common::outMessage("json",$this->_lang['errSupplyDelPicIsFail'],0);
		}
	}
}

$supply_manage = new ShowSupplyManage();
$supply_manage->main();
unset($supply_manage);
?>