<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_main.php   FILE_PATH : \multishop\member\own_main.php
 * ....会员后台首页
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net
 * @author ShopNC Develop Team
 * @package
 * @subpackage
 * @version Wed Sep 12 15:49:19 CST 2007
 */

require ("../global.inc.php");

class OwnMain extends CommonFrameWork
{
	/**
     * 会员对象
     *
     * @var obj
     */
	var $obj_member;
	/**
     * 商品订单对象
     *
     * @var obj
     */
	var $obj_product_order;
	/**
     * 商品对象
     *
     * @var obj
     */
	var $obj_product;
	/**
     * 商铺对象
     *
     * @var obj
     */
	var $obj_shop;
	/**
     * 用户组对象
     *
     * @var obj
     */
	var $obj_member_group;
	
	function main()
	{
		/**
         * 创建会员对象
         */
		if (!is_object($this->objmember))
		{
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
         * 创建商品订单对象
         */
		if (!is_object($this->obj_product_order))
		{
			require_once ("order.class.php");
			$this->obj_product_order = new ProductOrderClass();
		}
		/**
         * 创建商品对象
         */
		if (!is_object($this->obj_product))
		{
			require_once ("product.class.php");
			$this->obj_product = new ProductClass();
		}
		/**
         * 创建商铺对象
         */
		if (!is_object($this->obj_shop))
		{
			require_once ("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
         * 创建用户组对象
         */
		if (!is_object($this->obj_member_group))
		{
			require_once('member_group.class.php');
			$this->obj_member_group = new MemberGroupClass();
		}
		
		/**
         * 设置模板路径
         */
		$this->setsubtemplates("member");
		/**
         * 语言包
         */
		$this->getlang("own_main");
		$this->memberMenuModule();

		//得到会员资料
		$condition['id'] = $_SESSION['s_login']['id'];
		$member_array = $this->obj_member->getMemberInfo($condition, '*', 'more');
		$member_array['last_login_time'] = @date("Y", $member_array['last_login_time']).$this->_lang['langMainYear'].@date("m", $member_array['last_login_time']).$this->_lang['langMainMonth'].@date("d", $member_array['last_login_time']).$this->_lang['langMainDate']."  ".@date("H:i:s", $member_array['last_login_time']);
		if ($member_array['mg_id'] != ''){
			//查找用户组
			$group_row = $this->obj_member_group->getMemberGroupRow($member_array['mg_id']);
			$member_array['group_name'] = $group_row['mg_name'];
			//星星数
			$line = '';
			for ($i=0;$i<$group_row['mg_stars'];$i++){
				$line .= "<img src='". $this->_configinfo['websit']['site_url'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/member/images/star.gif'."'>";
			}
			$member_array['group_star'] = $line;
		}
		//卖家缴费
		if ($this->_configinfo['paymode']['shop_pay_mode'] == '1')
		{
			if (($member_array['shop_availability_time']-time()) > 0)
			{//取还可以使用的天数
				$use_day_num = intval(($member_array['shop_availability_time']-time())/(24*60*60));
			}
			if ($_SESSION["s_login"]['type'] == '1')
			{//是店铺的情况
				//店铺使用时间
				$member_array['shop_availability_time'] = $member_array['shop_availability_time']?@date('Y-m-d', $member_array['shop_availability_time']):
				$this->_lang['langMainShopPayLess'];
			}
			//取上架商品数量
			$obj_condition['member'] = $_SESSION['s_login']['id'];
			$product_array = $this->obj_product->getProductList($obj_condition, $obj_page);
			unset ($obj_condition);
		}

		//买家提醒区
		$obj_condition[state] = array ("0", "1", "2", "3");
		$obj_condition[member_id] = $_SESSION['s_login']['id'];
		$obj_condition[order_case] = 'bought';
		$obj_condition[time] = '2';
		$buyer_array = $this->obj_product_order->getProductOrderList($obj_condition, $obj_page);
		$buyer_remind = count($buyer_array);//最近1个月购买的宝贝
		unset ($obj_condition);
		$obj_condition = "";
		$obj_condition[state] = array ("3");
		$obj_condition[member_id] = $_SESSION['s_login']['id'];
		$obj_condition[order_case] = 'bought';
		$obj_condition[comment] = 5;
		$comment_array = $this->obj_product_order->getProductOrderList($obj_condition, $obj_page);
		$buyer_have_comment = count($comment_array);//最近1个月购买的宝贝
		unset ($obj_condition);
		/*卖家提醒区*/
		$obj_condition[state] = array (0);
		$obj_condition[member_id] = $_SESSION['s_login']['id'];
		$obj_condition[order_case] = 'sold';
		$obj_condition[time] = 'no';
		$seller_array = $this->obj_product_order->getProductOrderList($obj_condition, $obj_page);
		$seller_state_zero = count($seller_array);//未付款的订单
		unset ($obj_condition, $seller_array);
		$obj_condition[state] = array ("1");
		$obj_condition[member_id] = $_SESSION['s_login']['id'];
		$obj_condition[order_case] = 'sold';
		$obj_condition[time] = 'no';
		$seller_array = $this->obj_product_order->getProductOrderList($obj_condition, $obj_page);
		$seller_state_one = count($seller_array);/*等待发货的订单*/
		/**
             * 更新商品数量，橱窗推荐数
             */
		$this->obj_product->updateProductStatistics($_SESSION['s_login']['id'], 'recommend');
		/**
             * 页面输出
             */
		$this->output('member_array', $member_array);
		$this->output("member_info", $_SESSION['s_login']);
		$this->output('buyer_remind', $buyer_remind);
		$this->output('buyer_have_comment', $buyer_have_comment);
		$this->output('seller_state_zero', $seller_state_zero);
		$this->output('seller_state_one', $seller_state_one);
		$this->output('audit_state', $this->_showShop($_SESSION['s_login']['id']));
		$this->output('nonce_pay_mode', $this->_configinfo['paymode']['shop_pay_mode']);
		$this->output('use_day_num', $use_day_num);
		$this->output('product_count', count($product_array));
		$this->output('now_time', date('Y-m-d'));
		$this->showpage("own_main");
	}

	/**
         * 查看某一商铺信息
         *
         */
	function _showShop($member_id)
	{
		$shop_array = $this->obj_shop->getOneShopByMemeberId($member_id, '1', 'audit_state');
		$shop_array['audit_state'] = $this->_b_config['auditstate'][$shop_array['audit_state']];
		return $shop_array['audit_state'];
	}
}
$o_main = new OwnMain();
$o_main->main();
unset ($o_main);
?>
