<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////


/**
 * FILE_NAME : own_order.php   FILE_PATH : \multishop\member\own_order.php
 * ....商品订单管理功能
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Tue Aug 28 15:51:41 CST 2007
 */
require_once ("../global.inc.php");

class OwnProductOrderManage extends CommonFrameWork {
	/**
	 * 商品订单对象
	 *
	 * @var obj
	 */
	var $obj_product_order;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 商品对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 * 网站提醒对象
	 *
	 * @var obj
	 */
	var $obj_remind;
	/**
	 * 支付对象
	 *
	 * @var obj
	 */
	var $obj_payment;
	/**
	 * 收货地址
	 *
	 * @var obj
	 */
	var $obj_receive;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 预存款对象对象
	 *
	 * @var obj
	 */
	var $obj_predeposit;
	/**
	 * 外汇对象
	 *
	 * @var obj
	 */
	var $obj_exchange;
	
	function main() {
		/**
		 * 创建商品订单对象
		 */
		if (! is_object ( $this->obj_product_order )) {
			require_once ("order.class.php");
			$this->obj_product_order = new ProductOrderClass ( );
		}
		/**
		 * 创建验证对象
		 */
		if (! is_object ( $this->objvalidate )) {
			require_once ("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate ( );
		}
		
		/**
		 * 实例化商品类
		 */
		if (! is_object ( $this->obj_product )) {
			require_once ("product.class.php");
			$this->obj_product = new ProductClass ( );
		}
		
		/**
		 * 支付对象
		 */
		if (! is_object ( $this->obj_payment )) {
			require_once ("payment.class.php");
			$this->obj_payment = new PaymentClass ( );
		}
		
		/**
		 * 收货对象
		 */
		if (! is_object ( $this->obj_receive )) {
			require_once ("receive.class.php");
			$this->obj_receive = new ReceiveClass ( );
		}
		
		/**
		 * 分页对象
		 */
		if (! is_object ( $this->obj_page )) {
			require_once ("commonpage.class.php");
			$this->obj_page = new CommonPage ( );
		}
		
		/**
		 * 实例化用户类
		 */
		if (! is_object ( $this->obj_member )) {
			require_once ("member.class.php");
			$this->obj_member = new MemberClass ( );
		}
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates ( "member" );
		
		/**
		 * 语言包
		 */
		$this->getlang ( "own_order" );
		
		$this->memberMenuModule ();
		
		switch ($this->_input ['action']) {
			case "bought" :
				$order_case = "bought";
				$this->_listorder ( $order_case );
				break;
			case "group" :
				$group_state = "group_buying";
				$this->_listgroup ( $group_state );
				break;
			case "group_end" :
				$group_state = "group_end";
				$this->_listgroup ( $group_state );
				break;
			case "sold" :
				$order_case = "sold";
				$this->_listorder ( $order_case );
				break;
			case "payed" :
				$this->_updateproductorderstate ( 1 );
				break;
			case "delived" :
				$this->_updateproductorderstate ( 2 );
				break;
			case "received" :
				$this->_updateproductorderstate ( 3 );
				break;
			case "invoice" :
				$this->_invoice ();
				break;
			case 'invoice_save' :
				$this->_invoice_save ();
				break;
			case "order_receive" :
				$this->_order_receive ();
				break;
			case "pay_success" :
				$this->_pay_success ();
				break;
			case "bid_sel_payment" :
				$this->_bid_sel_payment ();
				break;
			case "bid_sel_payment_save" :
				$this->_bid_sel_payment_save ();
				break;
			case 'show' :
				$this->_show_order_info ( $this->_input ['sp_code'] );
				break;
			case 'offline_pay':
				$this->_offline_pay ();
				break;
			case 'save_offline_pay':
				$this->_save_offline_pay ();
				break;
			case 'close':
				$this->_close();
				break;
			case 'close_save':
				$this->_close_save();
				break;
			default :
				$order_case = "bought";
				$this->_listorder ( $order_case );
				break;
		}
	
	}
	
	/**
	 * 取得订单列表
	 *
	 * @param string $order_case 
	 */
	function _listorder($order_case) {
		//关闭过期交易，默认为7天
		$this->obj_product_order->closeProductOrderByTime();
		
		/**
		 * 取得查询参数
		 */
		$obj_condition ['key'] = $this->_input ['keyword'];
		$obj_condition ['keygenre'] = $this->_input ['searchtype'];
		$obj_condition ['time'] = $this->_input ['time'];
		$obj_condition ['p_name'] = $this->_input ['p_name'];
		/*如果有卖家名称*/
		if ($this->_input ['seller_nick'] != "") {
			$condition ['member_name'] = $this->_input ['seller_nick'];
			$member_info = $this->obj_member->getMemberInfo ( $condition );
			if (! empty ( $member_info )) {
				$obj_condition ['seller_id'] = $member_info ['member_id'];
			}
			unset ( $condition,$member_info );
		}
		//如果有买家名称
		if ($this->_input ['buyer_nick'] != "") {
			$condition ['member_name'] = $this->_input ['buyer_nick'];
			$member_info = $this->obj_member->getMemberInfo ( $condition );
			if (! empty ( $member_info )) {
				$obj_condition ['buyer_id'] = $member_info ['member_id'];
			}
			unset ( $condition,$member_info );
		}
		
		//时间搜索
		if ($this->_input ['start_time'] != "" && $this->_input ['end_time'] != "") {
			$time = @explode ( '-', $this->_input ['start_time'] );
			$obj_condition['start_time'] = @mktime ( 0, 0, 0, $time [1], $time [2], $time [0] );
			$time = @explode ( '-', $this->_input ['end_time'] );
			$obj_condition['end_time'] = @mktime ( 0, 0, 0, $time [1], $time [2], $time [0] );
			$obj_condition [search_time] = 1;
		}
		//其他限定条件
		if ($this->_input['order_state'] != ''){
			$obj_condition ['state'] = array($this->_input['order_state']);
		}else {
			$obj_condition ['state'] = array ("0", "1", "2", "3", "6" );
		}
		$obj_condition ['member_id'] = $_SESSION ['s_login'] ['id'];
		$obj_condition ['order_case'] = $order_case;
		$obj_condition ['order'] = 1;
		//取得订单列表
		$this->obj_page->pagebarnum ( 10 );
		$product_order_array = $this->obj_product_order->getProductOrderList ( $obj_condition, $this->obj_page );
		if (is_array ( $product_order_array )) {
			//分别初始化订单流程类
			require_once('order_process_auction.class.php');
			$obj_order_process_auction = new OrderProcessAuction();
			require_once('order_process_fixprice.class.php');
			$obj_order_process_fixprice = new OrderProcessFixprice();
			require_once('order_process_group.class.php');
			$obj_order_process_group = new OrderProcessGroup();
			//语言包
			$obj_order_process_auction->_lang = $this->_lang;
			$obj_order_process_fixprice->_lang = $this->_lang;
			$obj_order_process_group->_lang = $this->_lang;
			foreach ( $product_order_array as $key => $value ) {
				unset($obj_order_process_auction->order_info);
				unset($obj_order_process_fixprice->order_info);
				unset($obj_order_process_group->order_info);
				//取订单状态
				switch ($value['sell_type']){
					case '0'://拍卖
						$obj_order_process_auction->order_info = $value;
						$product_order_array[$key]['state_info'] = $obj_order_process_auction->getOrderStateInfo($value['sp_code']);
						break;
					case '1'://一口价
						$obj_order_process_fixprice->order_info = $value;
						$product_order_array[$key]['state_info'] = $obj_order_process_fixprice->getOrderStateInfo($value['sp_code']);
						break;
					case '2'://团购
						$obj_order_process_group->order_info = $value;
						$product_order_array[$key]['state_info'] = $obj_order_process_group->getOrderStateInfo($value['sp_code']);
						break;
				}
				
				//取会员信息
				if ($order_case == "bought") {
					$member_id = $value ['seller_id'];
				} else {
					$member_id = $value ['buyer_id'];
				}
				$condition ['id'] = $member_id;
				$member_info = $this->obj_member->getMemberInfo ( $condition );
				$product_order_array [$key] ['member_nick'] = $member_info ['login_name'];
				$product_order_array [$key] ['member_id'] = $member_id;
				
				//取成交时间
				$product_order_array [$key] ['sold_date'] = date ( "Y-m-d", $value ['sold_time'] );
				$product_order_array [$key] ['sold_hour'] = date ( "H:i", $value ['sold_time'] );
				//卖出的商品
				if ($this->_input ['action'] == "sold") { 
					if ($product_order_array [$key] ['sole_have_comment'] == "0") {
						if ($product_order_array [$key] ['sp_state'] == "3") {
							$product_order_array [$key] ['score_say'] = '<a href="own_score.php?action=add&orderid=' . $product_order_array [$key] ['sp_id'] . '&type=' . $this->_input ['action'] . '">' . $this->_lang ['langOrderNotAppraise'] . '</a>';
						}
					} else {
						$product_order_array [$key] ['score_say'] = $this->_lang ['langOrderAppraised'];
					}
				//买到的商品
				} else if ($this->_input ['action'] == "bought") { 
					if ($product_order_array [$key] ['buy_have_comment'] == "0") {
						if ($product_order_array [$key] ['sp_state'] == "3") {
							$product_order_array [$key] ['score_say'] = '<a href="own_score.php?action=add&orderid=' . $product_order_array [$key] ['sp_id'] . '&type=' . $this->_input ['action'] . '">' . $this->_lang ['langOrderNotAppraise'] . '</a>';
						}
					} else {
						$product_order_array [$key] ['score_say'] = $this->_lang ['langOrderAppraised'];
					}
				}
			}
		}
		$page_list = $this->obj_page->show ( 1 );
		//判断是否使用静态链接
		$product_order_array = $this->obj_product->checkProductIfHtml ( $product_order_array, $this->_configinfo ['productinfo'] ['ifhtml'] );
		
		//商品图片使用小图
		if (is_array ( $product_order_array )) {
			foreach ( $product_order_array as $k => $v ) {
				if ($product_order_array [$k] ['p_pic'] != '') {
					$temp = explode ( '.', $product_order_array [$k] ['p_pic'] );
					$temp_sub = explode ( '/', $temp [0] );
					if (is_array ( $temp_sub )) {
						for($i = 0; $i < count ( $temp_sub ) - 1; $i ++) {
							$temp_str .= $temp_sub [$i] . '/';
						}
						$product_order_array [$k] ['p_pic'] = $temp_str . substr ( $temp_sub [count ( $temp_sub ) - 1], 0, 23 ) . '_small.' . $temp [1];
						$temp_str = '';
					}
				}
			}
		}
		
		/**
		 * 页面输出
		 */
		$this->output ( "member_id", $_SESSION ['s_login'] ['id'] );
		$this->output ( "order_case", $order_case );
		$this->output ( "page_list", $page_list );
		$this->output ( "time", $this->_input ['time'] );
		$this->output ( "type", $this->_input ['action'] );
		$this->output ( "product_order_array", $product_order_array );
		$this->showpage ( "own_order.manage" );
	}
	
	/**
	 * 团购商品列表
	 *
	 */
	function _listgroup($group_state) {		
		/**
		 * 取得查询参数
		 */
		$obj_condition ['key'] = $this->_input ['keyword'];
		$obj_condition ['keygenre'] = $this->_input ['searchtype'];
		
		/**
		 * 其他限定条件
		 */
		$obj_condition ['order_case'] = "bought";
		if ($group_state == "group_buying") {
			$obj_condition ['state'] = array ("4" );
			$obj_condition ['sell_type'] = "2";
		} elseif ($group_state == "group_end") {
			$obj_condition ['state'] = array ("5" );
			$obj_condition ['sell_type'] = "2";
		}
		
		$obj_condition ['buyer_id'] = $_SESSION ['s_login'] ['id'];
		$obj_condition ['order_case'] = $order_case;
		
		/**
		 * 更新到期团购商品订单状态
		 */
		$group_product_order_tobe_end_array = $this->obj_product_order->updateProductOrderInCondition ();
		/**
		 * 更新到期商品状态
		 */
		$product_tobe_end_array = $this->obj_product->updateProductInCondition ();
		/**
		 * 更新过期交易结束团购未成立的订单状态
		 */
		
		/**
		 * 取得订单列表
		 */
		$this->obj_page->pagebarnum ( 10 );
		$product_order_array = $this->obj_product_order->getProductOrderList ( $obj_condition, $this->obj_page );
		if (is_array ( $product_order_array )) {
			foreach ( $product_order_array as $key => $value ) {
				if ($order_case == "bought") {
					$member_id = $value ['seller_id'];
				} else {
					$member_id = $value ['buyer_id'];
				}
				$mem_condition ['id'] = $member_id;
				$member_info = $this->obj_member->getMemberInfo ( $mem_condition );
				$product_order_array [$key] ['member_nick'] = $member_info ['login_name'];
				$product_order_array [$key] ['member_id'] = $member_id;
				
				$product_info = $this->obj_product->getProductRow ( $value ['p_code'] );
				if ($product_info ['p_sold_num'] < $product_info ['p_group_mincount']) {
					$product_order_array [$key] ['less_count'] = $product_info ['p_group_mincount'] - $product_info ['p_sold_num'];
				}
				$left_time = $product_info ['p_end_time'] - time ();
				if ($left_time < 0) {
					$is_end = "1";
				}
				$product_order_array [$key] ['left_days'] = intval ( $left_time / (24 * 60 * 60) );
				$product_order_array [$key] ['left_hours'] = intval ( ($left_time % (24 * 60 * 60)) / (60 * 60) );
				$product_order_array [$key] ['left_minutes'] = intval ( (($left_time % (60 * 60))) / 60 );
			
			}
		}
		if (count ( $product_order_array ) < 1) {
			$no_order = "no_order";
		}
		
		$page_list = $this->obj_page->show ( 1 );
		/*判断是否使用静态链接*/
		$product_order_array = $this->obj_product->checkProductIfHtml ( $product_order_array, $this->_configinfo ['productinfo'] ['ifhtml'] );
		/**
		 * 页面输出
		 */
		$this->output ( "member_id", $_SESSION ['s_login'] ['id'] );
		$this->output ( "order_case", $order_case );
		$this->output ( "no_order", $no_order );
		$this->output ( "is_end", $is_end );
		$this->output ( "page_list", $page_list );
		$this->output ( "group_state",  $group_state);
		$this->output ( "product_order_array", $product_order_array );
		$this->showpage ( "own_group_order.manage" );
	}
	
	/**
	 * 更改商品订单状态
	 *
	 * @param int $state 0:已成交 1:已支付 2:已发货 3:已收货
	 */
	function _updateproductorderstate($state) {
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["spcode"], "require" => "true", "message" => $this->_lang ['errOrderCodeEmpty'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			echo $error;
		} else {
			
			$condition_order ['sp_code'] = $this->_input ["spcode"];
			$product_array = $this->obj_product_order->getProductOrderList ( $condition_order, $this->obj_page );
			switch ($state) {
				case 1 :
					$this->_input ['pay_time'] = time ();
					break;
				case 2 :
					$this->_input ['deliver_time'] = time ();
					break;
				case 3 : //买家已确认收货
					$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ["spcode"] );
					//更改订单状态
					switch ($order_array['sell_type']){
						case '0'://拍卖
							require_once('order_process_auction.class.php');
							$obj_order_process = new OrderProcessAuction($order_array['sp_code']);
							break;
						case '1'://一口价
							require_once('order_process_fixprice.class.php');
							$obj_order_process = new OrderProcessFixprice($order_array['sp_code']);
							break;
						case '2'://团购
							require_once('order_process_group.class.php');
							$obj_order_process = new OrderProcessGroup($order_array['sp_code']);
							break;
						default:
							exit;
					}
					$obj_order_process->changeOrderState($order_array['sp_code'],3);
					$this->redirectPath ( "succ", "member/own_order.php?action=bought", $this->_lang ['langOrderState'] );
					break;
			}
			$this->_input ["txtSPstate"] = $state;
			
			$result = $this->obj_product_order->updateProductOrderState ( $this->_input );
			$this->redirectPath ( "succ", "member/own_order.php?action=bought", $this->_lang ['langOrderState'] );
		}
	}
	
	/**
	 * 发货
	 */
	function _invoice() {
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["sp_code"], "require" => "true", "message" => $this->_lang ['langOrderSpcodeEmpty'] ), array ("input" => $this->_input ["receive_code"], "require" => "true", "message" => $this->_lang ['langOrderReceivepcodeEmpty'] ), array ("input" => $this->_input ["type"], "require" => "true", "message" => $this->_lang ['langOrderPaymentWrong'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			//取订单信息判断订单编号是否与收货地址编号相同，不同则返回错误
			$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ["sp_code"] );
			if ($order_array ['receive_code'] != $this->_input ["receive_code"] || $order_array['seller_id'] != $_SESSION['s_login']['id']) {
				$this->redirectPath ( "error", "", $this->_lang ['langOrderSpcodeEmpty'] );
			}
			//判断订单状态，如果大于等于2，则报错
			if ($order_array ['sp_state'] > 1) {
				$this->redirectPath ( "error", "", $this->_lang ['langOrderStateChange'] );
			}
			
			/**
			 * 页面输出
			 */
			$this->output ( 'order_array', $order_array );
			$this->showpage ( "own_order.invoice" );
		}
	}
	
	/**
	 * 新增发货单
	 */
	function _invoice_save() {
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["sp_code"], "require" => "true", "message" => $this->_lang ['langOrderSpcodeEmpty'] ), array ("input" => $this->_input ["invoice_info"], "require" => "true", "message" => $this->_lang ['langOrderInvoiceEmpty'] ) );
		
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			//判断是否已经有对应的发货单,如果有则返回错误
			$invoice_array = $this->obj_product_order->getInvoice ( $this->_input ["sp_code"] );
			if (! empty ( $invoice_array )) {
				$this->redirectPath ( "error", "", $this->_lang ['langOrderInvoiceWrong'] );
			}
			//取订单信息
			$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ["sp_code"] );
			//判断对应的支付接口文件是否存在 不是预存款的方式
			if ($order_array ['sp_pay_mechod'] != 'predeposit' && (!file_exists ( "../payment/" . $order_array ['sp_pay_mechod'] . "/index.php" ) || !file_exists ("../payment/" . $order_array ['sp_pay_mechod'] . "/payment_module.php"))) {
				$result = "(../payment/" . $order_array ['sp_pay_mechod'] . "/index.php or payment_module.php)" . " is not exists";
				$this->redirectPath ( "error", "", $result );
			}
			//新增发货单
			$param_array = array ();
			$param_array ['order_code'] = $order_array ['sp_code'];
			$param_array ['receive_code'] = $order_array ['receive_code'];
			$param_array ['invoice_info'] = Common::replacebr ( $this->_input ["invoice_info"] );
			$result = $this->obj_product_order->addInvoice ( $param_array );
			if ($result == true) {
				switch ($order_array['sell_type']){
					case '0'://拍卖
						require_once('order_process_auction.class.php');
						$obj_order_process = new OrderProcessAuction();
						break;
					case '1'://一口价
						require_once('order_process_fixprice.class.php');
						$obj_order_process = new OrderProcessFixprice();
						break;
					case '2'://团购
						require_once('order_process_group.class.php');
						$obj_order_process = new OrderProcessGroup();
						break;
					default:
						exit;
				}
				
				//更改订单状态
				$obj_order_process->changeOrderState($order_array['sp_code'],2);
				
				if ($order_array ['sp_pay_mechod'] == 'predeposit' || $order_array ['sp_pay_mechod'] == 'offline') {
					$url = 'member/own_order.php?action=sold';
					$this->redirectPath ( "succ", $url, $this->_lang ['langOrderInvoiceAddIsSucc'] );
				} else {
					//跳转到对应的支付方式页面
					$url = 'payment/' . $order_array ['sp_pay_mechod'] . '/index.php?sp_code=' . $order_array ['sp_code'];
					$this->redirectPath ( "succ", $url, $this->_lang ['langOrderInvoiceAddIsSucc'] );
				}
			} else {
				$this->redirectPath ( "error", "", $this->_lang ['langOrderInvoiceIsFaild'] );
			}
		}
	}
	
	/**
	 * 买家确认收货单
	 */
	function _order_receive() {
		$sp_code = $this->_input ['sp_code'];
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $sp_code );
		if ($order_array ['buyer_id'] != $_SESSION ['s_login'] ['id']) {
			$this->redirectPath ( "error", "", $this->_lang ['langOrderReceiveIsFaild'] );
		}
		//取发货单内容
		$invoice_array = $this->obj_product_order->getInvoice($sp_code);
		$order_array['invoice_info'] = $invoice_array['invoice_info'];
		/**
		 * 页面输出
		 */
		$this->output ( 'order_array', $order_array );
		$this->showpage ( 'own_order.receive' );
	}
	
	/**
	 * 买家购买成功显示页面
	 */
	function _pay_success() {
		
		//取订单信息
		$sp_code = $this->_input ['sp_code'];
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $sp_code );
		
		//取收货地址
		$condition ['member_id'] = $order_array ['buyer_id'];
		$condition ['receive_code'] = $order_array ['receive_code'];
		$receive_info = $this->obj_receive->getAllReceive ( $condition, $this->obj_page );
		unset ( $condition );

		//取卖家信息
		$condition ['member_id'] = $order_array ['seller_id'];
		$seller_info = $this->obj_member->getMemberInfo ( $condition, '*', 'more' );
		$seller_info['sms_name']	= urlencode($seller_info['login_name']);
		
		//取商品信息
		$condition ['p_code'] = $order_array ['p_code'];
		$product_array = $this->obj_product->getProductList ( $condition, $this->obj_page );
		//判断商品是否有静态页
		$product_array = $this->obj_product->checkProductIfHtml ( $product_array, $this->_configinfo ['productinfo'] ['ifhtml'] );
		unset ( $condition );
		
		/**
		 * 页面输出
		 */
		$this->output ( 'order_array', $order_array );
		$this->output ( 'receive_info', $receive_info[0] );
		$this->output ( 'seller_info', $seller_info );
		$this->output ( 'product_array', $product_array );
		$this->showpage ( 'own_order.pay_success' );
	}
	
	/**
	 * 拍卖情况下订单选择支付方式和货币种类
	 */
	function _bid_sel_payment() {
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["sp_code"], "require" => "true", "message" => $this->_lang ['langOrderSpcodeEmpty'] ) );
		
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			//取订单信息
			$sp_code = $this->_input ['sp_code'];
			$order_array = $this->obj_product_order->getOneOrderBySpcode ( $sp_code );
			//判断是否是该订单的会员
			if ($order_array ['buyer_id'] == $_SESSION ['s_login'] ['id']) {
				//取商品信息
				$product_info = $this->obj_product->getProductRow ( $order_array ['p_code'] );
				//商品的支持的支付方式
				$product_payment = @explode ( '|', trim ( $product_info ['p_pay_method'], '|' ) );
				//商品的支持的货币种类
				$product_currency = @explode ( '|', trim ( $product_info ['p_currency_category'], '|' ) );
				//汇率列表
				//创建汇率对象，取汇率信息
				if (! is_object ( $this->obj_exchange )) {
					require_once ("exchange.class.php");
					$this->obj_exchange = new ExchangeClass ( );
				}
				$exchange_array = $this->obj_exchange->listExchange ( $condition, $page );
				
				if (is_array ( $product_payment )) {
					$payment_array = array ();
					$i = 0;
					foreach ( $product_payment as $k => $v ) {
						if (file_exists ( BasePath . '/payment/' . $v . "/payment_module.php" )) {
							include_once (BasePath . '/payment/' . $v . "/payment_module.php");
							$classname = $v . "PaymentMethod";
							$obj_module = new $classname ( );
							//该支付方式参数
							$array = $obj_module->payment_param ();
							//判断货币种类是否有值，如果没有
							if (! empty ( $array ['currency'] )) {
								$j = 0;
								$currency_array = array ();
								foreach ( $array ['currency'] as $k2 => $v2 ) {
									//判断是否该货币种类是该商品支持的,下标为货币种类，值为价格
									if (in_array ( $v2, $product_currency )) {
										if (is_array ( $exchange_array )) {
											foreach ( $exchange_array as $k3 => $v3 ) {
												if ($v3 ['exchange_name'] == $v2) {
													$currency_array [$v2] = @number_format ( ($product_info ['p_price'] / $v3 ['exchange_rate']) * 100, 2 ) <= 0.01 ? '0.01' : @number_format ( ($product_info ['p_price'] / $v3 ['exchange_rate']) * 100, 2 );
												}
											}
										}
									}
								}
								$payment_array [$v] ['name'] = $array ['name'];
								$payment_array [$v] ['currency'] = $currency_array;
								unset ( $currency_array );
								if ($i == '0') {
									$payment_array [$v] ['check'] = 1;
								}
								$i ++;
							}
							unset ( $obj_module, $array );
						}
					}
				}
				
				/**
				 * 页面输出
				 */
				$this->output ( 'product_info', $product_info );
				$this->output ( 'order_array', $order_array );
				$this->output ( 'payment_array', $payment_array );
				$this->showpage ( "own_order.bid_select_payment" );
			} else {
				$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
			}
		}
	
	}
	
	/**
	 * 更新订单的支付方式
	 */
	function _bid_sel_payment_save() {
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (array ("input" => $this->_input ["sp_code"], "require" => "true", "message" => $this->_lang ['errOrderCodeEmpty'] ) );
		$error = $this->obj_validate->validate ();
		if ($error != "") {
			$this->redirectPath ( "error", "", $error );
		} else {
			//取订单信息
			$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ['sp_code'] );
			//判断状态，如果不是已购买（state=0），直接跳转，不更新状态
			if ($order_array ['sp_state'] != '0'){
				$this->redirectPath ( "error", "", $error );
			}
			
			//更新订单
			$param_array = array ();
			$param_array ['sp_code'] = $order_array['sp_code'];
			$param_array ['sp_pay_mechod'] = $this->_input ['txtPayment'];
			$param_array ['sp_currency_category'] = $this->_input [$this->_input ['txtPayment'] . '_currency'];
			//如果是线下交易，则状态变为已付款
			if ($this->_input ['txtPayment'] == 'offline'){
				$param_array['sp_state'] = '1';
			}
			$this->obj_product_order->updateProductOrder ( $param_array );
			
			switch ($order_array['sell_type']){
				case '0'://拍卖
					require_once('order_process_auction.class.php');
					$obj_order_process = new OrderProcessAuction();
					break;
				case '1'://一口价
					require_once('order_process_fixprice.class.php');
					$obj_order_process = new OrderProcessFixprice();
					break;
				case '2'://团购
					require_once('order_process_group.class.php');
					$obj_order_process = new OrderProcessGroup();
					break;
				default:
					exit;
			}
			$order_array['state_info'] = $obj_order_process->getOrderStateInfo($order_array['sp_code']);
			//线下方式
			if ($this->_input ['txtPayment'] == 'offline'){
				$this->redirectPath ( "succ", 'member/own_order.php?action=bought', $this->_lang ['langOrderBargainingOk'] );
			}else {
				@header ( "Location: " . $order_array['state_info']['state_url'] );
			}
		}
	}
	
	/**
	 * 订单查看
	 */
	function _show_order_info($sp_code) {
		
		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $sp_code );
		//判断订单是否和会员一致
		if ($_SESSION['s_login']['id'] != $order_array['seller_id'] && $_SESSION['s_login']['id'] != $order_array['buyer_id']){
			$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
		}
		//格式化时间
		if ($order_array['pay_time'] != ''){
			$order_array['pay_time'] = date("Y-m-d H:i:s",$order_array['pay_time']);
		}
		if ($order_array['deliver_time'] != ''){
			$order_array['deliver_time'] = date("Y-m-d H:i:s",$order_array['deliver_time']);
		}
		if ($order_array['receive_time'] != ''){
			$order_array['receive_time'] = date("Y-m-d H:i:s",$order_array['receive_time']);
		}
		if ($order_array['sold_time'] != ''){
			$order_array['sold_time'] = date("Y-m-d H:i:s",$order_array['sold_time']);
		}
		
		//取收货地址
		$condition ['member_id'] = $order_array ['buyer_id'];
		$condition ['receive_code'] = $order_array ['receive_code'];
		$array = $this->obj_receive->getAllReceive ( $condition, $this->obj_page );
		$receive_info = $array[0];
		unset ( $condition ,$array);
		
		//取卖家信息
		$condition ['id'] = $order_array ['seller_id'];
		$condition ['member_state'] = 1;
		$seller_info = $this->obj_member->getMemberInfo ( $condition, '*', 'more' );
		$seller_info['sms_name']	= urlencode($seller_info['login_name']);
		unset ( $condition );
		
		//取买家信息
		$condition ['id'] = $order_array ['buyer_id'];
		$condition ['member_state'] = 1;
		$buyer_info = $this->obj_member->getMemberInfo ( $condition, '*', 'more' );
		unset ( $condition );
		//判断商品是否有静态页
		if (file_exists("../html/user/".$order_array['pc_id']."/item_detail-".$order_array['p_code'].".html")){
			$html_url = "../html/user/".$order_array['pc_id']."/item_detail-".$order_array['p_code'].".html";
		}
		//创建汇率对象，取汇率信息
		if (! is_object ( $this->obj_exchange )) {
			require_once ("exchange.class.php");
			$this->obj_exchange = new ExchangeClass ( );
		}
		//去货币对应中文名称的数组
		$exchange_remark = $this->obj_exchange->getExchangeArray();
		if (is_array($exchange_remark)){
			$order_array['sp_currency_category'] = $exchange_remark[$order_array['sp_currency_category']];
		}
		/**
		 * 页面输出
		 */
		$this->output ( 'order_array', $order_array );
		$this->output ( 'receive_info', $receive_info );
		$this->output ( 'seller_info', $seller_info );
		$this->output ( 'buyer_info', $buyer_info );
		$this->output ( 'html_url', $html_url );
		$this->showpage ( 'own_order.show' );
	}
	
	/**
	 * 线下状态 修改订单状态付款
	 */
	function _offline_pay(){
		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input['sp_code'] );
		//判断订单是否和会员一致
		if ($_SESSION['s_login']['id'] != $order_array['buyer_id']){
			$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
		}
		/**
		 * 页面输出
		 */
		$this->output ( 'order_array', $order_array );
		$this->showpage ( 'own_order.offline_pay' );
	}
	
	/**
	 * 线下状态 修改订单状态付款
	 */
	function _save_offline_pay(){
		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input['sp_code'] );
		//判断订单是否和会员一致
		if ($_SESSION['s_login']['id'] != $order_array['buyer_id']){
			$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
		}
		switch ($order_array['sell_type']){
			case '0'://拍卖
			require_once('order_process_auction.class.php');
			$obj_order_process = new OrderProcessAuction();
			break;
			case '1'://一口价
			require_once('order_process_fixprice.class.php');
			$obj_order_process = new OrderProcessFixprice();
			break;
			case '2'://团购
			require_once('order_process_group.class.php');
			$obj_order_process = new OrderProcessGroup();
			break;
			default:
				exit;
		}
		//更改订单状态
		$result = $obj_order_process->changeOrderState($order_array['sp_code'],1);
		if ($result === true){
			$this->redirectPath ( "succ", "member/own_order.php?action=bought", $this->_lang ['alertOrderOperatorOk'] );
		}else {
			$this->redirectPath ( "error", "", $this->_lang ['langOrderInvoiceIsFaild'] );
		}
	}
	
	/**
	 * 关闭交易
	 */
	function _close(){
		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ['sp_code'] );
		//判断状态，如果不是已购买（state=0），直接跳转，不更新状态
		if ($order_array ['sp_state'] != '0'){
			$this->redirectPath ( "error", "", $this->_lang['errOrderCloseIsNotAtState'] );
		}
		//判断订单是否和会员一致
		if ($_SESSION['s_login']['id'] != $order_array['seller_id']){
			$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
		}
		/**
		 * 页面输出
		 */
		$this->output('order_array',$order_array);
		$this->showpage('own_order.close');
	}
	
	/**
	 * 保存关闭信息
	 */
	function _close_save(){
		/**
		 * 验证提交信息
		 */
		$this->obj_validate->validateparam = array (
			array ("input" => $this->_input ["sp_code"], "require" => "true", "message" => $this->_lang ['langOrderSpcodeEmpty'] ), 
			array ("input" => $this->_input ["close_reason"], "require" => "true", "message" => $this->_lang['errOrderCloseReasonIsEmpty'] ) );
		
		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode ( $this->_input ['sp_code'] );
		//判断状态，如果不是已购买（state=0），直接跳转，不更新状态
		if ($order_array ['sp_state'] != '0'){
			$this->redirectPath ( "error", "", $this->_lang['errOrderCloseIsNotAtState'] );
		}
		//判断订单是否和会员一致
		if ($_SESSION['s_login']['id'] != $order_array['seller_id']){
			$this->redirectPath ( "error", "", $this->_lang ['langOrderIsSameToMember'] );
		}
		$value_array = array();
		$value_array['sp_code'] = $order_array['sp_code'];
		$value_array['sp_state'] = 7;
		$value_array['close_reason'] = $this->_input['close_reason'];
		//更改订单状态
		$result = $this->obj_product_order->updateProductOrder($value_array);
		if ($result === true){
			$this->redirectPath ( "succ", "member/own_order.php?action=sold", $this->_lang['langOrderCloseIsSucc'] );
		}else {
			$this->redirectPath ( "error", "", $this->_lang['errOrderCloseIsFail'] );
		}
	}
}

$product_order_manage = new OwnProductOrderManage ( );
$product_order_manage->main ();
unset ( $product_order_manage );
?>