<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_payment.php   FILE_PATH : E:\www\multishop\trunk\member\own_payment.php
 * ....支付方式设置
 *
 * @copyright Copyright (c) 2007 - 2007 www.shopnc.net 
 * @author ShopNC Develop Team
 * @package 
 * @subpackage 
 * @version Mon May 12 09:50:21 CST 2008
 */

include_once('../global.inc.php');

class OwnPayment extends CommonFrameWork{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	/**
	 * 支付对象
	 *
	 * @var obj
	 */
	var $obj_payment;
	
	function main(){
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->objmember)){
			require_once ("member.class.php");
			$this->objmember = new MemberClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->objvalidate)){
			require_once("commonvalidate.class.php");
			$this->objvalidate = new CommonValidate();
		}
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("member");
		
		//用户管理界面上的菜单
		$this->memberMenuModule();
		
		/**
		 * 执行操作
		 */
		switch($this->_input['action']){
			case "manage":
				$this->_manage();
				break;
			case "save":
				$this->_save();
				break;
			default:
				$this->_manage();
				break;
		}
	}
	
	/**
	 * 支付页面 
	 */
	function _manage(){
		//得到会员资料
		$condition['id'] = $_SESSION['s_login']['id'];
		$member_array = $this->objmember->getMemberInfo($condition,'*',$operate_genre='more');
		
		//配置文件中的支付方式$this->_configinfo['payment'];
		//数组文件中的支付方式$this->_b_config['payment'];
		//整合支付方式数组
		if (is_array($this->_configinfo['payment'])){
			$payment_array = array();
			foreach ($this->_configinfo['payment'] as $k => $v){
				//当支付模块开启的时候，排除线下交易的类型，线下交易在数据库中没有字段
				if ($v == 1 && file_exists(BasePath.'/payment/'.$k.'/payment_module.php')){
					include_once(BasePath.'/payment/'.$k.'/payment_module.php');
					$class_name = $k.'PaymentMethod';
					$obj_p_module = new $class_name;
					$param_array = $obj_p_module->payment_param();
					if ($param_array['type'] != 'offline'){
						$payment_array[$k]['name'] = $this->_b_config['payment'][$k];
					}
//					elseif ($param_array['type'] == 'offline'){//如果是线下的，则只设定是否开启该支付方式
//						$payment_array[$k]['name'] = $this->_b_config['payment'][$k];
//						$payment_array[$k]['radio'] = 1;
//					}
					unset($class_name,$obj_p_module,$param_array);
					//前台显示标识
					$sign = true;
				}
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('sign',$sign);
		$this->output('payment_array',$payment_array);
		$this->output('member_array',$member_array);
		$this->showpage('own_payment.manage');
	}
	
	/**
	 * 保存记录
	 */
	function _save(){
		//按照配置文件中的支付字段来接值
		if (is_array($this->_configinfo['payment'])){
			$payment_array = array();
			foreach ($this->_configinfo['payment'] as $k => $v){
				//当支付模块开启的时候，排除线下交易的类型，线下交易在数据库中没有字段
				if ($v == 1 && file_exists(BasePath.'/payment/'.$k.'/payment_module.php')){
					include_once(BasePath.'/payment/'.$k.'/payment_module.php');
					$class_name = $k.'PaymentMethod';
					$obj_p_module = new $class_name;
					$param_array = $obj_p_module->payment_param();
					if (!empty($param_array['field'])){
						$payment_array[$k] = $this->_input[$k];
					}
					unset($class_name,$obj_p_module,$param_array);
				}
			}
			$this->objmember->modifyMember($payment_array,$_SESSION['s_login']['id'],'payemnt');
		}
		$this->redirectPath("succ","member/own_payment.php",$this->_lang['langMInfoAmendOk']);
	}
}

$payment = new OwnPayment();
$payment->main();
unset($payment);
?>