<?php 
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_product.php   FILE_PATH : \multishop\member\own_product.php
 * ....商品管理功能
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Tue Aug 28 15:51:41 CST 2007
 */
require_once("../global.inc.php");

class OwnProductManage extends CommonFrameWork{
	/**
	 * 商品对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 * 商品分类对象
	 *
	 * @var obj
	 */
	var $objProductCate;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $objvalidate;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 拍卖商品出价对象
	 *
	 * @var obj
	 */
	var $obj_product_bid;
	/**
	 * 网站提醒对象
	 *
	 * @var obj
	 */
	var $obj_remind;
	/**
	 * 外汇对象
	 *
	 * @var obj
	 */
	var $obj_exchange;
	/**
	 * 地区对象
	 *
	 * @var obj
	 */
	var $obj_area;
	/**
	 * 订单对象
	 *
	 * @var obj
	 */
	var $obj_product_order;
	/**
	 * 商品品牌对象
	 *
	 * @var obj
	 */
	var $obj_product_brand;
	/**
	 * 店铺商品类别对象
	 *
	 * @var obj
	 */
	var $obj_shop_product_cate;
		
	function main(){
		/**
		 * 创建商品对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->objvalidate)){
			require_once("commonvalidate.class.php");
			$this->objvalidate = new CommonValidate();
		}
		/**
		 * 网站提醒操作
		 */
		if (!is_object($this->obj_remind)){
			require_once('remind.class.php');
			$this->obj_remind = new RemindClass();
		}
		/**
		 * 创建汇率对象
		 */
		if (!is_object($this->obj_exchange)){
			require_once("exchange.class.php");
			$this->obj_exchange = new ExchangeClass();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 创建品牌对象
		 */
		if (!is_object($this->obj_product_brand)){
			require_once ("product_brand.class.php");
			$this->obj_product_brand = new ProductBrandClass();
		}
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("product");
		$this->getlang("productsucc");
		
		$this->memberMenuModule();

		switch ($this->_input['action']){
			case "sell":
				//判断用户组权限
				CheckPermission::memberGroupPermission('sell',$_SESSION['s_login']['id']);
				//判断发布商品限制
				CheckPermission::outputProductPermission($_SESSION['s_login']['id']);
				$this->_sellproduct();
				break;
			case "add":
				$this->_addproduct();
				break;
			case "save":
				$this->_saveproduct();
				break;
			case "modi":
				$this->_modiproduct();
				break;
			case "update":
				$this->_updateproduct();
				break;
			case "del":
				$this->_delproduct();
				break;
			case "update_count":
				$this->_updateproductcount();
				break;
			case "pic_add":
				$this->_pic_add();
				break;
			case "pic_del":
				$this->_pic_del();
				break;
			default:
				exit;
				break;
		}
	}
	
	
	/**
	 * 出售商品第一步：选择商品分类
	 *
	 */
	function _sellproduct(){
		/**
		 * 语言包
		 */
		$this->getlang("productsell");
		
		/**
		 * 判断当前会员是否可以发布商品
		 */
		if ($this->_configinfo['paymode']['shop_pay_mode'] == '1'){
			//取会员信息
			$condition['id'] = $_SESSION['s_login']['id'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
			$member_array['product_number'] = $member_array['product_number']?$member_array['product_number']:0;
			//取上架商品数量
			$obj_condition['member'] = $_SESSION['s_login']['id'];
			$product_array = $this->obj_product->getProductList($obj_condition, $page);
			if (count($product_array) >= $member_array['product_number']){
				unset($condition,$member_array);
				$this->redirectPath("error","../member/own_shop_pay.php?action=pay",$this->_lang['langPCanSaleNumberMax']);
			}
		}
		
		/**
		 * 实例化商品类别类
		 */
		if (!is_object($this->obj_product_cate)){
			require_once("productclass.class.php");
			$this->obj_product_cate = new ProductCategoryClass();
		}

		$array = $this->obj_product_cate->listClassDetail('');
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0'){
					$product_top_cate[] = $v;
				}
			}
		}

		$this->output("top_cate", $product_top_cate);
		$this->output("pid", $this->_input['pid']);
		$this->showpage("own_product.sell");
	}

	/**
	 * 添加商品页面
	 *
	 */
	function _addproduct(){
		//判断是否有商品类别，如果没有，则返回到选择类别页面
		if ($this->_input['select_all'] == ''){
			$this->redirectPath('error','../member/own_product.php?action=sell',$this->_lang['errPcidEmpty']);
		}
		//商品类别
		if (!is_object($this->objProductCate)){
			require_once("productclass.class.php");
			$this->objProductCate = new ProductCategoryClass();
		}
		$ProductClassArray = $this->objProductCate->listClassDetail('');
		$select_all_id = explode("|", $this->_input['select_all']);
		$selltype = $this->_input['Selltype']?$this->_input['Selltype']:1;
		$i = 0;
		$cate_name = "";
		if (is_array($select_all_id)){
			foreach($select_all_id as $value){
				if (is_array($ProductClassArray)) {
					foreach ($ProductClassArray as $k => $v){
						if ($v['id'] == $value) {
							$select_row = $v;
							break;
						}
					}
				}
				if ($select_row[name] != '') {
					$cate_name .= ">>" . $select_row[name];
				}

				$i++;
			}
		}
		if("" != $cate_name){
			$cate_name = substr($cate_name, 2);
		}
		//商品属性
		require_once("attribute.class.php");
		$obj_product_attribute = new AttributeClass();
		require_once("attribute_content.class.php");
		$obj_product_attribute_content = new AttributeContentClass();
		
		
		$this->_input['pcid']=$this->_input['select_cate']?$this->_input['select_cate']:$select_all_id[count($select_all_id)-1];
		$condition_attribute['pc_id'] = $this->_input['pcid'];
		$product_attribute = $obj_product_attribute->getAttributeList($condition_attribute,$page);
		unset($condition_attribute);
		if(count($product_attribute)>0){
			//取商品属性内容
			foreach ($product_attribute as $k => $v){
				$condition_attribut_content['a_id'] = $v['a_id'];
				$product_attribute[$k]['content'] = $obj_product_attribute_content->getAttributeContentList($condition_attribut_content,$page);
				unset($condition_attribut_content);
				if (count($product_attribute[$k]['content']) > 0){
					$content_sign = 1;
				}else {
					unset($product_attribute[$k]);
				}
			}
			//判断商品属性是否有内容
			if ($content_sign == 1){//有内容
				$have_attribute = 1;
			}
			unset($content_sign);
		}
		
		list($usec, $sec) = explode(" ", microtime());
		$mytime = floor((((float)$usec + (float)$sec))*1000);
		
		
		//取支付方式
		if (is_array($this->_configinfo['payment'])){
			//会员信息
			$condition['id'] = $_SESSION['s_login']['id'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
			//取会员信息,用来验证显示的支付方式
			foreach ($this->_configinfo['payment'] as $k => $v){
				if ($v == 1 && file_exists(BasePath.'/payment/'.$k.'/payment_module.php')){
					include_once(BasePath.'/payment/'.$k.'/payment_module.php');
					$class_name = $k.'PaymentMethod';
					$obj_p_module = new $class_name;
					$param_array = $obj_p_module->payment_param();
					//不是线下的，并且在会员信息中有值的
					if ($param_array['type'] != 'offline' && $member_array[$k] != ''){
						$payment_array[$k]['name'] = $param_array['name'];
						//支持的货币种类
						$payment_array[$k]['currency'] = $param_array['currency'];//数组形式
						$payment_array[$k]['currency_line'] = implode('|',$param_array['currency']);//数组形式
					}elseif ($param_array['type'] == 'offline'){//是线下的
						$payment_array[$k]['name'] = $param_array['name'];
						//支持的货币种类
						$payment_array[$k]['currency'] = $param_array['currency'];//数组形式
						$payment_array[$k]['currency_line'] = implode('|',$param_array['currency']);//数组形式
					}
					//默认为显示的支付方式全部选中
					if ($payment_array[$k]['name'] != ''){
						$payment_array[$k]['check'] = 1;
					}
					$payment_description[] = $param_array;
					//销毁变量
					unset($class_name,$obj_p_module,$param_array);
				}
			}
		}
		//获得店铺宝贝分类
		if ($_SESSION['s_shop']['id'] != ''){
			$shop_product_category = $this->_getshopclass($_SESSION['s_shop']['id']);
		}			
		if (!is_array($payment_array)){
			$this->redirectPath("error","../member/own_payment.php",$this->_lang['errMPaymentEmpty']);
		}
		
		//取货币种类
		$condition_exchange['state'] = 1;
		$exchange_array = $this->obj_exchange->listExchange($condition_exchange,$page);
		if (is_array($exchange_array)){
			foreach ($exchange_array as $k => $v){
				$exchange_array[$k]['display'] = 'block';//前台显示标识
			}
		}
		//控制货币前台显示
		if (is_array($payment_array)){
			$array = array();
			$product_currency = array();
			foreach ($payment_array as $k => $v){
				if ($v['check'] == 1){//选中的支付方式
					if (is_array($v['currency'])){
						foreach ($v['currency'] as $k2 => $v2){
							$array[]= $v2;
						}
					}
				}
				//默认取所有货币为支持的货币
				$product_currency = array_merge($product_currency,$v['currency']);
			}
			$array = array_unique($array);
			sort($array);
			if (is_array($exchange_array)){
				foreach ($exchange_array as $k => $v){
					if (!in_array($v['exchange_name'],$array)){
						$exchange_array[$k]['display'] = 'none';//前台显示标识
					}
				}
				sort($exchange_array);
			}
		}
		//去除重复的货币种类
		$product_currency = array_unique($product_currency);
		unset($array);
		
		//地区调用
		$array = Common::getAreaCache('');
		$area_array = array();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[1] == '0'){
					$v['area_id'] = $v[0];
					$v['area_parent_id'] = $v[1];
					$v['area_name'] = $v[2];
					$v['is_parent'] = $v[5];//1是父ID，0不是
					$area_array[] = $v;
				}
			}
		}
		unset($array);
		
		//商品品牌内容
		$array = Common::getProductBrandCache('');
		$brand_list = array();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[1] == '0'){
					$v['pb_id'] = $v[0];
					$v['pb_u_id'] = $v[1];
					$v['pb_name'] = $v[2];
					$v['is_parent'] = $v[5];//1是父ID，0不是
					$brand_list[] = $v;
				}
			}
		}
		unset($array);
		
		//输出footer内容
		$this->_show_footer();
		
		/**
		 * 页面输出
		 */
		$this->output("area_array", $area_array);
		$this->output("config_predeposit", $this->_configinfo['payment']['predeposit']);
		$this->output("payment_description", $payment_description);
		$this->output("exchange_array", $exchange_array);
		$this->output("payment_array", $payment_array);
		$this->output("shop_product_cate_array",   $shop_product_category); 
		$this->output("selltype", $selltype);
		$this->output("product_code", $product_code);
		$this->output("nowtime", $mytime);
		$this->output("cate_name", $cate_name);
		$this->output("have_attribute", $have_attribute);
		$this->output("product_attribute", $product_attribute);
		$this->output("slPCId", $this->_input['pcid']);
		$this->output("select_all", $this->_input['select_all']);
		$this->output("payment_array", $payment_array);
		$this->output("product_currency", $product_currency);
		$this->output("brand_list", $brand_list);
		$this->showpage("own_product.add");
	}

	/**
	 * 保存商品信息
	 *
	 */
	function _saveproduct(){
		/**
		 * 验证表单信息
		 */

		if("2" == $this->_input["radioSelltype"]){//团购
			$this->_input["txtPprice"] = $this->_input["txtPoldprice"];
		}
		if("0" == $this->_input["radioSelltype"]){//拍卖
			$this->_input["txtPprice"] = $this->_input["minimumBid"];
		}

		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["txtPname"],"require"=>"true","message"=>$this->_lang['errPSNameEmpty']),
		array("input"=>$this->_input["slPCId"],"require"=>"true","message"=>$this->_lang['errPcidEmpty']),
		array("input"=>$this->_input["txtPinfo"],"require"=>"true","message"=>$this->_lang['errPSInfoEmpty']),
		array("input"=>$this->_input["radioSelltype"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSSelltype']),
		array("input"=>$this->_input["radioType"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSType']),
		array("input"=>$this->_input["txtPstorage"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSstorage']),
		//array("input"=>$this->_input["txtPprice"],"validator"=>"Currency","message"=>$this->_lang['errPSprice']),
		array("input"=>$this->_input["txtGroupprice"],"validator"=>"Currency","message"=>$this->_lang['errPSGroupprice']),
		array("input"=>$this->_input["txtPoldprice"],"validator"=>"Currency","message"=>$this->_lang['errPsPoldprice']),
		array("input"=>$this->_input["txtPoldprice"],"validator"=>"Compare","operator"=>">=","to"=>$this->_input["txtGroupprice"],"message"=>$this->_lang['errPSPriceNoGroupPrice']),
		array("input"=>$this->_input["txtGroupmincount"],"validator"=>"Number","message"=>$this->_lang['errPSGroupmincount']),
		array("input"=>$this->_input["area_id"],"require"=>"true","message"=>$this->_lang['errPProductAreaIsEmpty']),
		array("input"=>$this->_input["radioTransfee"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSTransfee']),
		array("input"=>$this->_input["radioInvoices"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSInvoices']),
		array("input"=>$this->_input["radioWarranty"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSWarranty']),
		array("input"=>$this->_input["slValiddays"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSValiddays']),
		array("input"=>$this->_input["chxAutopublish"],"validator"=>"Integer","message"=>$this->_lang['errPSAutopublish']),
		array("input"=>$this->_input["chxRecommended"],"validator"=>"Integer","message"=>$this->_lang['errPSRecommended']));
		$error = $this->objvalidate->validate();
		
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			$this->_input["txtPinfo"] = Common::replacebr($this->_input["txtPinfo"]);
			$this->_input["txtMemberid"] = $_SESSION['s_login']['id'];
			$this->_input["txtThemeid"] = 0;
			$this->_input["txtPpoint"] = 0;
			$this->_input["txtPviewnum"] = 0;
			if("" == $this->_input["chxAutopublish"]){
				$this->_input["chxAutopublish"] = 0;
			}
			if("" == $this->_input["chxRecommended"]){
				$this->_input["chxRecommended"]=0;
			}
			if(("0" == $this->_input["_now"])){
				$this->_input["txtPstate"] = 1;
				$this->_input["txtPstarttime"] = time();
				$this->_input["txtPendtime"] = Common::calculateDate("d",$this->_input["slValiddays"],time());
			}elseif ("1" == $this->_input["_now"]){
				$this->_input["txtPstate"] = 0;
				$start_time = split("-", $this->_input["_date"]);
				$this->_input["txtPstarttime"] = mktime($this->_input["_hour"],$this->_input["_minute"],0,$start_time[1],$start_time[2],$start_time[0]);
				$this->_input["txtPendtime"] = Common::calculateDate("d",$this->_input["slValiddays"],$this->_input["txtPstarttime"]);
				$this->_input["IfnoPub"] = 1;

			}elseif ("2" == $this->_input["_now"]){
				$this->_input["txtPstate"] = 0;
				$this->_input["txtPstarttime"] = "";
				$this->_input["txtPendtime"] = "";
			}

			//组合支付方式
			if (is_array($this->_input['txtPayment'])){
				$this->_input['payment'] = '';
				foreach ($this->_input['txtPayment'] as $k => $v){
					$this->_input['pay_method'] .= $v.'|';
				}
				$this->_input['pay_method'] = trim($this->_input['pay_method'],'|');
			}
			if ($this->_input['pay_method'] == '' &&  $this->_input['pay_predeposit'] == ''){//如果错误则返回
				$this->redirectPath("error","",$this->_lang['errPayment']);
			}else {
				$this->_input['pay_method'] = '|'.$this->_input['pay_method'].'|';
			}
			//组合支持交易的货币种类
			if (is_array($this->_input['currency'])){
				$this->_input['p_currency_category'] = '|'.@implode('|',$this->_input['currency']).'|';
			}

			/*生成商品编号*/
			$product_last_id = $this->obj_product->getProductLastId();
			if("" == $product_last_id){
				$product_last_id = 1;
			}else{
				$product_last_id += 1;
			}
			$chars = array(
			"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k",
			"l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
			"w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G",
			"H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R",
			"S", "T", "U", "V", "W", "X", "Y", "Z"
			);
			$random_string = Common::genRandomString($chars, 4);
			$this->_input["txtPcode"] = md5($product_last_id.$random_string);
			
			//处理上传图片
			$pic_arr = array();//图片名数组
			for ($i=0;;$i++){
				if(!isset($_FILES['txtPpic_'.$i]['name']) || $_FILES['txtPpic_'.$i]['name'] == ''){
					break;
				}
				$pic_arr[] = $this->_pic_add('txtPpic_'.$i);
			}
//			$pic_arr = @explode('|',$this->_input['p_pic']);
			if (is_array($pic_arr)){
				$pic_value = array();
				$j = 0;
				for ($i=0;$i<count($pic_arr);$i++){
					if ($pic_arr[$i] != ''){
						//$pic_arr[$i] 为缩略图文件名，更改为普通图片缩略图
						$arr = @explode('.',$pic_arr[$i]);
						$arr_two = @explode('_',$arr[0]);
						$pic_value[$j]['p_pic'] = $arr_two[0].'.'.$arr[1];
						$pic_value[$j]['p_code'] = $this->_input["txtPcode"];
						unset($arr,$arr_two);
						$j++;
					}
				}
			}
			//默认取第一个作为商品列表展示使用的图片，存入商品信息表中
			$this->_input['txtPpic'] = $pic_value[0]['p_pic'];
			//预存款
			if($this->_configinfo['payment']['predeposit'] == '1'){//开启状态
				$this->_input['pay_predeposit'] = ($this->_input['pay_predeposit']=='0')?$this->_input['pay_predeposit']:'1';
			}
			//会员信息
			$condition['id'] = $_SESSION['s_login']['id'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
			//判断是否是推荐商品，如果没有剩余的推荐数量，那么将推荐属性清除
			if ($member_array['recommend_max_count']-$member_array['recommend_product_count'] <= 1){
				$this->_input['chxRecommended'] = '0';
			}
			/**
			 * 商品信息入库
			 */
			$result = $this->obj_product->addProduct($this->_input);
			
			/**
			 * UC推送
			 */
			if ($this->_configinfo['api']['open_passport'] == '1' && $this->_configinfo['api']['passport_type'] == '2'){
				//商品信息参数
				$subject_url = $this->_configinfo['websit']['site_url'].'/home/product.php?action=view&pid='.$this->_input["txtPcode"];
				define('UC_APPID',$this->_configinfo['ucenter']['uc_appid']);
				$feed_param = array(
					'icon'=>'',
					'uid'=>$_SESSION['s_login']['id'],
					'username'=>$_SESSION['s_login']['name'],
					'title_template'=>'{actor}'.$this->_lang['langProductAdd'].'{subject}',
					'title_data'=>array('subject'=>"<a href='".$subject_url."'>".$this->_input['txtPname']."</a>"),
//					'body_template'=>$body_template,
//					'body_data'=>$body_data,
//					'body_general'=>$body_general,
//					'target_ids'=>$target_ids,
//					'image_1'=>$images[0]['url'],
//					'image_1_link'=>$images[0]['link'],
//					'image_2'=>$images[1]['url'],
//					'image_2_link'=>$images[1]['link'],
//					'image_3'=>$images[2]['url'],
//					'image_3_link'=>$images[2]['link'],
//					'image_4'=>$images[3]['url'],
//					'image_4_link'=>$images[3]['link']
				);
				
				require_once('ucenter.class.php');
				$obj_ucenter = new ucenterClass();
				$obj_ucenter->uc_feed($feed_param);
				unset($obj_ucenter);
			}
			/**
			 * 商品图片入库
			 */
			if (is_array($pic_value)){
				for ($i=0;$i<count($pic_value);$i++){
					$this->obj_product->addProductPic($pic_value[$i]);
				}
				unset($pic_value);
			}
			/**
		 	 * 商品属性及属性内容ID处理
		 	 */
			if(is_array($this->_input["attribute_content"])){
				$i = 0;
				foreach ($this->_input["attribute_content"] as $k => $v){
					if("" != $v){
						$attribute_array[$i] = explode('|', $v);
						list($ac_id[$i], $aid[$i]) = $attribute_array[$i];
						$i++;
					}
				}
				if(is_array($aid)){
					$new_aid = array_unique($aid);
					$i=0;
					foreach ($new_aid as $k => $v){
						$insert_aid[$i] = $v;
						$insert_acid[$i] = "";
						foreach($attribute_array as $key => $value){
							if($value[1] == $v){
								$insert_acid[$i] .= ",".$value[0];
							}
						}
						$insert_acid[$i] = preg_replace("/^,/", "", $insert_acid[$i]);
						$insert_ac[$i] = $insert_aid[$i]."|".$insert_acid[$i];
						$i++;
					}
					$result_attribute = $this->obj_product->addProductAttribute($this->_input["txtPcode"], $insert_ac);
				}
			}
			/**
			 * 更新商品发布数量的统计信息
			 */
			if($this->_input["txtPstate"] == "1"){
				$update_product_statis = $this->obj_product->updateProductStatistics($this->_input["txtMemberid"],'sell');
			}

			/**
			 * 生成静态页面
			 */
			$html = $this->make_product_html($this->_input["txtPcode"]);
			if(!$html){
				echo "faild to make html file";exit;
			}
			/*判断返回路径*/
			if (file_exists("../html/user/".$this->_input['slPCId']."/item_detail-".$this->_input["txtPcode"].'.html')){
				$url = "../html/user/".$this->_input['slPCId']."/item_detail-".$this->_input["txtPcode"].'.html';
			}else {
				$url = "../home/product.php?action=view&pid=".$this->_input["txtPcode"];
			}
			
			//成功发布商品
			CreditsClass::saveCreditsLog('succ_product_put',$_SESSION["s_login"]['id']);
			
			/**
			 * 设置模板路径
			 */
			$this->setsubtemplates("member");
			/**
			 * 页面输出
			 */
			$this->output('select_all',$this->_input['select_all']);
			$this->output('url',$url);
			$this->showpage("own_product.succ");
		}
	}

	/**
	 * 生成静态文件
	 *
	 */
	function make_product_html($p_id){
		/**
		 * 创建商品静态页面对象
		 */
		if (!is_object($obj_html_product)){
			require_once("../home/html.product.php");
			$obj_html_product = new HtmlProductManage();
		}
		$result = $obj_html_product->_make_product_html($p_id);
		return $result;
	}


	/**
	 * 修改产品信息
	 *
	 */
	function _modiproduct(){
		//验证会员和商品是否一致
		$this->checkRightMemberToProduct($this->_input["pid"]);
		/**
		 * 取商品信息
		 */
		$product_array = $this->obj_product->getProductRow($this->_input["pid"]);
		if ($product_array['p_sell_type'] != '1'){
			/**
			 * 实例化商品订单类
			 */
			if (!is_object($this->obj_product_order)){
				require_once("order.class.php");
				$this->obj_product_order = new ProductOrderClass();
			}
			if (!is_object($this->obj_product_bid)){
				require_once("bid.class.php");
				$this->obj_product_bid = new BidClass();
			}
			$condition['p_code'] = $this->_input["pid"];
			$condition['search_time'] = 1;
			$condition['start_time'] = $product_array['p_start_time'];
			$condition['end_time'] = $product_array['p_end_time'];
			$order = $this->obj_product_order->getProductOrderList($condition,$page);
			unset($condition);
			$condition['p_code'] = $product_array['p_code'];
			$bid = $this->obj_product_bid->getProductBidList($condition,$page);
			//判断条件
			//判断在这次发布时是否有商品的购买信息
			//判断在这次发布时是否有商品的拍卖
			if ((count($order) > 0 || count($bid) > 0) && $product_array['p_state'] == 1) {
				$error = $this->_lang['errPProductIsLocked'];
				$this->redirectPath("error","",$error);
			}
			unset($order,$bid,$condition);
		}
		/**
		 * 取商品所有类别
		 */
		if (!is_object($this->objProductCate)){
			require_once("productclass.class.php");
			$this->objProductCate = new ProductCategoryClass();
		}
		$ProductClassArray = $this->objProductCate->listClassDetail('');
		/**
		 * 商品属性处理
		 */
		require_once("attribute.class.php");
		$obj_product_attribute = new AttributeClass();
		require_once("attribute_content.class.php");
		$obj_product_attribute_content = new AttributeContentClass();
		//取商品属性选中项
		$attribute_condition_str = " and p_id = '" . $this->_input["pid"] . "'";
		$product_have_attribute = $this->obj_product->getProductAttribute($attribute_condition_str, $page);
		//将商品属性id组成一个数组
		if(is_array($product_have_attribute)){
			foreach ($product_have_attribute as $key => $value){
				$ac_content = explode(',', $value[pac_content]);
				foreach ($ac_content as $k => $v){
					$pac_attribute[] = $v;
				}
			}
		}
		//取属性
		$pcid = $product_array['pc_id'];
		$condition_attribute['pc_id'] = $pcid;
		$product_attribute = $obj_product_attribute->getAttributeList($condition_attribute,$page);
		unset($condition_attribute);
		if(count($product_attribute)>0){
			//取商品属性内容
			foreach ($product_attribute as $k => $v){
				$condition_attribut_content['a_id'] = $v['a_id'];
				$product_attribute[$k]['content'] = $obj_product_attribute_content->getAttributeContentList($condition_attribut_content,$page);
				unset($condition_attribut_content);
				if (count($product_attribute[$k]['content']) > 0){
					$content_sign = 1;
					//判断选中
					foreach ($product_attribute[$k]['content'] as $k2 => $v2){
						if(is_array($pac_attribute) && in_array($v2['ac_id'], $pac_attribute)){
							$product_attribute[$k]['content'][$k2]['ischecked'] = 1;
						}
					}
				}else {
					unset($product_attribute[$k]);
				}
			}
			//判断商品属性是否有内容
			if ($content_sign == 1){//有内容
				$have_attribute = 1;
			}
			unset($content_sign);
		}
		
		/**
		 * 商品类别
		 */
		if ($this->_input['select_all'] != ''){
			$select_all_id = explode("|", $this->_input['select_all']);
			$selltype = $this->_input['Selltype']?$this->_input['Selltype']:1;
			$i = 0;
			$cate_name = "";
			foreach($select_all_id as $value){
				$select_row = $this->objProductCate->getPcateRow($value);
				$cate_name .= ">>" . $select_row[0]['name'];
				$i++;
			}
			if("" != $cate_name){
				$cate_name = substr($cate_name, 2);
			}
		}else{
			$cate_row = $this->objProductCate->getPClassRow($pcid);
			for ($j=0;$j<4;$j++){
				if ($cate_row[pc_name] != '') {
					$cate_name = ">>" . $cate_row['pc_name'].$cate_name;
				}
				if ($cate_row[0]['pc_u_id'] != '0'){
					$cate_row = $this->objProductCate->getPClassRow($cate_row['pc_u_id']);
				}else {
					break;
				}
			}
		}

		$array = $this->objProductCate->listClassDetail('');
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[4] == '0') {
					$ProductCateArray[] = $v;
				}
			}
		}

		$ProductClassArray = $this->objProductCate->listClassDetail('');
		if(!is_array($ProductClassArray)){
			$ProductClassArray = array();
		}
	

		if ($this->_input['select_all'] != ''){
			$slPCId = $select_all_id[count($select_all_id)-1];
			$cate_path = $this->objProductCate->get_path($ProductClassArray, $slPCId);
		}else {
			$slPCId = $product_array['pc_id'];
			$cate_path = $this->objProductCate->get_path($ProductClassArray, $slPCId);
		}

		if ($product_array['p_state'] == '1') {
			$checked_state = 1;
		}elseif ($product_array['p_state'] == '0' && $product_array['p_start_time'] != '0') {
			$checked_state = 2;
		}else {
			$checked_state = 3;
		}
		
		//处理商品支持的货币种类
		if (strstr($product_array['p_currency_category'],'|')) {
			$product_currency = @explode('|',trim($product_array['p_currency_category'],'|'));
		}else {
			$product_currency = $product_array['p_currency_category'];
		}
		
		//取货币种类
		$condition_exchange['state'] = 1;
		$exchange_array = $this->obj_exchange->listExchange($condition_exchange,$page);
		if (is_array($exchange_array)){
			foreach ($exchange_array as $k => $v){
				$exchange_array[$k]['display'] = 'block';//前台显示标识
			}
		}
		
		//取支付方式
		if (is_array($this->_configinfo['payment'])){
			//取会员信息,用来验证显示的支付方式
			$condition['id'] = $_SESSION['s_login']['id'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*',$operate_genre='more');
			foreach ($this->_configinfo['payment'] as $k => $v){
				if ($v == 1 && file_exists(BasePath.'/payment/'.$k.'/payment_module.php')){
					include_once(BasePath.'/payment/'.$k.'/payment_module.php');
					$class_name = $k.'PaymentMethod';
					$obj_p_module = new $class_name;
					$param_array = $obj_p_module->payment_param();
					if ($param_array['type'] != 'offline' && $member_array[$k] != ''){//不是线下的，并且在会员信息中有值的
						$payment_array[$k]['name'] = $param_array['name'];
						//支持的货币种类
						$payment_array[$k]['currency'] = $param_array['currency'];//数组形式
						$payment_array[$k]['currency_line'] = implode('|',$param_array['currency']);//数组形式
					}elseif ($param_array['type'] == 'offline'){//是线下的 并且是开启状态的（值为1）
						$payment_array[$k]['name'] = $param_array['name'];
						//支持的货币种类
						$payment_array[$k]['currency'] = $param_array['currency'];//数组形式
						$payment_array[$k]['currency_line'] = implode('|',$param_array['currency']);//数组形式
					}
					//判断是否选中
					if (strstr($product_array['p_pay_method'],'|'.$k.'|') && $payment_array[$k]['name'] != ''){
						$payment_array[$k]['check'] = 1;
					}
					//支付说明是使用的数组
					$payment_description[] = $param_array;
					unset($class_name,$obj_p_module,$param_array);
				}
			}
		}
		//获得店铺宝贝分类
		if ($_SESSION['s_shop']['id'] != ''){
			$shop_product_category = $this->_getshopclass($_SESSION['s_shop']['id']);
		}			
		//控制货币前台显示
		if (is_array($payment_array)){
			$array = array();
			foreach ($payment_array as $k => $v){
				if ($v['check'] == 1){//选中的支付方式
					if (is_array($v['currency'])){
						foreach ($v['currency'] as $k2 => $v2){
							$array[]= $v2;
						}
					}
				}
			}
			$array = array_unique($array);
			sort($array);
			if (is_array($exchange_array)){
				foreach ($exchange_array as $k => $v){
					if (!in_array($v['exchange_name'],$array)){
						$exchange_array[$k]['display'] = 'none';//前台显示标识
					}
				}
				sort($exchange_array);
			}
		}
		unset($array);
		
		//图片列表	商品编辑页调用小图
		$condition_pic['p_code'] = $this->_input["pid"];
		$array = $this->obj_product->getProductPic($condition_pic,$page);
		if (is_array($array)){
			$pic_array = array();
			$j=0;
			for ($i=0;$i<count($array);$i++){
				if (file_exists(BasePath.'/'.$array[$i]['p_pic'])){
					$pic_array[$j]['p_pic'] = $array[$i]['p_pic'];		
					$temp = @explode('.',$array[$i]['p_pic']);
					$pic_array[$j]['small_pic'] = $temp[0].'_small.'.$temp[1];
					$pic_line .= '|'.$pic_array[$j]['small_pic'];
					$j++;
					unset($temp);
				}
			}
			$pic_line = trim($pic_line,'|');
		}
		unset($array);
		//地区调用
		$array = Common::getAreaCache('');
		$area_array = array();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[1] == '0'){
					$v['area_id'] = $v[0];
					$v['area_parent_id'] = $v[1];
					$v['area_name'] = $v[2];
					$v['is_parent'] = $v[5];//1是父ID，0不是
					$area_array[] = $v;
				}
			}
		}
		unset($array);
		//取地区内容
		if (!empty($product_array) && $product_array['p_area_id'] !=''){
			/**
			 * 创建地区对象
			 */
			if (!is_object($this->obj_area)){
				require_once ("area.class.php");
				$this->obj_area = new AreaClass();
			}
			$sel_area = $this->obj_area->getAreaPathList($product_array['p_area_id']);
		}
		
		//商品品牌内容
		$array = Common::getProductBrandCache('');
		$brand_list = array();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[1] == '0'){
					$v['pb_id'] = $v[0];
					$v['pb_u_id'] = $v[1];
					$v['pb_name'] = $v[2];
					$v['is_parent'] = $v[5];//1是父ID，0不是
					$brand_list[] = $v;
				}
			}
		}
		unset($array);
		//取品牌内容
		if (!empty($product_array) && $product_array['p_pb_id'] !=''){
			$sel_brand = $this->obj_product_brand->getProductBrandPathList($product_array['p_pb_id']);
		}
		//输出footer内容
		$this->_show_footer();
		/**
		 * 页面输出
		 */
		$this->output("sel_area", $sel_area);
		$this->output("area_array", $area_array);
		$this->output("config_predeposit", $this->_configinfo['payment']['predeposit']);
		$this->output("pic_array", $pic_array);
		$this->output("pic_num", count($pic_array));//图片数量
		$this->output("pic_line", $pic_line);
		$this->output("payment_description", $payment_description);
		$this->output("shop_product_cate_array",   $shop_product_category); 		
		$this->output("exchange_array", $exchange_array);
		$this->output("product_currency", $product_currency);
		$this->output("payment_array", $payment_array);
		$this->output("default_time",$product_array['p_start_time']);
		$this->output('checked_state',$checked_state);
		$this->output("slPCId", $slPCId);
		$this->output('ProductCateArray',$ProductCateArray);
		$this->output("selltype", $product_array['p_sell_type']);
		$this->output("site_url", $this->_configinfo['websit']['site_url']);
		$this->output("product_array", $product_array);
		$this->output("cate_name", $cate_name);
		$this->output("product_attribute", $product_attribute);
		$this->output("have_attribute", $have_attribute);
		$this->output("product_have_attribute", $pac_attribute);
		$this->output("sel_brand", $sel_brand);
		$this->output("brand_list", $brand_list);
		$this->showpage("own_product.add");
	}
	/**
	 * 获取店铺商品分类
	 *
	 * @param int $shop_id
	 * @return array
	 */
	function _getshopclass ($shop_id) {
		/**
		 * 创建商铺宝贝分类对象
		 */
		if (!is_object($this->obj_shop_product_cate)){
			require_once("shopproductcategory.class.php");
			$this->obj_shop_product_cate = new ShopProductCategoryClass();
		}			
		//得到店铺宝贝分类
		$condition_shop_product_cate['shop_id'] = $shop_id;
		$condition_shop_product_cate['order_by'] = " shop_product_class.class_parent_id asc,shop_product_class.class_sort asc,shop_product_class.class_id asc ";
		$shop_product_category = $this->obj_shop_product_cate->getCategory($condition_shop_product_cate,$page);
		//整理数组为多级
		$shop_product_category = $this->obj_shop_product_cate->_makeCategoryArray($shop_product_category);
		return 	$shop_product_category;	
	}
	/**
	 * 更新产品信息
	 *
	 */
	function _updateproduct(){
		if("2" == $this->_input["radioSelltype"]){//团购
			$this->_input["txtPprice"] = $this->_input["txtPoldprice"];
		}
		if("0" == $this->_input["radioSelltype"]){//拍卖
			$this->_input["txtPprice"] = $this->_input["minimumBid"];
		}
		/**
		 * 验证表单信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["txtPname"],"require"=>"true","message"=>$this->_lang['errPSNameEmpty']),
		array("input"=>$this->_input["txtPinfo"],"require"=>"true","message"=>$this->_lang['errPSInfoEmpty']),
		array("input"=>$this->_input["radioSelltype"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSSelltype']),
		array("input"=>$this->_input["slPCId"],"require"=>"true","validator"=>"Integer","message"=>$this->_lang['errPCId']),
		array("input"=>$this->_input["radioType"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSType']),
		array("input"=>$this->_input["txtPstorage"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSstorage']),
		//array("input"=>$this->_input["txtPprice"],"require"=>"true","validator"=>"Currency","message"=>$this->_lang['errPSprice']),
		array("input"=>$this->_input["txtGroupprice"],"validator"=>"Currency","message"=>$this->_lang['errPSGroupprice']),
		array("input"=>$this->_input["txtPoldprice"],"validator"=>"Currency","message"=>$this->_lang['errPSPoldprice']),
		array("input"=>$this->_input["txtGroupmincount"],"validator"=>"Number","message"=>$this->_lang['errPSGroupmincount']),
		array("input"=>$this->_input["area_id"],"require"=>"true","message"=>$this->_lang['errPProductAreaIsEmpty']),
		array("input"=>$this->_input["radioTransfee"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSTransfee']),
		array("input"=>$this->_input["radioInvoices"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSInvoices']),
		array("input"=>$this->_input["radioWarranty"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSWarranty']),
		array("input"=>$this->_input["slValiddays"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSValiddays']),
		array("input"=>$this->_input["chxAutopublish"],"validator"=>"Integer","message"=>$this->_lang['errPSAutopublish']),
		array("input"=>$this->_input["chxRecommended"],"validator"=>"Integer","message"=>$this->_lang['errPSRecommended']));
		
		$error = $this->objvalidate->validate();

		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			//取原来商品的信息
			$old_product = $this->obj_product->getProductRow($this->_input['txtPid']);
			//验证商品和会员是否一致
			$this->checkRightMemberToProduct($this->_input['txtPid']);

			//组合支付方式
			if (is_array($this->_input['txtPayment'])){
				$this->_input['payment'] = '';
				foreach ($this->_input['txtPayment'] as $k => $v){
					$this->_input['pay_method'] .= $v.'|';
				}
				$this->_input['pay_method'] = trim($this->_input['pay_method'],'|');
			}
			if ($this->_input['pay_method'] == '' && $this->_input['pay_predeposit'] == ''){//如果错误则返回
				$this->redirectPath("error","",$this->_lang['errPayment']);
			}else {
				$this->_input['pay_method'] = '|'.$this->_input['pay_method'].'|';
			}
			//组合支持交易的货币种类
			if (is_array($this->_input['currency'])){
				$this->_input['p_currency_category'] = '|'.@implode('|',$this->_input['currency']).'|';
			}

			$this->_input["txtPinfo"] = Common::replacebr($this->_input["txtPinfo"]);
			$this->_input["txtMemberid"] = $_SESSION['s_login']['id'];
			$this->_input["txtThemeid"] = 0;
			$this->_input["txtPpoint"] = 0;
			if("" == $this->_input["chxAutopublish"]){
				$this->_input["chxAutopublish"] = 0;
			}
			if("" == $this->_input["chxRecommended"]){
				$this->_input["chxRecommended"] = 0;
			}
			if("2" == $this->_input["radioSelltype"]){
				$this->_input["txtPprice"] = $this->_input["txtPoldprice"];
			}

			if(("0" == $this->_input["_now"])){			/*宝贝发布时间立刻开始*/
				if("1" != $this->_input["txtPstate"]){
					$this->_input["txtPstate"] = '1';
					$this->_input["txtPstarttime"] = time();
					$this->_input["txtPendtime"] = Common::calculateDate("d",$this->_input["slValiddays"],$this->_input["txtPstarttime"]);
				}elseif("" != $this->_input["slValiddays"]){	/*宝贝出售结束时间随有效期更改*/
					$this->_input["txtPendtime"] = Common::calculateDate("d",$this->_input["slValiddays"],$this->_input["txtPstarttime"]);
				}

			}elseif ("1" == $this->_input["_now"]){		/*宝贝发布时间设定开始*/
				$this->_input["txtPstate"] = '0';
				$start_time = split("-", $this->_input["_date"]);
				$this->_input["txtPstarttime"] = mktime($this->_input["_hour"],$this->_input["_minute"],0,$start_time[1],$start_time[2],$start_time[0]);
				$this->_input["txtPendtime"] = Common::calculateDate("d",$this->_input["slValiddays"],$this->_input["txtPstarttime"]);
				$this->_input["IfnoPub"] = 1;

			}elseif ("2" == $this->_input["_now"]){		/*宝贝放入仓库*/
				$this->_input["txtPstate"] = '0';
				$this->_input["txtPstarttime"] = "0";
				$this->_input["txtPendtime"] = "0";
			}

			//将原来的PIC数据清空
//			$this->obj_product->delProductPic($this->_input['txtPid']);
			//将图片字符串分割
			//处理上传图片
			$pic_arr = array();//图片名数组
			for ($i=0;;$i++){
				if(!isset($_FILES['txtPpic_'.$i]['name']) || $_FILES['txtPpic_'.$i]['name'] == ''){
					break;
				}
				$pic_arr[] = $this->_pic_add('txtPpic_'.$i);
			}
//			$pic_arr = @explode('|',$this->_input['p_pic']);
			if (is_array($pic_arr)){
				$pic_value = array();
				$j = 0;
				for ($i=0;$i<count($pic_arr);$i++){
					if ($pic_arr[$i] != ''){
						//$pic_arr[$i] 为缩略图文件名，更改为普通图片缩略图
						$arr = @explode('.',$pic_arr[$i]);
						$arr_two = @explode('_',$arr[0]);
						$pic_value[$j]['p_pic'] = $arr_two[0].'.'.$arr[1];
						$pic_value[$j]['p_code'] = $this->_input['txtPid'];
						unset($arr,$arr_two);
						$j++;
					}
				}
			}
			
			if ($pic_value[0]['p_pic'] != ''){
				$this->_input['txtPpic'] = $pic_value[0]['p_pic'];
			}
			//预存款
			if($this->_configinfo['payment']['predeposit'] == '1'){//开启状态
				$this->_input['pay_predeposit'] = ($this->_input['pay_predeposit']=='0')?$this->_input['pay_predeposit']:'1';
			}
			//会员信息
			$condition['id'] = $_SESSION['s_login']['id'];
			$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
			//判断是否是推荐商品，如果没有剩余的推荐数量，那么将推荐属性清除
			if ($member_array['recommend_max_count']-$member_array['recommend_product_count'] <= 1){
				$this->_input['chxRecommended'] = '0';
			}
			$result = $this->obj_product->updateProduct($this->_input);
			//图片入库
			if (is_array($pic_value)){
				for ($i=0;$i<count($pic_value);$i++){
					$this->obj_product->addProductPic($pic_value[$i]);
				}
				unset($pic_value);
			}
			
			/**
		 	 * 商品属性及属性内容ID处理
		 	 */
			if(is_array($this->_input["attribute_content"])){
				$i = 0;
				foreach ($this->_input["attribute_content"] as $k => $v){
					if("" != $v){
						$attribute_array[$i] = explode('|', $v);
						list($ac_id[$i], $aid[$i]) = $attribute_array[$i];
						$i++;
					}
				}

				$new_aid = array_unique($aid);
				$i=0;
				foreach ($new_aid as $k => $v){
					$insert_aid[$i] = $v;
					$insert_acid[$i] = "";
					foreach($attribute_array as $key => $value){
						if($value[1] == $v){
							$insert_acid[$i] .= ",".$value[0];
						}
					}
					$insert_acid[$i] = preg_replace("/^,/", "", $insert_acid[$i]);
					$insert_ac[$i] = $insert_aid[$i]."|".$insert_acid[$i];
					$i++;
				}
				$result_attribute = $this->obj_product->updateProductAttribute($this->_input["txtPcode"], $insert_ac);
			}
			/**
			 * 更新商品发布数量的统计信息
			 */
			$update_product_statis = $this->obj_product->updateProductStatistics($this->_input["txtMemberid"],'sell');

			/*删除原来旧的静态文件*/
			$old_file = "../html/user/".$old_product['pc_id']."/item_detail-".$old_product['p_code'].'.html';
			if (file_exists($old_file)){
				@unlink($old_file);
			}

			/**
			 * 生成静态页面
			 */
			$html = $this->make_product_html($this->_input["txtPid"]);
			if(!$html){
				$this->redirectPath('error','','faild to make html file');
			}
			/**
			 * 取商品新信息
			 */
			$product_row = $this->obj_product->getProductRow($this->_input["txtPid"]);
			if ($this->_configinfo['productinfo']['ifhtml'] == '1'){
				$url = "./html/user/".$product_row['pc_id']."/item_detail-".$product_row['p_code'].'.html';
			}else {
				$url = "./home/product.php?action=view&pid=".$product_row['p_code'];
			}
			$this->redirectPath("succ",$url,$this->_lang['langPSMerchandiseInfoAmendOk']);
		}
	}
	/**
	 * 更新商品数量
	 *
	 */
	function _updateproductcount(){
		/**
		 * 验证提交信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["txtPcode"],"require"=>"true","message"=>$this->_lang['errPSCodeEmpty']),
		array("input"=>$this->_input["txtPcount"],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errPSstorage']));
		$error = $this->objvalidate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			$result = $this->obj_product->updateProductCount($this->_input);
			$html   = $this->make_product_html($this->_input["txtPcode"]);
			if(!$html){
				$this->redirectPath("error","",$error);
			}
			$this->redirectPath("succ","member/own_product_list.php?action=list",$this->_lang['langPSoperatorOk']);
		}

	}
	/**
	 * 更改商品订单状态
	 *
	 * @param int $state 0:已成交 1:已支付 2:已发货 3:已收货 4:已好评
	 */
	function _updateproductorderstate($state){

		/**
		 * 验证提交信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["txtSPcode"],"require"=>"true","message"=>$this->_lang['errPSCodeEmpty']));
		$error = $this->objvalidate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			$this->_input["txtSPstate"] = $state;
			$result = $this->obj_product->updateProductOrderState($this->_input);
			$this->redirectPath("succ","member/own_product_list.php?action=list",$this->_lang['langPSoperatorOk']);
		}
	}
	/**
	 * 删除商品
	 *
	 */
	function _delproduct(){
		if (is_array($this->_input['chboxPid'])){
			foreach ($this->_input['chboxPid'] as $value){
				$this->objvalidate->setValidate(array("input"=>$value,"require"=>"true","message"=>$this->_lang['errProductId']));
			}
		}
		$error = $this->objvalidate->validate();
		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			if (is_array($this->_input['chboxPid'])){
				foreach ($this->_input['chboxPid'] as $k => $value){
					if ($this->_input['check_sign'][$value] != ''){
						unset($this->_input['chboxPid'][$k]);
					}else {//允许删除
						$this->checkRightMemberToProduct($value);
					}
				}
			}
			$result = $this->obj_product->delProduct($this->_input['chboxPid']);
			if($result){
				//返回链接的action标识
				$this->_input['list_type'] = $this->_input['list_type']?$this->_input['list_type']:'list';
				$this->redirectPath("succ","member/own_product_list.php?action=".$this->_input['list_type'],$this->_lang['langPSoperatorOk']);
			}else {
				$this->redirectPath("error","",$this->_lang['errProductId']);
			}
		}
	}

	/**
	 * 检查会员是否和商品所属会员相同
	 */
	function checkRightMemberToProduct($p_id){
		if ($p_id != ''){
			$product_array = $this->obj_product->getProductRow($p_id);
			if ($product_array['member_id'] != $_SESSION["s_login"]['id']){
				$error = $this->_lang['langPProductMemberErrRestartLogin'];
				$this->redirectPath("error","../index.html",$error);
			}
		}else {
			$error = $this->_lang['langPProductMemberErrRestartLogin'];
			$this->redirectPath("error","../index.html",$error);
		}
	}
	
	/**
	 * 商品图片上传
	 */
	function _pic_add($input_file_name){
//		if(isset($_FILES['txtPpic']['name']) and $_FILES['txtPpic']['name'] != ''){
		if (!is_object($this->obj_upload)){
			require_once("uploadfile.class.php");
			$this->obj_upload = new UploadFile();
			$this->obj_upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);
		}
		//上传商品图片
		$filename = $this->obj_upload->upfile($input_file_name);
		/*按比例生成图片*/
		$cut = $this->_configinfo['productinfo']['imageresize_ifcut'];
		if ($filename !== false){
			//加水印
			if ($this->_configinfo['gdimage']['wm_image_sign'] == 1 && file_exists(BasePath.'/'.$this->_configinfo['gdimage']['wm_image_name'])) {
				//图片名
				$return_name = $filename["getfilename"];
				require_once ("gdimage.class.php");
				$img = new GDImage();
				$img->wm_image_transition = $this->_configinfo['gdimage']['wm_image_transition'];//透明度
				$img->wm_image_pos = $this->_configinfo['gdimage']['wm_image_pos'];//位置
				$img->save_file = BasePath.'/'.$return_name;//返回文件名称
				$img->wm_image_name = BasePath.'/'.$this->_configinfo['gdimage']['wm_image_name'];//水印图片
				$img->create(BasePath.'/'.$return_name);
				unset($img);
			}
			include_once ('resizeImage.class.php');
			//判断图片大小
			$image_info = @getimagesize($filename['filename']);
			$width = $image_info[0];
			$height = $image_info[1];
			if ($width > $height){//用宽度
				$pic_param = $width;
				$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_width'],2);
			}else {//用高度
				$pic_param = $height;
				$small_percent = number_format($pic_param/$this->_configinfo['productinfo']['imageresize_height'],2);
			}
			//小图
			if (intval($small_percent) > 1){
				$obj_small = new resizeImage($filename['filename'],intval($width/$small_percent),intval($height/$small_percent),$cut);
			}elseif (intval($small_percent) == 1){
				//取与标准尺寸的差值
				$pic_percent = $small_percent;
				$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
				$small_width = intval($width*($pic_percent));
				$small_height = intval($height*($pic_percent));
				$obj_small = new resizeImage($filename['filename'],$small_width,$small_height,$cut);
			}else {
				$obj_small = new resizeImage($filename['filename'],$width,$height,$cut);
			}
			//中图
			if (intval($pic_param/192) > 1){
				$obj_mid = new resizeImage($filename['filename'],intval($width/($pic_param/192)),intval($height/($pic_param/192)),$cut,"_mid.");
			}elseif (intval($pic_param/192) == 1){
				//取与标准尺寸的差值
				$pic_percent = number_format($pic_param/192,2);
				$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
				$mid_width = intval($width*($pic_percent));
				$mid_height = intval($height*($pic_percent));
				$obj_mid = new resizeImage($filename['filename'],$mid_width,$mid_height,$cut,"_mid.");
			}else {
				$obj_mid = new resizeImage($filename['filename'],$width,$height,$cut,"_mid.");
			}
			//大图
			if (intval($pic_param/288) > 1){
				$obj_big = new resizeImage($filename['filename'],intval($width/($pic_param/288)),intval($height/($pic_param/288)),$cut,"_big.");
			}elseif (intval($pic_param/288) == 1){
				//取与标准尺寸的差值
				$pic_percent = number_format($pic_param/288,2);
				$pic_percent = ($pic_percent-1)>0.5?$pic_percent-1:(1-($pic_percent-1));
				$big_width = intval($width*($pic_percent));
				$big_height = intval($height*($pic_percent));
				$obj_big = new resizeImage($filename['filename'],$big_width,$big_height,$cut,"_big.");
			}else {
				$obj_big = new resizeImage($filename['filename'],$width,$height,$cut,"_big.");
			}
			unset($obj_small,$obj_mid,$obj_big);
		}
		return $filename["getfilename"];
		
		//图片名称$filename["getfilename"]
//		$arr = @explode('.',$filename["getfilename"]);
//		$return_name = $arr[0].'_small.'.$arr[1];
//		unset($arr);
		//图片缓存表中增加数据
//		$this->obj_product->addProductPicCache(array('p_pic_cache'=>$filename["getfilename"]));
//		return $filename["getfilename"];
//		Common::outMessage("json",$return_name,1);
//		}else {
//			//输出信息
//			Common::outMessage("json",$this->_lang['langPPicFormatIsWrong'],0);
//		}
	}
	
	/**
	 * AJAX删除图片
	 */
	function _pic_del(){
		if ($this->_input['pic_name'] != ''){
			//将传过来的图片名称分别整理为原有图片，中号和大号图片,全部删除
			$arr = @explode('.',$this->_input['pic_name']);
			$arr[0] = @str_replace('_small','',$arr[0]);
			@unlink(BasePath.'/'.$arr[0].'.'.$arr[1]);
			@unlink(BasePath.'/'.$arr[0].'_small.'.$arr[1]);
			@unlink(BasePath.'/'.$arr[0].'_big.'.$arr[1]);
			@unlink(BasePath.'/'.$arr[0].'_mid.'.$arr[1]);
			//将数据库中的图片信息，也删除
			$this->obj_product->delProductPicByPic($this->_input['pic_name']);
			//图片缓存表中删除数据
			$this->obj_product->delProductPicCache($arr[0].'.'.$arr[1]);
			unset($arr);
			//输出信息
			Common::outMessage("json",'SUCC',1);
		}else {
			//输出信息
			Common::outMessage("json",$this->_lang['langPPicFormatIsWrong'],0);
		}
	}
	
	/**
	 * 在商品添加修改页面 为了防止与im的js冲突，单独输出页脚内容
	 */
	function _show_footer(){
		/**
		 * 创建栏目对象
		 */
		if (!is_object($this->obj_section)){
			require_once("section.class.php");
			$this->obj_section = new SectionClass();
		}
		/**
		 * 语言包
		 */
		$this->getlang("sys_section.manage");
		/**
		 * 取得需要显示的通用栏目信息
		 */
		$array = $this->obj_section->getSectionList();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v['is_show'] == 1){
					$footer_array[] = $v;
				}
			}
		}
		/**
		 * 页面输出
		 */
		$this->output('config_poweredby',$this->_configinfo['websit']['poweredby']);
		$this->output('config_icprecord',$this->_configinfo['websit']['icprecord']);
		$this->output('url',$this->_configinfo['websit']['site_url']);
		$this->output('footer_array',$footer_array);
	}
}

$product_manage = new OwnProductManage();
$product_manage->main();
unset($product_manage);
?>