<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_productmessage.php   FILE_PATH : \multishop\member\own_productmessage.php
 * ....商品留言管理
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Mon Oct 15 15:03:16 CST 2007
 */

require ("../global.inc.php");
class OwnProductMessage extends CommonFrameWork{
	/**
	 * 留言对象
	 *
	 * @var obj
	 */
	var $obj_message;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	
	function main(){
		/**
		 * 创建留言对象
		 */
		if (!is_object($this->obj_message)){
			require_once("productmessage.class.php");
			$this->obj_message = new ProductMessageClass();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("commonpage.class.php");
			$this->obj_page = new CommonPage();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("productmessage");
		$this->memberMenuModule();
		
		switch($this->_input['action']){
			case "buy":
				$this->_listMessage("buy");
				break;
			case "sale":
				$this->_listMessage("sale");
				break;
			case "re":
				$this->_reMessage();
				break;
			case "resave":
				$this->_resave();
				break;
			default:
				$this->_listMessage();
		}
	}
	
	/**
	 * 留言
	 *
	 */
	function _listMessage($genre = "sale"){
		$this->obj_page->pagebarnum(20);    //每页20条记录
		if ($genre == "sale"){//我是卖家，买家回复/留言
			$message_array = $this->obj_message->getProductMessage($this->obj_page,$_SESSION['s_login']['id'],false,"sale");
		}else if($genre == "buy"){//我是买家，卖家回复/留言
			$message_array = $this->obj_message->getProductMessage($this->obj_page,$_SESSION['s_login']['name'],false,"buy");
		}
		$pagelist = $this->obj_page->show(1);      //分页显示
		
		if (is_array($message_array)){
			foreach ($message_array as $k => $v){
				$message_array[$k]['message_time'] = @date("Y-m-d H:i",$v['message_time']);
				//当我是买家，取卖家会员信息
				if ($genre == "buy"){
					$condition['id'] = $v['member_id'];//卖家ID
					$member_array = $this->obj_member->getMemberInfo($condition,'login_name');
					$message_array[$k]['seller_name'] = $member_array['login_name'];
					unset($condition,$member_array);
				}
			}
		}
		
		/**
		 * 页面输出
		 */
		$this->output('message_array',$message_array);    //输出留言列表
		$this->output('message_pagelist',$pagelist);      //输出留言分页
		$this->output('genre',$genre);      //留言类别
		$this->showpage('own_productmessage.manage');
	}
	
	/**
	 * 回复留言
	 */
	function _reMessage(){
		$message_array = $this->obj_message->getOneMessage($this->_input['id'],$_SESSION['s_login']['id']);    //得到某条留言内容
		$message_array['message_time'] = date("Y-m-d H:i",$message_array['message_time']);
		$this->output('message_array',$message_array[0]);   //输出留言内容
		$this->showpage('own_productmessage.re');
	}
	
	/**
	 * 保存回复内容
	 */
	function _resave(){
		/**
		 * 检验输入信息
		 */
		$this->obj_validate->validateparam = array(
			array("input"=>$this->_input["txtReMessage"],"require"=>"true","message"=>$this->_lang['errMakeRevertContent'])
		);
		/**
		 * 检验的错误信息
		 */
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			$exist_array = array('messageid'=>$this->_input['hideMessageID'],'productid'=>$this->_input['hideproductID'],'memberid'=>$_SESSION['s_login']['id']);
			if ($this->obj_message->isExistMessage($exist_array)){
				//将留言内容存放到数据库中
				$this->obj_message->reMessage($this->_input); 
				/**
				 * 网站提醒操作
				 */
				if (!is_object($this->obj_remind)){
					require_once('remind.class.php');
					$this->obj_remind = new RemindClass();
				}
				/**
				 * 创建商品对象
				 */
				if (!is_object($this->obj_product)){
					require_once("product.class.php");
					$this->obj_product = new ProductClass();
				}
				//取商品信息
				$product_array = $this->obj_product->getProductRowById($this->_input['hideproductID']);
				if (!empty($product_array)){
					//留言信息
					$message_array = $this->obj_message->getOneMessage($this->_input['hideMessageID'],$_SESSION['s_login']['id']);
					//提醒操作
					$value_array = array();
					$value_array['username'] = $message_array['member_name'];
					$value_array['product_name'] = $product_array['p_name'];
					$this->obj_remind->setMessageOrMail('buyer_message_seller_product_answer','message_seller_product_answer',$value_array,$message_array['member_name'],$this->_configinfo);//我在宝贝上的留言被卖家回复时，请通知我
					$this->redirectPath("succ","member/own_productmessage.php?action=sale",$this->_lang['alertRevertGuestBookOk']);
				}else {
					$this->redirectPath("succ","member/own_productmessage.php?action=sale",$this->_lang['errProductMInfoIsEmpty']);
				}
			}else{
				$this->redirectPath("error","",$this->_lang['errGuestBookNonentity']);
			}
		}
	}
}
$productmessage = new OwnProductMessage();
$productmessage->main();
unset($productmessage);
?>