<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : own_shop.php   FILE_PATH : \multishop\member\own_shop.php
 * ....商铺管理
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Thu Sep 06 16:52:10 CST 2007
 */

require_once("../global.inc.php");

class OwnShopManage extends CommonFrameWork{
	/**
	 * 商铺对象
	 *
	 * @var obj
	 */
	var $obj_shop;
	/**
	 * 商铺分类对象
	 *
	 * @var obj
	 */
	var $obj_shopcategory;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $objvalidate;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $objmember;
	/**
	 * 地区对象
	 *
	 * @var obj
	 */
	var $obj_area;
	
	function main(){
		/**
		 * 创建商铺对象
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
		 * 创建商铺分类对象
		 */
		if (!is_object($this->obj_shopcategory)){
			require_once("shopcategory.class.php");
			$this->obj_shopcategory = new ShopCategoryClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->objvalidate)){
			require_once("commonvalidate.class.php");
			$this->objvalidate = new CommonValidate();
		}

		/**
		 * 创建会员对象
		 */
		if (!is_object($this->objmember)){
			require_once("member.class.php");
			$this->objmember = new MemberClass();
		}

		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("member");

		/**
		 * 语言包
		 */
		$this->getlang("shop");
		
		//判断店铺删除状态
		$this->isShopDel();
		//用户管理界面上的菜单
		$this->memberMenuModule();
		
		$this->_input['hideMemberId'] = $_SESSION["s_login"]['id'];
		$this->_input['hideShopId'] = $_SESSION["s_shop"]['id'];

		/**
		 * 根据参数调用相应的方法
		 */
		switch ($this->_input['action']){
			case "modi":
				$this->shopMenuModule();
				$this->_getShopInfo();
				break;
			case "new":
				//判断用户组权限
				CheckPermission::memberGroupPermission('shop',$_SESSION['s_login']['id']);
				$this->_newShopInfo();
				break;
			case "save":
				$this->_saveShopInfo();
				break;
			case "save_modi":
				$this->_saveShopModi();
				break;
			case "dellogo":
				$this->_delLogo();
				break;
			case "intro":
				$this->shopMenuModule();
				$this->_getIntro();
				break;
			case "saveintro":
				$this->_saveShopIntro();
				break;
			case 'entity_check':
				$this->_showEntityInfo();
				break;
			case 'save_shopentity':
				$this->_saveEntityInfo();
				break;
			case "delbanner":
				$this->_delBanner();
				break;
			case 'view':
				$this->_showMyStore();
				break;
			default:
				$this->shopMenuModule();
				$this->_getShopInfo();
		}
	}

	/**
	 * 显示某商铺信息
	 *
	 */
	function _getShopInfo(){
		
		$shop_id = $this->obj_shop->getShopID($_SESSION['s_login']['name'],"login_name","1");
		
		/**
		 * 获取商铺信息
		 */
		$shop_array = array();
		$shop_array = $this->obj_shop->getOneShop($shop_id);

		/*判断商品是否存在图片*/
		if (file_exists('../'.$shop_array['shop_pic']) && $shop_array['shop_pic'] !=''){
			/*判断缩略图宽高，按比例缩小*/
			$image_array = @getimagesize('../'.$shop_array['shop_pic']);
			if ($image_array[0] != 0 && $image_array[1] != 0){
				if ($image_array[0] >= $image_array[1]) {/*宽 > 高*/
					$shop_array['width'] = 100;
					$shop_array['height'] = @number_format($image_array[1]/($image_array[0]/100),0);
				}else if ($image_array[0] <= $image_array[1]) {
					$shop_array['width'] = @number_format($image_array[0]/($image_array[1]/100),0);
					$shop_array['height'] = 100;
				}
			}
		}
		//取地区内容
		//地区内容
		$array = Common::getAreaCache();
		$area_array = array();
		if (is_array($array)){
			foreach ($array as $k => $v){
				if ($v[1] == '0'){
					$v['area_id'] = $v[0];
					$v['area_parent_id'] = $v[1];
					$v['area_name'] = $v[2];
					$v['is_parent'] = $v[5];//1是父ID，0不是
					$area_array[] = $v;
				}
			}
		}
		unset($array);
		//取已选择的地区内容
		if (!empty($shop_array) && $shop_array['shop_area_id'] !=''){
			//取地区内容
			if (!is_object($this->obj_area)){
				require_once ("area.class.php");
				$this->obj_area = new AreaClass();
			}
			$sel_area = $this->obj_area->getAreaPathList($shop_array['shop_area_id']);
		}
		/**
		 * 获取商铺的2级分类
		 */
		$category_array = $this->obj_shopcategory->getLevelCategory(2,'');
		if (is_array($category_array)) {
			$array = array();
			foreach ($category_array as $k => $v){
				if ($v['parent_id'] == '0'){
					$array[] = $v;
					/*取该类下的2级类别*/
					foreach ($category_array as $k2 => $v2){
						if ($v2['parent_id'] == $v['class_id']){
							$num = count($array)-1;
							$array[$num]['child'][] = $v2;
							unset($num);
						}
					}
				}
			}
		}
		/**
	     * 将商铺分类以下拉框的形式出现
	     */
		$this->output("area_array", $area_array);
		$this->output("sel_area", $sel_area);
		$this->output("shop_select_category", $array);    //输出商铺分类以下拉框
		$this->output("shop_info", $shop_array);
		$this->showpage("own_shop.modi");
	}
	/**
	 * 查看店铺
	 *
	 */
	function _showMyStore() {
		if ($_SESSION['s_login']['id']) {
			header("location:../store/index.php?userid=".$_SESSION['s_login']['id']);
		} else {
			header("location:../home");
		}
	}

	/**
	 * 新建一个商店
	 *
	 */
	function _newShopInfo(){
		
		$shop_id = $this->obj_shop->getShopID($_SESSION['s_login']['name'],"login_name","1");
		
		if ($_SESSION['s_shop']['id'] != '' || $shop_id != '' ){
			header('Location: own_shop.php?action=modi');
		}else {
			//地区内容
			$array = Common::getAreaCache('');
			$area_array = array();
			if (is_array($array)){
				foreach ($array as $k => $v){
					if ($v[1] == '0'){
						$v['area_id'] = $v[0];
						$v['area_parent_id'] = $v[1];
						$v['area_name'] = $v[2];
						$v['is_parent'] = $v[5];//1是父ID，0不是
						$area_array[] = $v;
					}
				}
			}
			unset($array);
			/**
			 * 获取商铺的2级分类
			 */
			$category_array = $this->obj_shopcategory->getLevelCategory(2,'');
			if (is_array($category_array)) {
				foreach ($category_array as $k => $v){
					if ($v['parent_id'] == '0'){
						$array[] = $v;
						/*取该类下的2级类别*/
						foreach ($category_array as $k2 => $v2){
							if ($v2['parent_id'] == $v['class_id']){
								$num = count($array)-1;
								$array[$num]['child'][] = $v2;
								unset($num);
							}
						}
					}
				}
			}
			/**
		     * 将商铺分类以下拉框的形式出现
		     */
			$this->output("area_array", $area_array);
			$this->output("shop_select_category", $array);    //输出商铺分类以下拉框
			$this->showpage("own_shop.add");   //显示页面
		}
	}

	/**
	 * 开店商铺信息
	 * 店铺名称、店铺类目、店铺介绍
	 *
	 */
	function _saveShopInfo(){
		/**
		 * 检验输入信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["hideMemberId"],"require"=>"true","message"=>$this->_lang['errCMemberNoLogin']), //您尚未登陆，请登陆
		array("input"=>$this->_input["txtShopName"],"require"=>"true","message"=>$this->_lang['errShopEnterName']), //请填写商店名称
		array("input"=>$this->_input["slcShopClass"],"require"=>"true","message"=>$this->_lang['errShopSelectClass']), //请选择商店分类
		//array("input"=>$this->_input["sale_range"],"require"=>"true","message"=>$this->_lang['errShopEnterSaleRange']), //请填写商店经营范围
		array("input"=>$this->_input["area_id"],"require"=>"true","message"=>$this->_lang['langShopPleaseSelectLocus']), //请选择所在地区
		);
		/**
		 * 检验的错误信息
		 */

		$error = $this->objvalidate->validate();

		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			//检测会员是否有店铺存在
			$array = $this->obj_shop->getOneShopByMemeberId($_SESSION['s_login']['id'],'1');
			if (!empty($array) || $_SESSION['s_login']['id'] == ''){
				$this->redirectPath("error","",$this->_lang['errShopIsExists']);
			}
			
			/**
			 * 创建会员对象
			 */
			if (!is_object($this->objmember)){
				require_once ("member.class.php");
				$this->objmember = new MemberClass();
			}
			//店铺审核标识
			$this->_input['ischeck'] = $this->_configinfo['shopinfo']['ifcheck'];
			
			//店铺二级域名
			if($this->_input['hideMemberId'] != ""){
				require_once("domain.class.php");
				$domain = new Domain();
				$domain_id = $domain->makeDomain($this->_input['hideMemberId']);
				$this->_input['shop_domain'] = $domain_id;
				unset($domain_id);
			}
			//新增店铺默认模板
			$this->_input['rdoStyle'] = '04';
			
			$result = $this->obj_shop->operateShop($this->_input);
			
			//开店
			CreditsClass::saveCreditsLog('open_shop',$_SESSION["s_login"]['id'],false);
			
			//得到商城ID
			$shop_id = $this->obj_shop->getShopID($_SESSION['s_login']['name'],"login_name","1"); 
			if ($shop_id > 0){
				$_SESSION["s_shop"]['id'] = $shop_id;
			}
			if ($this->_input['ischeck'] == "0"){//不需要审核
				$this->_input['member_type'] = "1";
				$_SESSION["s_login"]['type'] = "1";
				$this->objmember->modifyMember($this->_input,$_SESSION['s_login']['id'],"type");
				$this->redirectPath("succ",'member/own_main.php',$this->_lang['langShopInfoFillInOk']);
			}else {
				$this->redirectPath("succ",'member/own_main.php',$this->_lang['langShopInfoFillInOkWaitingCheck']);
			}
		}
	}

	/**
	 * 保存店铺信息修改
	 * 
	 */
	function _saveShopModi(){
		/**
		 * 检验输入信息
		 */
		$this->objvalidate->validateparam = array(
		array("input"=>$this->_input["hideMemberId"],"require"=>"true","message"=>$this->_lang['errCMemberNoLogin']), //您尚未登陆，请登陆
		array("input"=>$this->_input["txtShopName"],"require"=>"true","message"=>$this->_lang['errShopEnterName']), //请填写商店名称
		array("input"=>$this->_input["slcShopClass"],"require"=>"true","message"=>$this->_lang['errShopSelectClass']), //请选择商店分类
		//array("input"=>$this->_input["sale_range"],"require"=>"true","message"=>$this->_lang['errShopEnterSaleRange']), //请填写商店经营范围
		array("input"=>$this->_input["area_id"],"require"=>"true","message"=>$this->_lang['langShopPleaseSelectLocus']), //请选择所在地区
		);
		/**
		 * 检验的错误信息
		 */
		$error = $this->objvalidate->validate();

		if($error != ""){
			$this->redirectPath("error","",$error);
		}else{
			/**
			 * 创建会员对象
			 */
			if (!is_object($this->objmember)){
				require_once ("member.class.php");
				$this->objmember = new MemberClass();
			}
			/**
			 * 上传店标图片
			 */
			if($_FILES['fileShopLogo']['name'] != '' && $this->_input['hideShopId'] != ''){
				require_once("uploadfile.class.php");
				$upload = new UploadFile();
				$upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);   //允许上传的文件类型
				$upload->max_size = '500';
				$filename = $upload->upfile("fileShopLogo");
				$this->_input["fileShopLogo"] = $filename['getfilename'];//上传图片
				unset($upload);
			}
			/**
			 * 上传店铺banner图片
			 */
			if($_FILES['fileShopBanner']['name'] != '' && $this->_input['hideShopId'] != ''){
				require_once("uploadfile.class.php");
				$upload = new UploadFile();
				$upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);   //允许上传的文件类型
				$upload->max_size = '500';
				$filename = $upload->upfile("fileShopBanner");
				$this->_input["fileShopBanner"] = $filename['getfilename'];//上传图片
				unset($upload);
			}
			/**
			 * 店铺二级域名
			 */
			if($this->_input['hideMemberId'] != ""){
				require_once("domain.class.php");
				$domain = new Domain();
				$domain_id = $domain->makeDomain($this->_input['hideMemberId']);
				$this->_input['shop_domain'] = $domain_id;
			}

			$result = $this->obj_shop->operateShop($this->_input);  //把信息放入数据库中
			if ($this->_configinfo['shopinfo']['ifcheck'] == '0'){//不需要审核
				$this->_input['member_type'] = "1";
				$_SESSION["s_login"]['type'] = "1";
				$shop_id = $this->obj_shop->getShopID($_SESSION['s_login']['name'],"login_name","1");  //得到商城ID
				if ($shop_id > 0){
					$_SESSION["s_shop"]['id'] = $shop_id;
				}
				$this->objmember->modifyMember($this->_input,$_SESSION['s_login']['id'],"type");
			}
			$this->redirectPath("succ",'member/own_shop.php?action=modi',$this->_lang['langShopInfoFillInOk']);//填写商铺信息成功!
		}
	}

	/**
	 * 删除商店店标
	 *
	 */
	function _delLogo(){
		/**
		 * 获取商铺信息
		 */
		$shop_array = array();
		$shop_array = $this->obj_shop->getOneShop($_SESSION['s_shop']['id']);
		/**
		 * 删除图片
		 */
		if (file_exists("../" . $shop_array['shop_pic'])){
			unlink("../" . $shop_array['shop_pic']);
		}
		/**
		 * 更新数据库
		 */
		$result = $this->obj_shop->delPic($_SESSION['s_shop']['id']);
		$this->redirectPath("succ","member/own_shop.php?action=modi",$this->_lang['langShopDelLogo']);//您已经删除商铺LOGO了!
	}

	/**
	 * 得到店铺信息
	 *
	 */
	function _getIntro(){
		/**
		 * 获取商铺信息
		 */
		$shop_array = array();
		$shop_array = $this->obj_shop->getOneShop($_SESSION['s_shop']['id']);
		$shop_array['shop_intro'] = $shop_array['shop_intro'];
		/**
		 * 页面输出
		 */
		$this->output("shop_intro", $shop_array['shop_intro']);    //输出商铺介绍
		$this->showpage("own_shopintro.modi");   //显示页面
	}

	/**
	 * 保存店铺介绍
	 *
	 */
	function _saveShopIntro(){
		$result = $this->obj_shop->operateShop($this->_input);  //把信息放入数据库中
		$this->redirectPath("succ","member/own_shop.php?action=intro",$this->_lang['langShopAmendIntroOk']);//您已修改商铺介绍!
	}
	
	/**
	 * 实体店认证
	 */
	function _showEntityInfo(){
		$shop_id = $_SESSION['s_shop']['id'];
		$result = $this->obj_shop->getOneShop($shop_id,'1','audit_state');

		if ($result['audit_state'] == '1') {
			$this->redirectPath("succ","member/own_main.php",$this->_lang['langShopWaitAuditing']);//您的验证信息正处于等待审核状,管理员会尽快审核您的信息!
		}elseif ($result['audit_state'] == '2') {
			$this->redirectPath("succ","member/own_main.php",$this->_lang['langShopPassAuditing']);//您的验证信息已经被审核通过,恭喜您的店铺成为实体店铺!
		}elseif ($result['audit_state'] == '3'){
			$this->output('isRefuse','yes');
		}
		$this->showpage("own_shopentity_check.add");   //显示页面
	}

	/**
	 * 保存实体店认证信息
	 */
	function _saveEntityInfo(){
		if ($_SESSION['s_shop']['id'] == ''){
			return false;
		}
		require_once('uploadfile.class.php');
		$upload = new UploadFile();
		$upload->allow_type = explode(',',$this->_fileconfig['allowuploadimagetype']);
		$upload->ifresize = false;
		//身份证正面扫描图
		if(isset($_FILES['identity_card_copy_up']['name']) && $_FILES['identity_card_copy_up']['name'] != ''){
			$filename = $upload->upfile('identity_card_copy_up');
			$this->_input['identity_card_copy_up'] = $filename["getfilename"];
		}
		//身份证背面扫描图
		if(isset($_FILES['identity_card_copy_back']['name']) && $_FILES['identity_card_copy_back']['name'] != ''){
			$filename = $upload->upfile('identity_card_copy_back');
			$this->_input['identity_card_copy_back'] = $filename['getfilename'];
		}
		//营业执照扫描图
		if(isset($_FILES['license_copy']['name']) && $_FILES['license_copy']['name'] != ''){
			$filename = $upload->upfile('license_copy');
			$this->_input['license_copy'] = $filename["getfilename"];
		}
		unset($upload);

		$array = array();
		$array['shop_id']                 = $_SESSION['s_shop']['id'];
		$array['identity_card_copy_up']   = $this->_input['identity_card_copy_up'];    //身份证正面扫描图
		$array['identity_card_copy_back'] = $this->_input['identity_card_copy_back'];  //身份证背面扫描图
		$array['license_copy']            = $this->_input['license_copy'];             //营业执照扫描图
		$array['audit_state']             = '1';                                       //审核状态
		if ($this->obj_shop->_updateShop($array)) {
			//实名认证
			CreditsClass::saveCreditsLog('shop_entity',$_SESSION["s_login"]['id'],false);
			$this->redirectPath("succ","member/own_main.php",$this->_lang['langShopSubmitentityInfoOk']);
		}else {
			$this->redirectPath("succ","member/own_main.php",$this->_lang['langShopentityInfoLost']);
		}
	}
	
	/**
	 * 删除Banner图片
	 */
	function _delBanner(){
		/**
		 * 获取商铺信息
		 */
		$shop_array = array();
		$shop_array = $this->obj_shop->getOneShop($_SESSION['s_shop']['id']);

		/**
		 * 删除图片
		 */
		if (file_exists("../" . $shop_array['shop_banner_pic'])){
			@unlink("../" . $shop_array['shop_banner_pic']);
		}
		/**
		 * 更新数据库
		 */
		$value_array = array();
		$value_array['shop_id'] = $shop_array['shop_id'];
		$value_array['shop_banner_pic'] = '';
		$result = $this->obj_shop->_updateShop($value_array);
		unset($value_array);
		$this->redirectPath("succ","member/own_shop.php?action=modi",$this->_lang['langShopDelBanner']);//您已经删除商铺LOGO了!
		
	}
}


$shop_manage = new OwnShopManage();
$shop_manage->main();
unset($shop_manage);
?>