<?php
require ("../../global.inc.php");

class Alipay extends CommonFrameWork{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 *商品对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 *商品订单对象
	 *
	 * @var obj
	 */
	var $obj_product_order;
	
	function main(){
		/**
		 * 加载语言包
		 */
		$this->getlang("product");
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once ("member.class.php");
			$this->obj_member = new MemberClass();
		}
		/**
		 * 创建商品对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}
		/**
		 * 创建订单对象
		 */
		if (!is_object($this->obj_product_order)){
			require_once("order.class.php");
			$this->obj_product_order = new ProductOrderClass();
		}
		//判断信息ID是否为空
		if ($this->_input['sp_code'] == '' && $this->_input['out_trade_no'] == ''){
			$this->redirectPath("error","",$this->_lang['errProductInfoEmpty']);
		}
		$out_trade_no = $this->_input['sp_code']?$this->_input['sp_code']:$this->_input['out_trade_no'];
		/**
		 * 取订单信息
		 */
		$order_array = $this->obj_product_order->getOneOrderBySpcode($out_trade_no);
		/**
		 * 取卖家会员信息
		 */
		$condition['id'] = $order_array['seller_id'];
		$member_array = $this->obj_member->getMemberInfo($condition,'*','more');
		/**
		 * 取商品信息
		 */
		$product_array = $this->obj_product->getProductRow($order_array['p_code']);
		
		if (strtoupper($this->_configinfo['websit']['ncharset']) == 'UTF-8'){
			$order_array['p_name'] = Common::nc_change_charset($order_array['p_name'],'utf8_to_gbk');
		}
		$array = array();
		$array['order'] = $order_array;
		$array['member'] = $member_array;
		$array['product'] = $product_array;
		$array['site_url'] = $this->_configinfo['websit']['site_url'];
		$array['_input_charset'] = $this->_configinfo['websit']['ncharset'];
		$array['url'] = $this->_configinfo['websit']['site_url'].'/home/product.php?action=view&pid='.$product_array['p_code'];
		/*判断付款方式*/
		if ($product_array['p_transfee_charge'] == 0){
			$array['transfee'] = 'SELLER_PAY';/*卖家承担*/
			$array['order']['tf_type'] = "EXPRESS";
		}else {
			$array['transfee'] = 'BUYER_PAY';	/*买家承担*/
			$array['tf_type'] = $order_array['tf_type'];	/*运送方式*/
			switch($array['order']['tf_type']){
				case "1":
					$array['order']['tf_type'] = "POST";
					break;
				case "2":
					$array['order']['tf_type'] = "EXPRESS";
					break;
				case "3":
					$array['order']['tf_type'] = "EMS";
					break;
			}
		}
		
		return $array;
	}

	/**
	 * 接收支付宝的通知
	 */
	 function input_alipay(){
		return $this->_input;
	 }
	
	/**
	 * 更新商品订单交易状态
	 * $out_trade_no 交易编号
	 * $trade_status 交易状态,$out_trade_no,$trade_status
	 */
	function update_order($input){
		/**
		 * 创建订单对象
		 */
		if (!is_object($this->obj_product_order)){
			require_once("order.class.php");
			$this->obj_product_order = new ProductOrderClass();
		}
		
		if($input['trade_status'] == 'WAIT_BUYER_PAY'){/*等待买家付款*/
			$status = 0;
		}elseif($input['trade_status'] == 'WAIT_SELLER_SEND_GOODS'){/*买家已支付*/
			$status = 1;
			$alipay_id = $input['trade_no'];
		}else if($input['trade_status'] == 'WAIT_BUYER_CONFIRM_GOODS'){/*卖家已发货*/
			$status = 2;
		}else if($input['trade_status'] == 'TRADE_FINISHED'){/*买家已收货*/
			$status = 3;
		}else if($input['trade_status'] == 'TRADE_CLOSED'){/*交易中途关闭*/
			$status = 6; 
		}else if($input['trade_status'] == 'REFUND_SUCCESS'){/*退款成功*/
			$status = 6;
		}
		if($status != ''){
			/**
			 * 创建订单对象
			 */
			if (!is_object($this->obj_product_order)){
				require_once("order.class.php");
				$this->obj_product_order = new ProductOrderClass();
			}
			//取订单信息
			$order_array = $this->obj_product_order->getOneOrderBySpcode ($input['out_trade_no']);
			switch ($order_array['sell_type']){
				case '0'://拍卖
					require_once('order_process_auction.class.php');
					$obj_order_process = new OrderProcessAuction($input['out_trade_no']);
					break;
				case '1'://一口价
					require_once('order_process_fixprice.class.php');
					$obj_order_process = new OrderProcessFixprice($input['out_trade_no']);
					break;
				case '2'://团购
					require_once('order_process_group.class.php');
					$obj_order_process = new OrderProcessGroup($input['out_trade_no']);
					break;
				default:
					exit;
			}
			//更改订单状态
			$obj_order_process->alipay_id =$alipay_id;
			$obj_order_process->changeOrderState($input['out_trade_no'],$status);
			
			//如果是状态3的话，则跳转到评价页面
			if ($status == '0' || $status == '1'){
				$url = $this->_configinfo['websit']['site_url'].'/member/own_order.php?action=bought';
			}
			if ($status == '2'){
				$url = $this->_configinfo['websit']['site_url'].'/member/own_order.php?action=sold';
			}
			if ($status == '3'){
				$url = $this->_configinfo['websit']['site_url'].'/member/own_score.php?action=add&orderid='.$input['spcode'].'&type=bought';
			}
			@header("Location: $url");
		}else {
			echo 2;
		}
	}
}

$alipay_manage = new Alipay();
$array = $alipay_manage->main();



$partner = "";	//合作伙伴ID，使用支付宝之前必须填写！！！
$security_code = "";	//安全检验码，使用支付宝之前必须填写！！！
$seller_email = $array['member']['alipay'];//卖家邮箱
$_input_charset = $array['_input_charset']; //字符编码格式
$sign_type = "MD5"; //加密方式
$transport= "http";//访问模式,你可以根据自己的服务器是否支持ssl访问而选择http以及https访问模式
$notify_url = $array['site_url']."/payment/alipay/notify_url.php";// 异步返回地址
$return_url = $array['site_url']."/payment/alipay/return_url.php"; //同步返回地址
?>