<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php   FILE_PATH : E:\www\multishop\trunk\payment\tenpay\index.php
 * ....财付通支付方式链接跳转
 *
 * @copyright Copyright (c) 2007 - 2007 www.shopnc.net 
 * @author ShopNC Develop Team
 * @package 
 * @subpackage 
 * @version Thu May 08 10:17:14 CST 2008
 */

include("../../global.inc.php");//加载信息

class tenpayIndex extends CommonFrameWork{
	/**
	 *商品订单对象
	 *
	 * @var obj
	 */
	var $obj_product_order;
	/**
	 * 商品对象
	 *
	 * @var obj
	 */
	var $obj_product;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;

	function main(){

		//加载语言包
		$this->getlang("product");

		//创建订单对象
		if (!is_object($this->obj_product_order)){
			require_once("order.class.php");
			$this->obj_product_order = new ProductOrderClass();
		}
		/**
		 * 创建商品对象
		 */
		if (!is_object($this->obj_product)){
			require_once("product.class.php");
			$this->obj_product = new ProductClass();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->obj_member)){
			require_once("member.class.php");
			$this->obj_member = new MemberClass();
		}

		//取订单信息
		$order_array = $this->obj_product_order->getOneOrderBySpcode($this->_input["sp_code"]);
		
		//取商品信息
		$product_array = $this->obj_product->getProductRow($order_array['p_code']);
		
		//判断付款方式
		if ($product_array['p_transfee_charge'] == 1){//买家承担
			if($order_array['tf_type'] == '1'){//1平邮
				$transport_fee = $product_array['p_tf_py'];
			}else if($order_array['tf_type'] == '2'){//2快递
				$transport_fee = $product_array['p_tf_kd'];
			}else if($order_array['tf_type'] == '3'){//3EMS
				$transport_fee = $product_array['p_tf_kd'];
			}
		}else {
			$transport_fee = 0;
		}
		//取会员信息
		$member_array = $this->obj_member->getMemberInfo(array("id"=>$order_array['seller_id']),'*','more');
		
		//参数
		$array = array();
		$order_array['p_name'] = Char_class::cut_str($order_array['p_name'],10,0,$this->_configinfo['websit']['ncharset'],'');
		$array['mch_name'] = $order_array['p_name'];//商品名称
		$array['mch_price'] = $order_array['buy_num']*$order_array['unit_price']*100;//商品价格,单位为分
		$array['transport_desc'] = $order_array['p_name'];//物流说明
		$array['transport_fee'] = $transport_fee*100;//买方需要支付的物流费用
		$array['mch_desc'] = $order_array['p_name'];//交易说明
		$array['mch_vno'] = $this->_input["sp_code"];//订单号
		$array['cft_tid'] = $order_array['alipay_id'];//外部交易流水号
		$array['seller'] = $member_array['tenpay'];//卖家tenpay帐号

		return $array;
	}
}

$tenpay_index = new tenpayIndex();
$tenpay_param = $tenpay_index->main();

//路径输出
if($tenpay_param['cft_tid'] != ''){
	$url = 'https://www.tenpay.com/med/tradeDetail.shtml?b=1&trans_id='.$tenpay_param['cft_tid'];
}else{
	require_once("md5_request.php");
	$tenpay = new tenpay_online_payment;
	$tenpay->seller = $tenpay_param['seller'];//卖家帐号
	$url = $tenpay->tenpay_interface_pay ("$tenpay_param[mch_name]",$tenpay_param['mch_price'],"$tenpay_param[transport_desc]",$tenpay_param['transport_fee'],"$tenpay_param[mch_desc]",$tenpay_param['mch_vno']);
}
header("location: $url");exit;

//print_r("<a href=\"".$url."\" target=\"_blank\"><img src=\"./images/blue_logo.jpg\" alt=\"用财付通支付\" border=\"0\"></a>");
?>