<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : control.php   FILE_PATH : E:\www\multishop\trunk\store\control.php
 * ....书写本页代码的说明
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Thu Jun 19 10:07:47 CST 2008
 */

require_once("../global.inc.php");

class StoreControlClass extends CommonFrameWork{
	/**
	 * 商铺对象
	 *
	 * @var obj
	 */
	var $obj_shop;
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $obj_member;
	/**
	 * 商铺信息
	 *
	 * @var array
	 */
	var $shop_array;
	
	function main(){
		/**
		 * 初始化商铺类
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
		 * 创建会员对象
		 */
		if (!is_object($obj_member)){
			require_once("member.class.php");
			$obj_member = new MemberClass();
		}
		
		/**
		 * 判断会员是否有商铺
		 */
		$this->checkShopMember();
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		/**
		 * 语言包
		 */
		$this->getlang("store_control");

		////////////////////////////////////////////////////////
		//模板编辑页面配置信息
		$lang_config['intro']       = array('title'=>$this->_lang['langStoreControlIntro'],'div'=>'intro','h3'=>'titleintro','img'=>'side_intro','img.src'=>'intro','span'=>'blockintro');
		$lang_config['proclamation']     = array('title'=>$this->_lang['langStoreControlProclamation'],'div'=>'proclamation','h3'=>'titleproclamation','img'=>'side_proclamation','img.src'=>'proclamation','span'=>'blockproclamation');
		$lang_config['shop_product_class']   = array('title'=>$this->_lang['langStoreControlShopProductClass'],'div'=>'shop_product_class','h3'=>'titleshop_product_class','img'=>'side_shop_product_class','img.src'=>'shop_product_class','span'=>'blockshop_product_class');
		$lang_config['link']     = array('title'=>$this->_lang['langStoreControlLink'],'div'=>'link','h3'=>'titlelink','img'=>'side_link','img.src'=>'link','span'=>'blocklink');
		$lang_config['left_config'] = array('intro'=>$this->_lang['langStoreControlIntro'],'proclamation'=>$this->_lang['langStoreControlProclamation'],'shop_product_class'=>$this->_lang['langStoreControlShopProductClass'],'link'=>$this->_lang['langStoreControlLink']);
		$lang_config['main_config'] = array('main_recommended_product'=>$this->_lang['langStoreControlRecommendedProduct'],'main_product'=>$this->_lang['langStoreControlMainProduct'],'main_message'=>$this->_lang['langStoreControlMainMessage']);
		$this->output('Lang',$lang_config);
		//模板的栏目id
		$this->choiceblockside_all = 'intro,proclamation,shop_product_class,link';
		$this->choiceblockmain_all = 'main_recommended_product,main_product,main_message';
		////////////////////////////////////////////////////////


		switch($this->_input['action']){
			case "show":
				$this->_show();
				break;
			case "save":
				$this->_save();
				break;
			default:
				$this->_show();
				exit;
		}
	}
	/**
	 * 模板控制展示
	 */
	function _show(){
		$default_shop_style = array(
			'action'=>'save',
			'dragsubmit'=>$this->_lang['langCsave'],
			'bodycolor'=>'#ffffff',
			'bodyimage'=>'',
			'bodyrepeat'=>'',
			'bodyattachment'=>'',
			'fontcolor'=>'',
			'linkcolor'=>'',
			'cursor'=>'url('.$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/cursors/mouse010.ani)',
			'showside'=>'0',
			'headcolor'=>'',
			'headimage'=>$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/h001.jpg',
			'headrepeat'=>'',
			'headtextcolor'=>'',
			'contentcolor'=>'',
			'contentimage'=>$this->_configinfo['websit']['site_title'].'/templates/'.$this->_configinfo['websit']['templatesname'].'/store/img/h006.jpg',
			'contentrepeat'=>'',
			'sidecolor'=>'',
			'sideimage'=>'',
			'siderepeat'=>'',
			'maincolor'=>'',
			'mainimage'=>'',
			'mainrepeat'=>'',
			'moduleleft'=>'link',
			'cmodule'=>'main_recommended_product',
			'blocktitlecolor'=>'',
			'blocktitleimage'=>'',
			'blocktitlerepeat'=>'',
			'blocktitletextcolor'=>'',
			'blockcolor'=>'',
			'blockimage'=>'',
			'blockrepeat'=>'',
			'blocktextcolor'=>'',
			'choiceblockleft'=>'shop_product_class,intro,proclamation,link',
			'choiceblockmain'=>'main_recommended_product,main_product,main_message',
			'choiceblockright'=>'',
			'layout'=>'1',
			'slayout'=>'2',
		);
		$mid = 1;
		$arr = unserialize($this->shop_array['shop_style'])?unserialize($this->shop_array['shop_style']):$default_shop_style;

		
		//商铺信息，商铺公告，商铺类目，友情链接
		$arr[choiceblockside_all] = $this->choiceblockside_all;
		//商品列表，商铺留言
		$arr[choiceblockmain_all] = $this->choiceblockmain_all;
		
		//左边显示
		if ($arr['slayout'] == '2') {
			//页面显示的版区
			$side_template = explode(',',$arr['choiceblockleft']);
			$main_template = explode(',',$arr['choiceblockmain']);

			//抛出左边版区
			$this->output('side_template',$side_template);
			$this->output('main_template',$main_template);
		}else if ($arr['slayout'] == '0') {//右边显示
			//初始化页面内容
			$side_template  = explode(',',$arr['choiceblockright']);
			$main_template  = explode(',',$arr['choiceblockmain']);
			
			//抛出右边版区
			$this->output('side_template',$side_template);
			$this->output('main_template',$main_template);
		}else if ($arr['slayout'] == '-1') {//两端显示
			//页面显示的版区
			$left_template = explode(',',$arr['choiceblockleft']);
			$right_template = explode(',',$arr['choiceblockright']);
			$main_template = explode(',',$arr['choiceblockmain']);
			
			//合并左右两边数组
			$side_template_merge = array_merge($left_template,$right_template);
			$side_template = array();
			if (is_array($side_template_merge)){
				foreach ($side_template_merge as $value) {
					$side_template[] = $value;
				}
			}
			//抛出左边版区
			$this->output('left_template',$left_template);
			$this->output('right_template',$right_template);
			$this->output('main_template',$main_template);
			$this->output('side_template',$side_template);
		}else {
			$arr['slayout'] = 2;
		}
		
		//初始化字符串
		//如果初始化字符串不为空则进行处理(左边)
		if ($arr['choiceblockleft'] != '') {
			$left_template_init =  str_replace(',','][',$arr['choiceblockleft']);
			$left_template_init = '['.$left_template_init.']';
		} else {
			$left_template_init = '';
		}
		//如果初始化字符串不为空则进行处理(右边)
		if ($arr['choiceblockright'] != '') {
			$right_template_init =  str_replace(',','][',$arr['choiceblockright']);
			$right_template_init = '['.$right_template_init.']';
		} else {
			$right_template_init = '';
		}
		//如果初始化字符串不为空则进行处理(中间)
		if ($arr['choiceblockmain'] != '') {
			$main_template_init = str_replace(',','][',$arr['choiceblockmain']);
			$main_template_init = '['.$main_template_init.']';
		} else {
			$main_template_init = '';
		}
		
		//抛出初始化字符串
		$this->output('left_template_init',$left_template_init);
		$this->output('right_template_init',$right_template_init);
		$this->output('main_template_init',$main_template_init);
		
		//页面所有的版区(在添加版区内使用)
		$side_template_all  = explode(',',$arr['choiceblockside_all']);
		$main_template_all  = explode(',',$arr['choiceblockmain_all']);

		//抛出页面所有版区列表(初始化添加版区模块中的默认选中项目)
		$this->output('side_template_all',$side_template_all);
		$this->output('main_template_all',$main_template_all);
		
		$this->output('mid',$mid);
		$this->output('arrBlog',$arr);
		$this->output('arrBlogReg',$arr_blogreg);
		$this->output('arrBlogInfo',$arr_bloginfo);
		$this->output('shop_array',$this->shop_array);//店铺信息
		/**
		 * 模板输出
		 */
		$this->showpage('store_control');
	}
	
	/**
	 * 保存
	 */
	function _save() {
		//判断栏目是否存在，不存在的去除掉
		//中
		if ($this->_input['choiceblockmain'] != ''){
			$array = explode(',',$this->_input['choiceblockmain']);
			$this->_input['choiceblockmain'] = implode(',',array_intersect($array,explode(',',$this->choiceblockmain_all)));
		}
		//左
		if ($this->_input['choiceblockleft'] != ''){
			$array = explode(',',$this->_input['choiceblockleft']);
			$this->_input['choiceblockleft'] = implode(',',array_intersect($array,explode(',',$this->choiceblockside_all)));
		}
		//右
		if ($this->_input['choiceblockright'] != ''){
			$array = explode(',',$this->_input['choiceblockright']);
			$this->_input['choiceblockright'] = implode(',',array_intersect($array,explode(',',$this->choiceblockside_all)));
		}
		//更新店铺模板信息
		$value_array['shop_id'] = $this->shop_array['shop_id'];
		$value_array['shop_style'] = serialize($this->_input);
		$update_rs = $this->obj_shop->_updateShop($value_array);
		//生成商铺首页
		$result = $this->_make_html($this->shop_array['shop_id']);
		if ($result == true){
			$this->redirectPath("succ","member/own_shopstyle.php",$this->_lang['langStoreControlSetSucc']);
		}else {
			$this->redirectPath("error","",$result);
		}
	}
	
	/**
	 * 生成模板静态页
	 */
	function _make_html($shop_id){
		/**
		 * 创建店铺静态页面对象
		 */
		if (!is_object($obj_html_store)){
			require_once("../home/html.store.php");
			$this->obj_html_store = new HtmlStoreManage();
		}
		$result = $this->obj_html_store->_make_store_html($shop_id);
		return $result;
	}
	
	/**
	 * 检测商铺会员
	 */
	function checkShopMember(){
		//通过session中的会员信息取商铺信息
		if ($_SESSION['s_login']['id'] != ''){
			$shop_array = $this->obj_shop->getOneShopByMemeberId($_SESSION['s_login']['id']);
			if ($shop_array['ischeck'] == '0'){
				$this->redirectPath("error","",$this->_lang['langStoreControlNoShop']);
			}else {
				return $this->shop_array = $shop_array;
			}
		}else {
			$this->redirectPath("error","",$this->_lang['langStoreControlNoLogin']);
			exit;
		}
	}

}

$control = new StoreControlClass();
$control->main();
unset($control);
?>