<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : product.php   FILE_PATH : /var/www/multishop/trunk/store/product.php
 * ....商铺标签列表
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sat Jun 21 14:18:38 CST 2008
 */

require_once("../global.inc.php");

class StoreTagClass extends CommonFrameWork{
	/**
	 * 2级域名对象
	 *
	 * @var obj
	 */
	var $obj_domain;
	/**
	 * 店铺信息
	 *
	 * @var obj
	 */
	var $obj_shop;
	/**
	 * 店铺标签
	 *
	 * @var object
	 */
	var $obj_shoptag;	
		
	function main(){
		/**
		 * 初始化域名解析类
		 */
		if (!is_object($this->obj_domain)){
			require_once("domain.class.php");
			$this->obj_domain = new Domain();
		}
		/**
		 * 实例化店铺类
		 */
		if (!is_object($this->obj_shop)){
			require_once("shop.class.php");
			$this->obj_shop = new ShopClass();
		}
		/**
		 * 实例化店铺标签类
		 */
		if (!is_object($this->obj_shoptag)) {
			include_once("shoptag.class.php");
			$this->obj_shoptag = new ShopTag ();
		}			
		//开启2级域名
		if($this->_configinfo['subdomain']['ifsubdomain'] == '1' && $this->_configinfo['subdomain']['domainroot'] != ''){
			if (intval($this->_input['userid']) > 0 ){//跳转到该会员的2级域名下
				$shop_array = $this->obj_shop->getOneShopByMemeberId($this->_input['userid']);
				if (empty($shop_array)){//没有店铺
					$this->redirectPath("error",$this->_configinfo['websit']['site_url']."/index.html",$this->_lang['langStoreMemberIsNotOpen']);
				}
			}else {
				//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$domain_id = $line[1];
				unset($line);
				$shop_array = $this->obj_shop->getOneShopByDomainId($domain_id);
				if (!empty($shop_array)){//有会员
					$this->_input['userid'] = $shop_array['member_id'];
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
					exit;
				}
			}
			//本店2级域名链接
			$domain_url = 'http://'.$this->_configinfo['subdomain']['domainprefix'].$shop_array['shop_domain'].$this->_configinfo['subdomain']['domainroot'];
			$this->output('shop_domain_url',$domain_url);
		}else {//不开启2级域名,判断如果以2级域名的形式访问的话，则对链接进行整理，为普通访问形式
			if (intval($this->_input['userid']) <= 0 ){
				//切割域名，取userid
				$line = @explode($this->_configinfo['subdomain']['domainroot'],$_SERVER['HTTP_HOST']);
				$line = @explode($this->_configinfo['subdomain']['domainprefix'],$line[0]);
				$user_id = $line[1];
				unset($line);
				if (intval($user_id) > 0){
					@header("Location: ".$this->_configinfo['websit']['site_url'].'/store/product.php?userid='.$user_id);
				}else {//如果是非法的，则跳转
					@header("Location: ".$this->_configinfo['websit']['site_url']."/index.html");
				}
				exit;
			}
		}
		
		//判断商铺信息，并且输出到模板上商铺信息
		$this->ifStore();
		$this->shop_array = $this->storeBaseInfo();
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		/**
		 * 语言包
		 */
		$this->getlang("store");
		$this->getlang("store_control");
		switch($this->_input['action']){
			default:
				$this->_list();
		}
	}
	
	/**
	 * 商品列表显示
	 */
	function _list(){
		//首先要确定末班布局，取出模板上其他栏目的信息
		$this->shop_id = $this->shop_array['shop_id'];
		$shop_array = $this->storeBaseInfo();
		$arr = unserialize($this->shop_array['shop_style']);
		//左边显示
		if ($arr['slayout'] == '2') {
			//页面显示的版区
			$side_template = explode(',',$arr['choiceblockleft']);
			//抛出左边版区
			$this->output('side_template',$side_template);
		}else if ($arr['slayout'] == '0') {//右边显示
			//初始化页面内容
			$side_template  = explode(',',$arr['choiceblockright']);
			//抛出右边版区
			$this->output('side_template',$side_template);
		}else if ($arr['slayout'] == '-1') {//两端显示
			//页面显示的版区
			$left_template = explode(',',$arr['choiceblockleft']);
			$right_template = explode(',',$arr['choiceblockright']);
			//合并左右两边数组
			$side_template_merge = array_merge($left_template,$right_template);
			$side_template = array();
			if (is_array($side_template_merge)){
				foreach ($side_template_merge as $value) {
					$side_template[] = $value;
				}
			}
			//抛出左边版区
			$this->output('left_template',$left_template);
			$this->output('right_template',$right_template);
			$this->output('side_template',$side_template);
		}else {
			$arr['slayout'] = 2;
		}
		
		//店铺标签导航
		$tag_array = $this->obj_shoptag->getOneTag ($this->_input['tag'],'tag_content');			
		
		/**
		 * 页面输出
		 */
		$this->output('tag_array',$tag_array);
		$this->output('arrBlog',$arr);
		$this->output('member_id',$this->shop_array['member_id']);
		$this->output('shop_url',$shop_array['shop_link']);
		$this->output('view_type',$view_type);		
		$this->showpage('store_tag');
	}
}

$tag = new StoreTagClass();
$tag->main();
unset($tag);
?>