<?php
/////////////////////////////////////////////////////////////////////////////
// 此文件是 ShopNC多用户商城 的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : userinfo.php   FILE_PATH : \multishop\store\userinfo.php
 * ....用户基本信息
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Fri Sep 28 16:37:40 CST 2007
 */

require_once("../global.inc.php");

class StoreUser extends CommonFrameWork{
	/**
	 * 会员对象
	 *
	 * @var obj
	 */
	var $objmember;
	/**
	 * 地区信息
	 *
	 * @var obj
	 */
	var $obj_area;
	
	function main(){
		/**
		 * 创建会员对象
		 */
		if (!is_object($this->objmember)){
			require_once ("member.class.php");
			$this->objmember = new MemberClass();
		}
		/**
		 * 实例化地区类
		 */
		if (!is_object($this->obj_area)){
			require_once("area.class.php");
			$this->obj_area = new AreaClass();
		}
		
		/**
		 * 设置模板路径
		 */
		$this->setsubtemplates("store");
		/**
		 * 语言包
		 */
		$this->getlang("store_intro");
		
		/**
		 * 得到会员资料
		 */
		$condition[id] = $this->_input['userid'];
		$member_array = $this->objmember->getMemberInfo($condition,'*','more');
		$member_array['regist_time'] = date("Y-m-d",$member_array['regist_time']);
		$member_array['sms_username']	= urlencode($member_array['login_name']);	//将传递的用户名称用urlencode加密，这里用了和信息发送的键名相同，可以修改为其他。
		if ($member_array['area_id'] != ''){
			$sel_area = $this->obj_area->getAreaPathList($member_array['area_id']);
		}
		/**
		 * 模板输出
		 */
		$this->output('sel_area',$sel_area);
		$this->output('frame_shop_info',$member_array);
		$this->showpage("store_userinfo");
	}
}
$member = new StoreUser();
$member->main();
unset($member);
?>