<?php

    if(!defined('IN_DISCUZ') || !defined('IN_ADMINCP')) {
	   exit('Access Denied');
    }
class upimg{ 
    public $uploadFolder = 'source/plugin/v63shop/images/upload'; // ͼƬĿ¼ 
    public $thumbFolder = 'source/plugin/v63shop/images/uploadthumb'; // ͼĿ¼ 
    public $thumbWidth = 160; // ͼ 
    public $thumbHeight = 120; // ͼ߶ 
    public $autoThumb = TRUE; // ǷԶͼ 
    public $error = ''; // Ϣ 
    public $imgPath = ''; // ϴɹͼƬλ 
    public $thumbPath = ''; // ϴɹͼλ 
     
    // ˵ʼĿ¼ 
    function __construct($uploadFolder = 'source/plugin/v63shop/images/upload', $thumbFolder = 'source/plugin/v63shop/images/uploadthumb'){ 
        $this->uploadFolder = $uploadFolder; 
        $this->thumbFolder = $thumbFolder; 
        $this->_mkdir(); 
    } 
     
    // ˵ϴͼƬ<input />nameֵɹͼƬURLʧܷFALSEʹϢ$this->error 
    // bool/sting upload(string $html_tags_input_attrib_name); 
    function upload($inputName){ // ϴinputǩnameԡ 
        if ($this->error){ // дֱӷأ_mkdir 
            return FALSE; 
        } 
        if(!$_FILES[$inputName]["name"]){ 
            $this->error = 'ûϴͼƬ'; 
            return FALSE; 
        } 
        if($_FILES[$inputName]["name"]){
			$_FILES[$inputName]['tmp_name']=str_replace('\\\\','\\',$_FILES[$inputName]['tmp_name']);
            $isUpFile = $_FILES[$inputName]['tmp_name']; 
            if (is_uploaded_file($isUpFile)){ 
                $imgInfo = $this->_getinfo($isUpFile); 
                if (FALSE == $imgInfo){ 
                    return FALSE; 
                } 
                $extName = $imgInfo['type']; 
                $microSenond = floor(microtime()*10000);// ȡһ뼶,4λ 
                $newFileName = $uploadFolder . '/' . date('YmdHis') . $microSenond . '.' . $extName ; // ϴͼƬ֡ 
                $location = $this->uploadFolder . $newFileName; 
                $result = move_uploaded_file($isUpFile, $location); 
                if ($result){ 
                    if (TRUE == $this->autoThumb){ // Ƿͼ 
                        $thumb = $this->thumb($location, $this->thumbWidth, $this->thumbHeight); 
                        if (FALSE == $thumb){ 
                            return FALSE; 
                        } 
                    } 
                    $this->imgPath = $location; 
                    return $location; 
                }else{ 
                    $this->error = 'ƶʱļʱ'; 
                    return FALSE; 
                } 
            }else{ 
                $uploadError = $_FILES[$inputName]['error']; 
                if (1 == $uploadError){ // ļСphp.iniеupload_max_filesize 
                    $this->error = 'ļ̫󣬷ܾմ' . ini_get('upload_max_filesize') . 'ļ'; 
                    return FALSE; 
                }elseif (3 == $uploadError){ // ϴ˲ļ 
                    $this->error = 'ϴжϣ'; 
                    return FALSE; 
                }elseif (4 == $uploadError){ 
                    $this->error = 'ûļϴ'; 
                    return FALSE; 
                }elseif (6 == $uploadError){ 
                    $this->error = 'ҲʱļУϵķԱ'; 
                    return FALSE; 
                }elseif (7 == $uploadError){ 
                    $this->error = 'ļдʧܣϵķԱ'; 
                    return FALSE; 
                }else{ 
                    if (0 != $uploadError){ 
                        $this->error = 'δ֪ϴϵķԱ'; 
                        return FALSE; 
                    } 
                } // end if $uploadError 
            } // end if is_uploaded_file else 
        } // end if $_FILES[$inputName]["name"] 
    } 
     
    // ˵ȡͼƬϢϴʱļɹ飬ʧܷFALSEʹϢ 
    // array/bool _getinfo(string $upload_tmp_file) 
    private function _getinfo($img){ 
        if (!file_exists($img)){ 
            $this->error = 'ҲͼƬ޷ȡϢ'; 
            return FALSE; 
        } 
        $tempFile = @fopen($img, "rb"); 
        $bin = @fread($tempFile, 2); //ֻ2ֽ   
        @fclose($tempFile); 
        $strInfo = @unpack("C2chars", $bin); 
        $typeCode = intval($strInfo['chars1'] . $strInfo['chars2']); 
        $fileType = ''; 
        switch ($typeCode){ // 6677:bmp 255216:jpg 7173:gif 13780:png 7790:exe 8297:rar 8075:zip tar:109121 7z:55122 gz 31139 
            case '255216': 
                $fileType = 'jpg'; 
                break; 
            case '7173': 
                $fileType = 'gif'; 
                break; 
            case '13780': 
                $fileType = 'png'; 
                break; 
            default: 
                $fileType = 'unknown'; 
        } 
        if ($fileType == 'jpg' || $fileType == 'gif' || $fileType == 'png'){ 
            $imageInfo = getimagesize($img); 
            $imgInfo['size'] = $imageInfo['bits']; 
            $imgInfo["type"] = $fileType; 
            $imgInfo["width"] = $imageInfo[0]; 
            $imgInfo["height"] = $imageInfo[1]; 
            return $imgInfo; 
        }else{ // ͼƬļϢ 
            $this->error = 'ͼƬʹ'; 
            return FALSE; 
        } 
    } // end _getinfo 
     
    // ˵ͼȱŻ 
    // bool/string thumb(string $uploaded_file, int $thumbWidth, int $thumbHeight, string $thumbTail); 
    function thumb($img, $thumbWidth = 300, $thumbHeight = 200, $thumbTail = '_thumb'){ 
        $filename = $img; // һֹµͼʹ 
        $imgInfo = $this->_getinfo($img); 
        if (FALSE == $imgInfo){ 
            return FALSE; 
        } 
        $imgType = $imgInfo['type']; 
        switch ($imgType){ // һͼչ 
            case "jpg" : 
                $img = imagecreatefromjpeg($img); 
                $extName = 'jpg'; 
                break; 
            case 'gif' : 
                $img = imagecreatefromgif($img); 
                $extName = 'gif'; 
                break; 
            case 'png' : 
                $img = imagecreatefrompng($img); 
                $extName = 'png'; 
                break; 
            default : // ʹһſհͼ 
                $img = imagecreate($thumbWidth,$thumbHeight); 
                imagecolorallocate($img,0x00,0x00,0x00); 
                $extName = 'jpg'; 
        } 
        // źͼƬߴ(С죬) 
        $imgWidth = $imgInfo['width']; 
        $imgHeight = $imgInfo['height']; 
        if ($imgHeight > $imgWidth){ // ͼ 
            $newHeight = $thumbHeight; 
            $newWidth = ceil($imgWidth / ($imgHeight / $thumbHeight )); 
        }else if($imgHeight < $imgWidth){ // ͼ 
            $newHeight = ceil($imgHeight / ($imgWidth / $thumbWidth )); 
            $newWidth = $thumbWidth; 
        }else if($imgHeight == $imgWidth){ // ȱͼ 
            $newHeight = $thumbWidth; 
            $newWidth = $thumbWidth; 
        } 
        $bgimg = imagecreatetruecolor($newWidth,$newHeight); 
        $bg = imagecolorallocate($bgimg,0x00,0x00,0x00); 
        imagefill($bgimg,0,0,$bg); 
        $sampled = imagecopyresampled($bgimg,$img,0,0,0,0,$newWidth,$newHeight,$imgWidth,$imgHeight); 
        if(!$sampled ){ 
            $this->error = 'ͼʧ'; 
            @unlink($this->uploadFolder . '/' . $filename); // ɾϴͼƬ 
            return FALSE; 
        } 
        $filename = basename($filename); 
        $newFileName = substr($filename, 0, strrpos($filename, ".")) . $thumbTail . '.' . $extName ; //  
        $thumbPath = $this->thumbFolder . '/' . $newFileName; 
        switch ($extName){ 
            case 'jpg': 
                $result = imagejpeg($bgimg, $thumbPath); 
                break; 
            case 'gif': 
                $result = imagegif($bgimg, $thumbPath); 
                break; 
            case 'png': 
                $result = imagepng($bgimg, $thumbPath); 
                break; 
            default: // ϱжͳʱᴴһſհͼչΪjpg 
                $result = imagejpeg($bgimg, $thumbPath); 
        } 
        if ($result){ 
            $this->thumbPath = $thumbPath; 
            return $thumbPath; 
        }else{ 
            $this->error = 'ͼʧ'; 
            @unlink($this->uploadFolder . '/' . $filename); // ɾϴͼƬ 
            return FALSE; 
        } 
    } // end thumb 
     
     // ˵ͼƬĴĿ¼ 
    private function _mkdir(){ // ͼƬϴĿ¼ͼĿ¼ 
        if(!is_dir($this->uploadFolder)){ 
            $mkdirResutlt = @mkdir($this->uploadFolder); 
            if (!$mkdirResutlt){ 
                $this->error = 'ͼƬĿ¼ʧ'; 
                return FALSE; 
            } 
        } 
        if(!is_dir($this->thumbFolder) && TRUE == $this->autoThumb){ 
            $mkdirResutlt = @mkdir($this->thumbFolder); 
            if (!$mkdirResutlt){ 
                $this->error = 'ͼĿ¼ʧ'; 
                return FALSE; 
            } 
        } 
    } 
}

?> 