<?php
/**
 * @copyright   2008-2020 伯乐发卡 <http://www.lailiyun.com>
 * @creatdate   2020-9-10 Mr wang <634273662@qq.com>
 * @version   伯乐发卡V3（个人自动发卡系统）
 */


namespace BL\app\controller;

use BL\app\libs\Controller;

class chaka extends Controller
{
    public function index()
    {
       
        $oid = $this->req->get('oid');		
		$oid = mb_substr($oid , 0 , 18); 
        $data = $this->model()->select()->from('orders')->where(array('fields' => 'orderid=?', 'values' => array($oid)))->fetchRow();

			   if($this->config['pcindex']==5){				   
					$this->put('chaka'.$this->config['pcindex'].'.php', $data);				   
			   }else{
					$this->put('chaka.php', $data);				   
			   }
    }

    /**
     * 查询订单
     */
    public function orderList()
    {
        $data = $this->getReqdata($_POST);
        $cons = '';
        $consArr = [];
        $cons .= $cons ? ' and ' : '';
        $cons .= 'otype = ?';
        $consArr[] = $data['otype'];
       
        $cons .= ' and account = ?';
        $consArr[] = $data['account'];
        $orders = $this->model()->select()->from('orders')->where(array('fields' => $cons, 'values' => $consArr))->orderby('ctime desc')->fetchAll();
        if (!$orders) resMsg(0, null, '没有查询到订单记录，请检查密码是否正确或是否支付成功！');
        $html = '';
        $orderType = ['自动发卡', '手工订单', '下载链接'];
        $orderStatus = [
            0 => "<span class=\"am-badge am-badge-warning am-radius\">未付款</span>",
            1 => "<span class=\"am-badge am-badge-warning am-radius\">待处理</span>",
            2 => " <span class=\"am-badge am-badge-primary am-radius\">已处理</span>",
            3 => " <span class=\"am-badge am-badge-success am-radius\">已完成</span>",
            4 => " <span class=\"am-badge am-badge-danger am-radius\">处理失败</span>",
            5 => " <span class=\"am-badge am-badge-danger am-radius\">发卡失败</span>",
        ];


        foreach ($orders as $v) {
            $html .= "<tr>
                                <td>" . $v['orderid'] . "</td>
                                <td>
                                    <div class=\"am-btn-toolbar\">
                                        <div class=\"am-btn-group am-btn-group-xs\">
                                            <button onclick=\"orderInfo('" . $v['orderid'] . "')\"
                                                    class=\"am-btn am-btn-default \"><span class=\"am-icon-eye\"></span>订单详情
                                            </button>
                                        </div>
                                    </div>
                                </td>
                                <td>" . $orderStatus[$v['status']] . "</td>
                                <td>" . $v['oname'] . "</td>
                                <td>
                                    <span class=\"am-badge am-badge-success am-radius\">" . $orderType[$v['otype']] . "</span>
                                </td>
                                <td>" . $v['onum'] . "</td>
                                <td>" . $v['omoney'] . "</td>
                                <td>" . $v['cmoney'] . "</td>
                                <td>" . $v['account'] . "</td>
                                <td>

                                    <span class=\"am-badge am-badge-success am-radius\">" . $v['paytype'] . "</span>
                                </td>
                                <td class=\"am-hide-sm-only\">" . date('Y-m-d H:i', $v['ctime']) . "</td>
                            </tr>";
        }
        resMsg(1, $html);

    }

    /**
     * 订单详情
     */
    public function orderInfo()
    {

        $id = $this->req->post('id') ? $this->req->post('id') : 0;
        $data = $this->model()->select()->from('orders')->where(array('fields' => 'orderid=?', 'values' => array($id)))->fetchRow();
        if (!$data) resMsg(0, null, '订单不存在');
		if($data['otype']==1&&$data['status']==1){
			$data['info']="订单已提交到后台，请等待客服处理";
		}
        resMsg(1, $data, 'ok');


    }
    /**
     * 导出订单
     */
	public function import()
    {
        $id = $this->req->get('id') ? $this->req->get('id') : 0;
        $data = $this->model()->select()->from('orders')->where(array('fields' => 'orderid=?', 'values' => array($id)))->fetchRow();
        if (!$data) exit('订单不存在');
        $filename = $data['oname'].'-'.rand(100000,999999).".txt";
        Header( "Content-type:   application/octet-stream ");
        Header( "Accept-Ranges:   bytes ");
        header( "Content-Disposition:   attachment;   filename=".$filename);
        header( "Expires:   0 ");
        header( "Cache-Control:   must-revalidate,   post-check=0,   pre-check=0 ");
        header( "Pragma:   public ");
        echo $data['info'];
    }
}