<?php
/**
 * @copyright   2008-2020 伯乐发卡 <http://www.lailiyun.com>
 * @creatdate   2020-9-10 Mr wang <634273662@qq.com>
 * @version   伯乐发卡V3（个人自动发卡系统）
 */

namespace BL\app\libs;

use BL\app\blapp;
use BL\app\libs\Router;
use BL\app\libs\Req;
use BL\app\libs\Res;
use BL\app\libs\Page;
use BL\app\libs\Pageqt;
use BL\app\libs\Session;
use BL\app\controller\chkcode;
use BL\app\libs\Model;
use BL\app\Config;
use BL\app\model\Verifyuser;

class Controller
{
    public $data;
    public $tpl = 'view/default/';
    function __construct()
    {
        $this->router = new Router();
        $this->req = new Req();
        $this->res = new Res();
        $this->page = new Page();
        $this->pageqt = new Pageqt();
        $this->session = new Session();
        $this->chkcode = new chkcode();
        $this->config = $this->model()->select()->from('config')->fetchRow();
        $this->links = $this->model()->select()->from('links')->where(array('fields' => 'is_state=?', 'values' => array('1')))->fetchAll();

		$this->action = $this->router->put();
		$this->jsformat = $this->jsformat();
		$this->bgrand = $this->bgrand();
        $this->setConfig = new Config();
        $this->verifyUser = new Verifyuser();
        $this->urlbase =  strcasecmp($_SERVER['HTTPS'],"ON")==0?"https://":"http://";
    }
    public function model()
    {
        return new Model();
    }
	
	public function bgrand()
    {	
    	if(	$this->config['background']=="0"){
    		return "";
    	}elseif ($this->config['background']=="1"){
    		return '
    		<script>
		    $(document).ready(function(){
		     $("#bg").css("background", "#e9ecf3 url('.$this->config['bodyimage'].') no-repeat right center / cover");
		                $("#bg").css("background-attachment", "fixed");
		    });
		</script>';
    	}else{
    		return '<script>
			$(document).ready(function(){
			$.ajax({
			    type:"get",
			    url: "http://'.$_SERVER['HTTP_HOST'].'/bg.php?cid='.$this->config['background'].'",
			    dataType: "json",
			    async:true,
			    success: function(a) {
			        $("#bg").css("background", "#e9ecf3 url(\'"+a.url+"\')  no-repeat right center / cover");
			        $("#bg").css("background-attachment", "fixed");
			    }
			});
			});
			</script>';
    	}
		
     
    }
    
	/**html格式化供js使用
	 * @param int $status
	 * @param $data
	 * @param string $msg
	 */
	public function jsformat($str = null)
	{
	  $str = trim($str);
	  $str = str_replace('\\s\\s', '\\s', $str);
	  $str = str_replace(chr(10), '', $str);
	  $str = str_replace(chr(13), '', $str);
	  $str = str_replace('  ', '', $str);
	  $str = str_replace('\\', '\\\\', $str);
	  $str = str_replace('"', '\\"', $str);
	  $str = str_replace('\\\'', '\\\\\'', $str);
	  $str = str_replace("'", "\'", $str);
	  return $str;
	}
    public function put($file, $data = array())
    {
        if ($data) {
            extract($data);
        }
        if (!file_exists($this->tpl . $file)) {
            $file = 'blapp.php';
        }
        require_once $this->tpl . $file;
        $content = ob_get_contents();
        ob_get_clean();
        echo $content;
        if (ob_get_level()) {
            ob_end_flush();
        }
    }
    /**获取所有数组
     * @return array
     */
    public function getReqdata($mod)
    {
        $data = array();
        if (isset($mod)) {
            foreach ($mod as $key => $val) {
                $data[$key] = $this->req->request($key);
            }
        }
        return $data;
    }
}
?>