// pages/cart/cart.js
const app = getApp()
Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    total: 0,
    carts: [],
    selac: false,
    timid: false
  },
  onLoad: function (options) {
    wx.setNavigationBarTitle({
      title: '我的购物车 - ' + app.globalData.web
    })
    let that = this
    app.xhr({
      act: 'cart'
    }, function (r) {
      let c = [];
      for (let e in r.carts) {
        let d = e.split('_')
        let v = (d[1] == '' ? r.goods[d[0]].Nk : r.goods[d[0]].Nx.k['k_' + d[1]]) * 1
        c.push({
          i: d[0],
          n: r.goods[d[0]].Nm,
          p: r.goods[d[0]].Ni,
          m: r.goods[d[0]].Np,
          v: v,
          s: r.carts[e] > v ? v : r.carts[e],
          x: r.goods[d[0]].Nx,
          t: d[1],
          h: '',
          k: false
        })
        if (d[1] != '') {
          let b = []
          let j = 0;
          let s = c[c.length - 1]
          let f = s.p
          for (let v in s.x.n) {
            b.push(v + ':"' + s.x.n[v]['0123456789abcdefghijklmnopqrstuvwxyz'.indexOf(d[1].substr(j, 1))] + '"')
            if (j == 0 && s.x.m['m_' + d[1].substr(0, 1)]) f = s.x.m['m_' + d[1].substr(0, 1)]
            j++;
          }
          c[c.length - 1].h = b.join(',')
          c[c.length - 1].p = f
          if (s.x.p['p_' + d[1]]) c[c.length - 1].m = s.x.p['p_' + d[1]]
        }
      }
      that.setData({
        carts: c
      })
    })
  },
  fadeIO: function (obj, io) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: "block",
      h_msk: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(io ? 0.3 : 0).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none","h_msk":0}'))
      }, 550)
    }
  },
  editGnx: function (e) {
    let c = e.currentTarget.dataset['ei']
    let t = JSON.stringify(this.data.carts[c]);
    let s = JSON.parse(t)
    let h = [];
    let d = 0;
    for (let i in s.x.n) {
      h[d] = {
        n: i,
        m: s.x.n[i]
      };
      d++
    }
    for (let i = 0; i < h.length; i++) {
      for (let j = 0; j < h[i].m.length; j++) {
        h[i].m[j] = [(i == 0 && s.x.m['m_' + j]) ? s.x.m['m_' + j] : false, h[i].m[j], '0123456789abcdefghijklmnopqrstuvwxyz'.indexOf(s.t.substr(i, 1)) == j ? 1 : 0];
      }
    }
    this.setData({
      gds_nx: h,
      editid: c
    })
    this.fadeIO('gnx', 1)
    this.selType(false)
  },
  selType: function (e) {
    let n = this.data.gds_nx;
    let d = this.data.carts[this.data.editid];
    let nx = e ? e.currentTarget.dataset['nx'].split('-') : ['0', '0123456789abcdefghijklmnopqrstuvwxyz'.indexOf(d.t.substr(0, 1))]
    let p = '';
    let m = -1;
    let t = [];
    for (let i = 0; i < n[nx[0]].m.length; i++) n[nx[0]].m[i][2] = 0
    n[nx[0]].m[nx[1]][2] = 1
    for (let i = 0; i < n.length; i++) {
      let c = -1;
      for (let j = 0; j < n[i].m.length; j++) {
        if (n[i].m[j][2] == 1) {
          c = j;
          t.push('"' + n[i].n + '"');
        }
      }
      if (c > -1) {
        p += '0123456789abcdefghijklmnopqrstuvwxyz'.substr(c, 1)
        if (i == 0) m = c
      } else p += '-'
    }
    this.setData({
      gds_nx: n,
      sel_p: d.x.m['m_' + m] || d.p,
      sel_t: t.join(','),
      sel_k: d.x.k['k_' + p] || '0',
      sel_m: d.x.p['p_' + p] || d.m,
      sel_o: p
    })
  },
  setType: function () {
    if (this.data.sel_k * 1 == 0) {
      app.alt('所选商品或规格型号库存不足')
      return;
    }
    let d = this.data.carts;
    let e = this.data.editid;
    let x = this.data.gds_nx;
    let t = '';
    let h = [];
    for (let i = 0; i < x.length; i++) {
      let k = 0;
      let l = '';
      for (let j = 0; j < x[i].m.length; j++) {
        if (x[i].m[j][2] == 1) {
          k = j
          l = x[i].m[j][1]
        }
      }
      t += '0123456789abcdefghijklmnopqrstuvwxyz'.substr(k, 1)
      h.push(x[i].n + ':"' + l + '"')
    }
    d[e].t = t
    d[e].h = h.join(',')
    d[e].m = d[e].x.p['p_' + t] || d[e].m;
    d[e].p = d[e].x.m['m_' + t.substr(0, 1)] || d[e].p
    d[e].v = d[e].x.k['k_' + t]
    if (d[e].s > d[e].v) d[e].s = d[e].v
    this.setData({
      carts: d
    })
    this.hideGnx()
    this.cntCart()
    this.savCart()
  },
  hideGnx: function () {
    this.fadeIO('gnx', 0)
  },
  selCart: function (e) {
    let i = e.currentTarget.dataset['ci']
    let c = this.data.carts
    c[i].k = !c[i].k;
    this.setData({
      carts: c
    })
    this.cntCart()
  },
  allCart: function () {
    let a = !this.data.selac
    let c = this.data.carts
    for (let i = 0; i < c.length; i++) {
      c[i].k = a
    }
    this.setData({
      selac: a,
      carts: c
    })
    this.cntCart()
  },
  aodCart: function (e) {
    clearTimeout(this.data.timid)
    let i = e.currentTarget.dataset['ci']
    let b = e.currentTarget.dataset['ad']
    let c = this.data.carts
    c[i].s += b * 1;
    if (c[i].s < 1) c[i].s = 1
    if (c[i].s > c[i].v) {
      c[i].s = c[i].v
      app.alt('商品或型号规格库存不足')
    }
    this.setData({
      carts: c
    })
    this.cntCart()
    let that = this
    this.data.timid = setTimeout(function () {
      that.savCart()
    }, 1000)
  },
  cntCart: function () {
    let t = 0;
    let c = this.data.carts
    for (let i = 0; i < c.length; i++) {
      if (c[i].k) t += c[i].m * c[i].s
    }
    this.setData({
      total: Math.round(t * 100) / 100
    })
  },
  delCart: function () {
    let that = this
    wx.showModal({
      title: '提示',
      content: '确认删除所选商品？',
      success(res) {
        if (res.confirm) {
          let d = that.data.carts;
          let e = [];
          for (let i = 0; i < d.length; i++) {
            if (!d[i].k) e.push(d[i])
          }
          that.setData({
            carts: e
          })
          that.savCart(1)
        }
      }
    })
  },
  savCart: function (b) {
    let that = this
    let d = this.data.carts;
    let e = {}
    for (let i = 0; i < d.length; i++) {
      e[d[i].i + '_' + d[i].t] = d[i].s
    }
    app.xhr({
      act: 'crtv',
      Nk: e
    }, function (r) {
      if (b) app.alt('购物车保存成功')
    })
  },
  toOrder: function () {
    let d = this.data.carts;
    let e = []
    for (let i = 0; i < d.length; i++) {
      if (d[i].k) {
        if (d[i].v * 1 < d[i].s * 1 || d[i].s == 0) {
          app.alt('有商品缺货，请重新选择')
          return
        } else e.push([d[i].i, d[i].t, d[i].s])
      }
    }
    if (e.length == 0) {
      app.alt('请选择商品')
    } else wx.navigateTo({
      url: '../order/order?c=1&s=' + JSON.stringify(e)
    })
  }
})